/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.TenantHelpers;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011]c\u0001\u0002(P\u0001QC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")Q\u000e\u0001C\u0001]\"9!\u000f\u0001b\u0001\n\u0013\u0019\bbBA\u0001\u0001\u0001\u0006I\u0001\u001e\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000bA\u0011Ba\"\u0001\u0001\u0004%IA!#\t\u0011\tM\u0005\u0001)Q\u0005\u0003\u000fA\u0011B!(\u0001\u0005\u0004%IAa(\t\u0011\t5\u0006\u0001)A\u0005\u0005CCqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003R\u0002!IAa5\t\u000f\tm\b\u0001\"\u0003\u0003~\"91Q\u0001\u0001\u0005\n\r\u001d\u0001bBB\t\u0001\u0011\u000511\u0003\u0005\n\u0007c\u0001\u0011\u0013!C\u0001\u0007gA\u0011ba\u000e\u0001#\u0003%\taa\r\t\u000f\re\u0002\u0001\"\u0011\u0004<!911\t\u0001\u0005B\r\u0015\u0003bBB\u001d\u0001\u0011%11\u000b\u0005\b\u00073\u0002A\u0011BB.\u0011\u001d\u0019\t\u0007\u0001C\u0001\u0007GBqaa\u001a\u0001\t\u0003\u001aI\u0007C\u0004\u0004n\u0001!\tea\u001c\t\u000f\r}\u0004\u0001\"\u0011\u0004\u0002\"91q\u0011\u0001\u0005B\r%\u0005bBBH\u0001\u0011\u00051\u0011\u0013\u0005\b\u00077\u0003A\u0011ABO\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007GCqaa+\u0001\t\u0003\u0019i\u000bC\u0004\u00048\u0002!\t!!-\t\u000f\re\u0006\u0001\"\u0001\u0004<\"91\u0011\u001a\u0001\u0005\u0002\r-\u0007bBBr\u0001\u0011\u00051Q\u001d\u0005\b\u0007G\u0004A\u0011ABu\u0011\u001d\u0019i\u000f\u0001C\u0005\u0007_Dqa!@\u0001\t\u0013\u0019yP\u0002\u0004\u0002\f\u0001\u0001\u0015Q\u0002\u0005\u000b\u0003[1#Q3A\u0005\u0002\u0005=\u0002BCAFM\tE\t\u0015!\u0003\u00022!Q\u0011Q\u0012\u0014\u0003\u0016\u0004%\t!a$\t\u0015\u0005eeE!E!\u0002\u0013\t\t\n\u0003\u0006\u0002\u001c\u001a\u0012)\u001a!C\u0001\u0003;C!\"!,'\u0005#\u0005\u000b\u0011BAP\u0011)\tyK\nBK\u0002\u0013\u0005\u0011\u0011\u0017\u0005\u000b\u0003s3#\u0011#Q\u0001\n\u0005M\u0006BCA^M\tU\r\u0011\"\u0001\u0002>\"Q\u0011Q\u001a\u0014\u0003\u0012\u0003\u0006I!a0\t\u0015\u0005=gE!f\u0001\n\u0003\t\t\u000e\u0003\u0006\u0002n\u001a\u0012\t\u0012)A\u0005\u0003'Da!\u001c\u0014\u0005\u0002\u0005=\b\"CA\u007fM\u0005\u0005I\u0011AA\u0000\u0011%\u0011iAJI\u0001\n\u0003\u0011y\u0001C\u0005\u0003&\u0019\n\n\u0011\"\u0001\u0003(!I!1\u0006\u0014\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005c1\u0013\u0013!C\u0001\u0005gA\u0011Ba\u000e'#\u0003%\tA!\u000f\t\u0013\tub%%A\u0005\u0002\t}\u0002\"\u0003B\"M\u0005\u0005I\u0011\tB#\u0011%\u0011\tFJA\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003V\u0019\n\t\u0011\"\u0001\u0003X!I!1\r\u0014\u0002\u0002\u0013\u0005#Q\r\u0005\n\u0005[2\u0013\u0011!C\u0001\u0005_B\u0011Ba\u001d'\u0003\u0003%\tE!\u001e\t\u0013\ted%!A\u0005B\tm\u0004\"\u0003B?M\u0005\u0005I\u0011\tB@\u0011%\u0011\tIJA\u0001\n\u0003\u0012\u0019iB\u0005\u0005\u0010\u0001\t\t\u0011#\u0001\u0005\u0012\u0019I\u00111\u0002\u0001\u0002\u0002#\u0005A1\u0003\u0005\u0007[\u0016#\t\u0001b\u000b\t\u0013\tuT)!A\u0005F\t}\u0004\"\u0003C\u0017\u000b\u0006\u0005I\u0011\u0011C\u0018\u0011%!i$RA\u0001\n\u0003#ydB\u0005\u0005N=\u000b\t\u0011#\u0001\u0005P\u0019AajTA\u0001\u0012\u0003!\t\u0006\u0003\u0004n\u0017\u0012\u0005A1\u000b\u0005\n\t+Z\u0015\u0013!C\u0001\u0007g\u0011qBW6NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003!F\u000baa]3sm\u0016\u0014(\"\u0001*\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!V.`!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u0019\te.\u001f*fMB\u0011A,X\u0007\u0002\u001f&\u0011al\u0014\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\f\u0016!B;uS2\u001c\u0018B\u00013b\u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003-\u001eL!\u0001[,\u0003\u0007%sG/A\u0007jg6+H\u000e^5UK:\fg\u000e\u001e\t\u0003-.L!\u0001\\,\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"2a\u001c9r!\ta\u0006\u0001C\u0003f\u0007\u0001\u0007a\rC\u0004j\u0007A\u0005\t\u0019\u00016\u0002+A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dWV\tA\u000f\u0005\u0002v}6\taO\u0003\u0002xq\u0006)An\\2lg*\u0011\u0011P_\u0001\u000bG>t7-\u001e:sK:$(BA>}\u0003\u0011)H/\u001b7\u000b\u0003u\fAA[1wC&\u0011qP\u001e\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u00061\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\\u0007%\u0001\tnKR\fG-\u0019;b':\f\u0007o\u001d5piV\u0011\u0011q\u0001\t\u0004\u0003\u00131S\"\u0001\u0001\u0003!5+G/\u00193bi\u0006\u001cf.\u00199tQ>$8C\u0002\u0014V\u0003\u001f\t)\u0002E\u0002W\u0003#I1!a\u0005X\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0006\u0002(9!\u0011\u0011DA\u0012\u001d\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010'\u00061AH]8pizJ\u0011\u0001W\u0005\u0004\u0003K9\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003S\tYC\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002&]\u000bq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0003c\u0001\u0002\"a\r\u0002>\u0005\u0005\u0013\u0011K\u0007\u0003\u0003kQA!a\u000e\u0002:\u00059Q.\u001e;bE2,'bAA\u001e/\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\n\u0003:L(+\u001a4NCB\u0004B!a\u0011\u0002L9!\u0011QIA$!\r\tYbV\u0005\u0004\u0003\u0013:\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002N\u0005=#AB*ue&twMC\u0002\u0002J]\u0003b!a\r\u0002T\u0005]\u0013\u0002BA+\u0003k\u0011q\u0001T8oO6\u000b\u0007\u000f\u0005\u0003\u0002Z\u0005\u0015e\u0002BA.\u0003\u007frA!!\u0018\u0002z9!\u0011qLA:\u001d\u0011\t\t'a\u001c\u000f\t\u0005\r\u0014\u0011\u000e\b\u0005\u00037\t)'\u0003\u0002\u0002h\u0005\u0019qN]4\n\t\u0005-\u0014QN\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u001d\u0014b\u0001*\u0002r)!\u00111NA7\u0013\u0011\t)(a\u001e\u0002\r\r|W.\\8o\u0015\r\u0011\u0016\u0011O\u0005\u0005\u0003w\ni(A\u0004nKN\u001c\u0018mZ3\u000b\t\u0005U\u0014qO\u0005\u0005\u0003\u0003\u000b\u0019)A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f'\u0002BA>\u0003{JA!a\"\u0002\n\naR\u000b\u001d3bi\u0016lU\r^1eCR\f\u0007+\u0019:uSRLwN\\*uCR,'\u0002BAA\u0003\u0007\u000b\u0001\u0003]1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002\u001dQ|\u0007/[2t\u0005f$VM\\1oiV\u0011\u0011\u0011\u0013\t\t\u0003g\ti$!\u0011\u0002\u0014B1\u00111GAK\u0003\u0003JA!a&\u00026\t9\u0001*Y:i'\u0016$\u0018a\u0004;pa&\u001c7OQ=UK:\fg\u000e\u001e\u0011\u0002\u0011Q|\u0007/[2JIN,\"!a(\u0011\u0011\u0005\r\u0013\u0011UA!\u0003KKA!a)\u0002P\t\u0019Q*\u00199\u0011\t\u0005\u001d\u0016\u0011V\u0007\u0003\u0003{JA!a+\u0002~\t!Q+^5e\u0003%!x\u000e]5d\u0013\u0012\u001c\b%\u0001\u0007d_:$(o\u001c7mKJLE-\u0006\u0002\u00024B!a+!.g\u0013\r\t9l\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u00031\tG.\u001b<f\u0005J|7.\u001a:t+\t\ty\f\u0005\u0004\u00024\u0005M\u0013\u0011\u0019\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011qY)\u0002\u000f\rdWo\u001d;fe&!\u00111ZAc\u0005\u0019\u0011%o\\6fe\u0006i\u0011\r\\5wK\n\u0013xn[3sg\u0002\n!\"\u00197jm\u0016tu\u000eZ3t+\t\t\u0019\u000e\u0005\u0004\u00024\u0005M\u0013Q\u001b\t\t\u0003/\fI.a7\u0002h6\u0011\u0011\u0011H\u0005\u0005\u0003G\u000bI\u0004\u0005\u0003\u0002^\u0006\rXBAAp\u0015\u0011\t\t/! \u0002\u000f9,Go^8sW&!\u0011Q]Ap\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\t9+!;\n\t\u0005-\u0018Q\u0010\u0002\u0005\u001d>$W-A\u0006bY&4XMT8eKN\u0004CCDA\u0004\u0003c\f\u00190!>\u0002x\u0006e\u00181 \u0005\b\u0003[\u0019\u0004\u0019AA\u0019\u0011\u001d\tii\ra\u0001\u0003#Cq!a'4\u0001\u0004\ty\nC\u0004\u00020N\u0002\r!a-\t\u000f\u0005m6\u00071\u0001\u0002@\"9\u0011qZ\u001aA\u0002\u0005M\u0017\u0001B2paf$b\"a\u0002\u0003\u0002\t\r!Q\u0001B\u0004\u0005\u0013\u0011Y\u0001C\u0005\u0002.Q\u0002\n\u00111\u0001\u00022!I\u0011Q\u0012\u001b\u0011\u0002\u0003\u0007\u0011\u0011\u0013\u0005\n\u00037#\u0004\u0013!a\u0001\u0003?C\u0011\"a,5!\u0003\u0005\r!a-\t\u0013\u0005mF\u0007%AA\u0002\u0005}\u0006\"CAhiA\u0005\t\u0019AAj\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0005+\t\u0005E\"1C\u0016\u0003\u0005+\u0001BAa\u0006\u0003\"5\u0011!\u0011\u0004\u0006\u0005\u00057\u0011i\"A\u0005v]\u000eDWmY6fI*\u0019!qD,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003$\te!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0015U\u0011\t\tJa\u0005\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0006\u0016\u0005\u0003?\u0013\u0019\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tU\"\u0006BAZ\u0005'\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003<)\"\u0011q\u0018B\n\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"A!\u0011+\t\u0005M'1C\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u001d\u0003\u0003\u0002B%\u0005\u001fj!Aa\u0013\u000b\u0007\t5C0\u0001\u0003mC:<\u0017\u0002BA'\u0005\u0017\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012AZ\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011IFa\u0018\u0011\u0007Y\u0013Y&C\u0002\u0003^]\u00131!\u00118z\u0011!\u0011\t'PA\u0001\u0002\u00041\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003hA1\u0011q\u001bB5\u00053JAAa\u001b\u0002:\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ'\u0011\u000f\u0005\n\u0005Cz\u0014\u0011!a\u0001\u00053\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\tB<\u0011!\u0011\t\u0007QA\u0001\u0002\u00041\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0019\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000f\na!Z9vC2\u001cHc\u00016\u0003\u0006\"I!\u0011M\"\u0002\u0002\u0003\u0007!\u0011L\u0001\u0015[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R|F%Z9\u0015\t\t-%\u0011\u0013\t\u0004-\n5\u0015b\u0001BH/\n!QK\\5u\u0011%\u0011\tgBA\u0001\u0002\u0004\t9!A\tnKR\fG-\u0019;b':\f\u0007o\u001d5pi\u0002B3\u0001\u0003BL!\r1&\u0011T\u0005\u0004\u00057;&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0003\"B!!1\u0015BU\u001b\t\u0011)KC\u0002\u0003(F\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\u0011YK!*\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0013\u0001G7bs\n,g)\u001b7uKJ\fE.\u001b<f%\u0016\u0004H.[2bgRQ!1\u0017Ba\u0005\u000b\u0014IM!4\u0011\r\tU&q\u0017B^\u001b\u0005Q\u0018b\u0001B]u\n!A*[:u!\u0011\u0011IE!0\n\t\t}&1\n\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011\u0019m\u0003a\u0001\u0003\u000f\t\u0001b\u001d8baNDw\u000e\u001e\u0005\b\u0005\u000f\\\u0001\u0019\u0001BZ\u0003\u001d\u0011'o\\6feNDqAa3\f\u0001\u0004\tY.\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0003\u0004\u0003P.\u0001\rA[\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo]\u0001\u0015O\u0016$\b+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0015\u0019\tU'1\u001eBw\u0005c\u0014\u0019Pa>\u0011\u000bY\u000b)La6\u0011\r\u0005]!\u0011\u001cBo\u0013\u0011\u0011Y.a\u000b\u0003\u0011%#XM]1cY\u0016\u0004BAa8\u0003f:!\u00111\fBq\u0013\u0011\u0011\u0019/a!\u0002)5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u00119O!;\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0005G\f\u0019\tC\u0004\u0003D2\u0001\r!a\u0002\t\u000f\t=H\u00021\u0001\u0002B\u0005)Ao\u001c9jG\"9!1\u001a\u0007A\u0002\u0005m\u0007B\u0002B{\u0019\u0001\u0007!.A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bB\u0002B}\u0019\u0001\u0007!.A\rfeJ|'/\u00168bm\u0006LG.\u00192mK2K7\u000f^3oKJ\u001c\u0018\u0001\u00055bg\u0006c\u0017N^3F]\u0012\u0004x.\u001b8u)\u001dQ'q`B\u0001\u0007\u0007AqAa1\u000e\u0001\u0004\t9\u0001C\u0003f\u001b\u0001\u0007a\rC\u0004\u0003L6\u0001\r!a7\u0002!\u001d,G/\u00117jm\u0016,e\u000e\u001a9pS:$H\u0003CB\u0005\u0007\u0017\u0019iaa\u0004\u0011\u000bY\u000b),a:\t\u000f\t\rg\u00021\u0001\u0002\b!)QM\u0004a\u0001M\"9!1\u001a\bA\u0002\u0005m\u0017\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0019)b!\t\u0004,\r52q\u0006\t\u0007\u0003/\u001c9ba\u0007\n\t\re\u0011\u0011\b\u0002\u0004'\u0016\f\b\u0003\u0002Bp\u0007;IAaa\b\u0003j\n)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c\u0007bBB\u0012\u001f\u0001\u00071QE\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005]7qEA!\u0013\u0011\u0019I#!\u000f\u0003\u0007M+G\u000fC\u0004\u0003L>\u0001\r!a7\t\u0011\tUx\u0002%AA\u0002)D\u0001B!?\u0010!\u0003\u0005\rA[\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0007kQ3A\u001bB\n\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135\u000319W\r^!mYR{\u0007/[2t)\u0011\u0019)c!\u0010\t\u000f\r}\"\u00031\u0001\u0004B\u0005yA/\u001a8b]R\u0004&/\u001a4jq>\u0003H\u000fE\u0003W\u0003k\u000b\t%\u0001\nhKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0003BB$\u0007\u001f\u0002b!a6\u0004(\r%\u0003\u0003BAT\u0007\u0017JAa!\u0014\u0002~\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBB)'\u0001\u0007\u0011\u0011I\u0001\ni>\u0004\u0018n\u0019(b[\u0016$ba!\n\u0004V\r]\u0003b\u0002Bb)\u0001\u0007\u0011q\u0001\u0005\b\u0007\u007f!\u0002\u0019AB!\u0003A9W\r^!mYB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0004^\r}\u0003\u0003CA\"\u0003C\u001bI%a\u0016\t\u000f\t\rW\u00031\u0001\u0002\b\u0005!r-\u001a;O_:,\u00050[:uS:<Gk\u001c9jGN$Ba!\n\u0004f!911\u0005\fA\u0002\r\u0015\u0012A\u00045bg\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0004U\u000e-\u0004\"B3\u0018\u0001\u00041\u0017aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\rE\u0004CBA\f\u00053\u001c\u0019\b\u0005\u0003\u0004v\rmTBAB<\u0015\r\u0019I(U\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0007{\u001a9H\u0001\bCe>\\WM]'fi\u0006$\u0017\r^1\u0002%\u001d,G/\u00117jm\u0016\u0014%o\\6fe:{G-\u001a\u000b\u0007\u0007\u0013\u0019\u0019i!\"\t\u000b\u0015L\u0002\u0019\u00014\t\u000f\t-\u0017\u00041\u0001\u0002\\\u0006\u0019r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3fgR!11RBG!\u0019\t9B!7\u0002h\"9!1\u001a\u000eA\u0002\u0005m\u0017\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0019\u0019j!&\u0004\u0018B)a+!.\u0002X!9!q^\u000eA\u0002\u0005\u0005\u0003BBBM7\u0001\u0007a-A\u0006qCJ$\u0018\u000e^5p]&#\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u00024\u000e}\u0005b\u0002Bx9\u0001\u0007\u0011\u0011I\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u0007\u0013\u0019)ka*\u0004*\"9!q^\u000fA\u0002\u0005\u0005\u0003BBBM;\u0001\u0007a\rC\u0004\u0003Lv\u0001\r!a7\u00029\u001d,G\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1F]\u0012\u0004x.\u001b8ugR11qVBY\u0007k\u0003r!a\u0011\u0002\"\u001a\f9\u000fC\u0004\u00044z\u0001\ra!\u0013\u0002\u0005Q\u0004\bb\u0002Bf=\u0001\u0007\u00111\\\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JI\u0006\u0011r-\u001a;DYV\u001cH/\u001a:NKR\fG-\u0019;b)\u0019\u0019ila1\u0004HB!\u0011qUB`\u0013\u0011\u0019\t-! \u0003\u000f\rcWo\u001d;fe\"91Q\u0019\u0011A\u0002\u0005\u0005\u0013!C2mkN$XM]%e\u0011\u001d\u0011Y\r\ta\u0001\u00037\fa\"\u001e9eCR,W*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0004N\u000e=71\u001b\t\u0007\u0003/\u001c9b!\u0013\t\r\rE\u0017\u00051\u0001g\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\"91Q[\u0011A\u0002\r]\u0017!F;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\t\u0005\u00073\u001cy.\u0004\u0002\u0004\\*!1Q\\A?\u0003!\u0011X-];fgR\u001c\u0018\u0002BBq\u00077\u0014Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH/\u0001\u0005d_:$\u0018-\u001b8t)\rQ7q\u001d\u0005\b\u0005_\u0014\u0003\u0019AA!)\rQ71\u001e\u0005\b\u0007g\u001b\u0003\u0019AB%\u0003a\tG\rZ(s+B$\u0017\r^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\r\u0005\u0017\u001b\tpa=\u0004v\u000e]8\u0011 \u0005\b\u0003[!\u0003\u0019AA\u0019\u0011\u001d\ti\t\na\u0001\u0003#CqAa<%\u0001\u0004\t\t\u0005\u0003\u0004\u0004\u001a\u0012\u0002\rA\u001a\u0005\b\u0007w$\u0003\u0019AA,\u0003%\u0019H/\u0019;f\u0013:4w.A\nsK6|g/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0007\u0003\f\u0012\u0005A1\u0001C\u0003\t\u0017!i\u0001C\u0004\u0002.\u0015\u0002\r!!\r\t\u000f\u00055U\u00051\u0001\u0002\u0012\"9\u00111T\u0013A\u0002\u0011\u001d\u0001\u0003CA\u001a\t\u0013\t\t%!*\n\t\u0005\r\u0016Q\u0007\u0005\b\u0005_,\u0003\u0019AA!\u0011\u0019\u0019I*\na\u0001M\u0006\u0001R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\t\u0004\u0003\u0013)5#B#\u0005\u0016\u0011\u0005\u0002C\u0005C\f\t;\t\t$!%\u0002 \u0006M\u0016qXAj\u0003\u000fi!\u0001\"\u0007\u000b\u0007\u0011mq+A\u0004sk:$\u0018.\\3\n\t\u0011}A\u0011\u0004\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:4\u0004\u0003\u0002C\u0012\tSi!\u0001\"\n\u000b\u0007\u0011\u001dB0\u0001\u0002j_&!\u0011\u0011\u0006C\u0013)\t!\t\"A\u0003baBd\u0017\u0010\u0006\b\u0002\b\u0011EB1\u0007C\u001b\to!I\u0004b\u000f\t\u000f\u00055\u0002\n1\u0001\u00022!9\u0011Q\u0012%A\u0002\u0005E\u0005bBAN\u0011\u0002\u0007\u0011q\u0014\u0005\b\u0003_C\u0005\u0019AAZ\u0011\u001d\tY\f\u0013a\u0001\u0003\u007fCq!a4I\u0001\u0004\t\u0019.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0011\u0005C\u0011\n\t\u0006-\u0006UF1\t\t\u0010-\u0012\u0015\u0013\u0011GAI\u0003?\u000b\u0019,a0\u0002T&\u0019AqI,\u0003\rQ+\b\u000f\\37\u0011%!Y%SA\u0001\u0002\u0004\t9!A\u0002yIA\nqBW6NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u00039.\u001b\"aS+\u0015\u0005\u0011=\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final boolean isMultiTenant;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return false;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        CollectionConverters$.MODULE$.ListHasAsScala(brokers).asScala().foreach((Function1 & Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable)partitions -> (scala.collection.mutable.Iterable)partitions.map((Function1 & Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError(null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List offlineReplicas = partitionState.offlineReplicas();
            List observers = partitionState.observers();
            List<Integer> filteredObservers = this.maybeFilterAliveReplicas(snapshot, observers, listenerName, errorUnavailableEndpoints);
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").toString()).append(new StringBuilder(20).append("not found on leader ").append(leaderBrokerId).toString()).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString()).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(isr).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString()).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (!this.isMultiTenant && tenantPrefixOpt.isDefined()) {
            throw new IllegalStateException("Multi-tenant getAllTopics but metadataCache is not multitenant. Multitenant interceptor and multitenant metadata must always be configured together in a multitenant broker.");
        }
        return this.getAllTopics(this.metadataSnapshot(), tenantPrefixOpt);
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((IterableOnceOps)((MapOps)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable)p -> new TopicPartition(topicName, p.partitionIndex()))).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot, Option<String> tenantPrefixOpt) {
        Set set;
        if (tenantPrefixOpt instanceof Some) {
            String tenantPrefix = (String)((Some)tenantPrefixOpt).value();
            set = (Set)snapshot.topicsByTenant().getOrElse((Object)tenantPrefix, (Function0 & Serializable)() -> (Set)Set$.MODULE$.empty());
        } else if (None$.MODULE$.equals(tenantPrefixOpt)) {
            set = snapshot.partitionStates().keySet();
        } else {
            throw new MatchError(tenantPrefixOpt);
        }
        return set;
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple2;
            });
            return map;
        }, DummyImplicit$.MODULE$.dummyImplicit()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.diff(this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable)x$4 -> x$4.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable)x$5 -> x$5.getNode(listenerName));
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$6 -> x$6.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable)x$9 -> x$9.get((long)tp.partition())).map((Function1 & Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaIds).asScala().map((Function1 & Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long id = x0$1._1$mcJ$sp();
            Option option = ((Map)x0$1._2()).get((Object)listenerName).map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node));
            return option;
        });
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((IterableOps)this.getAllPartitions(snapshot).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = PartitionInfo.of((String)tp.topic(), (int)tp.partition(), (Node)ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.replicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.observers()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.isr()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.offlineReplicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            return partitionInfo;
        });
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getAllTopics(snapshot, (Option<String>)None$.MODULE$).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$10(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        Lock inWriteLock_inLock_lock = this.partitionMetadataLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        String tenantPrefix;
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
        if (this.isMultiTenant && (tenantPrefix = TenantHelpers.extractTenantPrefix(topic)) != null) {
            ((HashSet)topicsByTenant.getOrElseUpdate((Object)tenantPrefix, (Function0 & Serializable)() -> HashSet$.MODULE$.empty())).add((Object)topic);
            return;
        }
    }

    private void removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        partitionStates.get((Object)topic).foreach((Function1 & Serializable)infos -> {
            ZkMetadataCache.$anonfun$removePartitionInfo$1(this, partitionId, partitionStates, topic, topicIds, topicsByTenant, infos);
            return BoxedUnit.UNIT;
        });
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$10(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x$11) {
        Object object = x$11._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return object == null ? uuid != null : !object.equals(uuid);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            java.util.Map tags = UpdateMetadataRequest.tagMapFromBrokerTagCollection((List)broker.tags());
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new ConfluentNode(broker.id(), ep.host(), ep.port(), broker.rack(), tags));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack()), (scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(tags).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            aliveNodes.update((long)broker.id(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newTopicIds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest$1.topicStates()).asScala().map((Function1 & Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()))).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x$11)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map topicIds = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        topicIds.$plus$plus$eq((IterableOnce)newTopicIds);
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), $this.metadataSnapshot().topicsByTenant(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            $this.metadataSnapshot().partitionStates().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(topic, partitions) -> {
                partitionStates.update((Object)topic, (Object)partitions.clone());
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            AnyRefMap topicsByTenant = new AnyRefMap($this.metadataSnapshot().topicsByTenant().size());
            $this.metadataSnapshot().topicsByTenant().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(tenantPrefix, topics) -> {
                topicsByTenant.update((Object)tenantPrefix, (Object)topics.clone());
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = CollectionConverters$.MODULE$.IterableHasAsScala(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").toString()).append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString()).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").toString()).append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString()).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(60).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").toString()).append(new StringBuilder(85).append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString()).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ void $anonfun$removePartitionInfo$1(ZkMetadataCache $this, int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, AnyRefMap topicsByTenant$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            String tenantPrefix;
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
            if ($this.isMultiTenant && (tenantPrefix = TenantHelpers.extractTenantPrefix(topic$4)) != null) {
                topicsByTenant$2.get((Object)tenantPrefix).foreach((Function1 & Serializable)topics -> {
                    topics.remove((Object)topic$4);
                    if (topics.isEmpty()) {
                        return topicsByTenant$2.remove((Object)tenantPrefix);
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public ZkMetadataCache(int brokerId, boolean isMultiTenant) {
        this.brokerId = brokerId;
        this.isMultiTenant = isMultiTenant;
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (AnyRefMap<String, HashSet<String>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final AnyRefMap<String, HashSet<String>> topicsByTenant;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public AnyRefMap<String, HashSet<String>> topicsByTenant() {
            return this.topicsByTenant;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicsByTenant, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public AnyRefMap<String, HashSet<String>> copy$default$2() {
            return this.topicsByTenant();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$3() {
            return this.topicIds();
        }

        public Option<Object> copy$default$4() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$5() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$6() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicsByTenant();
                }
                case 2: {
                    return this.topicIds();
                }
                case 3: {
                    return this.controllerId();
                }
                case 4: {
                    return this.aliveBrokers();
                }
                case 5: {
                    return this.aliveNodes();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "partitionStates";
                }
                case 1: {
                    return "topicsByTenant";
                }
                case 2: {
                    return "topicIds";
                }
                case 3: {
                    return "controllerId";
                }
                case 4: {
                    return "aliveBrokers";
                }
                case 5: {
                    return "aliveNodes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            AnyRefMap<String, HashSet<String>> anyRefMap3 = this.topicsByTenant();
            AnyRefMap<String, HashSet<String>> anyRefMap4 = metadataSnapshot.topicsByTenant();
            if (anyRefMap3 == null) {
                if (anyRefMap4 != null) {
                    return false;
                }
            } else if (!anyRefMap3.equals(anyRefMap4)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicsByTenant = topicsByTenant;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

