/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.log.TierLogSegment;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetFromLeader;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchMetadata;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001B\u0016-\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\n\t\u0002\u0011\t\u0011)A\u0005\u000b.C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011%a\u0006A!A!\u0002\u0013i\u0006\rC\u0003b\u0001\u0011\u0005!\rC\u0004l\u0001\t\u0007I\u0011\u00027\t\rE\u0004\u0001\u0015!\u0003n\u0011\u001d\u0011\bA1A\u0005\nMDa\u0001 \u0001!\u0002\u0013!\bbB?\u0001\u0005\u0004%Ia\u001d\u0005\u0007}\u0002\u0001\u000b\u0011\u0002;\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003A\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0011\u00055\u0002\u0001)Q\u0005\u0003\u0007Aq!a\f\u0001\t#\n\t\u0004C\u0004\u0002:\u0001!\t&a\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0015\u0002H!9\u00111\n\u0001\u0005R\u00055\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\tI\u000b\u0001C!\u0003WCq!a0\u0001\t#\n\t\rC\u0004\u0002J\u0002!\t&a3\t\u000f\u0005]\u0007\u0001\"\u0015\u0002Z\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\b\"\u0003B\f\u0001\t\u0007I\u0011\u000bB\r\u0011!\u0011\t\u0003\u0001Q\u0001\n\tm\u0001\"\u0003B\u0012\u0001\t\u0007I\u0011\u000bB\r\u0011!\u0011)\u0003\u0001Q\u0001\n\tm\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005o\u0001A\u0011\u000bB\u001d\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003`\u0001!IA!\u0019\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\"9!q\u0012\u0001\u0005R\tE\u0005b\u0002BR\u0001\u0011E#Q\u0015\u0005\b\u0005\u0007\u0004A\u0011\u000bBc\u0011\u001d\u0011\u0019\u000e\u0001C)\u0005+\u0014\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u0011QFL\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001eA\u00111\u0007N\u0007\u0002Y%\u0011Q\u0007\f\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0003\u0011q\u0017-\\3\u0011\u0005a\neBA\u001d@!\tQT(D\u0001<\u0015\ta\u0004'\u0001\u0004=e>|GO\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)P\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A{\u0005a1o\\;sG\u0016\u0014%o\\6feB\u0011a)S\u0007\u0002\u000f*\u0011\u0001JL\u0001\bG2,8\u000f^3s\u0013\tQuI\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\n\u0005\u0011#\u0014\u0001\u00042s_.,'oQ8oM&<\u0007CA\u001aO\u0013\tyEFA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\t\u0019$+\u0003\u0002TY\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u001aW\u0013\t9FF\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005MR\u0016BA.-\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB\u00111GX\u0005\u0003?2\u0012\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\n\u0005q#\u0014A\u0002\u001fj]&$h\b\u0006\u0005dI\u00164w\r[5k!\t\u0019\u0004\u0001C\u00037\u0011\u0001\u0007q\u0007C\u0003E\u0011\u0001\u0007Q\tC\u0003M\u0011\u0001\u0007Q\nC\u0003Q\u0011\u0001\u0007\u0011\u000bC\u0003U\u0011\u0001\u0007Q\u000bC\u0003Y\u0011\u0001\u0007\u0011\fC\u0003]\u0011\u0001\u0007Q,A\u0005sKBd\u0017nY1JIV\tQ\u000e\u0005\u0002o_6\tQ(\u0003\u0002q{\t\u0019\u0011J\u001c;\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0005nCb\u0014\u0015\u0010^3t+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\b\u0013:$XmZ3s\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b%A\u0005gKR\u001c\u0007nU5{K\u0006Qa-\u001a;dQNK'0\u001a\u0011\u0002'%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8\u0016\u0005\u0005\r\u0001#\u00028\u0002\u0006\u0005%\u0011bAA\u0004{\t1q\n\u001d;j_:\u0004B!a\u0003\u0002\u001c5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0004d_6lwN\u001c\u0006\u0004_\u0005M!\u0002BA\u000b\u0003/\ta!\u00199bG\",'BAA\r\u0003\ry'oZ\u0005\u0005\u0003;\tiA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002/%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\u0012\u0003S\u00012A\\A\u0013\u0013\r\t9#\u0010\u0002\u0005+:LG\u000fC\u0005\u0002,A\t\t\u00111\u0001\u0002\u0004\u0005\u0019\u0001\u0010J\u0019\u0002)%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\u0005M\u0012Q\u0007\t\u0005]\u0006\u0015Q\u000eC\u0004\u00028I\u0001\r!!\u0003\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA\u001f\u0003\u0007\u00022A\\A \u0013\r\t\t%\u0010\u0002\u0005\u0019>tw\rC\u0004\u00028M\u0001\r!!\u0003\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005u\u0012\u0011\n\u0005\b\u0003o!\u0002\u0019AA\u0005\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u001f\n9&!\u0017\u0011\u000b9\f)!!\u0015\u0011\u0007M\n\u0019&C\u0002\u0002V1\u0012ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0004\u00028U\u0001\r!!\u0003\t\r\u0005mS\u00031\u0001n\u0003\u0015)\u0007o\\2i\u0003=1W\r^2i\rJ|W\u000eT3bI\u0016\u0014H\u0003BA1\u0003k\u0002\u0002\"a\u0019\u0002j\u0005%\u0011QN\u0007\u0003\u0003KR1!a\u001a>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\n)GA\u0002NCB\u0004B!a\u001c\u0002r5\t\u0001!C\u0002\u0002tQ\u0012\u0011BR3uG\"$\u0015\r^1\t\u000f\u0005]d\u00031\u0001\u0002z\u0005aa-\u001a;dQJ+\u0017/^3tiB!\u00111PAD\u001d\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003\u001b\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u000b\u000by(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002\n\u0006-%a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u000b\u000by(\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003#\u000by*!)\u0002&B)a.!\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a:\n1\u0001\\8h\u0013\u0011\ti*a&\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t9d\u0006a\u0001\u0003\u0013Aq!a)\u0018\u0001\u0004\ti$A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBAT/\u0001\u0007\u0011QN\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0011\ti+a-\u0011\r\u0005\r\u0014qVA\u0005\u0013\u0011\t\t,!\u001a\u0003\u0007M+G\u000fC\u0004\u00026b\u0001\r!a.\u0002%%t\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$Xm\u001d\t\t\u0003G\nI'!\u0003\u0002:B\u00191'a/\n\u0007\u0005uFFA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\fQDZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003{\t\u0019-!2\t\u000f\u0005]\u0012\u00041\u0001\u0002\n!1\u0011qY\rA\u00025\f1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006Ac-\u001a;dQRKWM]'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UCJ<W\r\u001e$s_6dU-\u00193feR1\u0011QZAj\u0003+\u00042aMAh\u0013\r\t\t\u000e\f\u0002\u0011\u001f\u001a47/\u001a;Ge>lG*Z1eKJDq!a\u000e\u001b\u0001\u0004\tI\u0001\u0003\u0004\u0002Hj\u0001\r!\\\u0001\u001cM\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u0005u\u00121\\Ao\u0011\u001d\t9d\u0007a\u0001\u0003\u0013Aa!a2\u001c\u0001\u0004i\u0017\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0002d\n-\u0001\u0003CA2\u0003S\nI!!:\u0011\t\u0005\u001d(Q\u0001\b\u0005\u0003S\fyP\u0004\u0003\u0002l\u0006mh\u0002BAw\u0003stA!a<\u0002x:!\u0011\u0011_A{\u001d\rQ\u00141_\u0005\u0003\u00033IA!!\u0006\u0002\u0018%\u0019q&a\u0005\n\t\u0005=\u0011\u0011C\u0005\u0005\u0003{\fi!A\u0004nKN\u001c\u0018mZ3\n\t\t\u0005!1A\u0001!\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002~\u00065\u0011\u0002\u0002B\u0004\u0005\u0013\u0011a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0003\u0002\t\r\u0001b\u0002B\u00079\u0001\u0007!qB\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003CA2\u0003S\nIA!\u0005\u0011\t\u0005=$1C\u0005\u0004\u0005+!$!C#q_\u000eDG)\u0019;b\u0003}I7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u00057\u00012A\u001cB\u000f\u0013\r\u0011y\"\u0010\u0002\b\u0005>|G.Z1o\u0003\u0001J7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\r\u001a\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fI\u0006i\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$\u0007%\u0001\u0005ueVt7-\u0019;f)\u0019\t\u0019Ca\u000b\u0003.!9\u0011qG\u0011A\u0002\u0005%\u0001b\u0002B\u0018C\u0001\u0007!\u0011G\u0001\u0010iJ,hnY1uS>t7\u000b^1uKB\u00191Ga\r\n\u0007\tUBFA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBA\u0012\u0005w\u0011i\u0004C\u0004\u00028\t\u0002\r!!\u0003\t\u000f\t}\"\u00051\u0001\u0002>\u00051qN\u001a4tKR\f!C\\3yiJ+\u0017\rZ=QCJ$\u0018\u000e^5p]R!!Q\tB*!\u0015q\u0017Q\u0001B$!\u001dq'\u0011JA\u0005\u0005\u001bJ1Aa\u0013>\u0005\u0019!V\u000f\u001d7feA\u00191Ga\u0014\n\u0007\tECFA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0003V\r\u0002\rAa\u0016\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\u0011\u0005\r\u0014\u0011NA\u0005\u0005\u001b\nac]3mK\u000e$\b+\u0019:uSRLwN\u001c+p\r\u0016$8\r\u001b\u000b\u0005\u0005\u000b\u0012i\u0006C\u0004\u0003V\u0011\u0002\rAa\u0016\u0002-\t,\u0018\u000e\u001c3GKR\u001c\u0007NR8s!\u0006\u0014H/\u001b;j_:$bAa\u0019\u0003\u0002\n\u0015\u0005C\u0002B3\u0005g\u0012IH\u0004\u0003\u0003h\t=d\u0002\u0002B5\u0005[r1A\u000fB6\u0013\u0005y\u0013BA\u0017/\u0013\r\u0011\t\bL\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0011)Ha\u001e\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0011\t\b\f\t\u0006]\u0006\u0015!1\u0010\t\u0005\u0005K\u0012i(\u0003\u0003\u0003\u0000\t]$\u0001\u0004*fa2L7-\u0019$fi\u000eD\u0007b\u0002BBK\u0001\u0007\u0011\u0011B\u0001\u0003iBDqAa\"&\u0001\u0004\u0011i%\u0001\u0006gKR\u001c\u0007n\u0015;bi\u0016\f!BY;jY\u00124U\r^2i)\u0011\u0011\u0019G!$\t\u000f\tUc\u00051\u0001\u0003X\u0005\u0011rN\u001c*fgR|'/\u001a+jKJ\u001cF/\u0019;f)!\t\u0019Ca%\u0003\u0016\ne\u0005bBA\u001cO\u0001\u0007\u0011\u0011\u0002\u0005\b\u0005/;\u0003\u0019AA\u001f\u0003U\u0001(o\u001c9pg\u0016$Gj\\2bY2{wm\u0015;beRDqAa'(\u0001\u0004\u0011i*A\u0005uS\u0016\u00148\u000b^1uKB\u00191Ga(\n\u0007\t\u0005FFA\u0005US\u0016\u00148\u000b^1uK\u0006qa-\u001a;dQRKWM]*uCR,GC\u0002BT\u0005o\u0013I\f\u0005\u0004\u0003*\nM&QT\u0007\u0003\u0005WSAA!,\u00030\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\tE\u00060\u0001\u0003vi&d\u0017\u0002\u0002B[\u0005W\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f\u0011\u001d\t9\u0004\u000ba\u0001\u0003\u0013AqAa/)\u0001\u0004\u0011i,A\u0006uS\u0016\u00148+Z4nK:$\b\u0003BAK\u0005\u007fKAA!1\u0002\u0018\nqA+[3s\u0019><7+Z4nK:$\u0018aH7bi\u0016\u0014\u0018.\u00197ju\u0016$\u0016.\u001a:Ti\u0006$X-\u00168uS2|eMZ:fiR1!q\u0019Bg\u0005\u001f\u0004bA!+\u0003J\nu\u0016\u0002\u0002Bf\u0005W\u0013aAR;ukJ,\u0007bBA\u001cS\u0001\u0007\u0011\u0011\u0002\u0005\b\u0005#L\u0003\u0019AA\u001f\u00031!\u0018M]4fi>3gm]3u\u0003\u0005j\u0017\r^3sS\u0006d\u0017N_3US\u0016\u00148\u000b^1uKVsG/\u001b7PE*,7\r^%e))\u00119Ma6\u0003Z\nm'q\u001d\u0005\b\u0003oQ\u0003\u0019AA\u0005\u0011\u001d\u0011\tN\u000ba\u0001\u0003{AqA!8+\u0001\u0004\u0011y.\u0001\buCJ<W\r^(cU\u0016\u001cG/\u00133\u0011\t\t\u0005(1]\u0007\u0003\u0005_KAA!:\u00030\n!Q+V%E\u0011\u0019\u0011IO\u000ba\u0001[\u0006\u0011B/\u0019:hKR\u0014Vm\u001d;pe\u0016,\u0005o\\2i\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean isTruncationOnFetchSupported;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.data().topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic.topic(), partition.partition())), (Object)new FullPartitionFetchMetadata(partition.fetchOffset(), partition.logStartOffset(), partition.partitionMaxBytes(), RequestUtils.getLeaderEpoch((int)partition.currentLeaderEpoch()), RequestUtils.getLeaderEpoch((int)partition.lastFetchedEpoch()))))));
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)partitions, QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel(), (Option<ClientMetadata>)None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(((IterableOnceOps)partitions.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LeaderOffsetIncremented$.MODULE$);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logStartOffset();
    }

    @Override
    public OffsetFromLeader fetchTierMaterializationTargetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Alter log dirs does not support tiered partitions");
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaMgr.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        });
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((IterableOnceOps)partitionMap.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$4 -> ReplicaAlterLogDirsThread.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$4))))) : Optional.empty();
            requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.KAFKA_STORAGE_ERROR));
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaId;
            boolean bl = false;
            boolean bl2 = false;
            int n = this.replicaId();
            short forReplica_allowedVersion = ApiKeys.FETCH.latestVersion();
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(forReplica_allowedVersion, forReplica_allowedVersion, (int)forReplica_replicaId, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)((Map)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)((Map)scala.collection.Map$.MODULE$.empty()));
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        throw new UnsupportedOperationException("Restoring tier state during an alter log dirs operation is not currently supported.");
    }

    public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        throw new UnsupportedOperationException("Fetching tier state during an alter log dirs operation is not currently supported.");
    }

    @Override
    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    @Override
    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)x$1).asJava()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(data.error().code()).setHighWatermark(data.highWatermark()).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset()).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records()));
            return tuple2;
        });
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitionMap$1.get((Object)tp).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isReadyForFetch())).foreach((Function1 & Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(52).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").toString()).append(new StringBuilder(81).append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, brokerTopicStats, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.empty()));
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isOffsetForLeaderEpochSupported = true;
        this.isTruncationOnFetchSupported = false;
    }
}

