/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Iterator;
import kafka.server.BrokerTopicStats;
import kafka.server.LogReadResult;
import org.apache.kafka.common.record.RecordBatch;

public final class FetchLag$ {
    public static final FetchLag$ MODULE$ = new FetchLag$();
    private static final long UnknownFetchLagMs = -1L;

    public long UnknownFetchLagMs() {
        return UnknownFetchLagMs;
    }

    private long lagInMs(LogReadResult result) {
        if (!result.isReadAllowed()) {
            return this.UnknownFetchLagMs();
        }
        Iterator iterator = result.info().records().batches().iterator();
        if (!iterator.hasNext()) {
            return 0L;
        }
        long firstBatchTimestamp = ((RecordBatch)iterator.next()).maxTimestamp();
        if (firstBatchTimestamp == -1L || result.fetchTimeMs() < firstBatchTimestamp) {
            return this.UnknownFetchLagMs();
        }
        return result.fetchTimeMs() - firstBatchTimestamp;
    }

    public void maybeRecordConsumerFetchTimeLag(boolean isFromConsumer, LogReadResult result, BrokerTopicStats brokerTopicStats) {
        long fetchLagMs;
        if (isFromConsumer && (fetchLagMs = this.lagInMs(result)) != this.UnknownFetchLagMs()) {
            brokerTopicStats.allTopicsStats().consumerFetchLagTimeMs().update(fetchLagMs);
            return;
        }
    }

    private FetchLag$() {
    }
}

