/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotas$;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.server.ProcessorQueueSizePercentiles$;
import kafka.server.QueueSizePercentiles;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r%g!\u0002-Z\u0001mk\u0006\u0002\u00035\u0001\u0005\u000b\u0007I\u0011\u00016\t\u0011E\u0004!\u0011!Q\u0001\n-D\u0001B\u001d\u0001\u0003\u0002\u0004%\ta\u001d\u0005\tu\u0002\u0011\t\u0019!C\u0001w\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006K\u0001\u001e\u0005\n\u0003\u001b\u0001!Q1A\u0005\u0002MD\u0011\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0013\u0005E\u0001A!b\u0001\n\u0003\u0019\b\"CA\n\u0001\t\u0005\t\u0015!\u0003u\u0011%\t)\u0002\u0001B\u0001B\u0003%A\u000f\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0005\u00033A\u0011\"\u001a\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002P\u0001\u0011\t\u0011)A\u0005\u0003#B!\"!\u0018\u0001\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011\u001d\ty\u0006\u0001C\u0001\u0003CB\u0011\"!\u001f\u0001\u0005\u0004%I!a\u001f\t\u0011\u0005E\u0005\u0001)A\u0005\u0003{B\u0011\"a%\u0001\u0005\u0004%\t!!&\t\u0011\u0005u\u0005\u0001)A\u0005\u0003/C\u0011\"a(\u0001\u0005\u0004%I!!)\t\u0011\u0005e\u0006\u0001)A\u0005\u0003GC\u0011\"a/\u0001\u0005\u0004%I!!0\t\u0011\u0005M\u0007\u0001)A\u0005\u0003\u007fC\u0011\"!6\u0001\u0005\u0004%I!a6\t\u0011\u0005=\b\u0001)A\u0005\u00033D\u0011\"!=\u0001\u0005\u0004%I!a6\t\u0011\u0005M\b\u0001)A\u0005\u00033D\u0011\"!>\u0001\u0005\u0004%I!a>\t\u0011\u0005}\b\u0001)A\u0005\u0003sD!B!\u0001\u0001\u0005\u0004%\t!WA|\u0011!\u0011\u0019\u0001\u0001Q\u0001\n\u0005e\b\u0002\u0003B\u0003\u0001\u0001\u0007I\u0011B:\t\u0013\t\u001d\u0001\u00011A\u0005\n\t%\u0001b\u0002B\u0007\u0001\u0001\u0006K\u0001\u001e\u0005\u000b\u0005\u001f\u0001!\u0019!C\u00013\nE\u0001\u0002\u0003Bm\u0001\u0001\u0006IAa\u0005\t\u0013\tm\u0007\u00011A\u0005\n\tM\u0003\"\u0003Bo\u0001\u0001\u0007I\u0011\u0002Bp\u0011!\u0011\u0019\u000f\u0001Q!\n\tUca\u0002B\u000f\u0001\u0001K&q\u0004\u0005\u000b\u0005\u000bJ#Q3A\u0005\u0002\t\u001d\u0003B\u0003B(S\tE\t\u0015!\u0003\u0003J!Q!\u0011K\u0015\u0003\u0016\u0004%\tAa\u0015\t\u0015\tm\u0013F!E!\u0002\u0013\u0011)\u0006C\u0004\u0002`%\"\tA!\u0018\t\u000f\t\r\u0014\u0006\"\u0011\u0003f!I!1N\u0015\u0002\u0002\u0013\u0005!Q\u000e\u0005\n\u0005gJ\u0013\u0013!C\u0001\u0005kB\u0011Ba#*#\u0003%\tA!$\t\u0013\tE\u0015&!A\u0005B\tM\u0005\u0002\u0003BPS\u0005\u0005I\u0011A:\t\u0013\t\u0005\u0016&!A\u0005\u0002\t\r\u0006\"\u0003BWS\u0005\u0005I\u0011\tBX\u0011%\u0011I,KA\u0001\n\u0003\u0011Y\fC\u0005\u0003F&\n\t\u0011\"\u0011\u0003H\"I!1Z\u0015\u0002\u0002\u0013\u0005#Q\u001a\u0005\n\u0005\u001fL\u0013\u0011!C!\u0005#D\u0011Ba5*\u0003\u0003%\tE!6\b\u0015\t\u0015\b!!A\t\u0002e\u00139O\u0002\u0006\u0003\u001e\u0001\t\t\u0011#\u0001Z\u0005SDq!a\u0018>\t\u0003\u0019\t\u0001C\u0005\u0003Pv\n\t\u0011\"\u0012\u0003R\"I11A\u001f\u0002\u0002\u0013\u00055Q\u0001\u0005\n\u0007\u0017i\u0014\u0011!CA\u0007\u001bA\u0001ba\b\u0001\t\u0003I6\u0011\u0005\u0005\t\u0007c\u0001A\u0011A-\u00044!91\u0011\u0007\u0001\u0005\n\r]\u0002\u0002CB\"\u0001\u0011\u0005\u0011l!\u0012\t\u000f\rU\u0003\u0001\"\u0011\u0004X!91\u0011\f\u0001\u0005B\r]\u0003bBB.\u0001\u0011\u00051q\u000b\u0005\b\u0007;\u0002A\u0011BB0\u0011!\u0019\t\u0007\u0001C\u00013\u000e\r\u0004bBB:\u0001\u0011%1Q\u000f\u0005\b\u0007\u0003\u0003A\u0011BB,\u0011\u001d\u0019\u0019\t\u0001C\u0005\u0007\u000bCqaa%\u0001\t\u0013\u00199\u0006C\u0004\u0004\u0016\u0002!Iaa\u0016\t\u000f\r]\u0005\u0001\"\u0003\u0004\u001a\"911\u0016\u0001\u0005\n\r5\u0006bBBX\u0001\u0011%1Q\u0016\u0005\b\u0007c\u0003A\u0011AB,\u000f)\u0019Y,WA\u0001\u0012\u0003Y6Q\u0018\u0004\n1f\u000b\t\u0011#\u0001\\\u0007\u007fCq!a\u0018V\t\u0003\u0019\t\rC\u0005\u0004DV\u000b\n\u0011\"\u0001\u0004F\nA\u0011iY2faR|'O\u0003\u0002[7\u00069a.\u001a;x_J\\'\"\u0001/\u0002\u000b-\fgm[1\u0014\u0007\u0001q&\r\u0005\u0002`A6\t\u0011,\u0003\u0002b3\n!\u0012IY:ue\u0006\u001cGoU3sm\u0016\u0014H\u000b\u001b:fC\u0012\u0004\"a\u00194\u000e\u0003\u0011T!!Z.\u0002\u000f5,GO]5dg&\u0011q\r\u001a\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018\u0001C3oIB{\u0017N\u001c;\u0004\u0001U\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o7\u000691\r\\;ti\u0016\u0014\u0018B\u00019n\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u00039\u0019XM\u001c3Ck\u001a4WM]*ju\u0016,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0002o\u0006)1oY1mC&\u0011\u0011P\u001e\u0002\u0004\u0013:$\u0018AE:f]\u0012\u0014UO\u001a4feNK'0Z0%KF$\"\u0001`@\u0011\u0005Ul\u0018B\u0001@w\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005A!!AA\u0002Q\f1\u0001\u001f\u00132\u0003=\u0019XM\u001c3Ck\u001a4WM]*ju\u0016\u0004\u0003fA\u0003\u0002\bA\u0019Q/!\u0003\n\u0007\u0005-aO\u0001\u0005w_2\fG/\u001b7f\u00039\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\fqB]3dm\n+hMZ3s'&TX\rI\u0001\u0012Y&\u001cH/\u001a8CC\u000e\\Gn\\4TSj,\u0017A\u00057jgR,gNQ1dW2|wmU5{K\u0002\naA\\8eK&#\u0017\u0001E2p]:,7\r^5p]F+x\u000e^1t!\ry\u00161D\u0005\u0004\u0003;I&\u0001E\"p]:,7\r^5p]F+x\u000e^1t!\u0011\t\t#a\r\u000e\u0005\u0005\r\"bA3\u0002&)!\u0011qEA\u0015\u0003\u0019\u0019w.\\7p]*\u0019A,a\u000b\u000b\t\u00055\u0012qF\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0012aA8sO&!\u0011QGA\u0012\u0005\u001diU\r\u001e:jGN\fA\"\\3ue&\u001c\u0007K]3gSb\u0004B!a\u000f\u0002J9!\u0011QHA#!\r\tyD^\u0007\u0003\u0003\u0003R1!a\u0011j\u0003\u0019a$o\\8u}%\u0019\u0011q\t<\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9E^\u0001\u0005i&lW\r\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&!\n\u0002\u000bU$\u0018\u000e\\:\n\t\u0005m\u0013Q\u000b\u0002\u0005)&lW-A\u0005m_\u001e\u0004&/\u001a4jq\u00061A(\u001b8jiz\"b#a\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0002t\u0005U\u0014q\u000f\t\u0003?\u0002AQ\u0001\u001b\tA\u0002-DQA\u001d\tA\u0002QDa!!\u0004\u0011\u0001\u0004!\bBBA\t!\u0001\u0007A\u000f\u0003\u0004\u0002\u0016A\u0001\r\u0001\u001e\u0005\b\u0003/\u0001\u0002\u0019AA\r\u0011\u0019)\u0007\u00031\u0001\u0002 !9\u0011q\u0007\tA\u0002\u0005e\u0002bBA(!\u0001\u0007\u0011\u0011\u000b\u0005\n\u0003;\u0002\u0002\u0013!a\u0001\u0003s\t1B\\5p'\u0016dWm\u0019;peV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\ni)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BAD\u0003\u0013\u000b1A\\5p\u0015\t\tY)\u0001\u0003kCZ\f\u0017\u0002BAH\u0003\u0003\u0013\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\u0005]\u0005\u0003BA@\u00033KA!a'\u0002\u0002\n\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011\u00111\u0015\t\u0007\u0003K\u000by+a-\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000bq!\\;uC\ndWMC\u0002\u0002.Z\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t,a*\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004?\u0006U\u0016bAA\\3\nI\u0001K]8dKN\u001cxN]\u0001\faJ|7-Z:t_J\u001c\b%A\tqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012,\"!a0\u0011\t\u0005\u0005\u0017qZ\u0007\u0003\u0003\u0007TA!!2\u0002H\u00061\u0011\r^8nS\u000eTA!!3\u0002L\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u00055\u0017\u0011R\u0001\u0005kRLG.\u0003\u0003\u0002R\u0006\r'!D!u_6L7MQ8pY\u0016\fg.\u0001\nqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012\u0004\u0013a\u00052m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014XCAAm!\u0011\tY.a;\u000e\u0005\u0005u'\u0002BAp\u0003C\fAaY8sK*\u0019Q-a9\u000b\t\u0005\u0015\u0018q]\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005%\u0018aA2p[&!\u0011Q^Ao\u0005\u0015iU\r^3s\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sA\u0005!\u0012mY2faR\u0014\u0015\r^2i)&lW-T3uKJ\fQ#Y2dKB$()\u0019;dQRKW.Z'fi\u0016\u0014\b%\u0001\u000foKR<xN]6UQJ,\u0017\rZ:DCB\f7-\u001b;z'\u0016t7o\u001c:\u0016\u0005\u0005e\b\u0003BA\u0011\u0003wLA!!@\u0002$\t11+\u001a8t_J\fQD\\3uo>\u00148\u000e\u00165sK\u0006$7oQ1qC\u000eLG/_*f]N|'\u000fI\u0001\u0019aJ|7-Z:t_J\fV/Z;f'&TXmU3og>\u0014\u0018!\u00079s_\u000e,7o]8s#V,W/Z*ju\u0016\u001cVM\\:pe\u0002\nQcY;se\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:J]\u0012,\u00070A\rdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=`I\u0015\fHc\u0001?\u0003\f!A\u0011\u0011\u0001\u0012\u0002\u0002\u0003\u0007A/\u0001\fdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=!\u0003A!\bN]8ui2,GmU8dW\u0016$8/\u0006\u0002\u0003\u0014A1\u0011Q\u0015B\u000b\u00053IAAa\u0006\u0002(\ni\u0001K]5pe&$\u00180U;fk\u0016\u00042Aa\u0007*\u001b\u0005\u0001!A\u0005#fY\u0006LX\rZ\"m_N,7k\\2lKR\u001c\u0012\"\u000bB\u0011\u0005O\u0011IDa\u0010\u0011\u0007U\u0014\u0019#C\u0002\u0003&Y\u0014a!\u00118z%\u00164\u0007C\u0002B\u0015\u0005g\u0011IB\u0004\u0003\u0003,\t=b\u0002BA \u0005[I\u0011a^\u0005\u0004\u0005c1\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005k\u00119DA\u0004Pe\u0012,'/\u001a3\u000b\u0007\tEb\u000fE\u0002v\u0005wI1A!\u0010w\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u000b\u0003B%!!1\tB\u001c\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019xnY6fiV\u0011!\u0011\n\t\u0005\u0003\u007f\u0012Y%\u0003\u0003\u0003N\u0005\u0005%!D*pG.,Go\u00115b]:,G.A\u0004t_\u000e\\W\r\u001e\u0011\u0002#\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5/\u0006\u0002\u0003VA\u0019QOa\u0016\n\u0007\tecO\u0001\u0003M_:<\u0017AE3oIRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0002\"bA!\u0007\u0003`\t\u0005\u0004b\u0002B#]\u0001\u0007!\u0011\n\u0005\b\u0005#r\u0003\u0019\u0001B+\u0003\u001d\u0019w.\u001c9be\u0016$2\u0001\u001eB4\u0011\u001d\u0011Ig\fa\u0001\u00053\tA\u0001\u001e5bi\u0006!1m\u001c9z)\u0019\u0011IBa\u001c\u0003r!I!Q\t\u0019\u0011\u0002\u0003\u0007!\u0011\n\u0005\n\u0005#\u0002\u0004\u0013!a\u0001\u0005+\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003x)\"!\u0011\nB=W\t\u0011Y\b\u0005\u0003\u0003~\t\u001dUB\u0001B@\u0015\u0011\u0011\tIa!\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BCm\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%%q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001fSCA!\u0016\u0003z\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!&\u0011\t\t]%QT\u0007\u0003\u00053SAAa'\u0002\n\u0006!A.\u00198h\u0013\u0011\tYE!'\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0015BV!\r)(qU\u0005\u0004\u0005S3(aA!os\"A\u0011\u0011A\u001b\u0002\u0002\u0003\u0007A/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\f\u0005\u0004\u00034\nU&QU\u0007\u0003\u0003WKAAa.\u0002,\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iLa1\u0011\u0007U\u0014y,C\u0002\u0003BZ\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0002]\n\t\u00111\u0001\u0003&\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011)J!3\t\u0011\u0005\u0005\u0001(!AA\u0002Q\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002i\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\u0016\u00061Q-];bYN$BA!0\u0003X\"I\u0011\u0011A\u001e\u0002\u0002\u0003\u0007!QU\u0001\u0012i\"\u0014x\u000e\u001e;mK\u0012\u001cvnY6fiN\u0004\u0013a\u00077bgR\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007\",7m\u001b+j[\u0016l5/A\u0010mCN$()Y2laJ,7o];sK\u000eCWmY6US6,Wj]0%KF$2\u0001 Bq\u0011%\t\taJA\u0001\u0002\u0004\u0011)&\u0001\u000fmCN$()Y2laJ,7o];sK\u000eCWmY6US6,Wj\u001d\u0011\u0002%\u0011+G.Y=fI\u000ecwn]3T_\u000e\\W\r\u001e\t\u0004\u00057i4#B\u001f\u0003l\n]\bC\u0003Bw\u0005g\u0014IE!\u0016\u0003\u001a5\u0011!q\u001e\u0006\u0004\u0005c4\u0018a\u0002:v]RLW.Z\u0005\u0005\u0005k\u0014yOA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BA!?\u0003\u00006\u0011!1 \u0006\u0005\u0005{\fI)\u0001\u0002j_&!!1\tB~)\t\u00119/A\u0003baBd\u0017\u0010\u0006\u0004\u0003\u001a\r\u001d1\u0011\u0002\u0005\b\u0005\u000b\u0002\u0005\u0019\u0001B%\u0011\u001d\u0011\t\u0006\u0011a\u0001\u0005+\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0010\rm\u0001#B;\u0004\u0012\rU\u0011bAB\nm\n1q\n\u001d;j_:\u0004r!^B\f\u0005\u0013\u0012)&C\u0002\u0004\u001aY\u0014a\u0001V;qY\u0016\u0014\u0004\"CB\u000f\u0003\u0006\u0005\t\u0019\u0001B\r\u0003\rAH\u0005M\u0001\u000eC\u0012$\u0007K]8dKN\u001cxN]:\u0015\u000bq\u001c\u0019c!\f\t\u000f\r\u0015\"\t1\u0001\u0004(\u0005ia.Z<Qe>\u001cWm]:peN\u0004b!!*\u0004*\u0005M\u0016\u0002BB\u0016\u0003O\u0013aAQ;gM\u0016\u0014\bbBB\u0018\u0005\u0002\u0007\u0011\u0011H\u0001\u0016aJ|7-Z:t_J$\u0006N]3bIB\u0013XMZ5y\u0003=\u0019H/\u0019:u!J|7-Z:t_J\u001cHc\u0001?\u00046!91qF\"A\u0002\u0005eB#\u0002?\u0004:\r\u0005\u0003bBAP\t\u0002\u000711\b\t\u0007\u0005g\u001bi$a-\n\t\r}\u00121\u0016\u0002\u0004'\u0016\f\bbBB\u0018\t\u0002\u0007\u0011\u0011H\u0001\u0011e\u0016lwN^3Qe>\u001cWm]:peN$R\u0001`B$\u0007\u0017Baa!\u0013F\u0001\u0004!\u0018a\u0003:f[>4XmQ8v]RDqa!\u0014F\u0001\u0004\u0019y%\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0007}\u001b\t&C\u0002\u0004Te\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\tA0A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\u0004eVt\u0017!\u00048fqR\u0004&o\\2fgN|'/\u0006\u0002\u00024\u0006i!/\u001a<feN,\u0017I\u001c3BI\u0012$2\u0001`B3\u0011\u001d\u00199G\u0013a\u0001\u0007S\naB]3wKJ\u001cXm\u00115b]:,G\u000e\u0005\u0003\u0004l\r=TBAB7\u0015\rQ\u0016QE\u0005\u0005\u0007c\u001aiG\u0001\bSKZ,'o]3DQ\u0006tg.\u001a7\u0002!=\u0004XM\\*feZ,'oU8dW\u0016$H\u0003CAL\u0007o\u001aYha \t\u000f\re4\n1\u0001\u0002:\u0005!\u0001n\\:u\u0011\u0019\u0019ih\u0013a\u0001i\u0006!\u0001o\u001c:u\u0011\u0019\t\tb\u0013a\u0001i\u0006!\u0012mY2faRtUm^\"p]:,7\r^5p]N\fa!Y2dKB$H\u0003BBD\u0007\u0013\u0003R!^B\t\u0005\u0013Bqaa#N\u0001\u0004\u0019i)A\u0002lKf\u0004B!a \u0004\u0010&!1\u0011SAA\u00051\u0019V\r\\3di&|gnS3z\u0003e\u0019Gn\\:f)\"\u0014x\u000e\u001e;mK\u0012\u001cuN\u001c8fGRLwN\\:\u000215\f\u0017PY3BI*,8\u000f\u001e'jgR,g.\u001a:Rk>$\u0018-A\nbgNLwM\u001c(fo\u000e{gN\\3di&|g\u000e\u0006\u0006\u0003>\u000em5qTBR\u0007OCqa!(Q\u0001\u0004\u0011I%A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\u0007C\u0003\u0006\u0019AAZ\u0003%\u0001(o\\2fgN|'\u000fC\u0004\u0004&B\u0003\rA!0\u0002\u00115\f\u0017P\u00117pG.Dqa!+Q\u0001\u0004\u0011)&\u0001\bti\u0006\u0014H\u000fV5nK:\u000bgn\\:\u0002E\r\u0014X-\u0019;f\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193t\u0007\u0006\u0004\u0018mY5usN+gn]8s)\t\tI0\u0001\u0010de\u0016\fG/\u001a)s_\u000e,7o]8s#V,W/Z*ju\u0016\u001cVM\\:pe\u00061q/Y6fkBD3aUB[!\u0011\u00119ja.\n\t\re&\u0011\u0014\u0002\t\u001fZ,'O]5eK\u0006A\u0011iY2faR|'\u000f\u0005\u0002`+N\u0019QK!\t\u0015\u0005\ru\u0016\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0007\u000fTC!!\u000f\u0003z\u0001")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private volatile int sendBufferSize;
    private final int recvBufferSize;
    private final int listenBacklogSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Metrics metrics;
    private final String metricPrefix;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private final Meter acceptBatchTimeMeter;
    private final Sensor networkThreadsCapacitySensor;
    private final Sensor processorQueueSizeSensor;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private long lastBackpressureCheckTimeMs;

    public static String $lessinit$greater$default$10() {
        return "";
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public void sendBufferSize_$eq(int x$1) {
        this.sendBufferSize = x$1;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    public int listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private Meter acceptBatchTimeMeter() {
        return this.acceptBatchTimeMeter;
    }

    private Sensor networkThreadsCapacitySensor() {
        return this.networkThreadsCapacitySensor;
    }

    public Sensor processorQueueSizeSensor() {
        return this.processorQueueSizeSensor;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private long lastBackpressureCheckTimeMs() {
        return this.lastBackpressureCheckTimeMs;
    }

    private void lastBackpressureCheckTimeMs_$eq(long x$1) {
        this.lastBackpressureCheckTimeMs = x$1;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$22 -> {
            x$22.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)x$23 -> {
            x$23.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$24 -> {
                x$24.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$25 -> {
                x$25.awaitShutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.removeMetric(new StringBuilder(22).append(this.metricPrefix).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.removeMetric(new StringBuilder(20).append(this.metricPrefix).append("AcceptBatchTimeNanos").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.metrics.removeSensor(this.networkThreadsCapacitySensor().name());
        this.metrics.removeSensor(this.processorQueueSizeSensor().name());
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                    this.maybeAdjustListenerQuota();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Processor nextProcessor() {
        void var1_1;
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() % this.processors().length());
        Processor processor = (Processor)this.processors().apply(this.currentProcessorIndex());
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() + 1);
        return var1_1;
    }

    public void reverseAndAdd(ReverseChannel reverseChannel) {
        this.connectionQuotas.inc(this.endPoint().listenerName(), reverseChannel.channel().socketAddress(), this.blockedPercentMeter());
        this.nextProcessor().reverseAndAdd(reverseChannel);
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            long startNanos = this.time.nanoseconds();
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            this.acceptBatchTimeMeter().mark(this.time.nanoseconds() - startNanos);
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$26)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private void maybeAdjustListenerQuota() {
        long timeMs = this.time.milliseconds();
        if (this.lastBackpressureCheckTimeMs() + ConnectionQuotas$.MODULE$.ConnectionBackpressureCheckIntervalMs() < timeMs) {
            this.connectionQuotas.maybeAdjustListenerQuota(this.endPoint().listenerName());
            this.lastBackpressureCheckTimeMs_$eq(timeMs);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock, long startTimeNanos) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter(), startTimeNanos, this.processorQueueSizeSensor())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").toString()).append(new StringBuilder(32).append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").toString()).append(new StringBuilder(39).append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").toString()).append(new StringBuilder(39).append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString()).toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createNetworkThreadsCapacitySensor() {
        void var2_2;
        void add_stat;
        void add_metricName;
        String listenerName = this.endPoint().listenerName().value();
        Sensor networkThreadsCapacitySensor = this.metrics.sensor(new StringBuilder(30).append("TotalNetworkThreadsPercentage-").append(listenerName).toString());
        Value value = new Value();
        MetricName metricName = ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics, listenerName);
        if (networkThreadsCapacitySensor == null) {
            throw null;
        }
        networkThreadsCapacitySensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createProcessorQueueSizeSensor() {
        void var2_2;
        void add_stat;
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        Percentiles percentiles;
        String listenerName = this.endPoint().listenerName().value();
        Sensor processorQueueSizeSensor = this.metrics.sensor(new StringBuilder(19).append("ProcessorQueueSize-").append(listenerName).toString());
        Map map = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName)}));
        String string = this.metricPrefix;
        int n = Processor$.MODULE$.ConnectionQueueSize();
        Metrics metrics = this.metrics;
        ProcessorQueueSizePercentiles$ createPercentiles_this = ProcessorQueueSizePercentiles$.MODULE$;
        Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$(createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        Object var3_7 = null;
        metrics = null;
        string = null;
        map = null;
        percentiles = null;
        Percentiles percentiles3 = percentiles2;
        if (processorQueueSizeSensor == null) {
            throw null;
        }
        processorQueueSizeSensor.add((CompoundStat)add_stat, null);
        return var2_2;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        Object var3_3 = null;
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        long connectionAcceptTimeNanos = $this.time.nanoseconds();
        while (!$this.assignNewConnection(socketChannel, processor = $this.nextProcessor(), --retriesLeft == 0, connectionAcceptTimeNanos)) {
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$26) {
        return x$26.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int listenBacklogSize, int nodeId, ConnectionQuotas connectionQuotas, Metrics metrics, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.listenBacklogSize = listenBacklogSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.metrics = metrics;
        this.metricPrefix = metricPrefix;
        this.time = time;
        super(connectionQuotas);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port(), listenBacklogSize);
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.acceptBatchTimeMeter = this.newMeter(new StringBuilder(20).append(metricPrefix).append("AcceptBatchTimeNanos").toString(), "processing and blocked time for a batch of new connections", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.networkThreadsCapacitySensor = this.createNetworkThreadsCapacitySensor();
        this.processorQueueSizeSensor = this.createProcessorQueueSizeSensor();
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.lastBackpressureCheckTimeMs = time.milliseconds();
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

