/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events.serdes;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.durability.events.serdes.BaseInfo;

public final class StartOffsetChange
extends Table {
    public static StartOffsetChange getRootAsStartOffsetChange(ByteBuffer _bb) {
        return StartOffsetChange.getRootAsStartOffsetChange(_bb, new StartOffsetChange());
    }

    public static StartOffsetChange getRootAsStartOffsetChange(ByteBuffer _bb, StartOffsetChange obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public StartOffsetChange __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte retentionType() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public long retentionValue() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public BaseInfo info() {
        return this.info(new BaseInfo());
    }

    public BaseInfo info(BaseInfo obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public int isr(int j) {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int isrLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer isrAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 4);
    }

    public ByteBuffer isrInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 4);
    }

    public static void startStartOffsetChange(FlatBufferBuilder builder) {
        builder.startObject(4);
    }

    public static void addRetentionType(FlatBufferBuilder builder, byte retentionType) {
        builder.addByte(0, retentionType, 0);
    }

    public static void addRetentionValue(FlatBufferBuilder builder, long retentionValue) {
        builder.addLong(1, retentionValue, 0L);
    }

    public static void addInfo(FlatBufferBuilder builder, int infoOffset) {
        builder.addStruct(2, infoOffset, 0);
    }

    public static void addIsr(FlatBufferBuilder builder, int isrOffset) {
        builder.addOffset(3, isrOffset, 0);
    }

    public static int createIsrVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startIsrVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endStartOffsetChange(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public static void finishStartOffsetChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedStartOffsetChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }
}

