/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.serdes.EventKey;
import kafka.durability.exceptions.DurabilityMetadataDeserializationException;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000594QAD\b\u0002\u0002YA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\t]\u0001\u0011\t\u0011)A\u0005G!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004A!b\u0001\n\u0003\u0001\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b]\u0002A\u0011\u0001\u001d\t\u000bu\u0002A\u0011\u0001 \t\u000b\u0015\u0003A\u0011\u0001 \t\u000b\u0019\u0003a\u0011A$\t\u000bA\u0003a\u0011A)\t\u000b\t\u0004A\u0011I2\t\u000b1\u0004A\u0011I7\u0003/\u0005\u00137\u000f\u001e:bGR$UO]1cS2LG/_#wK:$(B\u0001\t\u0012\u0003\u0019)g/\u001a8ug*\u0011!cE\u0001\u000bIV\u0014\u0018MY5mSRL(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u0010\u0013\t\u0001sBA\tEKN,'/[1mSj,'\u000f\u0016:bSR\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001$!\t!C&D\u0001&\u0015\t1s%\u0001\u0004d_6lwN\u001c\u0006\u0003)!R!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO&\u0011Q&\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!B3q_\u000eDW#A\u0019\u0011\u0005a\u0011\u0014BA\u001a\u001a\u0005\rIe\u000e^\u0001\u0007KB|7\r\u001b\u0011\u0002\u000fY,'o]5p]\u0006Aa/\u001a:tS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005siZD\b\u0005\u0002\u001f\u0001!)\u0011e\u0002a\u0001G!)qf\u0002a\u0001c!)Qg\u0002a\u0001c\u0005a1/\u001a:jC2L'0Z&fsV\tq\bE\u0002\u0019\u0001\nK!!Q\r\u0003\u000b\u0005\u0013(/Y=\u0011\u0005a\u0019\u0015B\u0001#\u001a\u0005\u0011\u0011\u0015\u0010^3\u0002\u001dM,'/[1mSj,g+\u00197vK\u0006i\u0001/Y=m_\u0006$')\u001e4gKJ,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000b1A\\5p\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0005fm\u0016tG\u000fV=qKV\t!\u000b\u0005\u0002T?:\u0011A+\u0018\b\u0003+rs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005e+\u0012A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011alD\u0001\u0014\tV\u0014\u0018MY5mSRLXI^3oiRK\b/Z\u0005\u0003A\u0006\u00141\u0003R;sC\nLG.\u001b;z\u000bZ,g\u000e\u001e+za\u0016T!AX\b\u0002\r\u0015\fX/\u00197t)\t!w\r\u0005\u0002\u0019K&\u0011a-\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015AG\u00021\u0001j\u0003\u0015yG\u000f[3s!\tA\".\u0003\u0002l3\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\r")
public abstract class AbstractDurabilityEvent
implements DeserializerTrait {
    private final TopicPartition topicPartition;
    private final int epoch;
    private final int version;
    private int KEY_INITIAL_LENGTH;
    private int EVENT_TYPE_LENGTH;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Enumeration.Value deserializeEventType(byte value) {
        return DeserializerTrait.deserializeEventType$(this, value);
    }

    @Override
    public AbstractDurabilityEvent deserialize(byte[] key, byte[] value) throws DurabilityMetadataDeserializationException {
        return DeserializerTrait.deserialize$(this, key, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public int KEY_INITIAL_LENGTH() {
        return this.KEY_INITIAL_LENGTH;
    }

    @Override
    public int EVENT_TYPE_LENGTH() {
        return this.EVENT_TYPE_LENGTH;
    }

    @Override
    public void kafka$durability$events$DeserializerTrait$_setter_$KEY_INITIAL_LENGTH_$eq(int x$1) {
        this.KEY_INITIAL_LENGTH = x$1;
    }

    @Override
    public void kafka$durability$events$DeserializerTrait$_setter_$EVENT_TYPE_LENGTH_$eq(int x$1) {
        this.EVENT_TYPE_LENGTH = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int epoch() {
        return this.epoch;
    }

    public int version() {
        return this.version;
    }

    public byte[] serializeKey() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        int topicNameOffset = builder.createString((CharSequence)this.topicPartition().topic());
        EventKey.startEventKey(builder);
        EventKey.addTopicName(builder, topicNameOffset);
        EventKey.addPartition(builder, this.topicPartition().partition());
        int end = EventKey.endEventKey(builder);
        builder.finish(end);
        ByteBuffer buffer = builder.dataBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public byte[] serializeValue() {
        ByteBuffer payload = this.payloadBuffer();
        ByteBuffer buf = ByteBuffer.allocate(payload.remaining() + this.EVENT_TYPE_LENGTH());
        buf.put((byte)this.eventType().id());
        buf.put(payload);
        return buf.array();
    }

    public abstract ByteBuffer payloadBuffer();

    public abstract Enumeration.Value eventType();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof AbstractDurabilityEvent)) return false;
        AbstractDurabilityEvent abstractDurabilityEvent = (AbstractDurabilityEvent)other;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = abstractDurabilityEvent.topicPartition();
        if (topicPartition == null) {
            if (topicPartition2 != null) {
                return false;
            }
        } else if (!topicPartition.equals(topicPartition2)) return false;
        Enumeration.Value value = this.eventType();
        Enumeration.Value value2 = abstractDurabilityEvent.eventType();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!Predef$.MODULE$.wrapByteArray(this.payloadBuffer().array()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(abstractDurabilityEvent.payloadBuffer().array()))) return false;
        if (this.epoch() != abstractDurabilityEvent.epoch()) return false;
        if (this.version() != abstractDurabilityEvent.version()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), this.eventType(), this.payloadBuffer(), BoxesRunTime.boxToInteger((int)this.epoch()), BoxesRunTime.boxToInteger((int)this.version())}))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public AbstractDurabilityEvent(TopicPartition topicPartition, int epoch, int version) {
        this.topicPartition = topicPartition;
        this.epoch = epoch;
        this.version = version;
        DeserializerTrait.$init$(this);
        Statics.releaseFence();
    }
}

