/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db.serdes;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.durability.db.serdes.PartitionInfo;

public final class TopicInfo
extends Table {
    public static TopicInfo getRootAsTopicInfo(ByteBuffer _bb) {
        return TopicInfo.getRootAsTopicInfo(_bb, new TopicInfo());
    }

    public static TopicInfo getRootAsTopicInfo(ByteBuffer _bb, TopicInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public TopicInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String topic() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer topicInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public PartitionInfo partitions(int j) {
        return this.partitions(new PartitionInfo(), j);
    }

    public PartitionInfo partitions(PartitionInfo obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int partitionsLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createTopicInfo(FlatBufferBuilder builder, int topicOffset, int partitionsOffset) {
        builder.startObject(2);
        TopicInfo.addPartitions(builder, partitionsOffset);
        TopicInfo.addTopic(builder, topicOffset);
        return TopicInfo.endTopicInfo(builder);
    }

    public static void startTopicInfo(FlatBufferBuilder builder) {
        builder.startObject(2);
    }

    public static void addTopic(FlatBufferBuilder builder, int topicOffset) {
        builder.addOffset(0, topicOffset, 0);
    }

    public static void addPartitions(FlatBufferBuilder builder, int partitionsOffset) {
        builder.addOffset(1, partitionsOffset, 0);
    }

    public static int createPartitionsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startPartitionsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endTopicInfo(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

