/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AliveBrokersSnapshot {
    public static final AliveBrokersSnapshot EMPTY_SNAPSHOT = new AliveBrokersSnapshot(Collections.emptyMap(), Collections.emptySet());
    private final Map<Integer, Long> liveBrokerIdsAndEpochs;
    private final Set<Integer> brokerReplicaExclusions;

    public AliveBrokersSnapshot(Map<Integer, Long> liveBrokerIdsAndEpochs, Set<Integer> brokerReplicaExclusions) {
        this.liveBrokerIdsAndEpochs = Collections.unmodifiableMap(liveBrokerIdsAndEpochs);
        this.brokerReplicaExclusions = Collections.unmodifiableSet(brokerReplicaExclusions);
    }

    public Set<Integer> replicaExclusions() {
        return new HashSet<Integer>(this.brokerReplicaExclusions);
    }

    public Optional<Long> epochFor(int brokerId) {
        return Optional.ofNullable(this.liveBrokerIdsAndEpochs.get(brokerId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliveBrokersSnapshot that = (AliveBrokersSnapshot)o;
        return Objects.equals(this.liveBrokerIdsAndEpochs, that.liveBrokerIdsAndEpochs) && Objects.equals(this.brokerReplicaExclusions, that.brokerReplicaExclusions);
    }

    public int hashCode() {
        return Objects.hash(this.liveBrokerIdsAndEpochs, this.brokerReplicaExclusions);
    }

    public String toString() {
        return "AliveBrokersSnapshot{liveBrokerIdsAndEpochs=" + this.liveBrokerIdsAndEpochs + ", brokerReplicaExclusions=" + this.brokerReplicaExclusions + "}";
    }
}

