/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.JsonArray;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005-ba\u0002\u000b\u0016!\u0003\r\t\u0001\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006Q\u00011\t\"\u000b\u0005\u0006m\u0001!\ta\u000e\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006K\u0002!\tA\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\u0006o\u0002!\t\u0005\u001f\u0005\u0006y\u0002!\t% \u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u000f\u001d\tY!\u0006E\u0001\u0003\u001b1a\u0001F\u000b\t\u0002\u0005=\u0001bBA\t\u001b\u0011\u0005\u00111\u0003\u0005\b\u0003+iA\u0011AA\f\r\u0019\ti\"\u0004\u0003\u0002 !A\u0001\u0006\u0005BC\u0002\u0013E\u0011\u0006C\u0005\u0002\"A\u0011\t\u0011)A\u0005U!A\u0011\u0011\u0003\t\u0005\u0002U\t\u0019CA\u0005Kg>tg+\u00197vK*\u0011acF\u0001\u0005UN|gN\u0003\u0002\u00193\u0005)Q\u000f^5mg*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002KA\u0011aDJ\u0005\u0003O}\u0011A!\u00168ji\u0006!an\u001c3f+\u0005Q\u0003CA\u00165\u001b\u0005a#BA\u0017/\u0003!!\u0017\r^1cS:$'BA\u00181\u0003\u001dQ\u0017mY6t_:T!!\r\u001a\u0002\u0013\u0019\f7\u000f^3sq6d'\"A\u001a\u0002\u0007\r|W.\u0003\u00026Y\tA!j]8o\u001d>$W-\u0001\u0002u_V\u0011\u0001h\u000f\u000b\u0003s\u0011\u0003\"AO\u001e\r\u0001\u0011)Ah\u0001b\u0001{\t\tA+\u0005\u0002?\u0003B\u0011adP\u0005\u0003\u0001~\u0011qAT8uQ&tw\r\u0005\u0002\u001f\u0005&\u00111i\b\u0002\u0004\u0003:L\b\"B#\u0004\u0001\b1\u0015A\u00033fG>$WMS:p]B\u0019q\tS\u001d\u000e\u0003UI!!S\u000b\u0003\u0015\u0011+7m\u001c3f\u0015N|g.\u0001\u0005u_\u0016KG\u000f[3s+\ta%\r\u0006\u0002NGB!aJV-b\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S7\u00051AH]8pizJ\u0011\u0001I\u0005\u0003+~\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n1Q)\u001b;iKJT!!V\u0010\u0011\u0005isfBA.]!\t\u0001v$\u0003\u0002^?\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\tiv\u0004\u0005\u0002;E\u0012)A\b\u0002b\u0001{!)Q\t\u0002a\u0002IB\u0019q\tS1\u0002\u0019\u0005\u001c(j]8o\u001f\nTWm\u0019;\u0016\u0003\u001d\u0004\"a\u00125\n\u0005%,\"A\u0003&t_:|%M[3di\u0006\u0011\u0012m\u001d&t_:|%M[3di>\u0003H/[8o+\u0005a\u0007c\u0001\u0010nO&\u0011an\b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017\u0005\u001c(j]8o\u0003J\u0014\u0018-_\u000b\u0002cB\u0011qI]\u0005\u0003gV\u0011\u0011BS:p]\u0006\u0013(/Y=\u0002#\u0005\u001c(j]8o\u0003J\u0014\u0018-_(qi&|g.F\u0001w!\rqR.]\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011\u0010\u0005\u0002\u001fu&\u00111p\b\u0002\u0004\u0013:$\u0018AB3rk\u0006d7\u000fF\u0002\u007f\u0003\u0007\u0001\"AH@\n\u0007\u0005\u0005qDA\u0004C_>dW-\u00198\t\r\u0005\u0015!\u00021\u0001B\u0003\u0005\t\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003e\u000b\u0011BS:p]Z\u000bG.^3\u0011\u0005\u001dk1CA\u0007\u001e\u0003\u0019a\u0014N\\5u}Q\u0011\u0011QB\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u00033\tY\u0002\u0005\u0002H\u0001!)\u0001f\u0004a\u0001U\tq!)Y:jG*\u001bxN\u001c,bYV,7\u0003\u0002\t\u001e\u00033\tQA\\8eK\u0002\"B!!\n\u0002*A\u0019\u0011q\u0005\t\u000e\u00035AQ\u0001K\nA\u0002)\u0002")
public interface JsonValue {
    public static JsonValue apply(JsonNode node) {
        return JsonValue$.MODULE$.apply(node);
    }

    public JsonNode node();

    default public <T> T to(DecodeJson<T> decodeJson) {
        return decodeJson.decode(this.node());
    }

    default public <T> Either<String, T> toEither(DecodeJson<T> decodeJson) {
        return decodeJson.decodeEither(this.node());
    }

    default public JsonObject asJsonObject() {
        Option<JsonObject> option = this.asJsonObjectOption();
        if (option == null) {
            throw null;
        }
        Option<JsonObject> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw JsonValue.$anonfun$asJsonObject$1(this);
        }
        return (JsonObject)getOrElse_this.get();
    }

    default public Option<JsonObject> asJsonObjectOption() {
        if (this instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)this;
            return new Some((Object)jsonObject);
        }
        JsonNode jsonNode = this.node();
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            return new Some((Object)new JsonObject(objectNode));
        }
        return None$.MODULE$;
    }

    default public JsonArray asJsonArray() {
        Option<JsonArray> option = this.asJsonArrayOption();
        if (option == null) {
            throw null;
        }
        Option<JsonArray> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw JsonValue.$anonfun$asJsonArray$1(this);
        }
        return (JsonArray)getOrElse_this.get();
    }

    default public Option<JsonArray> asJsonArrayOption() {
        if (this instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)this;
            return new Some((Object)jsonArray);
        }
        JsonNode jsonNode = this.node();
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            return new Some((Object)new JsonArray(arrayNode));
        }
        return None$.MODULE$;
    }

    default public int hashCode() {
        return this.node().hashCode();
    }

    default public boolean equals(Object a) {
        if (a instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)a;
            JsonNode jsonNode = this.node();
            JsonNode jsonNode2 = jsonValue.node();
            return !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null);
        }
        return false;
    }

    default public String toString() {
        return this.node().toString();
    }

    public static /* synthetic */ Nothing$ $anonfun$asJsonObject$1(JsonValue $this) {
        throw new JsonMappingException(null, new StringBuilder(31).append("Expected JSON object, received ").append($this.node()).toString());
    }

    public static /* synthetic */ Nothing$ $anonfun$asJsonArray$1(JsonValue $this) {
        throw new JsonMappingException(null, new StringBuilder(30).append("Expected JSON array, received ").append($this.node()).toString());
    }

    public static void $init$(JsonValue $this) {
    }

    private static class BasicJsonValue
    implements JsonValue {
        private final JsonNode node;

        @Override
        public <T> T to(DecodeJson<T> decodeJson) {
            return (T)((JsonValue)this).to(decodeJson);
        }

        @Override
        public <T> Either<String, T> toEither(DecodeJson<T> decodeJson) {
            return ((JsonValue)this).toEither(decodeJson);
        }

        @Override
        public JsonObject asJsonObject() {
            return ((JsonValue)this).asJsonObject();
        }

        @Override
        public Option<JsonObject> asJsonObjectOption() {
            return ((JsonValue)this).asJsonObjectOption();
        }

        @Override
        public JsonArray asJsonArray() {
            return ((JsonValue)this).asJsonArray();
        }

        @Override
        public Option<JsonArray> asJsonArrayOption() {
            return ((JsonValue)this).asJsonArrayOption();
        }

        @Override
        public int hashCode() {
            return ((JsonValue)this).hashCode();
        }

        @Override
        public boolean equals(Object a) {
            return ((JsonValue)this).equals(a);
        }

        @Override
        public String toString() {
            return ((JsonValue)this).toString();
        }

        @Override
        public JsonNode node() {
            return this.node;
        }

        public BasicJsonValue(JsonNode node) {
            this.node = node;
        }
    }
}

