/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$ = new DumpLogSegments$();
    private static final String RecordIndent = "|";

    public String RecordIndent() {
        return RecordIndent;
    }

    public void main(String[] args) {
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        Map misMatchesForIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        Map nonConsecutivePairsForLogFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (String string : opts.files()) {
            DumpLogSegments$.$anonfun$main$1(opts, nonConsecutivePairsForLogFilesMap, misMatchesForIndexFilesMap, timeIndexDumpErrors, string);
        }
        Object var6_6 = null;
        misMatchesForIndexFilesMap.foreach((Function1 & Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$2(x0$1);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1 & Serializable)x0$3 -> {
            DumpLogSegments$.$anonfun$main$4(x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpTxnIndex(File file) {
        List list = new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file).allAbortedTxns();
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            DumpLogSegments$.$anonfun$dumpTxnIndex$1((AbortedTxn)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach((Function1 & Serializable)entry -> {
                DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$1(entry);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            String toLong$extension_$this = file.getName().split("\\.")[0];
            Object var18_7 = null;
            long startOffset = Long.parseLong(toLong$extension_$this);
            File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString());
            boolean open_mutable = false;
            FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
            int x$4 = -1;
            OffsetIndex index = new OffsetIndex(file, startOffset, x$4, false);
            if (indexSanityOnly) {
                index.sanityCheck();
                String println_x = new StringBuilder(21).append(file).append(" passed sanity check.").toString();
                Console$.MODULE$.println((Object)println_x);
                return;
            }
            int n = 0;
            int until$extension_end = index.entries();
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    DumpLogSegments$.$anonfun$dumpIndex$1(index, object, fileRecords, maxMessageSize, misMatchesForIndexFilesMap, file, verifyOnly, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        Object object = new Object();
        try {
            block10: {
                block9: {
                    String toLong$extension_$this = file.getName().split("\\.")[0];
                    Object var25_7 = null;
                    long startOffset = Long.parseLong(toLong$extension_$this);
                    File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString());
                    boolean open_mutable = false;
                    FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
                    File indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.IndexFileSuffix()).toString());
                    int x$4 = -1;
                    OffsetIndex index = new OffsetIndex(indexFile, startOffset, x$4, false);
                    int x$8 = -1;
                    TimeIndex timeIndex = new TimeIndex(file, startOffset, x$8, false);
                    try {
                        if (indexSanityOnly) {
                            timeIndex.sanityCheck();
                            String println_x = new StringBuilder(21).append(file).append(" passed sanity check.").toString();
                            Console$.MODULE$.println((Object)println_x);
                            Object var27_17 = null;
                            break block9;
                        }
                        long create_e = -1L;
                        LongRef prevTimestamp = new LongRef(create_e);
                        int n = 0;
                        int until$extension_end = timeIndex.entries();
                        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
                        if (!foreach$mVc$sp_this.isEmpty()) {
                            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                            while (true) {
                                DumpLogSegments$.$anonfun$dumpTimeIndex$1(timeIndex, object, index, fileRecords, timeIndexDumpErrors, file, prevTimestamp, verifyOnly, foreach$mVc$sp_i);
                                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                            }
                        }
                        Object var20_22 = null;
                        break block10;
                    }
                    finally {
                        fileRecords.closeHandlers();
                        index.closeHandler();
                        timeIndex.closeHandler();
                    }
                }
                return;
            }
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private void dumpLog(File file, boolean printContents, Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        String toLong$extension_$this = file.getName().split("\\.")[0];
        Object var19_7 = null;
        long startOffset = Long.parseLong(toLong$extension_$this);
        String println_x = new StringBuilder(17).append("Starting offset: ").append(startOffset).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var20_9 = null;
        boolean open_mutable = false;
        FileRecords fileRecords = FileRecords.open((File)file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
        try {
            long create_e = 0L;
            LongRef validBytes = new LongRef(create_e);
            long create_e2 = -1L;
            LongRef lastOffset = new LongRef(create_e2);
            AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)fileRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(validBytes, isDeepIteration, lastOffset, nonConsecutivePairsForLogFilesMap, file, printContents, parser, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
            if (trailingBytes > 0L) {
                String println_x2 = new StringBuilder(35).append("Found ").append(trailingBytes).append(" invalid bytes at the end of ").append(file.getName()).toString();
                Console$.MODULE$.println((Object)println_x2);
                Object var22_17 = null;
            }
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            String print_x = new StringBuilder(145).append("baseOffset: ").append(batch.baseOffset()).append(" lastOffset: ").append(batch.lastOffset()).append(" count: ").append(batch.countOrNull()).append(" baseSequence: ").append(batch.baseSequence()).append(" lastSequence: ").append(batch.lastSequence()).append(" producerId: ").append(batch.producerId()).append(" producerEpoch: ").append(batch.producerEpoch()).append(" partitionLeaderEpoch: ").append(batch.partitionLeaderEpoch()).append(" isTransactional: ").append(batch.isTransactional()).append(" isControl: ").append(batch.isControlBatch()).toString();
            Console$.MODULE$.print((Object)print_x);
            Object var4_3 = null;
        } else {
            String print_x = new StringBuilder(8).append("offset: ").append(batch.lastOffset()).toString();
            Console$.MODULE$.print((Object)print_x);
            Object var5_4 = null;
        }
        String println_x = new StringBuilder(61).append(" position: ").append(accumulativeBytes).append(" ").append(batch.timestampType()).append(": ").append(batch.maxTimestamp()).append(" size: ").append(batch.sizeInBytes()).append(" magic: ").append(batch.magic()).append(" compresscodec: ").append(batch.compressionType()).append(" crc: ").append(batch.checksum()).append(" isvalid: ").append(batch.isValid()).toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments.DumpLogSegmentsOptions opts$1, Map nonConsecutivePairsForLogFilesMap$1, Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        File file = new File(arg);
        String println_x = new StringBuilder(8).append("Dumping ").append(file).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var8_6 = null;
        String filename = file.getName();
        String suffix = filename.substring(filename.lastIndexOf("."));
        String string = Log$.MODULE$.LogFileSuffix();
        if (!(string != null ? !string.equals(suffix) : suffix != null)) {
            MODULE$.dumpLog(file, opts$1.shouldPrintDataLog(), (Map<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$1, opts$1.isDeepIteration(), opts$1.maxMessageSize(), opts$1.messageParser());
            return;
        }
        String string2 = Log$.MODULE$.IndexFileSuffix();
        if (!(string2 != null ? !string2.equals(suffix) : suffix != null)) {
            MODULE$.dumpIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), (Map<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$1, opts$1.maxMessageSize());
            return;
        }
        String string3 = Log$.MODULE$.TimeIndexFileSuffix();
        if (!(string3 != null ? !string3.equals(suffix) : suffix != null)) {
            MODULE$.dumpTimeIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), timeIndexDumpErrors$1, opts$1.maxMessageSize());
            return;
        }
        String string4 = Log$.MODULE$.ProducerSnapshotFileSuffix();
        if (!(string4 != null ? !string4.equals(suffix) : suffix != null)) {
            MODULE$.dumpProducerIdSnapshot(file);
            return;
        }
        String string5 = Log$.MODULE$.TxnIndexFileSuffix();
        if (!(string5 != null ? !string5.equals(suffix) : suffix != null)) {
            MODULE$.dumpTxnIndex(file);
            return;
        }
        System.err.println(new StringBuilder(22).append("Ignoring unknown file ").append(file).toString());
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            long indexOffset = x0$2._1$mcJ$sp();
            long logOffset = x0$2._2$mcJ$sp();
            System.err.println(new StringBuilder(30).append("  Index offset: ").append(indexOffset).append(", log offset: ").append(logOffset).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            String fileName = (String)x0$1._1();
            List listOfMismatches = (List)x0$1._2();
            System.err.println(new StringBuilder(15).append("Mismatches in :").append(fileName).toString());
            if (listOfMismatches == null) {
                throw null;
            }
            List foreach_these = listOfMismatches;
            while (!foreach_these.isEmpty()) {
                DumpLogSegments$.$anonfun$main$3((Tuple2)foreach_these.head());
                foreach_these = (List)foreach_these.tail();
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$4) {
        if (x0$4 != null) {
            long first = x0$4._1$mcJ$sp();
            long second = x0$4._2$mcJ$sp();
            System.err.println(new StringBuilder(18).append("  ").append(first).append(" is followed by ").append(second).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            String fileName = (String)x0$3._1();
            List listOfNonConsecutivePairs = (List)x0$3._2();
            System.err.println(new StringBuilder(27).append("Non-consecutive offsets in ").append(fileName).toString());
            if (listOfNonConsecutivePairs == null) {
                throw null;
            }
            List foreach_these = listOfNonConsecutivePairs;
            while (!foreach_these.isEmpty()) {
                DumpLogSegments$.$anonfun$main$5((Tuple2)foreach_these.head());
                foreach_these = (List)foreach_these.tail();
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$dumpTxnIndex$1(AbortedTxn abortedTxn) {
        String println_x = new StringBuilder(68).append("version: ").append(abortedTxn.version()).append(" producerId: ").append(abortedTxn.producerId()).append(" firstOffset: ").append(abortedTxn.firstOffset()).append(" ").append("lastOffset: ").append(abortedTxn.lastOffset()).append(" lastStableOffset: ").append(abortedTxn.lastStableOffset()).toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$dumpProducerIdSnapshot$2(BatchMetadata metadata) {
        String print_x = new StringBuilder(69).append("firstSequence: ").append(metadata.firstSeq()).append(" lastSequence: ").append(metadata.lastSeq()).append(" ").append("lastOffset: ").append(metadata.lastOffset()).append(" offsetDelta: ").append(metadata.offsetDelta()).append(" timestamp: ").append(metadata.timestamp()).toString();
        Console$.MODULE$.print((Object)print_x);
    }

    public static final /* synthetic */ void $anonfun$dumpProducerIdSnapshot$1(ProducerStateEntry entry) {
        String print_x = new StringBuilder(72).append("producerId: ").append(entry.producerId()).append(" producerEpoch: ").append(entry.producerEpoch()).append(" ").append("coordinatorEpoch: ").append(entry.coordinatorEpoch()).append(" currentTxnFirstOffset: ").append(entry.currentTxnFirstOffset()).append(" ").toString();
        Console$.MODULE$.print((Object)print_x);
        Object var2_1 = null;
        Option option = entry.batchMetadata().headOption();
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$2((BatchMetadata)foreach_this.get());
        }
        Object var1_2 = null;
        Console$.MODULE$.println();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$dumpIndex$1(OffsetIndex index$1, Object nonLocalReturnKey1$1, FileRecords fileRecords$1, int maxMessageSize$1, Map misMatchesForIndexFilesMap$2, File file$1, boolean verifyOnly$1, int i) {
        OffsetPosition entry = index$1.entry(i);
        if (entry.offset() == index$1.baseOffset() && i > 0) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        long firstBatchLastOffset = ((RecordBatch)fileRecords$1.slice(entry.position(), maxMessageSize$1).batches().iterator().next()).lastOffset();
        if (firstBatchLastOffset != entry.offset()) {
            void $colon$colon_elem;
            List misMatchesSeq = (List)misMatchesForIndexFilesMap$2.getOrElse((Object)file$1.getAbsolutePath(), (Function0 & Serializable)() -> Nil$.MODULE$);
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(entry.offset(), firstBatchLastOffset);
            if (misMatchesSeq == null) {
                throw null;
            }
            sp2 = null;
            misMatchesSeq = new .colon.colon((Object)$colon$colon_elem, misMatchesSeq);
            misMatchesForIndexFilesMap$2.put((Object)file$1.getAbsolutePath(), (Object)misMatchesSeq);
        }
        if (!verifyOnly$1) {
            String println_x = new StringBuilder(19).append("offset: ").append(entry.offset()).append(" position: ").append(entry.position()).toString();
            Console$.MODULE$.println((Object)println_x);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(TimeIndex timeIndex$1, Object nonLocalReturnKey2$1, OffsetIndex index$2, FileRecords fileRecords$2, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, File file$2, LongRef prevTimestamp$1, boolean verifyOnly$2, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                if (entry.offset() == timeIndex$1.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                position = index$2.lookup(entry.offset()).position();
                partialFileRecords = fileRecords$2.slice(position, 0x7FFFFFFF);
                batches = AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)partialFileRecords.batches()).asScala();
                create_e = -1L;
                maxTimestamp = new LongRef(create_e);
                var14_15 = false;
                var15_16 = null;
                var16_17 = batches.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(kafka.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimestampOffset)entry));
                if (!None$.MODULE$.equals(var16_17)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), -1);
                break block9;
            }
            if (!(var16_17 instanceof Some)) ** GOTO lbl-1000
            var14_15 = true;
            var15_16 = (Some)var16_17;
            batch = (FileLogInputStream.FileChannelRecordBatch)var15_16.value();
            if (batch.lastOffset() != entry.offset()) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), batch.lastOffset());
            } else if (var14_15) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var15_16.value();
                AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp()) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$2, entry.timestamp(), maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp()) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$2, entry.timestamp(), prevTimestamp$1.elem);
                }
            } else {
                throw new MatchError((Object)var16_17);
            }
        }
        if (!verifyOnly$2) {
            println_x = new StringBuilder(20).append("timestamp: ").append(entry.timestamp()).append(" offset: ").append(entry.offset()).toString();
            Console$.MODULE$.println((Object)println_x);
            var21_20 = null;
        }
        prevTimestamp$1.elem = entry.timestamp();
    }

    public static final /* synthetic */ String $anonfun$dumpLog$4(Header x$2) {
        return x$2.key();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$5(Object key) {
        String print_x = new StringBuilder(6).append(" key: ").append(key).toString();
        Console$.MODULE$.print((Object)print_x);
    }

    public static final /* synthetic */ void $anonfun$dumpLog$6(Object payload) {
        String print_x = new StringBuilder(10).append(" payload: ").append(payload).toString();
        Console$.MODULE$.print((Object)print_x);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$dumpLog$2(LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, FileLogInputStream.FileChannelRecordBatch batch$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, Record record) {
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            void $colon$colon_elem;
            List nonConsecutivePairsSeq = (List)nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)file$3.getAbsolutePath(), (Function0 & Serializable)() -> Nil$.MODULE$);
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(lastOffset$1.elem, record.offset());
            if (nonConsecutivePairsSeq == null) {
                throw null;
            }
            sp2 = null;
            nonConsecutivePairsSeq = new .colon.colon((Object)$colon$colon_elem, nonConsecutivePairsSeq);
            nonConsecutivePairsForLogFilesMap$2.put((Object)file$3.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
        }
        lastOffset$1.elem = record.offset();
        String print_x = new StringBuilder(34).append(MODULE$.RecordIndent()).append(" offset: ").append(record.offset()).append(" ").append(batch$1.timestampType()).append(": ").append(record.timestamp()).append(" ").append("keysize: ").append(record.keySize()).append(" valuesize: ").append(record.valueSize()).toString();
        Console$.MODULE$.print((Object)print_x);
        Object var22_9 = null;
        if (batch$1.magic() >= 2) {
            void mkString_end;
            void mkString_sep;
            void mkString_start;
            StringBuilder stringBuilder = new StringBuilder(24).append(" sequence: ").append(record.sequence()).append(" headerKeys: ");
            Header[] map$extension_$this = record.headers();
            int map$extension_len = map$extension_$this.length;
            Object[] map$extension_ys = new String[map$extension_len];
            if (map$extension_len > 0) {
                for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                    String array_update_value = map$extension_$this[map$extension_i].key();
                    map$extension_ys[map$extension_i] = array_update_value;
                    Object var27_14 = null;
                }
            }
            Object var17_10 = null;
            Object var19_12 = null;
            ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray(map$extension_ys);
            String string = "]";
            String string2 = ",";
            String string3 = "[";
            if (ofRef2 == null) {
                throw null;
            }
            string3 = null;
            string2 = null;
            string = null;
            String print_x2 = stringBuilder.append(IterableOnceOps.mkString$((IterableOnceOps)ofRef2, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).toString();
            Console$.MODULE$.print((Object)print_x2);
            Object var23_18 = null;
        } else {
            String print_x3 = new StringBuilder(16).append(" crc: ").append(record.checksumOrNull()).append(" isvalid: ").append(record.isValid()).toString();
            Console$.MODULE$.print((Object)print_x3);
            Object var24_19 = null;
        }
        if (batch$1.isControlBatch()) {
            short controlTypeId = ControlRecordType.parseTypeId((ByteBuffer)record.key());
            ControlRecordType controlRecordType = ControlRecordType.fromTypeId((short)controlTypeId);
            if (ControlRecordType.ABORT.equals(controlRecordType) ? true : ControlRecordType.COMMIT.equals(controlRecordType)) {
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                String print_x4 = new StringBuilder(34).append(" endTxnMarker: ").append(endTxnMarker.controlType()).append(" coordinatorEpoch: ").append(endTxnMarker.coordinatorEpoch()).toString();
                Console$.MODULE$.print((Object)print_x4);
                Object var25_23 = null;
            } else {
                String print_x5 = new StringBuilder(16).append(" controlType: ").append(controlRecordType).append("(").append(controlTypeId).append(")").toString();
                Console$.MODULE$.print((Object)print_x5);
                Object var26_24 = null;
            }
        } else if (printContents$1) {
            void var13_27;
            void var12_26;
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option key = (Option)tuple2._1();
            Option payload = (Option)tuple2._2();
            if (var12_26 == null) {
                throw null;
            }
            if (!var12_26.isEmpty()) {
                DumpLogSegments$.$anonfun$dumpLog$5(var12_26.get());
            }
            if (var13_27 == null) {
                throw null;
            }
            if (!var13_27.isEmpty()) {
                DumpLogSegments$.$anonfun$dumpLog$6(var13_27.get());
            }
        }
        Console$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(LongRef validBytes$1, boolean isDeepIteration$1, LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean printContents$1, DumpLogSegments.MessageParser parser$1, FileLogInputStream.FileChannelRecordBatch batch) {
        MODULE$.printBatchLevel(batch, validBytes$1.elem);
        if (isDeepIteration$1) {
            AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(lastOffset$1, nonConsecutivePairsForLogFilesMap$2, file$3, batch, printContents$1, parser$1, record);
                return BoxedUnit.UNIT;
            });
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(DumpLogSegments.DumpLogSegmentsOptions opts$1, Map nonConsecutivePairsForLogFilesMap$1, Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        DumpLogSegments$.$anonfun$main$1(opts$1, nonConsecutivePairsForLogFilesMap$1, misMatchesForIndexFilesMap$1, timeIndexDumpErrors$1, arg);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpTxnIndex$1$adapted(AbortedTxn abortedTxn) {
        DumpLogSegments$.$anonfun$dumpTxnIndex$1(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$3$adapted(Tuple2 x0$2) {
        DumpLogSegments$.$anonfun$main$3(x0$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$5$adapted(Tuple2 x0$4) {
        DumpLogSegments$.$anonfun$main$5(x0$4);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpProducerIdSnapshot$2$adapted(BatchMetadata metadata) {
        DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$2(metadata);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean((boolean)DumpLogSegments$.$anonfun$dumpTimeIndex$2(entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = Math.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpLog$5$adapted(Object key) {
        DumpLogSegments$.$anonfun$dumpLog$5(key);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpLog$6$adapted(Object payload) {
        DumpLogSegments$.$anonfun$dumpLog$6(payload);
        return BoxedUnit.UNIT;
    }
}

