/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.ConnectionQuotas;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.slf4j.event.Level;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005aAB\n\u0015\u0003\u00031\u0002\u0004\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u001d!\u0004A1A\u0005\nUBaA\u0010\u0001!\u0002\u00131\u0004bB \u0001\u0001\u0004%I!\u000e\u0005\b\u0001\u0002\u0001\r\u0011\"\u0003B\u0011\u0019Q\u0005\u0001)Q\u0005m!9q\n\u0001b\u0001\n\u0013\u0001\u0006BB,\u0001A\u0003%\u0011\u000bC\u0003Y\u0001\u0019\u0005\u0011\fC\u0003[\u0001\u0011\u0005\u0011\fC\u0003\\\u0001\u0011\u0005\u0011\fC\u0003]\u0001\u0011\u0005Q\fC\u0003b\u0001\u0011\u0005\u0011\fC\u0003c\u0001\u0011E\u0011\fC\u0003d\u0001\u0011E\u0011\fC\u0003e\u0001\u0011EQ\rC\u0003g\u0001\u0011\u0005qM\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\u0006\u0003+Y\tqA\\3uo>\u00148NC\u0001\u0018\u0003\u0015Y\u0017MZ6b'\u0011\u0001\u0011$\t\u0013\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012\u0001\u00027b]\u001eT\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!7\t1qJ\u00196fGR\u0004\"A\u0007\u0012\n\u0005\rZ\"\u0001\u0003*v]:\f'\r\\3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0012!B;uS2\u001c\u0018BA\u0015'\u0005\u001daunZ4j]\u001e\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0004\u0001A\u0011QFL\u0007\u0002)%\u0011q\u0006\u0006\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\fa\u0001P5oSRtDC\u0001\u001a4!\ti\u0003\u0001C\u0003+\u0005\u0001\u0007A&\u0001\u0007ti\u0006\u0014H/\u001e9MCR\u001c\u0007.F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0006d_:\u001cWO\u001d:f]RT!aO\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003{a\u0012abQ8v]R$un\u001e8MCR\u001c\u0007.A\u0007ti\u0006\u0014H/\u001e9MCR\u001c\u0007\u000eI\u0001\u000eg\",H\u000fZ8x]2\u000bGo\u00195\u0002#MDW\u000f\u001e3po:d\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n!QK\\5u\u0011\u001dIe!!AA\u0002Y\n1\u0001\u001f\u00132\u00039\u0019\b.\u001e;e_^tG*\u0019;dQ\u0002B#a\u0002'\u0011\u0005\rk\u0015B\u0001(E\u0005!1x\u000e\\1uS2,\u0017!B1mSZ,W#A)\u0011\u0005I+V\"A*\u000b\u0005QC\u0014AB1u_6L7-\u0003\u0002W'\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fa!\u00197jm\u0016\u0004\u0013AB<bW\u0016,\b\u000fF\u0001C\u0003AIg.\u001b;jCR,7\u000b[;uI><h.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\nSN\u001cF/\u0019:uK\u0012$\u0012A\u0018\t\u0003\u0007~K!\u0001\u0019#\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011m^1jiN#\u0018M\u001d;va\u0006y1\u000f^1siV\u00048i\\7qY\u0016$X-\u0001\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uK\u0006I\u0011n\u001d*v]:LgnZ\u000b\u0002=\u0006)1\r\\8tKR\u0019!\t\u001b<\t\u000b%\u0014\u0002\u0019\u00016\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\u0005-$X\"\u00017\u000b\u0005Ui'B\u00018p\u0003\u0019\u0019w.\\7p]*\u0011q\u0003\u001d\u0006\u0003cJ\fa!\u00199bG\",'\"A:\u0002\u0007=\u0014x-\u0003\u0002vY\naA*[:uK:,'OT1nK\")qO\u0005a\u0001q\u000691\r[1o]\u0016d\u0007CA=\u007f\u001b\u0005Q(BA>}\u0003!\u0019\u0007.\u00198oK2\u001c(BA?\u001e\u0003\rq\u0017n\\\u0005\u0003\u007fj\u0014QbU8dW\u0016$8\t[1o]\u0016d\u0007")
public abstract class AbstractServerThread
implements Runnable,
Logging {
    private final ConnectionQuotas connectionQuotas;
    private final CountDownLatch startupLatch;
    private volatile CountDownLatch shutdownLatch;
    private final AtomicBoolean alive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch x$1) {
        this.shutdownLatch = x$1;
    }

    private AtomicBoolean alive() {
        return this.alive;
    }

    public abstract void wakeup();

    public void initiateShutdown() {
        if (this.alive().getAndSet(false)) {
            this.wakeup();
            return;
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public boolean isStarted() {
        return this.startupLatch().getCount() == 0L;
    }

    public void awaitStartup() {
        this.startupLatch().await();
    }

    public void startupComplete() {
        this.shutdownLatch_$eq(new CountDownLatch(1));
        this.startupLatch().countDown();
    }

    public void shutdownComplete() {
        this.shutdownLatch().countDown();
    }

    public boolean isRunning() {
        return this.alive().get();
    }

    public void close(ListenerName listenerName, SocketChannel channel) {
        if (channel != null) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Closing connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
            this.connectionQuotas.dec(listenerName, channel.socket().getInetAddress());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.socket().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.close(), this, Level.ERROR);
            return;
        }
    }

    public AbstractServerThread(ConnectionQuotas connectionQuotas) {
        this.connectionQuotas = connectionQuotas;
        this.startupLatch = new CountDownLatch(1);
        this.shutdownLatch = new CountDownLatch(0);
        this.alive = new AtomicBoolean(true);
    }
}

