/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerStateEntry;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Crc32C;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ProducerStateManager$ {
    public static final ProducerStateManager$ MODULE$ = new ProducerStateManager$();
    private static final short ProducerSnapshotVersion = 1;
    private static final String VersionField = "version";
    private static final String CrcField = "crc";
    private static final String ProducerIdField = "producer_id";
    private static final String LastSequenceField = "last_sequence";
    private static final String ProducerEpochField = "epoch";
    private static final String LastOffsetField = "last_offset";
    private static final String OffsetDeltaField = "offset_delta";
    private static final String TimestampField = "timestamp";
    private static final String ProducerEntriesField = "producer_entries";
    private static final String CoordinatorEpochField = "coordinator_epoch";
    private static final String CurrentTxnFirstOffsetField = "current_txn_first_offset";
    private static final int VersionOffset = 0;
    private static final int CrcOffset = MODULE$.VersionOffset() + 2;
    private static final int ProducerEntriesOffset = MODULE$.CrcOffset() + 4;
    private static final Schema ProducerSnapshotEntrySchema = new Schema(new Field[]{new Field(MODULE$.ProducerIdField(), (Type)Type.INT64, "The producer ID"), new Field(MODULE$.ProducerEpochField(), (Type)Type.INT16, "Current epoch of the producer"), new Field(MODULE$.LastSequenceField(), (Type)Type.INT32, "Last written sequence of the producer"), new Field(MODULE$.LastOffsetField(), (Type)Type.INT64, "Last written offset of the producer"), new Field(MODULE$.OffsetDeltaField(), (Type)Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field(MODULE$.TimestampField(), (Type)Type.INT64, "Max timestamp from the last written entry"), new Field(MODULE$.CoordinatorEpochField(), (Type)Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field(MODULE$.CurrentTxnFirstOffsetField(), (Type)Type.INT64, "The first offset of the on-going transaction (-1 if there is none)")});
    private static final Schema PidSnapshotMapSchema = new Schema(new Field[]{new Field(MODULE$.VersionField(), (Type)Type.INT16, "Version of the snapshot file"), new Field(MODULE$.CrcField(), (Type)Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field(MODULE$.ProducerEntriesField(), (Type)new ArrayOf((Type)MODULE$.ProducerSnapshotEntrySchema()), "The entries in the producer table")});

    public int $lessinit$greater$default$3() {
        return 3600000;
    }

    private short ProducerSnapshotVersion() {
        return ProducerSnapshotVersion;
    }

    private String VersionField() {
        return VersionField;
    }

    private String CrcField() {
        return CrcField;
    }

    private String ProducerIdField() {
        return ProducerIdField;
    }

    private String LastSequenceField() {
        return LastSequenceField;
    }

    private String ProducerEpochField() {
        return ProducerEpochField;
    }

    private String LastOffsetField() {
        return LastOffsetField;
    }

    private String OffsetDeltaField() {
        return OffsetDeltaField;
    }

    private String TimestampField() {
        return TimestampField;
    }

    private String ProducerEntriesField() {
        return ProducerEntriesField;
    }

    private String CoordinatorEpochField() {
        return CoordinatorEpochField;
    }

    private String CurrentTxnFirstOffsetField() {
        return CurrentTxnFirstOffsetField;
    }

    private int VersionOffset() {
        return VersionOffset;
    }

    private int CrcOffset() {
        return CrcOffset;
    }

    private int ProducerEntriesOffset() {
        return ProducerEntriesOffset;
    }

    public Schema ProducerSnapshotEntrySchema() {
        return ProducerSnapshotEntrySchema;
    }

    public Schema PidSnapshotMapSchema() {
        return PidSnapshotMapSchema;
    }

    public Iterable<ProducerStateEntry> readSnapshot(File file) {
        try {
            long computedCrc;
            byte[] buffer = Files.readAllBytes(file.toPath());
            Struct struct = this.PidSnapshotMapSchema().read(ByteBuffer.wrap(buffer));
            Short version = struct.getShort(this.VersionField());
            if (!BoxesRunTime.equalsNumObject((Number)version, (Object)this.ProducerSnapshotVersion())) {
                throw new CorruptSnapshotException(new StringBuilder(43).append("Snapshot contained an unknown file version ").append(version).toString());
            }
            Long crc = struct.getUnsignedInt(this.CrcField());
            if (!BoxesRunTime.equalsNumObject((Number)crc, (Object)(computedCrc = Crc32C.compute((byte[])buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.length - this.ProducerEntriesOffset()))))) {
                throw new CorruptSnapshotException(new StringBuilder(74).append("Snapshot is corrupt (CRC is no longer valid). ").append("Stored crc: ").append(crc).append(". Computed crc: ").append(computedCrc).toString());
            }
            Object[] map$extension_$this = struct.getArray(this.ProducerEntriesField());
            int map$extension_len = map$extension_$this.length;
            Object[] map$extension_ys = new ProducerStateEntry[map$extension_len];
            if (map$extension_len > 0) {
                for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                    ProducerStateEntry array_update_value = ProducerStateManager$.$anonfun$readSnapshot$1(map$extension_$this[map$extension_i]);
                    map$extension_ys[map$extension_i] = array_update_value;
                    Object var13_11 = null;
                }
            }
            Object var9_7 = null;
            Object var11_9 = null;
            return Predef$.MODULE$.wrapRefArray(map$extension_ys);
        }
        catch (SchemaException e) {
            throw new CorruptSnapshotException(new StringBuilder(35).append("Snapshot failed schema validation: ").append(e.getMessage()).toString());
        }
    }

    public void kafka$log$ProducerStateManager$$writeSnapshot(File file, Map<Object, ProducerStateEntry> entries) {
        Struct struct = new Struct(this.PidSnapshotMapSchema());
        struct.set(this.VersionField(), (Object)this.ProducerSnapshotVersion());
        struct.set(this.CrcField(), (Object)0L);
        Struct[] entriesArray = (Struct[])((IterableOnceOps)entries.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long producerId = x0$1._1$mcJ$sp();
                ProducerStateEntry entry = (ProducerStateEntry)x0$1._2();
                Struct producerEntryStruct = struct.instance(MODULE$.ProducerEntriesField());
                Option<Object> option = entry.currentTxnFirstOffset();
                if (option == null) {
                    throw null;
                }
                Option<Object> getOrElse_this = option;
                Object object = getOrElse_this.isEmpty() ? Long.valueOf(-1L) : getOrElse_this.get();
                Object var6_5 = null;
                producerEntryStruct.set(MODULE$.ProducerIdField(), (Object)producerId).set(MODULE$.ProducerEpochField(), (Object)entry.producerEpoch()).set(MODULE$.LastSequenceField(), (Object)entry.lastSeq()).set(MODULE$.LastOffsetField(), (Object)entry.lastDataOffset()).set(MODULE$.OffsetDeltaField(), (Object)entry.lastOffsetDelta()).set(MODULE$.TimestampField(), (Object)entry.lastTimestamp()).set(MODULE$.CoordinatorEpochField(), (Object)entry.coordinatorEpoch()).set(MODULE$.CurrentTxnFirstOffsetField(), object);
                return producerEntryStruct;
            }
            throw new MatchError(null);
        })).toArray(ClassTag$.MODULE$.apply(Struct.class));
        struct.set(this.ProducerEntriesField(), (Object)entriesArray);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        long crc = Crc32C.compute((ByteBuffer)buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.limit() - this.ProducerEntriesOffset()));
        int writeUnsignedInt_index = this.CrcOffset();
        buffer.putInt(writeUnsignedInt_index, (int)(crc & 0xFFFFFFFFL));
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileChannel.write(buffer);
        }
    }

    private boolean isSnapshotFile(File file) {
        return file.getName().endsWith(Log$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public Seq<File> listSnapshotFiles(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            Option option = Option$.MODULE$.apply((Object)dir.listFiles());
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ProducerStateManager$.$anonfun$listSnapshotFiles$1((File[])map_this.get()));
            Object var2_2 = null;
            None$ getOrElse_this = object;
            return getOrElse_this.isEmpty() ? ProducerStateManager$.$anonfun$listSnapshotFiles$3() : getOrElse_this.get();
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public void deleteSnapshotsBefore(File dir, long offset) {
        JFunction1.mcZJ.sp & Serializable kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate = (JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 < offset;
        ((IterableOnceOps)this.listSnapshotFiles(dir).filter(arg_0 -> ProducerStateManager$.$anonfun$deleteSnapshotFiles$1$adapted((Function1)kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate, arg_0))).foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager$.$anonfun$deleteSnapshotFiles$2(file)));
    }

    public void kafka$log$ProducerStateManager$$deleteSnapshotFiles(File dir, Function1<Object, Object> predicate) {
        ((IterableOnceOps)this.listSnapshotFiles(dir).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)predicate.apply$mcZJ$sp(Log$.MODULE$.offsetFromFile(file))))).foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager$.$anonfun$deleteSnapshotFiles$2(file)));
    }

    public Function1<Object, Object> kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2() {
        return (JFunction1.mcZJ.sp & Serializable)x$2 -> true;
    }

    public static final /* synthetic */ ProducerStateEntry $anonfun$readSnapshot$1(Object producerEntryObj) {
        Struct producerEntryStruct = (Struct)producerEntryObj;
        Long producerId = producerEntryStruct.getLong(MODULE$.ProducerIdField());
        Short producerEpoch = producerEntryStruct.getShort(MODULE$.ProducerEpochField());
        Integer seq = producerEntryStruct.getInt(MODULE$.LastSequenceField());
        Long offset = producerEntryStruct.getLong(MODULE$.LastOffsetField());
        Long timestamp = producerEntryStruct.getLong(MODULE$.TimestampField());
        Integer offsetDelta = producerEntryStruct.getInt(MODULE$.OffsetDeltaField());
        Integer coordinatorEpoch = producerEntryStruct.getInt(MODULE$.CoordinatorEpochField());
        Long currentTxnFirstOffset = producerEntryStruct.getLong(MODULE$.CurrentTxnFirstOffsetField());
        Queue lastAppendedDataBatches = new Queue(16);
        if (BoxesRunTime.unboxToLong((Object)offset) >= 0L) {
            BatchMetadata $plus$eq_elem = new BatchMetadata(BoxesRunTime.unboxToInt((Object)seq), BoxesRunTime.unboxToLong((Object)offset), BoxesRunTime.unboxToInt((Object)offsetDelta), BoxesRunTime.unboxToLong((Object)timestamp));
            lastAppendedDataBatches.addOne((Object)$plus$eq_elem);
            Object var11_11 = null;
        }
        return new ProducerStateEntry(BoxesRunTime.unboxToLong((Object)producerId), (Queue<BatchMetadata>)lastAppendedDataBatches, BoxesRunTime.unboxToShort((Object)producerEpoch), BoxesRunTime.unboxToInt((Object)coordinatorEpoch), BoxesRunTime.unboxToLong((Object)timestamp), (Option<Object>)(BoxesRunTime.unboxToLong((Object)currentTxnFirstOffset) >= 0L ? new Some((Object)BoxesRunTime.unboxToLong((Object)currentTxnFirstOffset)) : None$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$writeSnapshot$2() {
        return -1L;
    }

    public static final /* synthetic */ boolean $anonfun$listSnapshotFiles$2(File f) {
        return f.isFile() && MODULE$.isSnapshotFile(f);
    }

    public static final /* synthetic */ Seq $anonfun$listSnapshotFiles$1(File[] files) {
        Object object;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(files.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Object var4_1 = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = object;
        for (int filter$extension_i = 0; filter$extension_i < files.length; ++filter$extension_i) {
            File filter$extension_x = files[filter$extension_i];
            if (!ProducerStateManager$.$anonfun$listSnapshotFiles$2(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var1_3 = null;
        Object var3_5 = null;
        return ArrayOps$.MODULE$.toIndexedSeq$extension((Object)((Object[])filter$extension_res.result()));
    }

    public static final /* synthetic */ Seq $anonfun$listSnapshotFiles$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(File file) {
        return Files.deleteIfExists(file.toPath());
    }

    private ProducerStateManager$() {
    }

    public static final /* synthetic */ Object $anonfun$listSnapshotFiles$2$adapted(File f) {
        return BoxesRunTime.boxToBoolean((boolean)ProducerStateManager$.$anonfun$listSnapshotFiles$2(f));
    }
}

