/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r%b\u0001\u0002!B\u0001\u0019C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"AA\u000f\u0001B\u0001B\u0003%a\r\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0001w\u0011%\t\t\u0002\u0001B\u0001B\u0003%q\u000f\u0003\u0006\u0002\u0014\u0001\u0011)\u0019!C\u0001\u0003+A!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\f\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011%\tY\u0004\u0001a\u0001\n\u0013\ti\u0004C\u0005\u0002@\u0001\u0001\r\u0011\"\u0003\u0002B!9\u0011Q\n\u0001!B\u0013\u0001\u0007BCA,\u0001\t\u0007I\u0011A!\u0002Z!A\u0011\u0011\r\u0001!\u0002\u0013\tY\u0006C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0007\u0003\u0006\u0002p\u0001\u0011\r\u0011\"\u0001B\u0003cB\u0001B!\u0012\u0001A\u0003%\u00111\u000f\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011!\u0011Y\u0006\u0001C\u0001\u0003\nu\u0003b\u0002B0\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0005C\u0002A\u0011AAt\u0011\u001d\u0011\u0019\u0007\u0001C!\u0005KBqA!\u001c\u0001\t\u0003\u0012y\u0007C\u0004\u0003|\u0001!\tE! \t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"9!1\u0012\u0001\u0005\u0002\t5\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WCqA!.\u0001\t\u0003\u00119\fC\u0004\u0003<\u0002!\tA!0\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"I!Q\u001b\u0001\u0012\u0002\u0013\u0005!q\u001b\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011!\u0011I\u0010\u0001C\u0001\u0007\u0006u\u0002\u0002\u0003B~\u0001\u0011\u0005\u0011I!\u0018\u0007\u000f\u0005\r\u0005\u0001A!\u0002\u0006\"Q\u0011Q\u0012\u0014\u0003\u0002\u0003\u0006I!a$\t\u000f\u0005-b\u0005\"\u0001\u0002\u0016\"9\u0011\u0011\u0014\u0014\u0005R\u0005m\u0005\"CAUM\t\u0007I\u0011AAV\u0011!\t\u0019L\nQ\u0001\n\u00055\u0006\"CA[M\u0001\u0007I\u0011AA\\\u0011%\tyL\na\u0001\n\u0003\t\t\r\u0003\u0005\u0002F\u001a\u0002\u000b\u0015BA]\u0011%\tIM\na\u0001\n\u0003\tY\rC\u0005\u0002T\u001a\u0002\r\u0011\"\u0001\u0002V\"A\u0011\u0011\u001c\u0014!B\u0013\ti\rC\u0004\u0002^\u001a\"I!a8\t\u000f\u0005\u0015h\u0005\"\u0011\u0002h\"9\u0011\u0011\u001e\u0014\u0005\n\u0005-\bbBAzM\u0011%\u00111\u001e\u0005\b\u0005\u000b1C\u0011\u0002B\u0004\u0011\u001d\u0011\u0019B\nC\u0001\u0005+9qA!@B\u0011\u0003\u0011yP\u0002\u0004A\u0003\"\u00051\u0011\u0001\u0005\b\u0003WID\u0011AB\u0002\u0011%\u0019)!\u000fb\u0001\n\u0003\u00199\u0001\u0003\u0005\u0004\fe\u0002\u000b\u0011BB\u0005\u0011\u001d\u0019i!\u000fC\u0001\u0007\u001fAqaa\u0005:\t\u0003\u0019)\u0002C\u0005\u0004$e\n\n\u0011\"\u0001\u0004&\tQAj\\4DY\u0016\fg.\u001a:\u000b\u0005\t\u001b\u0015a\u00017pO*\tA)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u00019UjU-\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g!\tq\u0015+D\u0001P\u0015\t\u00016)A\u0003vi&d7/\u0003\u0002S\u001f\n9Aj\\4hS:<\u0007C\u0001+X\u001b\u0005)&B\u0001,D\u0003\u001diW\r\u001e:jGNL!\u0001W+\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0005\u0002[;6\t1L\u0003\u0002]\u0007\u000611/\u001a:wKJL!AX.\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u00035Ig.\u001b;jC2\u001cuN\u001c4jOB\u0011\u0011MY\u0007\u0002\u0003&\u00111-\u0011\u0002\u000e\u00072,\u0017M\\3s\u0007>tg-[4\u0002\u000f1|w\rR5sgV\ta\rE\u0002hU2l\u0011\u0001\u001b\u0006\u0003S&\u000b!bY8mY\u0016\u001cG/[8o\u0013\tY\u0007NA\u0002TKF\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u0005%|'\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014AAR5mK\u0006AAn\\4ESJ\u001c\b%\u0001\u0003m_\u001e\u001cX#A<\u0011\u000b9C(0a\u0003\n\u0005e|%\u0001\u0002)p_2\u00042a_A\u0004\u001b\u0005a(BA?\u007f\u0003\u0019\u0019w.\\7p]*\u0011Ai \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\t1a\u001c:h\u0013\r\tI\u0001 \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\r\t\u0017QB\u0005\u0004\u0003\u001f\t%a\u0001'pO\u0006)An\\4tA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\"!a\u0006\u0011\u0007i\u000bI\"C\u0002\u0002\u001cm\u0013A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eI\u0001\u0005i&lW\r\u0005\u0003\u0002$\u0005\u001dRBAA\u0013\u0015\t\u0001F0\u0003\u0003\u0002*\u0005\u0015\"\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003DA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u0002CA1\u0001\u0011\u0015y\u0016\u00021\u0001a\u0011\u0015!\u0017\u00021\u0001g\u0011\u0015)\u0018\u00021\u0001x\u0011\u001d\t\u0019\"\u0003a\u0001\u0003/A\u0011\"a\b\n!\u0003\u0005\r!!\t\u0002\r\r|gNZ5h+\u0005\u0001\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u00111IA%!\rA\u0015QI\u0005\u0004\u0003\u000fJ%\u0001B+oSRD\u0001\"a\u0013\f\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\r\t\u0015\u0004\u0019\u0005E\u0003c\u0001%\u0002T%\u0019\u0011QK%\u0003\u0011Y|G.\u0019;jY\u0016\fab\u00197fC:,'/T1oC\u001e,'/\u0006\u0002\u0002\\A\u0019\u0011-!\u0018\n\u0007\u0005}\u0013IA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fqb\u00197fC:,'/T1oC\u001e,'\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\"!a\u001a\u0011\u00079\u000bI'C\u0002\u0002l=\u0013\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%\u0001\u0005dY\u0016\fg.\u001a:t+\t\t\u0019\b\u0005\u0004\u0002v\u0005m\u0014qP\u0007\u0003\u0003oR1!!\u001fi\u0003\u001diW\u000f^1cY\u0016LA!! \u0002x\tY\u0011I\u001d:bs\n+hMZ3s!\r\t\tIJ\u0007\u0002\u0001\ti1\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001c2AJAD!\rq\u0015\u0011R\u0005\u0004\u0003\u0017{%AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\f\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\t\u0004\u0011\u0006E\u0015bAAJ\u0013\n\u0019\u0011J\u001c;\u0015\t\u0005}\u0014q\u0013\u0005\b\u0003\u001bC\u0003\u0019AAH\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003;\u0003B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G\u0003\u0018\u0001\u00027b]\u001eLA!a*\u0002\"\n11\u000b\u001e:j]\u001e\fqa\u00197fC:,'/\u0006\u0002\u0002.B\u0019\u0011-a,\n\u0007\u0005E\u0016IA\u0004DY\u0016\fg.\u001a:\u0002\u0011\rdW-\u00198fe\u0002\n\u0011\u0002\\1tiN#\u0018\r^:\u0016\u0005\u0005e\u0006cA1\u0002<&\u0019\u0011QX!\u0003\u0019\rcW-\u00198feN#\u0018\r^:\u0002\u001b1\f7\u000f^*uCR\u001cx\fJ3r)\u0011\t\u0019%a1\t\u0013\u0005-S&!AA\u0002\u0005e\u0016A\u00037bgR\u001cF/\u0019;tA!\u001aa&!\u0015\u0002#1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8/\u0006\u0002\u0002NB\u0019\u0011-a4\n\u0007\u0005E\u0017IA\u0007Qe\u0016\u001cE.Z1o'R\fGo]\u0001\u0016Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cx\fJ3r)\u0011\t\u0019%a6\t\u0013\u0005-\u0003'!AA\u0002\u00055\u0017A\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ug\u0002B3!MA)\u0003%\u0019\u0007.Z2l\t>tW\r\u0006\u0003\u0002D\u0005\u0005\bBBAre\u0001\u0007!0\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\r\u0011|wk\u001c:l)\t\t\u0019%\u0001\u000buef\u001cE.Z1o\r&dG\u000f[5fgRdun\u001a\u000b\u0003\u0003[\u00042\u0001SAx\u0013\r\t\t0\u0013\u0002\b\u0005>|G.Z1o\u0003E\u0019G.Z1o\r&dG\u000f[5fgRdun\u001a\u0015\u0006k\u0005](1\u0001\t\u0006\u0011\u0006e\u0018Q`\u0005\u0004\u0003wL%A\u0002;ie><8\u000fE\u0002b\u0003\u007fL1A!\u0001B\u0005QaunZ\"mK\u0006t\u0017N\\4Fq\u000e,\u0007\u000f^5p]\u000e\u0012\u0011Q`\u0001\tG2,\u0017M\u001c'pOR!\u00111\tB\u0005\u0011\u001d\u0011YA\u000ea\u0001\u0005\u001b\t\u0011b\u00197fC:\f'\r\\3\u0011\u0007\u0005\u0014y!C\u0002\u0003\u0012\u0005\u0013!\u0002T8h)>\u001cE.Z1o\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005\r#q\u0003B\u000e\u0005g\u0011iD!\u0011\t\u000f\teq\u00071\u0001\u0002\u0010\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005;9\u0004\u0019\u0001B\u0010\u0003\u0011q\u0017-\\3\u0011\t\t\u0005\"q\u0006\b\u0005\u0005G\u0011Y\u0003E\u0002\u0003&%k!Aa\n\u000b\u0007\t%R)\u0001\u0004=e>|GOP\u0005\u0004\u0005[I\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002(\nE\"b\u0001B\u0017\u0013\"9!QG\u001cA\u0002\t]\u0012\u0001\u00024s_6\u00042\u0001\u0013B\u001d\u0013\r\u0011Y$\u0013\u0002\u0005\u0019>tw\rC\u0004\u0003@]\u0002\rAa\u000e\u0002\u0005Q|\u0007b\u0002B\"o\u0001\u0007\u0011\u0011X\u0001\u0006gR\fGo]\u0001\nG2,\u0017M\\3sg\u0002\nQ#\\1y\u001fZ,'o\u00117fC:,'\u000f\u00165sK\u0006$7\u000f\u0006\u0003\u0002\u0010\n-\u0003b\u0002B''\u0001\u0007!qJ\u0001\u0002MB9\u0001J!\u0015\u0002\u0000\tU\u0013b\u0001B*\u0013\nIa)\u001e8di&|g.\r\t\u0004\u0011\n]\u0013b\u0001B-\u0013\n1Ai\\;cY\u0016\fq\u0002Z3bIRC'/Z1e\u0007>,h\u000e^\u000b\u0003\u0003\u001f\u000bqa\u001d;beR,\b/\u0001\u0005tQV$Hm\\<o\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"Aa\u001a\u0011\u000b\u001d\u0014IGa\b\n\u0007\t-\u0004NA\u0002TKR\fqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005\r#\u0011\u000f\u0005\b\u0005gB\u0002\u0019\u0001B;\u0003%qWm^\"p]\u001aLw\rE\u0002[\u0005oJ1A!\u001f\\\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0007\u0003\u0007\u0012yHa!\t\u000f\t\u0005\u0015\u00041\u0001\u0003v\u0005Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0005gJ\u0002\u0019\u0001B;\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u00111\tBE\u0011\u0019\t\u0019O\u0007a\u0001u\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\t\u0005\r#q\u0012\u0005\u0007\u0005#[\u0002\u0019\u00017\u0002\u000f\u0011\fG/\u0019#je\u0006\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)!\t\u0019Ea&\u0003\u001a\nu\u0005BBAr9\u0001\u0007!\u0010\u0003\u0004\u0003\u001cr\u0001\r\u0001\\\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u0005?c\u0002\u0019\u00017\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002D\t\u0015\u0006b\u0002BT;\u0001\u0007!qD\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t\u0019E!,\u00030\nE\u0006B\u0002BI=\u0001\u0007A\u000e\u0003\u0004\u0002dz\u0001\rA\u001f\u0005\b\u0005gs\u0002\u0019\u0001B\u001c\u0003\u0019ygMZ:fi\u0006)\u0012MY8si\u0006sG\rU1vg\u0016\u001cE.Z1oS:<G\u0003BA\"\u0005sCa!a9 \u0001\u0004Q\u0018A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0007\u0012y\fC\u0004\u0003B\u0002\u0002\rAa1\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004Ba\u001aBcu&\u0019!q\u00195\u0003\u0011%#XM]1cY\u0016\fA\"Y<bSR\u001cE.Z1oK\u0012$\u0002\"!<\u0003N\n='\u0011\u001b\u0005\u0007\u0003G\f\u0003\u0019\u0001>\t\u000f\tM\u0016\u00051\u0001\u00038!I!1[\u0011\u0011\u0002\u0003\u0007!qG\u0001\n[\u0006Dx+Y5u\u001bN\fa#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$HeM\u000b\u0003\u00053TCAa\u000e\u0003\\.\u0012!Q\u001c\t\u0005\u0005?\u0014I/\u0004\u0002\u0003b*!!1\u001dBs\u0003%)hn\u00195fG.,GMC\u0002\u0003h&\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YO!9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"A!=\u0011\u000b\u001d\u0014)Ma=\u0011\r!\u0013)P_A\u0006\u0013\r\u001190\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u00031\u0019G.Z1oKJ\u001cu.\u001e8u\u0003)aunZ\"mK\u0006tWM\u001d\t\u0003Cf\u001a\"!O$\u0015\u0005\t}\u0018!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0007\u0013\u0001Ra\u001aB5\u0003;\u000baCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\u000eG2,\u0017M\\3s\u0007>tg-[4\u0015\u0007\u0001\u001c\t\u0002C\u0004\u0002<u\u0002\rA!\u001e\u0002/\r\u0014X-\u0019;f\u001d\u0016<8\t\\3b]\u0016$7+Z4nK:$HCBB\f\u0007;\u0019y\u0002E\u0002b\u00073I1aa\u0007B\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0007\u0005z\u0002\r!a\u0003\t\u000f\r\u0005b\b1\u0001\u00038\u0005Q!-Y:f\u001f\u001a47/\u001a;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u00199C\u000b\u0003\u0002\"\tm\u0007")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static LogSegment createNewCleanedSegment(Log log, long baseOffset) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, baseOffset);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)0.0, (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$maxOverCleanerThreads$1(maxOverCleanerThreads_f, BoxesRunTime.unboxToDouble((Object)max), thread))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        int n = 0;
        int until$extension_end = this.kafka$log$LogCleaner$$config().numThreads();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleaner.$anonfun$startup$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = Math.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        ArrayBuffer<CleanerThread> arrayBuffer = this.cleaners();
        if (arrayBuffer == null) {
            throw null;
        }
        return SeqOps.size$(arrayBuffer);
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        double max_y = BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread));
        return Math.max(max, max_y);
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)0.0, (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$maxOverCleanerThreads$1(maxOverCleanerThreads_f, BoxesRunTime.unboxToDouble((Object)max), thread)))) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)Math.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)0.0, (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$maxOverCleanerThreads$1(maxOverCleanerThreads_f, BoxesRunTime.unboxToDouble((Object)max), thread))));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)0.0, (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$maxOverCleanerThreads$1(maxOverCleanerThreads_f, BoxesRunTime.unboxToDouble((Object)max), thread)))) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$startup$2(LogCleaner $this, int i) {
        CleanerThread cleaner = $this.new CleanerThread(i);
        ArrayBuffer<CleanerThread> arrayBuffer = $this.cleaners();
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)cleaner);
        cleaner.start();
    }

    public static final /* synthetic */ boolean $anonfun$awaitCleaned$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$awaitCleaned$2(long offset$1, long x$9) {
        return x$9 >= offset$1;
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        Option option = this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1);
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        if (fold_this.isEmpty()) {
            return false;
        }
        long l = BoxesRunTime.unboxToLong((Object)fold_this.get());
        return LogCleaner.$anonfun$awaitCleaned$2(offset$1, l);
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
                return;
            }
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else if (option instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)option).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(option);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id, name, from, to}))).append(StringOps$.MODULE$.format$extension("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)stats.bytesRead() / (double)0x100000, stats.elapsedSecs(), (double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000}))).append(StringOps$.MODULE$.format$extension("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)stats.mapBytesRead() / (double)0x100000, stats.elapsedIndexSecs(), (double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs(), (double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()}))).append(StringOps$.MODULE$.format$extension("\tBuffer utilization: %.1f%%%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)100 * stats.bufferUtilization()}))).append(StringOps$.MODULE$.format$extension("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)stats.bytesRead() / (double)0x100000, stats.elapsedSecs() - stats.elapsedIndexSecs(), (double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()), (double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()}))).append(StringOps$.MODULE$.format$extension("\tStart size: %,.1f MB (%,d messages)%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)stats.bytesRead() / (double)0x100000, stats.messagesRead()}))).append(StringOps$.MODULE$.format$extension("\tEnd size: %,.1f MB (%,d messages)%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)stats.bytesWritten() / (double)0x100000, stats.messagesWritten()}))).append(StringOps$.MODULE$.format$extension("\t%.1f%% size reduction (%.1f%% fewer messages)%n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()), 100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.lastPreCleanStats().cleanablePartitions(), this.lastPreCleanStats().delayedPartitions(), this.lastPreCleanStats().maxCompactionDelayMs()})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("\tFound %d invalid messages during compaction.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stats.invalidMessagesRead()})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                Log log = (Log)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)Math.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

