/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t}t!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003ad\u0001B\u0019)\u0001yB\u0001\"\u0015\u0003\u0003\u0002\u0003\u0006IA\u0015\u0005\t1\u0012\u0011\t\u0011)A\u00053\"AA\f\u0002B\u0001B\u0003%Q\f\u0003\u0005i\t\t\u0005\t\u0015!\u0003j\u0011!aGA!A!\u0002\u0013i\u0007\"B\u001d\u0005\t\u0003\u0019\bbB=\u0005\u0005\u0004%IA\u001f\u0005\b\u0003\u0007!\u0001\u0015!\u0003|\u0011%\t)\u0001\u0002b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002&\u0011\u0001\u000b\u0011BA\u0005\u0011%\t9\u0003\u0002b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002,\u0011\u0001\u000b\u0011BA\u0010\u0011%\ti\u0003\u0002b\u0001\n\u0013\ty\u0003\u0003\u0005\u0002J\u0011\u0001\u000b\u0011BA\u0019\u0011%\tY\u0005\u0002b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002l\u0011\u0001\u000b\u0011BA(\u0011%\ti\u0007\u0002b\u0001\n\u0003\ny\u0007\u0003\u0005\u0002r\u0011\u0001\u000b\u0011BA\r\u0011\u001d\t\u0019\b\u0002C!\u0003kBq!a$\u0005\t\u0003\n\t\n\u0003\u0005\u0002\u001a\u0012!\t\u0001KAN\u0011!\t9\u000b\u0002C\u0001Q\u0005%\u0002\u0002CAU\t\u0011\u0005\u0001&a+\t\u000f\u0005\u001dG\u0001\"\u0001\u0002\u0012\"A\u0011\u0011\u001a\u0003\u0005\u0002!\n)\bC\u0004\u0002L\u0012!I!!4\t\u000f\u0005MG\u0001\"\u0001\u0002V\"9\u0011q \u0003\u0005\u0002\u0005=\u0004b\u0002B\u0001\t\u0011%!1\u0001\u0005\b\u0005\u001b!A\u0011\u0001B\b\u0011\u001d\u0011)\u0002\u0002C\u0005\u0005/AqA!\b\u0005\t\u0003\u0011y\u0002C\u0004\u0003T\u0011!\tA!\u0016\t\u000f\tmC\u0001\"\u0001\u0003^\u0005yBK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u000b\u0005%R\u0013a\u0003;sC:\u001c\u0018m\u0019;j_:T!a\u000b\u0017\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002[\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0019\u0002\u001b\u0005A#a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011a\r\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0013!B1qa2LH#D\u001f\u0003b\t\r$q\u000eB9\u0005g\u0012)\b\u0005\u00021\tM!AaP#L!\t\u00015)D\u0001B\u0015\t\u0011E&\u0001\u0004d_6lwN\\\u0005\u0003\t\u0006\u0013Q#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\r\u0005\u0002G\u00136\tqI\u0003\u0002IY\u0005)Q\u000f^5mg&\u0011!j\u0012\u0002\b\u0019><w-\u001b8h!\tau*D\u0001N\u0015\tqE&A\u0004nKR\u0014\u0018nY:\n\u0005Ak%!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u000611m\u001c8gS\u001e\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u0017\u0002\rM,'O^3s\u0013\t9FKA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002T5&\u00111\f\u0016\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u!\tqf-D\u0001`\u0015\t\u0001\u0017-A\u0004dY&,g\u000e^:\u000b\u00055\u0012'BA2e\u0003\u0019\t\u0007/Y2iK*\tQ-A\u0002pe\u001eL!aZ0\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014\bC\u0001\u0019k\u0013\tY\u0007FA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u0006!A/[7f!\tq\u0017/D\u0001p\u0015\tA\u0005O\u0003\u0002CC&\u0011!o\u001c\u0002\u0005)&lW\r\u0006\u0004>iV4x\u000f\u001f\u0005\u0006#*\u0001\rA\u0015\u0005\u00061*\u0001\r!\u0017\u0005\u00069*\u0001\r!\u0018\u0005\u0006Q*\u0001\r!\u001b\u0005\u0006Y*\u0001\r!\\\u0001\u0018S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016,\u0012a\u001f\t\u0003y~l\u0011! \u0006\u0003}B\fqA\\3uo>\u00148.C\u0002\u0002\u0002u\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\f\u0001$\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3!\u0003Ui\u0017M]6feN\fV/Z;f!\u0016\u0014(I]8lKJ,\"!!\u0003\u0011\u0011\u0005-\u0011QCA\r\u0003?i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u000bG>t7-\u001e:sK:$(bAA\nk\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\u0004\u001b\u0006\u0004\bc\u0001\u001b\u0002\u001c%\u0019\u0011QD\u001b\u0003\u0007%sG\u000fE\u00021\u0003CI1!a\t)\u00059!\u0006P\\'be.,'/U;fk\u0016\fa#\\1sW\u0016\u00148/U;fk\u0016\u0004VM\u001d\"s_.,'\u000fI\u0001\u001d[\u0006\u00148.\u001a:t#V,W/\u001a$peVs7N\\8x]\n\u0013xn[3s+\t\ty\"A\u000fnCJ\\WM]:Rk\u0016,XMR8s+:\\gn\\<o\u0005J|7.\u001a:!\u0003Y!\bP\u001c'pO\u0006\u0003\b/\u001a8e%\u0016$(/_)vKV,WCAA\u0019!\u0019\t\u0019$a\u0010\u0002D5\u0011\u0011Q\u0007\u0006\u0005\u0003\u001f\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001B;uS2T!!!\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0003\n)DA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\rE\u00021\u0003\u000bJ1!a\u0012)\u0005I\u0001VM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8\u0002/QDh\u000eT8h\u0003B\u0004XM\u001c3SKR\u0014\u00180U;fk\u0016\u0004\u0013A\b;sC:\u001c\u0018m\u0019;j_:\u001cx+\u001b;i!\u0016tG-\u001b8h\u001b\u0006\u00148.\u001a:t+\t\ty\u0005\u0005\u0005\u00024\u0005E\u0013QKA\"\u0013\u0011\t\u0019&!\u000e\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002X\u0005\u0015d\u0002BA-\u0003C\u00022!a\u00176\u001b\t\tiFC\u0002\u0002`9\na\u0001\u0010:p_Rt\u0014bAA2k\u00051\u0001K]3eK\u001aLA!a\u001a\u0002j\t11\u000b\u001e:j]\u001eT1!a\u00196\u0003}!(/\u00198tC\u000e$\u0018n\u001c8t/&$\b\u000eU3oI&tw-T1sW\u0016\u00148\u000fI\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN,\"!!\u0007\u0002#I,\u0017/^3tiRKW.Z8vi6\u001b\b%\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011q\u000f\t\u0007\u0003s\n\u0019)!#\u000f\t\u0005m\u0014q\u0010\b\u0005\u00037\ni(C\u00017\u0013\r\t\t)N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t))a\"\u0003\u0011%#XM]1cY\u0016T1!!!6!\r\u0001\u00151R\u0005\u0004\u0003\u001b\u000b%a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/\u0001\u0005tQV$Hm\\<o)\t\t\u0019\nE\u00025\u0003+K1!a&6\u0005\u0011)f.\u001b;\u0002\u001dE,X-^3G_J\u0014%o\\6feR!\u0011QTAR!\u0015!\u0014qTA\u0010\u0013\r\t\t+\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015\u0016\u00041\u0001\u0002\u001a\u0005A!M]8lKJLE-A\u000brk\u0016,XMR8s+:\\gn\\<o\u0005J|7.\u001a:\u0002'\u0005$G-T1sW\u0016\u00148OR8s\u0005J|7.\u001a:\u0015\u0011\u0005M\u0015QVA]\u0003{Cq!a,\u001c\u0001\u0004\t\t,\u0001\u0004ce>\\WM\u001d\t\u0005\u0003g\u000b),D\u0001q\u0013\r\t9\f\u001d\u0002\u0005\u001d>$W\rC\u0004\u0002<n\u0001\r!!\u0007\u0002#QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002@n\u0001\r!!1\u0002\u001dQDh.\u00133B]\u0012l\u0015M]6feB\u0019\u0001'a1\n\u0007\u0005\u0015\u0007FA\nUq:LE-\u00118e\u001b\u0006\u00148.\u001a:F]R\u0014\u00180A\bsKR\u0014\u0018\u0010T8h\u0003B\u0004XM\u001c3t\u0003u!'/Y5o#V,W/\u001a3Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0018AE<sSR,G\u000b\u001f8D_6\u0004H.\u001a;j_:$B!a%\u0002P\"9\u0011\u0011\u001b\u0010A\u0002\u0005\r\u0013A\u00059f]\u0012LgnZ\"p[BdW\r^3Uq:\f1#\u00193e)btW*\u0019:lKJ\u001cHk\\*f]\u0012$\"\"a%\u0002X\u0006m\u00171^A{\u0011\u001d\tIn\ba\u0001\u00033\t\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\u0005uw\u00041\u0001\u0002`\u0006IA\u000f\u001f8SKN,H\u000e\u001e\t\u0005\u0003C\f9/\u0004\u0002\u0002d*\u0019\u0011Q\u001d9\u0002\u0011I,\u0017/^3tiNLA!!;\u0002d\n\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u00055x\u00041\u0001\u0002p\u0006YA\u000f\u001f8NKR\fG-\u0019;b!\r\u0001\u0014\u0011_\u0005\u0004\u0003gD#a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007bBA|?\u0001\u0007\u0011\u0011`\u0001\f]\u0016<X*\u001a;bI\u0006$\u0018\rE\u00021\u0003wL1!!@)\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u000239,X\u000e\u0016=og^KG\u000f\u001b)f]\u0012LgnZ'be.,'o]\u0001\u0019Q\u0006\u001c\b+\u001a8eS:<W*\u0019:lKJ\u001cHk\\,sSR,G\u0003\u0002B\u0003\u0005\u0017\u00012\u0001\u000eB\u0004\u0013\r\u0011I!\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\ti/\ta\u0001\u0003_\fq#\\1zE\u0016<&/\u001b;f)bt7i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005M%\u0011\u0003\u0005\b\u0005'\u0011\u0003\u0019AA+\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017A\u0004;ss\u0006\u0003\b/\u001a8e)>dun\u001a\u000b\u0005\u0003'\u0013I\u0002C\u0004\u0003\u001c\r\u0002\r!a\u0011\u0002\u0019QDh\u000eT8h\u0003B\u0004XM\u001c3\u00025\u0005$G\r\u0016=o\u001b\u0006\u00148.\u001a:t)>\u0014%o\\6feF+X-^3\u0015\u001d\u0005M%\u0011\u0005B\u0012\u0005[\u00119Da\u000f\u0003>!9!1\u0003\u0013A\u0002\u0005U\u0003b\u0002B\u0013I\u0001\u0007!qE\u0001\u000baJ|G-^2fe&#\u0007c\u0001\u001b\u0003*%\u0019!1F\u001b\u0003\t1{gn\u001a\u0005\b\u0005_!\u0003\u0019\u0001B\u0019\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019AGa\r\n\u0007\tURGA\u0003TQ>\u0014H\u000fC\u0004\u0003:\u0011\u0002\r!a8\u0002\rI,7/\u001e7u\u0011\u001d\tI\u000e\na\u0001\u00033AqAa\u0010%\u0001\u0004\u0011\t%A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011\u0019E!\u0013\u0003N5\u0011!Q\t\u0006\u0005\u0005\u000f\n\t\"A\u0005j[6,H/\u00192mK&!!1\nB#\u0005\r\u0019V\r\u001e\t\u0005\u0003g\u0013y%C\u0002\u0003RA\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0011sK6|g/Z'be.,'o\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002\u0014\n]\u0003b\u0002B-K\u0001\u0007\u0011\u0011D\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\nZ\u0001\u0016e\u0016lwN^3NCJ\\WM]:G_J$\u0006P\\%e)\u0011\t\u0019Ja\u0018\t\u000f\tMa\u00051\u0001\u0002V!)\u0011k\u0001a\u0001%\"1aj\u0001a\u0001\u0005K\u0002BAa\u001a\u0003l5\u0011!\u0011\u000e\u0006\u0003\u001dBLAA!\u001c\u0003j\t9Q*\u001a;sS\u000e\u001c\b\"\u0002-\u0004\u0001\u0004I\u0006\"\u00025\u0004\u0001\u0004I\u0007\"\u00027\u0004\u0001\u0004i\u0007b\u0002B<\u0007\u0001\u0007!\u0011P\u0001\u000bY><7i\u001c8uKb$\bc\u00018\u0003|%\u0019!QP8\u0003\u00151{wmQ8oi\u0016DH\u000f")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements KafkaMetricsGroup {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private final int requestTimeoutMs;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    @Override
    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        return this.drainQueuedTransactionMarkers();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.markersQueuePerBroker().clear();
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)brokerId);
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    /*
     * WARNING - void declaration
     */
    public void addMarkersForBroker(Node broker, int txnTopicPartition, TxnIdAndMarkerEntry txnIdAndMarker) {
        Object var10_9;
        Object object;
        void atomicGetOrUpdate_key;
        int brokerId = broker.id();
        Integer n = brokerId;
        scala.collection.concurrent.Map<Object, TxnMarkerQueue> atomicGetOrUpdate_map = this.markersQueuePerBroker();
        Option option = atomicGetOrUpdate_map.get((Object)atomicGetOrUpdate_key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnMarkerQueue atomicGetOrUpdate_value = new TxnMarkerQueue(broker);
            Option option2 = atomicGetOrUpdate_map.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value);
            if (option2 == null) {
                throw null;
            }
            Option atomicGetOrUpdate_getOrElse_this = option2;
            object = atomicGetOrUpdate_getOrElse_this.isEmpty() ? atomicGetOrUpdate_value : atomicGetOrUpdate_getOrElse_this.get();
            var10_9 = null;
        } else {
            throw new MatchError((Object)option);
        }
        Object var6_6 = null;
        n = null;
        option = null;
        Object var9_8 = null;
        var10_9 = null;
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)object;
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, txnIdAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Added marker ").append(txnIdAndMarker.txnMarkerEntry()).append(" for transactional id ").append(txnIdAndMarker.txnId()).append(" to destination broker ").append(brokerId).toString());
    }

    public void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Retry appending ").append(txnLogAppend).append(" transaction log").toString());
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    public Iterable<RequestAndCompletionHandler> drainQueuedTransactionMarkers() {
        this.retryLogAppends();
        ArrayList txnIdAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(txnIdAndMarkerEntries)));
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, txnIdAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$2(check$ifrefutable$1))).foreach((Function1 & Serializable)txnIdAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$3(this, txnIdAndMarker);
            return BoxedUnit.UNIT;
        });
        return (Iterable)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList txnIdAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(txnIdAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), txnIdAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$drainQueuedTransactionMarkers$6(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = AsJavaExtensions.BufferHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Buffer)((Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry()))).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                return new RequestAndCompletionHandler(node, (AbstractRequest.Builder<? extends AbstractRequest>)new WriteTxnMarkersRequest.Builder(markersToSend), requestCompletionHandler);
            }
            throw new MatchError(null);
        });
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Completed sending transaction markers for ").append(transactionalId).append("; begin transition ").append("to ").append(newMetadata.txnState()).toString());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("No longer the coordinator for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel appending ").append(newMetadata).append(" to transaction log").toString());
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("Loading the transaction partition that contains ").append(transactionalId).append(" while my ").append("current coordinator epoch is ").append(coordinatorEpoch).append("; so cancel appending ").append(newMetadata).append(" to ").append("transaction log since the loading process will continue the remaining work").toString());
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Sending ").append(transactionalId).append("'s transaction markers for ").append(txnMetadata).append(" with ").append("coordinator epoch ").append(coordinatorEpoch).append(" succeeded, trying to append complete transaction log now").toString());
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(178).append("The cached metadata ").append(txnMetadata).append(" has changed to ").append(epochAndMetadata).append(" after ").append("completed sending the markers with coordinator epoch ").append(coordinatorEpoch).append("; abort ").append("transiting the metadata to ").append(newMetadata).append(" as it may have been updated by another process").toString());
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", ").append("but there is no metadata in the cache; this is not expected").toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        this.addTxnMarkersToBrokerQueue(transactionalId, txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, coordinatorEpoch, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option option = Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            PendingCompleteTxn pendingCompleteTxn = (PendingCompleteTxn)foreach_this.get();
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return;
        }
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)));
    }

    public void addTxnMarkersToBrokerQueue(String transactionalId, long producerId, short producerEpoch, TransactionResult result, int coordinatorEpoch, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(transactionalId);
        topicPartitions.groupBy((Function1 & Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName())).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)topicPartitions.toList()).asJava());
                        TxnIdAndMarkerEntry txnIdAndMarker = new TxnIdAndMarkerEntry(transactionalId, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, txnIdAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, txnIdAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Encountered ").append(error).append(" trying to fetch transaction metadata for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel sending markers to its partition leaders").toString());
                            return this.transactionsWithPendingMarkers().remove(transactionalId);
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(144).append("The cached metadata has changed to ").append(epochAndMetadata).append(" (old coordinator epoch is ").append(coordinatorEpoch).append(") since preparing to send markers; cancel sending markers to its partition leaders").toString());
                                    return this.transactionsWithPendingMarkers().remove(transactionalId);
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(161).append("Couldn't find leader endpoint for partitions ").append(topicPartitions).append(" while trying to send transaction markers for ").append(transactionalId).append(", these partitions are likely deleted already and hence can be skipped").toString());
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        Option<BlockingQueue<TxnIdAndMarkerEntry>> option = this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        if (option == null) {
            throw null;
        }
        Option<BlockingQueue<TxnIdAndMarkerEntry>> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            BlockingQueue blockingQueue = (BlockingQueue)foreach_this.get();
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, blockingQueue);
        }
        Object var2_2 = null;
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxnId(String transactionalId) {
        this.transactionsWithPendingMarkers().remove(transactionalId);
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1() {
        return this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2() {
        return this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ TxnMarkerQueue $anonfun$addMarkersForBroker$1(Node broker$1) {
        return new TxnMarkerQueue(broker$1);
    }

    public static final /* synthetic */ boolean $anonfun$drainQueuedTransactionMarkers$2(TxnIdAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$drainQueuedTransactionMarkers$3(TransactionMarkerChannelManager $this, TxnIdAndMarkerEntry txnIdAndMarker) {
        String transactionalId = txnIdAndMarker.txnId();
        long producerId = txnIdAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = txnIdAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = txnIdAndMarker.txnMarkerEntry().transactionResult();
        int coordinatorEpoch = txnIdAndMarker.txnMarkerEntry().coordinatorEpoch();
        Set topicPartitions = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)txnIdAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(transactionalId, producerId, producerEpoch, txnResult, coordinatorEpoch, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$drainQueuedTransactionMarkers$6(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Completed transaction for ").append(txnLogAppend$2.transactionalId()).append(" with coordinator epoch ").append(txnLogAppend$2.coordinatorEpoch()).append(", final state after commit: ").append(txnLogAppend$2.txnMetadata().state()).toString());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("No longer the coordinator for transactionalId: ").append(txnLogAppend$2.transactionalId()).append(" while trying to append to transaction log, skip writing to transaction log").toString());
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Not available to append ").append(txnLogAppend$2).append(": possible causes include ").append(Errors.UNKNOWN_TOPIC_OR_PARTITION).append(", ").append(Errors.NOT_ENOUGH_REPLICAS).append(", ").append(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND).append(" and ").append(Errors.REQUEST_TIMED_OUT).append("; retry appending").toString());
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(149).append("Coordinator is loading the partition ").append($this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId())).append(" and hence cannot complete append of ").append(txnLogAppend$2).append("; ").append("skip writing to transaction log as the loading process should complete it").toString());
            return;
        }
        if (error != null) {
            String errorMsg = new StringBuilder(57).append("Unexpected error ").append(error.exceptionName()).append(" while appending to transaction log for ").append(txnLogAppend$2.transactionalId()).toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeMarkersForTxnTopicPartition$2(TxnIdAndMarkerEntry check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)queue).asScala().withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2(check$ifrefutable$3))).foreach((Function1 & Serializable)entry -> {
            $this.removeMarkersForTxnId(entry.txnId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeMarkersForTxnTopicPartition$6(TxnIdAndMarkerEntry check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)queue).asScala().withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6(check$ifrefutable$4))).foreach((Function1 & Serializable)entry -> {
            $this.removeMarkersForTxnId(entry.txnId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Option<BlockingQueue<TxnIdAndMarkerEntry>> option = ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1);
            if (option == null) {
                throw null;
            }
            Option<BlockingQueue<TxnIdAndMarkerEntry>> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                BlockingQueue blockingQueue = (BlockingQueue)foreach_this.get();
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, blockingQueue);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        super(new StringBuilder(22).append("TxnMarkerSenderThread-").append(config.brokerId()).toString(), networkClient, time, true);
        this.logIdent_$eq(new StringBuilder(39).append("[Transaction Marker Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = AsScalaExtensions.ConcurrentMapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.requestTimeoutMs = BoxesRunTime.unboxToInt((Object)config.requestTimeoutMs());
        this.newGauge("UnknownDestinationQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("LogAppendRetryQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public static final /* synthetic */ Object $anonfun$maybeWriteTxnCompletion$1$adapted(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1($this, transactionalId$2, pendingCompleteTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$removeMarkersForTxnTopicPartition$1$adapted(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1($this, queue);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$removeMarkersForTxnTopicPartition$5$adapted(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, queue);
        return BoxedUnit.UNIT;
    }
}

