/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.OptionException;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArraySeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConsumerGroupCommand$
implements Logging {
    public static final ConsumerGroupCommand$ MODULE$ = new ConsumerGroupCommand$();
    private static final String MISSING_COLUMN_VALUE = "-";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        try {
            void var6_5;
            opts.checkArgs();
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
            OptionSet optionSet = opts.options();
            .colon.colon count_this = new .colon.colon((Object)opts.listOpt(), (List)new .colon.colon((Object)opts.describeOpt(), (List)new .colon.colon((Object)opts.deleteOpt(), (List)new .colon.colon((Object)opts.resetOffsetsOpt(), (List)new .colon.colon((Object)opts.deleteOffsetsOpt(), (List)Nil$.MODULE$)))));
            int count_res = 0;
            for (OptionSpec optionSpec : count_this) {
                if (!optionSet.has(optionSpec)) continue;
                ++count_res;
            }
            Object var7_6 = null;
            Object var5_4 = null;
            if (var6_5 != true) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets");
            }
            this.run(opts);
            return;
        }
        catch (OptionException e) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), e.getMessage());
        }
    }

    public void run(ConsumerGroupCommand.ConsumerGroupCommandOptions opts) {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts, (Map<String, String>)((Map)Map$.MODULE$.empty()));){
            try {
                if (opts.options().has((OptionSpec)opts.listOpt())) {
                    consumerGroupService.listGroups();
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    consumerGroupService.describeGroups();
                } else if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    consumerGroupService.deleteGroups();
                } else if (opts.options().has((OptionSpec)opts.resetOffsetsOpt())) {
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options().has((OptionSpec)opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                        Console$.MODULE$.println((Object)exported);
                    } else {
                        this.printOffsetsToReset(offsetsToReset);
                    }
                } else if (opts.options().has((OptionSpec)opts.deleteOffsetsOpt())) {
                    consumerGroupService.deleteOffsets();
                }
            }
            catch (IllegalArgumentException e) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), e.getMessage());
            }
            catch (Throwable e) {
                this.printError(new StringBuilder(47).append("Executing consumer group command failed due to ").append(e.getMessage()).toString(), (Option<Throwable>)new Some((Object)e));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Set<ConsumerGroupState> consumerGroupStatesFromString(String input) {
        String[] map$extension_$this = StringOps$.MODULE$.split$extension(input, ',');
        int map$extension_len = map$extension_$this.length;
        Object[] map$extension_ys = new ConsumerGroupState[map$extension_len];
        if (map$extension_len > 0) {
            for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                ConsumerGroupState array_update_value = ConsumerGroupCommand$.$anonfun$consumerGroupStatesFromString$1(map$extension_$this[map$extension_i]);
                map$extension_ys[map$extension_i] = array_update_value;
                Object var19_6 = null;
            }
        }
        Object var7_2 = null;
        Object var9_4 = null;
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray(map$extension_ys);
        if (ofRef2 == null) {
            throw null;
        }
        Set parsedStates = IterableOnceOps.toSet$((IterableOnceOps)ofRef2);
        if (parsedStates.contains((Object)ConsumerGroupState.UNKNOWN)) {
            void mkString_end;
            void mkString_sep;
            Object object;
            ConsumerGroupState[] refArrayOps_xs = ConsumerGroupState.values();
            Object var4_8 = null;
            ConsumerGroupState[] filter$extension_$this = refArrayOps_xs;
            ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
            Class clazz = filter$extension_make_evidence$1.runtimeClass();
            Class<Byte> clazz2 = Byte.TYPE;
            if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofByte();
            } else {
                Class<Short> clazz3 = Short.TYPE;
                if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofShort();
                } else {
                    Class<Character> clazz4 = Character.TYPE;
                    if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofChar();
                    } else {
                        Class<Integer> clazz5 = Integer.TYPE;
                        if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofInt();
                        } else {
                            Class<Long> clazz6 = Long.TYPE;
                            if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofLong();
                            } else {
                                Class<Float> clazz7 = Float.TYPE;
                                if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofFloat();
                                } else {
                                    Class<Double> clazz8 = Double.TYPE;
                                    if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofDouble();
                                    } else {
                                        Class<Boolean> clazz9 = Boolean.TYPE;
                                        if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                            object = new ArrayBuilder.ofBoolean();
                                        } else {
                                            Class<Void> clazz10 = Void.TYPE;
                                            object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Object var15_10 = null;
            clazz = null;
            ArrayBuilder.ofByte filter$extension_res = object;
            for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
                ConsumerGroupState filter$extension_x = filter$extension_$this[filter$extension_i];
                if (!ConsumerGroupCommand$.$anonfun$consumerGroupStatesFromString$2(filter$extension_x)) continue;
                filter$extension_res.addOne((Object)filter$extension_x);
            }
            Object var11_9 = null;
            Object var12_12 = null;
            Object var14_14 = null;
            Object[] validStates = (ConsumerGroupState[])filter$extension_res.result();
            ArraySeq.ofRef ofRef3 = Predef$.MODULE$.wrapRefArray(validStates);
            String string = ", ";
            if (ofRef3 == null) {
                throw null;
            }
            ArraySeq.ofRef mkString_this = ofRef3;
            String string2 = "";
            String mkString_start = "";
            Object var17_19 = null;
            string2 = null;
            Object var5_17 = null;
            string = null;
            throw new IllegalArgumentException(new StringBuilder(41).append("Invalid state list '").append(input).append("'. Valid states are: ").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).toString());
        }
        return parsedStates;
    }

    public String MISSING_COLUMN_VALUE() {
        return MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        String println_x = new StringBuilder(8).append("\nError: ").append(msg).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var3_3 = null;
        if (e == null) {
            throw null;
        }
        if (!e.isEmpty()) {
            ((Throwable)e.get()).printStackTrace();
            return;
        }
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public Long convertTimestamp(String timeString) {
        Date date;
        switch (timeString == null ? 0 : timeString.hashCode()) {
            default: 
        }
        String datetime = timeString.split("T")[1].contains("+") || timeString.split("T")[1].contains("-") || timeString.split("T")[1].contains("Z") ? timeString.toString() : new StringBuilder(1).append(timeString).append("Z").toString();
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(datetime);
        }
        catch (ParseException parseException) {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(datetime);
        }
        return date.getTime();
    }

    public void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        if (groupAssignmentsToReset.nonEmpty()) {
            String println_x = StringOps$.MODULE$.format$extension("\n%-30s %-30s %-10s %-15s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"GROUP", "TOPIC", "PARTITION", "NEW-OFFSET"}));
            Console$.MODULE$.println((Object)println_x);
            Object var2_2 = null;
        }
        groupAssignmentsToReset.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$printOffsetsToReset$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ ConsumerGroupState $anonfun$consumerGroupStatesFromString$1(String s) {
        return ConsumerGroupState.parse((String)s.trim());
    }

    public static final /* synthetic */ boolean $anonfun$consumerGroupStatesFromString$2(ConsumerGroupState x$1) {
        ConsumerGroupState consumerGroupState = x$1;
        ConsumerGroupState consumerGroupState2 = ConsumerGroupState.UNKNOWN;
        return consumerGroupState == null ? consumerGroupState2 != null : !consumerGroupState.equals(consumerGroupState2);
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$4(String groupId$1, Tuple2 x$3) {
        if (x$3 != null) {
            TopicPartition consumerAssignment = (TopicPartition)x$3._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)x$3._2();
            String println_x = StringOps$.MODULE$.format$extension("%-30s %-30s %-10s %-15s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupId$1, consumerAssignment.topic(), consumerAssignment.partition(), offsetAndMetadata.offset()}));
            Console$.MODULE$.println((Object)println_x);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$2(Tuple2 x$4) {
        if (x$4 != null) {
            String groupId = (String)x$4._1();
            ((Map)x$4._2()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$printOffsetsToReset$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$3 -> {
                ConsumerGroupCommand$.$anonfun$printOffsetsToReset$4(groupId, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    private ConsumerGroupCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }

    public static final /* synthetic */ Object $anonfun$consumerGroupStatesFromString$2$adapted(ConsumerGroupState x$1) {
        return BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$consumerGroupStatesFromString$2(x$1));
    }

    public static final /* synthetic */ Object $anonfun$printError$1$adapted(Throwable x$2) {
        x$2.printStackTrace();
        return BoxedUnit.UNIT;
    }
}

