/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$QuotaConfigs$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements kafka.common.Config {
    public static final ConfigCommand$ MODULE$ = new ConfigCommand$();
    private static final String BrokerDefaultEntityName = "";
    private static final String BrokerLoggerConfigType = "broker-loggers";
    private static final Seq<String> BrokerSupportedConfigTypes = (Seq)ConfigType$.MODULE$.all().appended((Object)MODULE$.BrokerLoggerConfigType());
    private static final Seq<String> ZkSupportedConfigTypes = ConfigType$.MODULE$.all();
    private static final int DefaultScramIterations = 4096;
    private static final Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public void validateChars(String prop, String value) {
        kafka.common.Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String BrokerDefaultEntityName() {
        return BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return BrokerSupportedConfigTypes;
    }

    public Seq<String> ZkSupportedConfigTypes() {
        return ZkSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user or broker");
            opts.checkArgs();
            if (!opts.options().has(opts.zkConnectOpt())) {
                this.processCommand(opts);
                return;
            }
            String println_x = "Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.";
            Console$.MODULE$.println((Object)println_x);
            Object var10_3 = null;
            String println_x2 = "Use --bootstrap-server instead to specify a broker to connect to.";
            Console$.MODULE$.println((Object)println_x2);
            Object var11_4 = null;
            this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    void mkString_end;
                    void mkString_sep;
                    ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])args);
                    String string = " ";
                    if (ofRef2 == null) {
                        throw null;
                    }
                    ArraySeq.ofRef mkString_this = ofRef2;
                    String string2 = "";
                    String mkString_start = "";
                    Object var12_9 = null;
                    string2 = null;
                    Object var4_7 = null;
                    string = null;
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            if (throwable != null) {
                void mkString_end;
                void mkString_sep;
                if (this.logger().underlying().isDebugEnabled()) {
                    void mkString_end2;
                    void mkString_sep2;
                    ArraySeq.ofRef ofRef3 = Predef$.MODULE$.wrapRefArray((Object[])args);
                    String string = " ";
                    if (ofRef3 == null) {
                        throw null;
                    }
                    ArraySeq.ofRef mkString_this = ofRef3;
                    String string3 = "";
                    String mkString_start = "";
                    Object var14_13 = null;
                    string3 = null;
                    Object var6_11 = null;
                    string = null;
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep2, (String)mkString_end2)).append("'").toString(), throwable);
                }
                ArraySeq.ofRef ofRef4 = Predef$.MODULE$.wrapRefArray((Object[])args);
                String string = " ";
                if (ofRef4 == null) {
                    throw null;
                }
                ArraySeq.ofRef mkString_this = ofRef4;
                String string4 = "";
                String mkString_start = "";
                Object var16_17 = null;
                string4 = null;
                Object var8_15 = null;
                string = null;
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            throw null;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        Option<ZKClientConfig> option = ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile());
        if (option == null) {
            throw null;
        }
        Option<ZKClientConfig> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? new ZKClientConfig() : getOrElse_this.get();
        Object var13_3 = null;
        Object zkClientConfig = object;
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled((ZKClientConfig)zkClientConfig);
        Time x$6 = Time.SYSTEM;
        Some x$7 = new Some(zkClientConfig);
        String x$8 = "kafka.server";
        String x$9 = "SessionExpireListener";
        None$ x$10 = None$.MODULE$;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, 30000, 30000, Integer.MAX_VALUE, x$6, x$8, x$9, (Option<String>)x$10, (Option<ZKClientConfig>)x$7);
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfigWithZk(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfigWithZk(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            Set dynamicBrokerConfigs;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && (dynamicBrokerConfigs = (Set)AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)configsToBeAdded).asScala().keySet().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$1(elem)))).nonEmpty()) {
                String string5 = entityName;
                String string6 = ConfigEntityName$.MODULE$.Default();
                boolean perBrokerConfig = string5 == null ? string6 != null : !string5.equals(string6);
                String errorMessage = new StringBuilder(70).append("--bootstrap-server option must be specified to update broker configs ").append(dynamicBrokerConfigs).append(".").toString();
                String info = "Broker configuration updates using ZooKeeper are supported for bootstrapping before brokers are started to enable encrypted password configs to be stored in ZooKeeper.";
                if (perBrokerConfig) {
                    Option<Object> option = adminZkClient.parseBroker(entityName);
                    if (option == null) {
                        throw null;
                    }
                    Option<Object> foreach_this = option;
                    if (!foreach_this.isEmpty()) {
                        int n = BoxesRunTime.unboxToInt((Object)foreach_this.get());
                        ConfigCommand$.$anonfun$alterConfigWithZk$2(zkClient, errorMessage, entityName, info, n);
                    }
                    Object var18_16 = null;
                } else if (!zkClient.getAllBrokersInCluster().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfigWithZk$4(errorMessage, info)).toString());
                }
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$1)));
        if (invalidConfigs.nonEmpty()) {
            String mkString_sep = ",";
            Object var19_20 = null;
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
        }
        new Implicits.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable)x$2 -> configs.remove(x$2));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        String println_x = new StringBuilder(39).append("Completed updating config for entity: ").append(entity).append(".").toString();
        Console$.MODULE$.println((Object)println_x);
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        for (ScramMechanism scramMechanism : ScramMechanism.values()) {
            ConfigCommand$.$anonfun$preProcessScramCredentials$1(this, configsToBeAdded, scramMechanism);
        }
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Password encoder secret not specified");
        });
        Option option = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? Defaults$.MODULE$.PasswordEncoderCipherAlgorithm() : getOrElse_this.get();
        Object var3_3 = null;
        Option option2 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp());
        if (option2 == null) {
            throw null;
        }
        Option map_this = option2;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$createPasswordEncoder$3((String)map_this.get()));
        Object var4_4 = null;
        None$ getOrElse_this2 = object2;
        Object var5_5 = null;
        Option option3 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp());
        if (option3 == null) {
            throw null;
        }
        Option map_this2 = option3;
        Object object3 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$createPasswordEncoder$5((String)map_this2.get()));
        Object var6_6 = null;
        None$ getOrElse_this3 = object3;
        Object var7_7 = null;
        return new PasswordEncoder(new Password(encoderSecret), (Option<String>)None$.MODULE$, (String)object, BoxesRunTime.unboxToInt((Object)(getOrElse_this2.isEmpty() ? Integer.valueOf(Defaults$.MODULE$.PasswordEncoderKeyLength()) : getOrElse_this2.get())), BoxesRunTime.unboxToInt((Object)(getOrElse_this3.isEmpty() ? Integer.valueOf(Defaults$.MODULE$.PasswordEncoderIterations()) : getOrElse_this3.get())));
    }

    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        new Implicits.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)configsToBeAdded).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
        if (!passwordEncoderConfigs.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = ConfigCommand$.$anonfun$preProcessBrokerConfigs$2(passwordEncoderConfigs);
                Object var6_4 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)passwordEncoderConfigs).asScala().keySet().foreach((Function1 & Serializable)x$1 -> configsToBeAdded.remove(x$1));
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)configsToBeAdded).asScala().keySet().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
        if (passwordConfigs.nonEmpty()) {
            if (!passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp())) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$preProcessBrokerConfigs$5(passwordConfigs)).toString());
            }
            PasswordEncoder passwordEncoder = this.createPasswordEncoder((Map<String, String>)AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)passwordEncoderConfigs).asScala());
            passwordConfigs.foreach((Function1 & Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        configEntity.getAllEntities(zkClient).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfigWithZk$1$adapted(kafka.zk.AdminZkClient boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = new Properties();
        if (opts.options().has(opts.addConfigFile())) {
            String file = (String)opts.options().valueOf(opts.addConfigFile());
            new Implicits.PropertiesOps(props).$plus$plus$eq(Utils.loadProps((String)file, null));
        }
        if (opts.options().has(opts.addConfig())) {
            boolean bl;
            String[][] configsToBeAdded;
            block8: {
                void map$extension_ct;
                String pattern = "(?=[^\\]]*(?:\\[|$))";
                ClassTag classTag = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class));
                String[] map$extension_$this = ((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder(1).append(",").append(pattern).toString());
                int map$extension_len = map$extension_$this.length;
                Object map$extension_ys = map$extension_ct.newArray(map$extension_len);
                if (map$extension_len > 0) {
                    for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                        String string = map$extension_$this[map$extension_i];
                        ScalaRunTime$.MODULE$.array_update(map$extension_ys, map$extension_i, (Object)string.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1));
                    }
                }
                Object var6_6 = null;
                classTag = null;
                Object var9_8 = null;
                configsToBeAdded = (String[][])map$extension_ys;
                for (int forall$extension_i = 0; forall$extension_i < configsToBeAdded.length; ++forall$extension_i) {
                    if (ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(configsToBeAdded[forall$extension_i])) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Invalid entity config: all configs to be added must be in the format \"key=val\".").toString());
            }
            for (String[] stringArray : configsToBeAdded) {
                props.setProperty(stringArray[0].trim(), stringArray[1].replaceAll("\\[?\\]?", "").trim());
            }
        }
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            String println_x = new StringBuilder(165).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString();
            Console$.MODULE$.println((Object)println_x);
        }
        return props;
    }

    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options().has(opts.deleteConfig())) {
            Buffer configsToBeDeleted = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)opts.options().valuesOf(opts.deleteConfig())).asScala().map((Function1 & Serializable)x$7 -> x$7.trim());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            return configsToBeDeleted;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        Admin adminClient = Admin.create((Properties)props);
        if (opts.options().has((OptionSpec)opts.alterOpt())) {
            List<String> list = opts.entityTypes();
            if (list == null) {
                throw null;
            }
            List<String> list2 = opts.entityNames();
            if (list2 == null) {
                throw null;
            }
            if (SeqOps.size$(list) != SeqOps.size$(list2)) {
                throw new IllegalArgumentException("An entity name must be specified for every entity type");
            }
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(adminClient, opts);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        String entityTypeHead = (String)entityTypes.head();
        String entityNameHead = (String)entityNames.head();
        scala.collection.mutable.Map configsToBeAddedMap = AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)this.parseConfigsToBeAdded(opts)).asScala();
        scala.collection.mutable.Map configsToBeAdded = (scala.collection.mutable.Map)configsToBeAddedMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            }
            throw new MatchError(null);
        });
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityTypeHead) : entityTypeHead != null)) {
            void $plus$plus_suffix;
            scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), entry))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                String mkString_sep = ",";
                Object var37_12 = null;
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
            }
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, entityNameHead);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
            IterableOps iterableOps = (IterableOps)configsToBeAdded.values().map((Function1 & Serializable)x$9 -> new AlterConfigOp(x$9, AlterConfigOp.OpType.SET));
            IterableOnce iterableOnce = (IterableOnce)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
            if (iterableOps == null) {
                throw null;
            }
            iterableOnce = null;
            Collection alterEntries = AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)((Iterable)iterableOps.concat((IterableOnce)$plus$plus_suffix))).asJavaCollection();
            Object[] objectArray = new Tuple2[1];
            Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)configResource);
            Object var39_17 = null;
            objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)alterEntries);
            Void cfr_ignored_0 = (Void)adminClient.incrementalAlterConfigs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityTypeHead) : entityTypeHead != null)) {
                scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), entry))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
                if (invalidConfigs.nonEmpty()) {
                    String mkString_sep = ",";
                    Object var40_20 = null;
                    throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
                }
                MapOps mapOps = (MapOps)oldConfig.$plus$plus((IterableOnce)configsToBeAdded);
                if (mapOps == null) {
                    throw null;
                }
                scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)mapOps.removedAll(configsToBeDeleted);
                scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$8(x$10)));
                if (sensitiveEntries.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
                }
                Config newConfig = new Config(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)newEntries).asJava().values());
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
                Object[] objectArray = new Tuple2[1];
                Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)configResource);
                Object var41_26 = null;
                objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)newConfig);
                Void cfr_ignored_1 = (Void)adminClient.alterConfigs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                String string3 = this.BrokerLoggerConfigType();
                if (!(string3 != null ? !string3.equals(entityTypeHead) : entityTypeHead != null)) {
                    void $plus$plus_suffix;
                    void $plus$plus_suffix2;
                    scala.collection.immutable.Seq validLoggers = (scala.collection.immutable.Seq)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, true, false).map((Function1 & Serializable)x$11 -> x$11.name());
                    IterableOps iterableOps = (IterableOps)configsToBeDeleted.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)));
                    IterableOnce iterableOnce = (IterableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)));
                    if (iterableOps == null) {
                        throw null;
                    }
                    iterableOnce = null;
                    Seq invalidBrokerLoggers = (Seq)iterableOps.concat((IterableOnce)$plus$plus_suffix2);
                    if (invalidBrokerLoggers.nonEmpty()) {
                        String mkString_sep = ",";
                        Object var43_30 = null;
                        throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString("", mkString_sep, "")).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityNameHead);
                    AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
                    IterableOps iterableOps2 = (IterableOps)configsToBeAdded.values().map((Function1 & Serializable)x$12 -> new AlterConfigOp(x$12, AlterConfigOp.OpType.SET));
                    IterableOnce iterableOnce2 = (IterableOnce)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
                    if (iterableOps2 == null) {
                        throw null;
                    }
                    iterableOnce2 = null;
                    Collection alterLogLevelEntries = AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)((Iterable)iterableOps2.concat((IterableOnce)$plus$plus_suffix))).asJavaCollection();
                    Object[] objectArray = new Tuple2[1];
                    Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)configResource);
                    Object var45_35 = null;
                    objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)alterLogLevelEntries);
                    Void cfr_ignored_2 = (Void)adminClient.incrementalAlterConfigs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                } else {
                    boolean bl;
                    String string4 = ConfigType$.MODULE$.User();
                    if (!(string4 != null ? !string4.equals(entityTypeHead) : entityTypeHead != null)) {
                        bl = true;
                    } else {
                        String string5 = ConfigType$.MODULE$.Client();
                        bl = !(string5 != null ? !string5.equals(entityTypeHead) : entityTypeHead != null);
                    }
                    if (bl) {
                        void $plus$plus_suffix;
                        Nil$ nil$;
                        Nil$ nil$2;
                        Iterable nonQuotaConfigsToAdd = (Iterable)configsToBeAdded.keys().filterNot((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(name)));
                        if (nonQuotaConfigsToAdd.nonEmpty()) {
                            throw new IllegalArgumentException(new StringBuilder(90).append("Only quota configs can be added for '").append(entityTypeHead).append("' using --bootstrap-server. Unexpected config names: ").append(nonQuotaConfigsToAdd).toString());
                        }
                        Seq nonQuotaConfigsToDelete = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(name)));
                        if (nonQuotaConfigsToDelete.nonEmpty()) {
                            throw new IllegalArgumentException(new StringBuilder(92).append("Only quota configs can be deleted for '").append(entityTypeHead).append("' using --bootstrap-server. Unexpected config names: ").append(nonQuotaConfigsToDelete).toString());
                        }
                        Map<String, Double> oldConfig = this.getClientQuotasConfig(adminClient, entityTypes, entityNames);
                        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
                        if (invalidConfigs.nonEmpty()) {
                            String mkString_sep = ",";
                            Object var46_40 = null;
                            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
                        }
                        if (entityTypes == Nil$.MODULE$) {
                            nil$2 = Nil$.MODULE$;
                        } else {
                            .colon.colon map_h;
                            .colon.colon map_t = map_h = new .colon.colon((Object)ConfigCommand$.$anonfun$alterConfig$17((String)entityTypes.head()), (List)Nil$.MODULE$);
                            for (List map_rest = (List)entityTypes.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                .colon.colon map_nx = new .colon.colon((Object)ConfigCommand$.$anonfun$alterConfig$17((String)map_rest.head()), (List)Nil$.MODULE$);
                                map_t.next_$eq((List)map_nx);
                                map_t = map_nx;
                            }
                            Statics.releaseFence();
                            nil$2 = map_h;
                        }
                        Object var49_41 = null;
                        Object var50_42 = null;
                        Object var51_43 = null;
                        Object var52_44 = null;
                        Nil$ alterEntityTypes = nil$2;
                        if (entityNames == Nil$.MODULE$) {
                            nil$ = Nil$.MODULE$;
                        } else {
                            .colon.colon map_h;
                            .colon.colon map_t = map_h = new .colon.colon((Object)ConfigCommand$.$anonfun$alterConfig$18((String)entityNames.head()), (List)Nil$.MODULE$);
                            for (List map_rest = (List)entityNames.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                .colon.colon map_nx = new .colon.colon((Object)ConfigCommand$.$anonfun$alterConfig$18((String)map_rest.head()), (List)Nil$.MODULE$);
                                map_t.next_$eq((List)map_nx);
                                map_t = map_nx;
                            }
                            Statics.releaseFence();
                            nil$ = map_h;
                        }
                        Object var53_46 = null;
                        Object var54_47 = null;
                        Object var55_48 = null;
                        Object var56_49 = null;
                        Nil$ alterEntityNames = nil$;
                        HashMap alterEntityMap = new HashMap();
                        List list = (List)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)alterEntityTypes, (IterableOnce)alterEntityNames);
                        if (list == null) {
                            throw null;
                        }
                        List foreach_these = list;
                        while (!foreach_these.isEmpty()) {
                            Tuple2 tuple2 = (Tuple2)foreach_these.head();
                            ConfigCommand$.$anonfun$alterConfig$19(alterEntityMap, tuple2);
                            foreach_these = (List)foreach_these.tail();
                        }
                        Object var47_52 = null;
                        ClientQuotaEntity entity = new ClientQuotaEntity(alterEntityMap);
                        AlterClientQuotasOptions alterOptions = new AlterClientQuotasOptions().validateOnly(false);
                        IterableOps iterableOps = (IterableOps)configsToBeAddedMap.map((Function1 & Serializable)x0$3 -> {
                            if (x0$3 != null) {
                                double d;
                                String key = (String)x0$3._1();
                                String value = (String)x0$3._2();
                                try {
                                    d = Double.parseDouble(value);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IllegalArgumentException(new StringBuilder(45).append("Cannot parse quota configuration value for ").append(key).append(": ").append(value).toString());
                                }
                                double doubleValue = d;
                                return new ClientQuotaAlteration.Op(key, Double.valueOf(doubleValue));
                            }
                            throw new MatchError(null);
                        });
                        IterableOnce iterableOnce = (IterableOnce)configsToBeDeleted.map((Function1 & Serializable)key -> new ClientQuotaAlteration.Op(key, null));
                        if (iterableOps == null) {
                            throw null;
                        }
                        iterableOnce = null;
                        Collection alterOps = AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)((Iterable)iterableOps.concat((IterableOnce)$plus$plus_suffix))).asJavaCollection();
                        Void cfr_ignored_3 = (Void)adminClient.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(entity, alterOps)), alterOptions).all().get(60L, TimeUnit.SECONDS);
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported entity type: ").append(entityTypeHead).toString());
                    }
                }
            }
        }
        if (!entityNameHead.isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(32).append("Completed updating config for ").append(StringOps$.MODULE$.dropRight$extension(entityTypeHead, 1)).append(" ").append(entityNameHead).append(".").toString());
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(54).append("Completed updating default config for ").append(entityTypeHead).append(" in the cluster.").toString());
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        boolean bl2;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        boolean describeAll = opts.options().has((OptionSpec)opts.allOpt());
        String string = (String)entityTypes.head();
        String string2 = ConfigType$.MODULE$.Topic();
        if (!(string2 != null ? !string2.equals(string) : string != null)) {
            bl2 = true;
        } else {
            String string3 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string) : string != null)) {
                bl2 = true;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                bl2 = !(string4 != null ? !string4.equals(string) : string != null);
            }
        }
        if (bl2) {
            this.describeResourceConfig(adminClient, (String)entityTypes.head(), (Option<String>)entityNames.headOption(), describeAll);
            return;
        }
        String string5 = ConfigType$.MODULE$.User();
        if (!(string5 != null ? !string5.equals(string) : string != null)) {
            bl = true;
        } else {
            String string6 = ConfigType$.MODULE$.Client();
            bl = !(string6 != null ? !string6.equals(string) : string != null);
        }
        if (bl) {
            this.describeClientQuotasConfig(adminClient, entityTypes, entityNames);
            return;
        }
        throw new MatchError((Object)string);
    }

    private void describeResourceConfig(Admin adminClient, String entityType, Option<String> entityName, boolean describeAll) {
        None$ none$;
        if (entityName == null) {
            throw null;
        }
        if (entityName.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string = (String)entityName.get();
            Some some = new Some((Object)new .colon.colon((Object)string, (List)Nil$.MODULE$));
            none$ = some;
        }
        None$ getOrElse_this = none$;
        Object var5_6 = null;
        ((scala.collection.immutable.Seq)(getOrElse_this.isEmpty() ? ConfigCommand$.$anonfun$describeResourceConfig$2(entityType, adminClient) : getOrElse_this.get())).foreach((Function1 & Serializable)entity -> {
            ConfigCommand$.$anonfun$describeResourceConfig$4(entityType, describeAll, adminClient, entity);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<ConfigEntry> getResourceConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        void var6_7;
        void var7_8;
        Some some;
        ConfigResource.Type type;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            if (!entityName.isEmpty()) {
                Topic.validate((String)entityName);
            }
            type = ConfigResource.Type.TOPIC;
            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG);
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                String string3 = this.BrokerDefaultEntityName();
                if (!(string3 != null ? !string3.equals(entityName) : entityName != null)) {
                    type = ConfigResource.Type.BROKER;
                    some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
                } else {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    type = ConfigResource.Type.BROKER;
                    some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG);
                }
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                    if (!entityName.isEmpty()) {
                        ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    }
                    type = ConfigResource.Type.BROKER_LOGGER;
                    some = None$.MODULE$;
                } else {
                    throw new MatchError((Object)entityType);
                }
            }
        }
        Some some2 = some;
        ConfigResource.Type configResourceType = type;
        Option dynamicConfigSource = (Option)some2;
        None$ configSourceFilter = describeAll ? None$.MODULE$ : var7_8;
        ConfigResource configResource = new ConfigResource((ConfigResource.Type)var6_7, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return ((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((Config)configs.get(configResource)).entries()).asScala().filter(arg_0 -> ConfigCommand$.$anonfun$getResourceConfig$1$adapted((Option)configSourceFilter, arg_0))).toSeq();
    }

    private void describeClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).foreach((Function1 & Serializable)x0$1 -> {
            ConfigCommand$.$anonfun$describeClientQuotasConfig$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Double> getClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        if (entityTypes == null) {
            throw null;
        }
        if (entityNames == null) {
            throw null;
        }
        if (SeqOps.size$(entityTypes) != SeqOps.size$(entityNames)) {
            throw new IllegalArgumentException("Exactly one entity name must be specified for every entity type");
        }
        Option option = this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).headOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$getClientQuotasConfig$1((Tuple2)map_this.get()));
        Object var4_4 = null;
        None$ getOrElse_this = object;
        return (Map)(getOrElse_this.isEmpty() ? (Map)Map$.MODULE$.empty() : getOrElse_this.get());
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> getAllClientQuotasConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        Nil$ nil$;
        Nil$ nil$2;
        Nil$ nil$3;
        if (entityTypes == null) {
            throw null;
        }
        if (entityTypes == Nil$.MODULE$) {
            nil$3 = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            String string = (String)entityTypes.head();
            .colon.colon map_t = map_h = new .colon.colon((Object)new Some((Object)string), (List)Nil$.MODULE$);
            for (List map_rest = (List)entityTypes.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                string = (String)map_rest.head();
                .colon.colon map_nx = new .colon.colon((Object)new Some((Object)string), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$3 = map_h;
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        if (entityNames == null) {
            throw null;
        }
        if (entityNames == Nil$.MODULE$) {
            nil$2 = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            String string = (String)entityNames.head();
            .colon.colon map_t = map_h = new .colon.colon((Object)new Some((Object)string), (List)Nil$.MODULE$);
            for (List map_rest = (List)entityNames.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                string = (String)map_rest.head();
                .colon.colon map_nx = new .colon.colon((Object)new Some((Object)string), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$2 = map_h;
        }
        Object var9_10 = null;
        Object var10_11 = null;
        Object var11_12 = null;
        Object var12_13 = null;
        List list = (List)nil$3.zipAll((Iterable)nil$2, (Object)None$.MODULE$, (Object)None$.MODULE$);
        if (list == null) {
            throw null;
        }
        List map_this = list;
        if (map_this == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)ConfigCommand$.$anonfun$getAllClientQuotasConfigs$3((Tuple2)map_this.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)ConfigCommand$.$anonfun$getAllClientQuotasConfigs$3((Tuple2)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Object var13_14 = null;
        Object var14_15 = null;
        Object var15_16 = null;
        Object var16_17 = null;
        Object var17_18 = null;
        Nil$ components = nil$;
        return AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)components).asJava())).entities().get(30L, TimeUnit.SECONDS))).asScala();
    }

    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        String string;
        List<String> entityNames;
        List<String> entityTypes;
        block3: {
            block2: {
                entityTypes = opts.entityTypes();
                entityNames = opts.entityNames();
                Object object = entityTypes.head();
                String string2 = ConfigType$.MODULE$.User();
                if (!(object == null ? string2 != null : !object.equals(string2))) break block2;
                Object object2 = entityTypes.head();
                String string3 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string3) : string3 != null) break block3;
            }
            return this.parseClientQuotaEntity(opts, entityTypes, entityNames);
        }
        Option option = entityNames.headOption();
        Option name = option instanceof Some && "".equals(string = (String)((Some)option).value()) ? new Some((Object)ConfigEntityName$.MODULE$.Default()) : option;
        return new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseClientQuotaEntity(ConfigCommand.ConfigCommandOptions opts, List<String> types, List<String> names) {
        if (opts.options().has((OptionSpec)opts.alterOpt())) {
            if (names == null) {
                throw null;
            }
            if (types == null) {
                throw null;
            }
            if (SeqOps.size$(names) != SeqOps.size$(types)) {
                throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
            }
        }
        if (types == null) {
            throw null;
        }
        if (SeqOps.size$(types) != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? types.reverse() : types;
        sortedNames = (reverse != false && names.length() == 2 ? names.reverse() : names).iterator();
        if (entityTypes == null) {
            throw null;
        }
        if (entityTypes == Nil$.MODULE$) {
            v2 = Nil$.MODULE$;
        } else {
            var14_8 = (String)entityTypes.head();
            map_t = map_h = new .colon.colon((Object)ConfigCommand$.$anonfun$parseClientQuotaEntity$1(sortedNames, var14_8), (List)Nil$.MODULE$);
            for (map_rest = (List)entityTypes.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                var14_8 = (String)map_rest.head();
                map_nx = new .colon.colon((Object)ConfigCommand$.$anonfun$parseClientQuotaEntity$1(sortedNames, var14_8), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            v2 = map_h;
        }
        var10_9 = null;
        var11_10 = null;
        var12_11 = null;
        var13_12 = null;
        entities = v2;
        v3 = (ConfigCommand.Entity)entities.head();
        if (SeqOps.size$((SeqOps)entities) > 1) {
            apply_n = 1;
            v4 = new Some(LinearSeqOps.apply$((LinearSeqOps)entities, (int)apply_n));
            v5 = v4;
        } else {
            v5 = None$.MODULE$;
        }
        return new ConfigCommand.ConfigEntity(v3, (Option<ConfigCommand.Entity>)v5);
    }

    public static final /* synthetic */ ZKClientConfig $anonfun$processCommandWithZk$1() {
        return new ZKClientConfig();
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$1(String elem) {
        return MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning().contains((Object)elem);
    }

    public static final /* synthetic */ String $anonfun$alterConfigWithZk$3(String errorMessage$1, String entityName$1, String info$1) {
        return new StringBuilder(26).append(errorMessage$1).append(" when broker ").append(entityName$1).append(" is running. ").append(info$1).toString();
    }

    public static final /* synthetic */ void $anonfun$alterConfigWithZk$2(KafkaZkClient zkClient$1, String errorMessage$1, String entityName$1, String info$1, int brokerId) {
        if (!zkClient$1.getBroker(brokerId).isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfigWithZk$3(errorMessage$1, entityName$1, info$1)).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$alterConfigWithZk$4(String errorMessage$1, String info$1) {
        return new StringBuilder(47).append(errorMessage$1).append(" for default cluster if any broker is running. ").append(info$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        void var6_8;
        void var7_9;
        String iterations;
        Option option;
        String augmentString_x = "(?:iterations=([0-9]*),)?password=(.*)";
        Object var8_3 = null;
        String r$extension_$this = augmentString_x;
        Object var9_4 = null;
        Regex pattern = new Regex(r$extension_$this, (scala.collection.immutable.Seq)Nil$.MODULE$);
        if (credentialStr != null && !(option = pattern.unapplySeq((CharSequence)credentialStr)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            iterations = (String)((LinearSeqOps)option.get()).apply(0);
            String password = (String)((LinearSeqOps)option.get()).apply(1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        int iterations2 = iterations != null ? Integer.parseInt(iterations) : this.DefaultScramIterations();
        if (var7_9 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append((int)var7_9).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        return ScramCredentialUtils.credentialToString((ScramCredential)new ScramFormatter(mechanism).generateCredential((String)var6_8, (int)var7_9));
    }

    public static final /* synthetic */ Object $anonfun$preProcessScramCredentials$1(ConfigCommand$ $this, Properties configsToBeAdded$1, ScramMechanism mechanism) {
        String string = configsToBeAdded$1.getProperty(mechanism.mechanismName());
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (string != null) break;
                return BoxedUnit.UNIT;
            }
        }
        return configsToBeAdded$1.setProperty(mechanism.mechanismName(), $this.scramCredential$1(mechanism, string));
    }

    public static final /* synthetic */ String $anonfun$createPasswordEncoder$2() {
        return Defaults$.MODULE$.PasswordEncoderCipherAlgorithm();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$3(String x$4) {
        return Integer.parseInt(x$4);
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$4() {
        return Defaults$.MODULE$.PasswordEncoderKeyLength();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$5(String x$5) {
        return Integer.parseInt(x$5);
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$6() {
        return Defaults$.MODULE$.PasswordEncoderIterations();
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((String)x0$1._1()).startsWith("password.encoder.");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$2(Properties passwordEncoderConfigs$1) {
        return new StringBuilder(101).append("Password encoder configs ").append(passwordEncoderConfigs$1.keySet()).append(" will be used for encrypting").append(" passwords, but will not be stored in ZooKeeper.").toString();
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$5(Set passwordConfigs$1) {
        return new StringBuilder(226).append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append(" must be specified to update ").append(passwordConfigs$1).append(".").append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$describeConfigWithZk$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
        if (!configs.isEmpty() || !describeAllUsers$1) {
            void mkString_sep;
            Object[] objectArray = new Object[2];
            objectArray[0] = entity;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)configs).asScala().map((Function1 & Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString());
            String string = ",";
            if (iterableOnceOps == null) {
                throw null;
            }
            string = null;
            objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep, "");
            String println_x = StringOps$.MODULE$.format$extension("Configs for %s are %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
            Console$.MODULE$.println((Object)println_x);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseConfigsToBeAdded$3() {
        return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$8(Tuple2 x$10) {
        return ((ConfigEntry)x$10._2()).value() == null;
    }

    public static final /* synthetic */ String $anonfun$alterConfig$17(String entType) {
        String string = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(entType) : entType != null)) {
            return "user";
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entType) : entType != null)) {
            return "client-id";
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected entity type: ").append(entType).toString());
    }

    public static final /* synthetic */ String $anonfun$alterConfig$18(String en) {
        if (!en.isEmpty()) {
            return en;
        }
        return null;
    }

    public static final /* synthetic */ String $anonfun$alterConfig$19(HashMap alterEntityMap$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            return alterEntityMap$1.put(k, v);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ List $anonfun$describeResourceConfig$1(String name) {
        return new .colon.colon((Object)name, (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$describeResourceConfig$2(String entityType$1, Admin adminClient$1) {
        boolean bl;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType$1) : entityType$1 != null)) {
            return AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Set)((java.util.Set)adminClient$1.listTopics(new ListTopicsOptions().listInternal(true)).names().get())).asScala().toSeq();
        }
        String string2 = ConfigType$.MODULE$.Broker();
        if (!(string2 != null ? !string2.equals(entityType$1) : entityType$1 != null)) {
            bl = true;
        } else {
            String string3 = MODULE$.BrokerLoggerConfigType();
            bl = !(string3 != null ? !string3.equals(entityType$1) : entityType$1 != null);
        }
        if (bl) {
            void $colon$plus_elem;
            scala.collection.immutable.Seq seq = ((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((Collection)adminClient$1.describeCluster(new DescribeClusterOptions()).nodes().get())).asScala().map((Function1 & Serializable)x$13 -> x$13.idString())).toSeq();
            String string4 = MODULE$.BrokerDefaultEntityName();
            if (seq == null) {
                throw null;
            }
            return (scala.collection.immutable.Seq)seq.appended((Object)$colon$plus_elem);
        }
        throw new MatchError((Object)entityType$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$describeResourceConfig$5(ConfigEntry entry) {
        void mkString_sep;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)entry.synonyms()).asScala().map((Function1 & Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString());
        String string = ", ";
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps mkString_this = iterableOnceOps;
        Object var2_2 = null;
        string = null;
        String synonyms = mkString_this.mkString("", (String)mkString_sep, "");
        String println_x = new StringBuilder(26).append("  ").append(entry.name()).append("=").append(entry.value()).append(" sensitive=").append(entry.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$4(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = MODULE$.BrokerDefaultEntityName();
        if (!(string != null ? !string.equals(entity) : entity != null)) {
            String println_x = new StringBuilder(40).append("Default configs for ").append(entityType$1).append(" in the cluster are:").toString();
            Console$.MODULE$.println((Object)println_x);
            Object var5_4 = null;
        } else {
            String configSourceStr = describeAll$1 ? "All" : "Dynamic";
            String println_x = new StringBuilder(19).append(configSourceStr).append(" configs for ").append(StringOps$.MODULE$.dropRight$extension(entityType$1, 1)).append(" ").append(entity).append(" are:").toString();
            Console$.MODULE$.println((Object)println_x);
            Object var6_6 = null;
        }
        MODULE$.getResourceConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1 & Serializable)entry -> {
            ConfigCommand$.$anonfun$describeResourceConfig$5(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$2, String entityType$2) {
        try {
            Integer.parseInt(entityName$2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(63).append("The entity name for ").append(entityType$2).append(" must be a valid integer broker id, found: ").append(entityName$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getResourceConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        if (configSourceFilter$1 instanceof Some) {
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)((Some)configSourceFilter$1).value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            return !(configSource2 != null ? !configSource2.equals(configSource) : configSource != null);
        }
        if (None$.MODULE$.equals(configSourceFilter$1)) {
            return true;
        }
        throw new MatchError((Object)configSourceFilter$1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ String $anonfun$describeClientQuotasConfig$2(String entityType$3, String name) {
        String string;
        block5: {
            switch (entityType$3 == null ? 0 : entityType$3.hashCode()) {
                case -1904137635: {
                    if (!"client-id".equals(entityType$3)) break;
                    string = "client-id";
                    break block5;
                }
                case 3599307: {
                    if (!"user".equals(entityType$3)) break;
                    string = "user-principal";
                    break block5;
                }
            }
            throw new MatchError((Object)entityType$3);
        }
        String typeStr = string;
        if (name != null) {
            return new StringBuilder(3).append(typeStr).append(" '").append(name).append("'").toString();
        }
        return new StringBuilder(12).append("the default ").append(typeStr).toString();
    }

    private static final Option entitySubstr$1(String entityType, scala.collection.mutable.Map entityEntries$1) {
        Option option = entityEntries$1.get((Object)entityType);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return None$.MODULE$;
        }
        String string = (String)map_this.get();
        return new Some((Object)ConfigCommand$.$anonfun$describeClientQuotasConfig$2(entityType, string));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$describeClientQuotasConfig$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            void mkString_sep;
            void mkString_sep2;
            void $plus$plus_suffix;
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map entries = (java.util.Map)x0$1._2();
            scala.collection.mutable.Map entityEntries = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)entity.entries()).asScala();
            Iterable iterable = Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("user", entityEntries));
            Option option = ConfigCommand$.entitySubstr$1("client-id", entityEntries);
            if (iterable == null) {
                throw null;
            }
            option = null;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)iterable.concat((IterableOnce)$plus$plus_suffix);
            String string = ", ";
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps mkString_this = iterableOnceOps;
            Object var7_6 = null;
            string = null;
            String entityStr = mkString_this.mkString("", (String)mkString_sep2, "");
            IterableOnceOps iterableOnceOps2 = (IterableOnceOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)entries).asScala().map((Function1 & Serializable)e -> new StringBuilder(1).append(e._1()).append("=").append(e._2()).toString());
            String string2 = ", ";
            if (iterableOnceOps2 == null) {
                throw null;
            }
            IterableOnceOps mkString_this2 = iterableOnceOps2;
            Object var9_9 = null;
            string2 = null;
            String entriesStr = mkString_this2.mkString("", (String)mkString_sep, "");
            String println_x = new StringBuilder(17).append("Configs for ").append(entityStr).append(" are ").append(entriesStr).toString();
            Console$.MODULE$.println((Object)println_x);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$getClientQuotasConfig$1(Tuple2 x$15) {
        return AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)x$15._2())).asScala();
    }

    public static final /* synthetic */ Map $anonfun$getClientQuotasConfig$2() {
        return (Map)Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Some $anonfun$getAllClientQuotasConfigs$1(String x$16) {
        return new Some((Object)x$16);
    }

    public static final /* synthetic */ Some $anonfun$getAllClientQuotasConfigs$2(String x$17) {
        return new Some((Object)x$17);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClientQuotaFilterComponent $anonfun$getAllClientQuotasConfigs$3(Tuple2 x0$1) {
        block8: {
            block10: {
                block9: {
                    if (x0$1 == null) break block8;
                    entityTypeOpt = (Option)x0$1._1();
                    entityNameOpt = (Option)x0$1._2();
                    var4_3 = false;
                    var5_4 = null;
                    if (!(entityTypeOpt instanceof Some)) break block9;
                    var4_3 = true;
                    var5_4 = (Some)entityTypeOpt;
                    var6_5 = (String)var5_4.value();
                    v0 = ConfigType$.MODULE$.User();
                    if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) break block9;
                    v1 = "user";
                    break block10;
                }
                if (!var4_3) ** GOTO lbl-1000
                var7_6 = (String)var5_4.value();
                v2 = ConfigType$.MODULE$.Client();
                if (!(v2 != null ? v2.equals(var7_6) == false : var7_6 != null)) {
                    v1 = "client-id";
                } else lbl-1000:
                // 2 sources

                {
                    if (var4_3) {
                        throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected entity type ").append(entityTypeOpt.get()).toString());
                    }
                    if (None$.MODULE$.equals(entityTypeOpt)) {
                        throw new IllegalArgumentException("More entity names specified than entity types");
                    }
                    throw new MatchError((Object)entityTypeOpt);
                }
            }
            entityType = v1;
            var8_8 = false;
            var9_9 = null;
            if (entityNameOpt instanceof Some) {
                var8_8 = true;
                var9_9 = (Some)entityNameOpt;
                var10_10 = (String)var9_9.value();
                if ("".equals(var10_10)) {
                    return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                }
            }
            if (var8_8) {
                name = (String)var9_9.value();
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name);
            }
            if (None$.MODULE$.equals(entityNameOpt)) {
                return ClientQuotaFilterComponent.ofEntityType((String)entityType);
            }
            throw new MatchError((Object)entityNameOpt);
        }
        throw new MatchError(null);
    }

    private static final String sanitizeName$1(String entityType, String name) {
        boolean bl;
        if (name.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        String string = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            bl = true;
        } else {
            String string2 = ConfigType$.MODULE$.Client();
            bl = !(string2 != null ? !string2.equals(entityType) : entityType != null);
        }
        if (bl) {
            return Sanitizer.sanitize((String)name);
        }
        throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseClientQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$3$adapted(String x$4) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3(x$4));
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$5$adapted(String x$5) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5(x$5));
    }

    public static final /* synthetic */ Object $anonfun$describeConfigWithZk$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfigWithZk$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$parseConfigsToBeAdded$2$adapted(String[] config) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config));
    }

    public static final /* synthetic */ Object $anonfun$getResourceConfig$1$adapted(Option configSourceFilter$1, ConfigEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$getResourceConfig$1(configSourceFilter$1, entry));
    }
}

