/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class AdminUtils$
implements Logging {
    public static final AdminUtils$ MODULE$ = new AdminUtils$();
    private static final Random rand = new Random();
    private static final String AdminClientId = "__admin_client";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Random rand() {
        return rand;
    }

    public String AdminClientId() {
        return AdminClientId;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (brokerMetadatas == null) {
            throw null;
        }
        if (replicationFactor > brokerMetadatas.length()) {
            throw new InvalidReplicationFactorException(new StringBuilder(53).append("Replication factor: ").append(replicationFactor).append(" larger than available brokers: ").append(brokerMetadatas.length()).append(".").toString());
        }
        if (brokerMetadatas.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$1(x$1)))) {
            return this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Seq<Object>)((Seq)brokerMetadatas.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()))), fixedStartIndex, startPartitionId);
        }
        if (brokerMetadatas.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$3(x$3)))) {
            throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
        }
        return this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray((ClassTag)ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        int n = Math.max(0, startPartitionId);
        int n2 = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        int n3 = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n3, nPartitions, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                if (n > 0 && n % brokerArray.length == 0) {
                    ++n2;
                }
                int $anonfun$assignReplicasToBrokersRackUnaware$1_firstReplicaIndex = (n + startIndex) % brokerArray.length;
                ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$1_replicaBuffer = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerArray[$anonfun$assignReplicasToBrokersRackUnaware$1_firstReplicaIndex]}));
                int n4 = 0;
                int $anonfun$assignReplicasToBrokersRackUnaware$1_until$extension_end = replicationFactor - 1;
                Range.Exclusive $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this = new Range.Exclusive(n4, $anonfun$assignReplicasToBrokersRackUnaware$1_until$extension_end, 1);
                if (!$anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.isEmpty()) {
                    int $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i = $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.start();
                    while (true) {
                        int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers = brokerArray.length;
                        int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift = 1 + (n2 + $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i) % ($anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers - 1);
                        Integer $anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem = brokerArray[($anonfun$assignReplicasToBrokersRackUnaware$1_firstReplicaIndex + $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift) % $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers];
                        Object var18_20 = null;
                        ArrayBuffer cfr_ignored_0 = (ArrayBuffer)$anonfun$assignReplicasToBrokersRackUnaware$1_replicaBuffer.addOne((Object)$anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem);
                        if ($anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i == $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.scala$collection$immutable$Range$$lastElement) break;
                        $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i += $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.step();
                    }
                }
                Object var15_17 = null;
                ret.put((Object)n, (Object)$anonfun$assignReplicasToBrokersRackUnaware$1_replicaBuffer);
                ++n;
                Object var13_15 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((IterableOnceOps)brokerMetadatas.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int id = x1.id();
                    Option<String> option = x1.rack();
                    if (option instanceof Some) {
                        String rack = (String)((Some)option).value();
                        Integer ArrowAssoc_self = id;
                        Object var7_6 = null;
                        Integer $minus$greater$extension_$this = ArrowAssoc_self;
                        return (B1)new Tuple2((Object)$minus$greater$extension_$this, (Object)rack);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                return x1 != null && x1.rack() instanceof Some;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        if (arrangedBrokerList == null) {
            throw null;
        }
        int numBrokers = arrangedBrokerList.length();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.length());
        int n = Math.max(0, startPartitionId);
        int n2 = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.length());
        int n3 = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n3, nPartitions, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                Object var26_28;
                Object var28_30;
                Integer n4;
                if (n > 0 && n % arrangedBrokerList.length() == 0) {
                    ++n2;
                }
                int $anonfun$assignReplicasToBrokersRackAware$1_firstReplicaIndex = (n + startIndex) % arrangedBrokerList.length();
                int $anonfun$assignReplicasToBrokersRackAware$1_leader = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply($anonfun$assignReplicasToBrokersRackAware$1_firstReplicaIndex));
                ArrayBuffer $anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$anonfun$assignReplicasToBrokersRackAware$1_leader}));
                Set $anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)brokerRackMap.apply((Object)$anonfun$assignReplicasToBrokersRackAware$1_leader)}));
                Set $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$anonfun$assignReplicasToBrokersRackAware$1_leader}));
                int n5 = 0;
                int n6 = 0;
                int $anonfun$assignReplicasToBrokersRackAware$1_until$extension_end = replicationFactor - 1;
                Range.Exclusive $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this = new Range.Exclusive(n6, $anonfun$assignReplicasToBrokersRackAware$1_until$extension_end, 1);
                if (!$anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.isEmpty()) {
                    int $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_i = $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.start();
                    while (true) {
                        boolean $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_done = false;
                        while (!$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_done) {
                            void $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_nBrokers;
                            int n7 = arrangedBrokerList.length();
                            int $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift = n2 * numRacks;
                            int $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift = 1 + ($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift + n5) % ($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_nBrokers - true);
                            int $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(($anonfun$assignReplicasToBrokersRackAware$1_firstReplicaIndex + $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift) % $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_nBrokers));
                            String $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_rack = (String)brokerRackMap.apply((Object)$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker);
                            if (!($anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas.contains((Object)$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_rack) && $anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas.size() != numRacks || $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas.contains((Object)$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker) && $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas.size() != numBrokers)) {
                                void $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem;
                                n4 = $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker;
                                if ($anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer == null) {
                                    throw null;
                                }
                                $anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer.addOne((Object)$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem);
                                n4 = null;
                                $anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas.addOne((Object)$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_rack);
                                Integer $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2 = $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker;
                                $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas.addOne((Object)$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2);
                                var28_30 = null;
                                $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_done = true;
                            }
                            ++n5;
                        }
                        var26_28 = null;
                        n4 = null;
                        var28_30 = null;
                        if ($anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_i == $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                        $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_i += $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.step();
                    }
                }
                Object var21_23 = null;
                ret.put((Object)n, (Object)$anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer);
                ++n;
                Object var17_19 = null;
                Object var18_20 = null;
                Object var19_21 = null;
                var26_28 = null;
                n4 = null;
                var28_30 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String rack = (String)x0$1._1();
                Seq brokers = (Seq)x0$1._2();
                return new Tuple2((Object)rack, (Object)brokers.iterator());
            }
            throw new MatchError(null);
        });
        String[] racks = (String[])ArrayOps$.MODULE$.sorted$extension((Object)((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (SeqOps.size$((SeqOps)result) < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            if (rackIterator.hasNext()) {
                Object $plus$eq_elem = rackIterator.next();
                result.addOne($plus$eq_elem);
                Object var7_7 = null;
            }
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((IterableOps)brokerRackMap.toSeq().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int id = x0$1._1$mcI$sp();
                String rack = (String)x0$1._2();
                return new Tuple2((Object)rack, (Object)id);
            }
            throw new MatchError(null);
        })).groupBy((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (String)x0$2._1();
            }
            throw new MatchError(null);
        }).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                String rack = (String)x0$3._1();
                scala.collection.immutable.Seq rackAndIdList = (scala.collection.immutable.Seq)x0$3._2();
                return new Tuple2((Object)rack, ((SeqOps)rackAndIdList.map((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$getInverseMap$4(x0$4)))).sorted((Ordering)Ordering.Int$.MODULE$));
            }
            throw new MatchError(null);
        });
    }

    private int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$1(BrokerMetadata x$1) {
        return x$1.rack().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$3(BrokerMetadata x$3) {
        return x$3.rack().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$2(ArrayBuffer replicaBuffer$1, int[] brokerArray$1, int firstReplicaIndex$1, IntRef nextReplicaShift$1, int j) {
        void replicaIndex_nBrokers;
        int n = brokerArray$1.length;
        int replicaIndex_secondReplicaShift = nextReplicaShift$1.elem;
        int replicaIndex_shift = 1 + (replicaIndex_secondReplicaShift + j) % (replicaIndex_nBrokers - true);
        Integer $plus$eq_elem = brokerArray$1[(firstReplicaIndex$1 + replicaIndex_shift) % replicaIndex_nBrokers];
        return (ArrayBuffer)replicaBuffer$1.addOne((Object)$plus$eq_elem);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assignReplicasToBrokersRackUnaware$1(IntRef currentPartitionId$1, int[] brokerArray$1, IntRef nextReplicaShift$1, int startIndex$1, int replicationFactor$1, scala.collection.mutable.Map ret$1, int x$4) {
        if (currentPartitionId$1.elem > 0 && currentPartitionId$1.elem % brokerArray$1.length == 0) {
            ++nextReplicaShift$1.elem;
        }
        int firstReplicaIndex = (currentPartitionId$1.elem + startIndex$1) % brokerArray$1.length;
        ArrayBuffer replicaBuffer = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerArray$1[firstReplicaIndex]}));
        int n = 0;
        int until$extension_end = replicationFactor$1 - 1;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                void $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers;
                int n2 = brokerArray$1.length;
                int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_secondReplicaShift = nextReplicaShift$1.elem;
                int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift = 1 + ($anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_secondReplicaShift + foreach_i) % ($anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers - true);
                Integer $anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem = brokerArray$1[(firstReplicaIndex + $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift) % $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers];
                Object var13_13 = null;
                ArrayBuffer cfr_ignored_0 = (ArrayBuffer)replicaBuffer.addOne((Object)$anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var10_11 = null;
        ret$1.put((Object)currentPartitionId$1.elem, (Object)replicaBuffer);
        ++currentPartitionId$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assignReplicasToBrokersRackAware$2(IndexedSeq arrangedBrokerList$1, int firstReplicaIndex$2, IntRef nextReplicaShift$2, int numRacks$1, IntRef k$1, scala.collection.immutable.Map brokerRackMap$1, Set racksWithReplicas$1, Set brokersWithReplicas$1, int numBrokers$1, ArrayBuffer replicaBuffer$2, int x$5) {
        boolean done = false;
        while (!done) {
            void replicaIndex_nBrokers;
            void replicaIndex_replicaIndex;
            int n = arrangedBrokerList$1.length();
            int n2 = k$1.elem;
            int replicaIndex_secondReplicaShift = nextReplicaShift$2.elem * numRacks$1;
            int replicaIndex_shift = 1 + (replicaIndex_secondReplicaShift + replicaIndex_replicaIndex) % (replicaIndex_nBrokers - true);
            int broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList$1.apply((firstReplicaIndex$2 + replicaIndex_shift) % replicaIndex_nBrokers));
            String rack = (String)brokerRackMap$1.apply((Object)broker);
            if (!(racksWithReplicas$1.contains((Object)rack) && racksWithReplicas$1.size() != numRacks$1 || brokersWithReplicas$1.contains((Object)broker) && brokersWithReplicas$1.size() != numBrokers$1)) {
                void $plus$eq_elem;
                Integer n3 = broker;
                if (replicaBuffer$2 == null) {
                    throw null;
                }
                replicaBuffer$2.addOne((Object)$plus$eq_elem);
                n3 = null;
                racksWithReplicas$1.addOne((Object)rack);
                Integer $plus$eq_elem2 = broker;
                brokersWithReplicas$1.addOne((Object)$plus$eq_elem2);
                Object var15_15 = null;
                done = true;
            }
            ++k$1.elem;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assignReplicasToBrokersRackAware$1(IntRef currentPartitionId$2, IndexedSeq arrangedBrokerList$1, IntRef nextReplicaShift$2, int startIndex$2, scala.collection.immutable.Map brokerRackMap$1, int replicationFactor$2, int numRacks$1, int numBrokers$1, scala.collection.mutable.Map ret$2, int x$6) {
        if (currentPartitionId$2.elem > 0) {
            if (arrangedBrokerList$1 == null) {
                throw null;
            }
            if (currentPartitionId$2.elem % arrangedBrokerList$1.length() == 0) {
                ++nextReplicaShift$2.elem;
            }
        }
        if (arrangedBrokerList$1 == null) {
            throw null;
        }
        int firstReplicaIndex = (currentPartitionId$2.elem + startIndex$2) % arrangedBrokerList$1.length();
        int leader = BoxesRunTime.unboxToInt((Object)arrangedBrokerList$1.apply(firstReplicaIndex));
        ArrayBuffer replicaBuffer = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
        Set racksWithReplicas = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)brokerRackMap$1.apply((Object)leader)}));
        Set brokersWithReplicas = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
        int n = 0;
        int n2 = 0;
        int until$extension_end = replicationFactor$2 - 1;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                Object var23_24;
                Integer n3;
                boolean $anonfun$assignReplicasToBrokersRackAware$2_done = false;
                while (!$anonfun$assignReplicasToBrokersRackAware$2_done) {
                    void $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_nBrokers;
                    int n4 = arrangedBrokerList$1.length();
                    int $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift = nextReplicaShift$2.elem * numRacks$1;
                    int $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift = 1 + ($anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift + n) % ($anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_nBrokers - true);
                    int $anonfun$assignReplicasToBrokersRackAware$2_broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList$1.apply((firstReplicaIndex + $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift) % $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_nBrokers));
                    String $anonfun$assignReplicasToBrokersRackAware$2_rack = (String)brokerRackMap$1.apply((Object)$anonfun$assignReplicasToBrokersRackAware$2_broker);
                    if (!(racksWithReplicas.contains((Object)$anonfun$assignReplicasToBrokersRackAware$2_rack) && racksWithReplicas.size() != numRacks$1 || brokersWithReplicas.contains((Object)$anonfun$assignReplicasToBrokersRackAware$2_broker) && brokersWithReplicas.size() != numBrokers$1)) {
                        void $anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem;
                        n3 = $anonfun$assignReplicasToBrokersRackAware$2_broker;
                        if (replicaBuffer == null) {
                            throw null;
                        }
                        replicaBuffer.addOne((Object)$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem);
                        n3 = null;
                        racksWithReplicas.addOne((Object)$anonfun$assignReplicasToBrokersRackAware$2_rack);
                        Integer $anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2 = $anonfun$assignReplicasToBrokersRackAware$2_broker;
                        brokersWithReplicas.addOne((Object)$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2);
                        var23_24 = null;
                        $anonfun$assignReplicasToBrokersRackAware$2_done = true;
                    }
                    ++n;
                }
                Object var21_22 = null;
                n3 = null;
                var23_24 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var16_18 = null;
        ret$2.put((Object)currentPartitionId$2.elem, (Object)replicaBuffer);
        ++currentPartitionId$2.elem;
    }

    public static final /* synthetic */ int $anonfun$getInverseMap$4(Tuple2 x0$4) {
        if (x0$4 != null) {
            return x0$4._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    private AdminUtils$() {
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$2$adapted(ArrayBuffer replicaBuffer$1, int[] brokerArray$1, int firstReplicaIndex$1, IntRef nextReplicaShift$1, Object j) {
        return AdminUtils$.$anonfun$assignReplicasToBrokersRackUnaware$2(replicaBuffer$1, brokerArray$1, firstReplicaIndex$1, nextReplicaShift$1, BoxesRunTime.unboxToInt((Object)j));
    }
}

