/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.coordinator.transaction.generated;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;

public class CoordinatorRecordJsonConverters {
    public static JsonNode writeRecordKeyAsJson(ApiMessage key) {
        switch (key.apiKey()) {
            case 0:
                return TransactionLogKeyJsonConverter.write((TransactionLogKey) key, (short) 0);
            default:
                throw new UnsupportedVersionException("Unknown record id " + key.apiKey());
        }
    }
    
    public static JsonNode writeRecordValueAsJson(ApiMessage value, short version) {
        switch (value.apiKey()) {
            case 0:
                return TransactionLogValueJsonConverter.write((TransactionLogValue) value, version);
            default:
                throw new UnsupportedVersionException("Unknown record id " + value.apiKey());
        }
    }
    
    public static ApiMessage readRecordKeyFromJson(JsonNode json, short apiKey) {
        switch (apiKey) {
            case 0:
                return TransactionLogKeyJsonConverter.read(json, (short) 0);
            default:
                throw new UnsupportedVersionException("Unknown record id " + apiKey);
        }
    }
    
    public static ApiMessage readRecordValueFromJson(JsonNode json, short apiKey, short version) {
        switch (apiKey) {
            case 0:
                return TransactionLogValueJsonConverter.read(json, version);
            default:
                throw new UnsupportedVersionException("Unknown record id " + apiKey);
        }
    }
    
}
