/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.CloudAdminCommandBase;
import org.apache.kafka.tools.cellsadmincmd.AlterCellCommand;
import org.apache.kafka.tools.cellsadmincmd.AssignBrokersCommand;
import org.apache.kafka.tools.cellsadmincmd.AssignTenantsCommand;
import org.apache.kafka.tools.cellsadmincmd.CellStatusCommand;
import org.apache.kafka.tools.cellsadmincmd.CreateCellCommand;
import org.apache.kafka.tools.cellsadmincmd.CreateQuarantinedCellCommand;
import org.apache.kafka.tools.cellsadmincmd.DeleteCellCommand;
import org.apache.kafka.tools.cellsadmincmd.DescribeCellLoadCommand;
import org.apache.kafka.tools.cellsadmincmd.DescribeCellsCommand;
import org.apache.kafka.tools.cellsadmincmd.DescribeTenantsCommand;
import org.apache.kafka.tools.cellsadmincmd.OffloadCellCommand;
import org.apache.kafka.tools.cellsadmincmd.UnassignBrokersCommand;

public class CellsAdminCommand
extends CloudAdminCommandBase {
    static final String COMMAND_NAME = "kafka-cells-admin.sh";
    static final String COMMAND_DESCRIPTION = "CLI to manage cells in a kafka cluster";
    static final List<CloudAdminCommand> CELL_COMMANDS = Arrays.asList(new DescribeCellsCommand(), new DescribeTenantsCommand(), new DescribeCellLoadCommand(), new AlterCellCommand(), new CreateCellCommand(), new AssignTenantsCommand(), new DeleteCellCommand(), new AssignBrokersCommand(), new UnassignBrokersCommand(), new OffloadCellCommand(), new CreateQuarantinedCellCommand(), new CellStatusCommand());

    public static List<Integer> getCellIdsFromArgs(Namespace ns) {
        Optional<String> cellIdsOption = Optional.ofNullable(ns.getString("cell_ids"));
        if (cellIdsOption.isPresent()) {
            String cellIds = cellIdsOption.get();
            return Arrays.stream(cellIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> getTenantIdsFromArgs(Namespace ns) {
        Optional<String> tenantIdsOption = Optional.ofNullable(ns.getString("tenant_ids"));
        if (tenantIdsOption.isPresent()) {
            String tenantIds = tenantIdsOption.get();
            return Arrays.stream(tenantIds.split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static void main(String[] args) throws Exception {
        CellsAdminCommand.execute(COMMAND_NAME, COMMAND_DESCRIPTION, args, CELL_COMMANDS, System.out);
    }
}

