/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class AssignTenantsCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "assign-tenants";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Assigns tenants to a cell");
        parser.addArgument(new String[]{"--tenant-ids"}).help("list of tenants to assign separated by comma").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
        parser.addArgument(new String[]{"--cell-id"}).help("target cell id").action((ArgumentAction)Arguments.store()).type(Integer.class).required(true);
        parser.addArgument(new String[]{"--force"}).help("force assign even if moving tenant(s) to a quarantined or excluded cell or moving out of a quarantined cell").action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        List errs;
        int cellId = ns.getInt("cell_id");
        String tenantIds = ns.getString("tenant_ids");
        boolean force = Optional.ofNullable(ns.getString("force")).map(Boolean::parseBoolean).orElse(false);
        List assignments = Arrays.stream(tenantIds.split(",")).map(tenantId -> new AssignTenantsToCellRequestData.TenantToCellAssignment().setCellId(cellId).setTenantId(tenantId).setForce(force)).collect(Collectors.toList());
        try {
            errs = (List)admin.assignTenantsToCell(assignments).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to assign tenants to cell", e.getCause());
            return;
        }
        if (errs.isEmpty()) {
            CellsAdminCommand.printMessageAndExit(out, "Successfully set tenants " + tenantIds + " to cell " + cellId);
        } else {
            for (AssignTenantsToCellResponseData.TenantAssignmentErrors err : errs) {
                out.println(err.errorMessage());
            }
            CellsAdminCommand.printErrorAndExit("Failed to set all tenants to cell");
        }
    }
}

