/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.kafka.common.Uuid;

final class PartitionMetadata {
    public static final String PARTITION_METADATA_FILENAME = "partition.metadata";
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile(":\\s+");
    private final int version;
    private final Uuid topicId;
    private final boolean isMetadataRecovery;

    public PartitionMetadata(int version, Uuid topicId, boolean isMetadataRecovery) {
        this.version = version;
        this.topicId = topicId;
        this.isMetadataRecovery = isMetadataRecovery;
    }

    public int getVersion() {
        return this.version;
    }

    public Uuid getTopicId() {
        return this.topicId;
    }

    public boolean isMetadataRecovery() {
        return this.isMetadataRecovery;
    }

    public static void write(Path dir) {
        Path partitionPath = dir.resolve(PARTITION_METADATA_FILENAME);
        Path tempPath = null;
        try {
            tempPath = Files.createTempFile(dir, PARTITION_METADATA_FILENAME, ".tmp", new FileAttribute[0]);
            Files.write(tempPath, String.format("version: %s\ntopic_id: %s\nis_metadata_recovery: %s", 0, Uuid.METADATA_TOPIC_ID, true).getBytes(), new OpenOption[0]);
            if (Files.exists(partitionPath, new LinkOption[0])) {
                throw new UncheckedIOException(new IOException(String.format("partition.metadata file already exists: %s", partitionPath)));
            }
            Files.move(tempPath, partitionPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(new IOException(String.format("Failed to create partition.metadata at: %s", partitionPath)));
        }
        finally {
            if (tempPath != null) {
                try {
                    Files.deleteIfExists(tempPath);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static PartitionMetadata read(Path dir) {
        try {
            int version;
            List<String> lines = Files.readAllLines(dir.resolve(PARTITION_METADATA_FILENAME), StandardCharsets.UTF_8);
            if (lines.size() != 3) {
                throw new IllegalArgumentException(String.format("partition.metadata file has incorrect number of fields %s", lines));
            }
            String[] lineSplit = WHITESPACES_PATTERN.split(lines.get(0));
            if (lineSplit.length != 2) {
                throw new IOException(String.format("Malformed line in checkpoint file: '%s'", lines.get(0)));
            }
            try {
                version = Integer.parseInt(lineSplit[1]);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(String.format("version field isn't populated by an int: %s", lineSplit[1]));
            }
            lineSplit = WHITESPACES_PATTERN.split(lines.get(1));
            if (lineSplit.length != 2) {
                throw new IOException(String.format("Malformed line in checkpoint file: '%s'", lines.get(0)));
            }
            Uuid metadataTopicId = Uuid.fromString((String)lineSplit[1]);
            lineSplit = WHITESPACES_PATTERN.split(lines.get(2));
            if (lineSplit.length != 2) {
                throw new IOException(String.format("Malformed line in checkpoint file: '%s'", lines.get(0)));
            }
            boolean isMetadataRecovery = Boolean.parseBoolean(lineSplit[1]);
            return new PartitionMetadata(version, metadataTopicId, isMetadataRecovery);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionMetadata compMetadata = (PartitionMetadata)o;
        return this.version == compMetadata.version && this.topicId.equals((Object)compMetadata.topicId) && this.isMetadataRecovery == compMetadata.isMetadataRecovery;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.topicId, this.isMetadataRecovery);
    }
}

