/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;

public final class MetadataRecoveryState {
    private final MetadataRecoveryPartition recoveryPartition;
    private final MetadataEncryptorFactory metadataEncryptorFactory;
    private MetadataImage currentImage;

    public MetadataRecoveryState(MetadataRecoveryPartition metadataRecoveryPartition, MetadataEncryptorFactory metadataEncryptorFactory) {
        this.recoveryPartition = metadataRecoveryPartition;
        this.metadataEncryptorFactory = metadataEncryptorFactory;
        this.currentImage = MetadataImage.EMPTY;
    }

    public void load() {
        long lastCommittedOffset = -1L;
        int lastCommittedEpoch = 0;
        long lastCommittedTimestamp = -1L;
        MetadataDelta metadataDelta = new MetadataDelta.Builder().setImage(this.currentImage).setMetadataEncryptorFactory(this.metadataEncryptorFactory).build();
        for (Batch recordBatch : this.recoveryPartition) {
            for (ApiMessageAndVersion record : recordBatch) {
                metadataDelta.replay(record.message());
            }
            lastCommittedOffset = recordBatch.lastOffset();
            lastCommittedEpoch = recordBatch.epoch();
            lastCommittedTimestamp = recordBatch.appendTimestamp();
        }
        this.currentImage = metadataDelta.apply(new MetadataProvenance(lastCommittedOffset, lastCommittedEpoch, lastCommittedTimestamp));
    }

    public MetadataImage getImage() {
        return this.currentImage;
    }

    public void importCheckpoint(RecordsSnapshotReader<ApiMessageAndVersion> snapshotReplay, RecordsSnapshotReader<ApiMessageAndVersion> snapshotAppend) {
        Batch batch;
        if (this.recoveryPartition.iterator().hasNext()) {
            throw new IllegalStateException("Recovery partition should be empty");
        }
        MetadataDelta metadataDelta = new MetadataDelta.Builder().setImage(this.currentImage).setMetadataEncryptorFactory(this.metadataEncryptorFactory).build();
        while (snapshotReplay.hasNext()) {
            batch = snapshotReplay.next();
            for (ApiMessageAndVersion record : batch.records()) {
                metadataDelta.replay(record.message());
            }
        }
        this.currentImage = metadataDelta.apply(new MetadataProvenance(snapshotReplay.lastContainedLogOffset(), snapshotReplay.lastContainedLogEpoch(), snapshotReplay.lastContainedLogTimestamp()));
        while (snapshotAppend.hasNext()) {
            batch = snapshotAppend.next();
            this.appendRecordsOrControlRecords((Batch<ApiMessageAndVersion>)batch);
        }
    }

    public void applyLogs(AutoCloseableIterator<Batch<ApiMessageAndVersion>> replayIterator) {
        boolean reachedEndingOffset = false;
        long lastContainedLogTimestamp = 0L;
        while (replayIterator.hasNext() && !reachedEndingOffset) {
            Batch batch = (Batch)replayIterator.next();
            lastContainedLogTimestamp = Math.max(batch.appendTimestamp(), lastContainedLogTimestamp);
            int epoch = batch.epoch();
            try {
                MetadataDelta metadataDelta = new MetadataDelta.Builder().setImage(this.currentImage).setMetadataEncryptorFactory(this.metadataEncryptorFactory).build();
                for (ApiMessageAndVersion record : batch.records()) {
                    metadataDelta.replay(record.message());
                }
                long lastContainedOffset = this.currentImage.provenance().lastContainedOffset() + (long)batch.records().size();
                this.currentImage = metadataDelta.apply(new MetadataProvenance(lastContainedOffset, epoch, lastContainedLogTimestamp));
                reachedEndingOffset = this.appendRecordsOrControlRecords((Batch<ApiMessageAndVersion>)batch);
            }
            catch (RuntimeException e) {
                System.err.println("Failure to apply records." + String.format("Please use %s(.sh/.bat) %s to view the current state of the recovery partition", "kafka-metadata-recovery", "display"));
                throw e;
            }
        }
    }

    public void exportCheckpoint(long offset, int epoch, long lastContainedLogTimestamp, Path outDirectory) {
        try (RaftSnapshotWriter raftSnapshotWriter = new RaftSnapshotWriter((SnapshotWriter)RecordsSnapshotWriter.createWithHeader((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)outDirectory, (OffsetAndEpoch)new OffsetAndEpoch(offset, epoch), Optional.empty()), (int)0x800000, (MemoryPool)new BatchMemoryPool(5, 0x800000), (Time)Time.SYSTEM, (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE), 0x800000);){
            this.currentImage.write((ImageWriter)raftSnapshotWriter, new ImageWriterOptions.Builder(this.currentImage).build());
        }
    }

    private boolean appendRecordsOrControlRecords(Batch<ApiMessageAndVersion> batch) {
        if (batch.controlRecords().isEmpty()) {
            return this.appendRecords(batch);
        }
        return this.appendControlRecords(batch);
    }

    private boolean appendRecords(Batch<ApiMessageAndVersion> batch) {
        for (ApiMessageAndVersion record : batch.records()) {
            if (record.message() instanceof NoOpRecord) continue;
            this.recoveryPartition.appendRecord(record);
        }
        return false;
    }

    private boolean appendControlRecords(Batch<ApiMessageAndVersion> batch) {
        for (ControlRecord controlRecord : batch.controlRecords()) {
            this.recoveryPartition.maybeAppendControlRecord(controlRecord);
        }
        return false;
    }
}

