/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.CheckpointIterator;
import io.confluent.kafka.tools.recovery.FreezableAppender;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryState;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class ExportCommand {
    static final String COMMAND = "export";
    private static final String CHECKPOINT_OPTION = "--checkpoint";
    private static final String END_OFFSET_OPTION = "--end-offset";
    private static final String EPOCH_OPTION = "--epoch";
    private static final String OUT_DIRECTORY_OPTION = "--out-directory";
    private static final String JSON_OPTION = "--json";

    static void addCommand(Subparsers subparsers) {
        Subparser export = subparsers.addParser(COMMAND).help("Export current recovery state in json or checkpoint format");
        MutuallyExclusiveGroup destinationOptions = export.addMutuallyExclusiveGroup("export destination options").required(true);
        destinationOptions.addArgument(new String[]{CHECKPOINT_OPTION}).dest(CHECKPOINT_OPTION).action((ArgumentAction)Arguments.storeTrue()).help("Export as checkpoint file");
        destinationOptions.addArgument(new String[]{JSON_OPTION}).dest(JSON_OPTION).action((ArgumentAction)Arguments.storeTrue()).help("Export as json file");
        ArgumentGroup toCheckpointOptions = export.addArgumentGroup("--checkpoint arguments");
        toCheckpointOptions.addArgument(new String[]{END_OFFSET_OPTION}).dest(END_OFFSET_OPTION).help("the end offset for the checkpoint id").choices((ArgumentChoice)Arguments.range((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(Long.MAX_VALUE))).type(Long.class);
        toCheckpointOptions.addArgument(new String[]{EPOCH_OPTION}).dest(EPOCH_OPTION).help("the epoch for the checkpoint id").choices((ArgumentChoice)Arguments.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).type(Integer.class);
        toCheckpointOptions.addArgument(new String[]{OUT_DIRECTORY_OPTION}).dest(OUT_DIRECTORY_OPTION).metavar(new String[]{"<out-directory>"}).help("the path the directory where the checkpoint file will be written").type((ArgumentType)Arguments.fileType().verifyIsDirectory().verifyCanWrite());
    }

    static int execute(Namespace namespace) {
        block42: {
            long endingOffset = 0L;
            int epoch = 0;
            Path outPath = Optional.ofNullable(namespace.getString(OUT_DIRECTORY_OPTION)).map(x$0 -> Paths.get(x$0, new String[0])).orElse(Paths.get(System.getProperty("user.dir"), new String[0]));
            if (namespace.getBoolean(CHECKPOINT_OPTION).booleanValue()) {
                if (namespace.getLong(END_OFFSET_OPTION) == null || namespace.getInt(EPOCH_OPTION) == null) {
                    throw new IllegalArgumentException("Must specify --end-offset and --epoch options with --checkpoint");
                }
                endingOffset = namespace.getLong(END_OFFSET_OPTION);
                epoch = namespace.getInt(EPOCH_OPTION);
            }
            Path recoveryLogDir = MetadataRecoveryUtils.recoveryLogDirectory(namespace);
            Properties props = MetadataRecoveryUtils.loadRecoveryConfig(namespace);
            MetadataEncryptorFactory encryptorFactory = MetadataEncryptorFactory.fromProperties((Properties)props);
            try (MetadataRecoveryPartition recoveryPartition = MetadataRecoveryPartition.open(recoveryLogDir, new Metrics(), Time.SYSTEM);){
                MetadataRecoveryState metadataRecoveryState = new MetadataRecoveryState(recoveryPartition, encryptorFactory);
                metadataRecoveryState.load();
                if (namespace.getBoolean(CHECKPOINT_OPTION).booleanValue()) {
                    metadataRecoveryState.exportCheckpoint(endingOffset, epoch, Time.SYSTEM.milliseconds(), outPath);
                    break block42;
                }
                try {
                    Path metadataCheckpoints = Files.createTempDirectory("temp", new FileAttribute[0]);
                    metadataRecoveryState.exportCheckpoint(0L, 0, Time.SYSTEM.milliseconds(), metadataCheckpoints);
                    Path tempSnapshot = metadataCheckpoints.resolve("00000000000000000000-0000000000.checkpoint");
                    try (CheckpointIterator checkpointIterator = new CheckpointIterator(tempSnapshot);
                         FreezableAppender<ApiMessageAndVersion> sink = MetadataRecoveryUtils.jsonAppender(System.out, Time.SYSTEM.milliseconds());){
                        while (checkpointIterator.hasNext()) {
                            Batch<ApiMessageAndVersion> batch = checkpointIterator.next();
                            if (batch.records().isEmpty()) continue;
                            sink.append(batch.records());
                        }
                        sink.freeze();
                    }
                    Files.deleteIfExists(tempSnapshot);
                    Files.deleteIfExists(metadataCheckpoints);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return 0;
    }
}

