/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.Snapshots;

public class CheckpointRemoteCommand {
    static final String COMMAND = "remote";
    private static final String OPTION_POSITIONAL = "option";
    private static final String OPTION_LIST = "list";
    private static final String OPTION_GET = "get";
    private static final String OBJECT_STORE_CONFIG_OPTION = "--object-store-config";
    private static final String DEFAULT_KAFKA_PROPS_FILE = "/mnt/config/kafka.properties";
    private static final String LIST_SHOW_VERSIONS_OPTION = "--show-versions";
    private static final String GET_CLUSTER_ID_OPTION = "--cluster-id";
    private static final String GET_REPLICA_ID_OPTION = "--replica-id";
    private static final String GET_TIMESTAMP_MS_OPTION = "--timestamp-ms";
    private static final String GET_END_OFFSET_OPTION = "--end-offset";
    private static final String GET_EPOCH_OPTION = "--epoch";
    private static final String GET_VERSION_OPTION = "--version";
    private static final String GET_OUT_DIRECTORY_OPTION = "--out-directory";

    static void addCommand(Subparser remote) {
        Subparsers remoteSubparsers = remote.addSubparsers().dest(OPTION_POSITIONAL).help("valid subcommands: list, get");
        Subparser listParser = remoteSubparsers.addParser(OPTION_LIST).help("List all checkpoints in object store");
        listParser.addArgument(new String[]{OBJECT_STORE_CONFIG_OPTION}).dest(OBJECT_STORE_CONFIG_OPTION).metavar(new String[]{"<object-store-config>"}).help("the path to object store config file").type((ArgumentType)Arguments.fileType().verifyCanRead()).required(false).setDefault((Object)DEFAULT_KAFKA_PROPS_FILE);
        listParser.addArgument(new String[]{LIST_SHOW_VERSIONS_OPTION}).dest(LIST_SHOW_VERSIONS_OPTION).metavar(new String[]{"<show-versions>"}).help("display version information for each checkpoint").type(Boolean.class).required(false).action((ArgumentAction)Arguments.storeTrue());
        Subparser getParser = remoteSubparsers.addParser(OPTION_GET).help("Download a checkpoint from object store");
        getParser.addArgument(new String[]{OBJECT_STORE_CONFIG_OPTION}).dest(OBJECT_STORE_CONFIG_OPTION).metavar(new String[]{"<object-store-config>"}).help("the path to object store config file").type((ArgumentType)Arguments.fileType().verifyCanRead()).required(false).setDefault((Object)DEFAULT_KAFKA_PROPS_FILE);
        getParser.addArgument(new String[]{GET_CLUSTER_ID_OPTION}).dest(GET_CLUSTER_ID_OPTION).metavar(new String[]{"<cluster-id>"}).help("the cluster id for the checkpoint").type(String.class).required(true);
        getParser.addArgument(new String[]{GET_REPLICA_ID_OPTION}).dest(GET_REPLICA_ID_OPTION).metavar(new String[]{"<replica-id>"}).help("the replica id for the checkpoint").type(Integer.class).required(true);
        getParser.addArgument(new String[]{GET_END_OFFSET_OPTION}).dest(GET_END_OFFSET_OPTION).metavar(new String[]{"<end-offset>"}).help("the end offset for the checkpoint").type(Long.class).required(true);
        getParser.addArgument(new String[]{GET_EPOCH_OPTION}).dest(GET_EPOCH_OPTION).metavar(new String[]{"<epoch>"}).help("the epoch for the checkpoint").type(Integer.class).required(true);
        getParser.addArgument(new String[]{GET_TIMESTAMP_MS_OPTION}).dest(GET_TIMESTAMP_MS_OPTION).metavar(new String[]{"<timestamp-ms>"}).help("the timestamp ms for the checkpoint").type(Long.class).required(true);
        getParser.addArgument(new String[]{GET_VERSION_OPTION}).dest(GET_VERSION_OPTION).metavar(new String[]{"<version>"}).help("the version information for the checkpoint").type(String.class).required(false);
        getParser.addArgument(new String[]{GET_OUT_DIRECTORY_OPTION}).dest(GET_OUT_DIRECTORY_OPTION).metavar(new String[]{"<out-directory>"}).help("the path the directory where the checkpoint file will be downloaded").type((ArgumentType)Arguments.fileType().verifyIsDirectory().verifyCanWrite()).required(true);
    }

    static int execute(Namespace namespace) {
        switch (namespace.getString(OPTION_POSITIONAL)) {
            case "list": {
                return CheckpointRemoteCommand.listObjects(namespace.getString(OBJECT_STORE_CONFIG_OPTION), namespace.getBoolean(LIST_SHOW_VERSIONS_OPTION));
            }
            case "get": {
                return CheckpointRemoteCommand.getObject(namespace.getString(OBJECT_STORE_CONFIG_OPTION), namespace.getString(GET_CLUSTER_ID_OPTION), namespace.getInt(GET_REPLICA_ID_OPTION), namespace.getLong(GET_TIMESTAMP_MS_OPTION), new OffsetAndEpoch(namespace.getLong(GET_END_OFFSET_OPTION).longValue(), namespace.getInt(GET_EPOCH_OPTION).intValue()), namespace.getString(GET_VERSION_OPTION) == null ? null : new VersionInformation(namespace.getString(GET_VERSION_OPTION)), namespace.getString(GET_OUT_DIRECTORY_OPTION));
            }
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }

    private static int listObjects(String objectStorePath, boolean versionInfo) {
        TierObjectStore tierObjectStore;
        try {
            tierObjectStore = TierObjectStoreUtils.objectStore((String)objectStorePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Map listOutput = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)tierObjectStore, (boolean)versionInfo, (String)"");
        System.out.println("clusterId\t\t\t\t\treplicaId\tsnapshotId\t\t\t\t\t\t\ttimestamp\t\tversion");
        for (Map.Entry entry : listOutput.entrySet()) {
            System.out.printf("%s\t\t%s\t\t%s\t%s\t%s%n", ((KRaftSnapshotObject)entry.getKey()).clusterId(), ((KRaftSnapshotObject)entry.getKey()).nodeId(), ((KRaftSnapshotObject)entry.getKey()).snapshotId(), ((KRaftSnapshotObject)entry.getKey()).appendTimeStampMs(), entry.getValue());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getObject(String objectStorePath, String clusterId, int nodeId, long appendTimestampMs, OffsetAndEpoch snapshotId, VersionInformation versionInfo, String outDir) {
        TierObjectStore tierObjectStore;
        try {
            tierObjectStore = TierObjectStoreUtils.objectStore((String)objectStorePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        TierObjectStore.KRaftSnapshotMetadata metadata = new TierObjectStore.KRaftSnapshotMetadata(new KRaftSnapshotObject(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition(), clusterId, nodeId, appendTimestampMs, snapshotId));
        try (TierObjectStoreResponse response = KRaftSnapshotObjectUtils.getObject((TierObjectStore)tierObjectStore, (TierObjectStore.KRaftSnapshotMetadata)metadata, (VersionInformation)versionInfo);){
            InputStream stream = response.getInputStream();
            Path filePath = Snapshots.snapshotPath((Path)Paths.get(outDir, new String[0]), (OffsetAndEpoch)snapshotId);
            Files.copy(stream, filePath, new CopyOption[0]);
            int n = 0;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

