/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.CheckpointIterator;
import io.confluent.kafka.tools.recovery.FreezableAppender;
import io.confluent.kafka.tools.recovery.JsonIterator;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.server.common.ApiMessageAndVersion;

final class CheckpointConvertCommand {
    private static final String FROM_JSON_OPTION = "--from-json";
    private static final String FROM_CHECKPOINT_OPTION = "--from-checkpoint";
    private static final String TO_JSON_OPTION = "--to-json";
    private static final String TO_CHECKPOINT_OPTION = "--to-checkpoint";
    private static final String END_OFFSET_OPTION = "--end-offset";
    private static final String EPOCH_OPTION = "--epoch";
    private static final String OUT_DIRECTORY_OPTION = "--out-directory";
    static final String COMMAND = "convert";

    CheckpointConvertCommand() {
    }

    static void addCommand(Subparser convert) {
        MutuallyExclusiveGroup fromOptions = convert.addMutuallyExclusiveGroup("from arguments").required(true);
        fromOptions.addArgument(new String[]{FROM_JSON_OPTION}).dest(FROM_JSON_OPTION).metavar(new String[]{"<from-json>"}).help("path to the JSON checkpoint file").type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead());
        fromOptions.addArgument(new String[]{FROM_CHECKPOINT_OPTION}).dest(FROM_CHECKPOINT_OPTION).metavar(new String[]{"<from-checkpoint>"}).help("path to the checkpoint file").type((ArgumentType)Arguments.fileType().verifyCanRead());
        MutuallyExclusiveGroup toOptions = convert.addMutuallyExclusiveGroup("to arguments").required(true);
        toOptions.addArgument(new String[]{TO_JSON_OPTION}).dest(TO_JSON_OPTION).help("convert the metadata checkpoint to JSON and print to standard out").action((ArgumentAction)Arguments.storeTrue());
        toOptions.addArgument(new String[]{TO_CHECKPOINT_OPTION}).dest(TO_CHECKPOINT_OPTION).help(String.format("convert to the Kafka checkpoint file named <end-offset>-<epoch>.checkpoint. If this option is used, the following options must be specified: %s, %s", END_OFFSET_OPTION, EPOCH_OPTION)).action((ArgumentAction)Arguments.storeTrue());
        ArgumentGroup toCheckpointOptions = convert.addArgumentGroup("--to-checkpoint arguments");
        toCheckpointOptions.addArgument(new String[]{END_OFFSET_OPTION}).dest(END_OFFSET_OPTION).help("the end offset for the checkpoint id").choices((ArgumentChoice)Arguments.range((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(Long.MAX_VALUE))).type(Long.class);
        toCheckpointOptions.addArgument(new String[]{EPOCH_OPTION}).dest(EPOCH_OPTION).help("the epoch for the checkpoint id").choices((ArgumentChoice)Arguments.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).type(Integer.class);
        toCheckpointOptions.addArgument(new String[]{OUT_DIRECTORY_OPTION}).dest(OUT_DIRECTORY_OPTION).metavar(new String[]{"<out-directory>"}).help("the path the directory where the checkpoint file will be written").type((ArgumentType)Arguments.fileType().verifyIsDirectory().verifyCanWrite());
    }

    static int execute(Namespace namespace) {
        try (AutoCloseableIterator<Batch<ApiMessageAndVersion>> source = CheckpointConvertCommand.metadataIterator(namespace);){
            SnapshotHeaderRecord actualHeader;
            try {
                Batch firstBatch = (Batch)source.next();
                List controlRecords = firstBatch.controlRecords();
                ControlRecord controlHeader = (ControlRecord)controlRecords.get(0);
                actualHeader = (SnapshotHeaderRecord)controlHeader.message();
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Expected the first batch to be a snapshot header control record", e);
            }
            long lastContainedLogTimestamp = actualHeader.lastContainedLogTimestamp();
            try (FreezableAppender<ApiMessageAndVersion> sink = MetadataRecoveryUtils.metadataAppender(namespace, lastContainedLogTimestamp, TO_CHECKPOINT_OPTION, TO_JSON_OPTION);){
                while (source.hasNext()) {
                    Batch batch = (Batch)source.next();
                    if (batch.records().isEmpty()) continue;
                    sink.append(batch.records());
                }
                sink.freeze();
            }
        }
        return 0;
    }

    private static AutoCloseableIterator<Batch<ApiMessageAndVersion>> metadataIterator(Namespace namespace) {
        if (namespace.getString(FROM_CHECKPOINT_OPTION) != null) {
            Path path = Paths.get(namespace.getString(FROM_CHECKPOINT_OPTION), new String[0]);
            return new CheckpointIterator(path);
        }
        if (namespace.getString(FROM_JSON_OPTION) != null) {
            Optional<Path> path = Optional.empty();
            Optional<InputStream> stream = Optional.empty();
            if (namespace.getString(FROM_JSON_OPTION).equals("-")) {
                stream = Optional.of(System.in);
            } else {
                path = Optional.of(Paths.get(namespace.getString(FROM_JSON_OPTION), new String[0]));
            }
            return new JsonIterator(path, stream);
        }
        throw new IllegalArgumentException("one 'from' option must be specified");
    }
}

