/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.JsonIterator;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryState;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import kafka.utils.FileLock;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.ApiMessageAndVersion;

final class ApplyCommand {
    static final String COMMAND = "apply";
    private static final String JSON_OPTION = "--json";

    ApplyCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparser apply = subparsers.addParser(COMMAND).help("replace recovery state with a new state");
        MutuallyExclusiveGroup sourceOptions = apply.addMutuallyExclusiveGroup("apply origin options").required(true);
        sourceOptions.addArgument(new String[]{JSON_OPTION}).dest(JSON_OPTION).metavar(new String[]{"<json-objects>"}).help("provide an array of <json-objects> as records to apply").type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int execute(Namespace namespace) {
        Path logDir = MetadataRecoveryUtils.recoveryLogDirectory(namespace);
        Optional<FileLock> lock = MetadataRecoveryUtils.maybeSetupFileLock(namespace);
        try (MetadataRecoveryPartition recoveryPartition = MetadataRecoveryPartition.open(logDir, new Metrics(), Time.SYSTEM);){
            Properties props = MetadataRecoveryUtils.loadRecoveryConfig(namespace);
            MetadataEncryptorFactory encryptorFactory = MetadataEncryptorFactory.fromProperties((Properties)props);
            MetadataRecoveryState metadataRecoveryState = new MetadataRecoveryState(recoveryPartition, encryptorFactory);
            metadataRecoveryState.load();
            try (AutoCloseableIterator<Batch<ApiMessageAndVersion>> iterator = ApplyCommand.metadataIterator(namespace);){
                metadataRecoveryState.applyLogs(iterator);
            }
        }
        finally {
            lock.ifPresent(FileLock::unlock);
        }
        return 0;
    }

    private static AutoCloseableIterator<Batch<ApiMessageAndVersion>> metadataIterator(Namespace namespace) {
        if (namespace.getString(JSON_OPTION) != null) {
            Optional<Path> path = Optional.empty();
            Optional<InputStream> stream = Optional.empty();
            if (namespace.getString(JSON_OPTION).equals("-")) {
                stream = Optional.of(System.in);
            } else {
                path = Optional.of(Paths.get(namespace.getString(JSON_OPTION), new String[0]));
            }
            return new JsonIterator(path, stream);
        }
        throw new IllegalArgumentException("one 'origin' option must be specified");
    }
}

