/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ToolsTestUtils {
    public static String captureStandardOut(Runnable runnable) {
        return ToolsTestUtils.captureStandardStream(false, runnable);
    }

    public static String captureStandardErr(Runnable runnable) {
        return ToolsTestUtils.captureStandardStream(true, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String captureStandardStream(boolean isErr, Runnable runnable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream currentStream = isErr ? System.err : System.out;
        PrintStream tempStream = new PrintStream(outputStream);
        if (isErr) {
            System.setErr(tempStream);
        } else {
            System.setOut(tempStream);
        }
        try {
            runnable.run();
            String string = new String(outputStream.toByteArray()).trim();
            return string;
        }
        finally {
            if (isErr) {
                System.setErr(currentStream);
            } else {
                System.setOut(currentStream);
            }
        }
    }
}

