/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.MetadataQuorumCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
class MetadataQuorumCommandTest {
    private final ClusterInstance cluster;

    public MetadataQuorumCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=2, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=2), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=2, controllers=1), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=1), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=1, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=2)})
    public void testDescribeQuorumReplicationSuccessful() throws InterruptedException {
        this.cluster.waitForReadyBrokers();
        String describeOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe", "--replication"}));
        List outputs = Arrays.stream(describeOutput.split("\n")).skip(1L).collect(Collectors.toList());
        if (this.cluster.config().clusterType() == Type.CO_KRAFT) {
            Assertions.assertEquals((int)Math.max(this.cluster.config().numControllers(), this.cluster.config().numBrokers()), (int)outputs.size());
        } else {
            Assertions.assertEquals((int)(this.cluster.config().numBrokers() + this.cluster.config().numControllers()), (int)outputs.size());
        }
        Pattern leaderPattern = Pattern.compile("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+-?\\d+\\s+Leader\\s*");
        Assertions.assertTrue((boolean)leaderPattern.matcher((CharSequence)outputs.get(0)).find());
        Assertions.assertTrue((boolean)outputs.stream().skip(1L).noneMatch(o -> leaderPattern.matcher((CharSequence)o).find()));
        Pattern followerPattern = Pattern.compile("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+-?\\d+\\s+Follower\\s*");
        Assertions.assertEquals((long)(this.cluster.config().numControllers() - 1), (long)outputs.stream().filter(o -> followerPattern.matcher((CharSequence)o).find()).count());
        Pattern observerPattern = Pattern.compile("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+-?\\d+\\s+Observer\\s*");
        if (this.cluster.config().clusterType() == Type.CO_KRAFT) {
            Assertions.assertEquals((long)Math.max(0, this.cluster.config().numBrokers() - this.cluster.config().numControllers()), (long)outputs.stream().filter(o -> observerPattern.matcher((CharSequence)o).find()).count());
        } else {
            Assertions.assertEquals((long)this.cluster.config().numBrokers(), (long)outputs.stream().filter(o -> observerPattern.matcher((CharSequence)o).find()).count());
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=2, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=2), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=2, controllers=1), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=1), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=1, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=2)})
    public void testDescribeQuorumStatusSuccessful() throws InterruptedException {
        this.cluster.waitForReadyBrokers();
        String describeOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe", "--status"}));
        String[] outputs = describeOutput.split("\n");
        Assertions.assertTrue((boolean)outputs[0].matches("ClusterId:\\s+\\S{22}"));
        Assertions.assertTrue((boolean)outputs[1].matches("LeaderId:\\s+\\d+"));
        Assertions.assertTrue((boolean)outputs[2].matches("LeaderEpoch:\\s+\\d+"));
        Assertions.assertTrue((boolean)outputs[3].matches("HighWatermark:\\s+-?\\d+"));
        Assertions.assertTrue((boolean)outputs[4].matches("MaxFollowerLag:\\s+\\d+"));
        Assertions.assertTrue((boolean)outputs[5].matches("MaxFollowerLagTimeMs:\\s+-?\\d+"));
        Assertions.assertTrue((boolean)outputs[6].matches("CurrentVoters:\\s+\\[\\d+(,\\d+)*]"));
        if (this.cluster.config().clusterType() == Type.CO_KRAFT && this.cluster.config().numBrokers() <= this.cluster.config().numControllers()) {
            Assertions.assertTrue((boolean)outputs[7].matches("CurrentObservers:\\s+\\[]"));
        } else {
            Assertions.assertTrue((boolean)outputs[7].matches("CurrentObservers:\\s+\\[\\d+(,\\d+)*]"));
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=1, controllers=1), @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)})
    public void testOnlyOneBrokerAndOneController() {
        String statusOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe", "--status"}));
        Assertions.assertEquals((Object)"MaxFollowerLag:         0", (Object)statusOutput.split("\n")[4]);
        Assertions.assertEquals((Object)"MaxFollowerLagTimeMs:   0", (Object)statusOutput.split("\n")[5]);
        String replicationOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe", "--replication"}));
        Assertions.assertEquals((Object)"0", (Object)replicationOutput.split("\n")[1].split("\\s+")[2]);
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=1, controllers=1)})
    public void testCommandConfig() throws IOException {
        File tmpfile = TestUtils.tempFile((String)"security.protocol=SSL_PLAINTEXT");
        Assertions.assertEquals((int)1, (int)MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--command-config", tmpfile.getAbsolutePath(), "describe", "--status"}));
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testDescribeQuorumInZkMode() {
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> MetadataQuorumCommand.execute((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe", "--status"}))).getCause() instanceof UnsupportedVersionException));
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> MetadataQuorumCommand.execute((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe", "--replication"}))).getCause() instanceof UnsupportedVersionException));
    }
}

