/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.tools.ProducerPerformance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class ProducerPerformanceTest {
    @Mock
    KafkaProducer<byte[], byte[]> producerMock;
    @Spy
    ProducerPerformance producerPerformanceSpy;

    private File createTempFile(String contents) throws IOException {
        File file = File.createTempFile("ProducerPerformanceTest", ".tmp");
        file.deleteOnExit();
        Files.write(file.toPath(), contents.getBytes(), new OpenOption[0]);
        return file;
    }

    @Test
    public void testReadPayloadFile() throws Exception {
        File payloadFile = this.createTempFile("Hello\nKafka");
        String payloadFilePath = payloadFile.getAbsolutePath();
        String payloadDelimiter = "\n";
        List payloadByteList = ProducerPerformance.readPayloadFile((String)payloadFilePath, (String)payloadDelimiter);
        Assertions.assertEquals((int)2, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String((byte[])payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String((byte[])payloadByteList.get(1)));
    }

    @Test
    public void testReadProps() throws Exception {
        List<String> producerProps = Collections.singletonList("bootstrap.servers=localhost:9000");
        String producerConfig = this.createTempFile("acks=1").getAbsolutePath();
        String transactionalId = "1234";
        boolean transactionsEnabled = true;
        Properties prop = ProducerPerformance.readProps(producerProps, (String)producerConfig, (String)transactionalId, (boolean)transactionsEnabled);
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)5, (int)prop.size());
    }

    @Test
    public void testNumberOfCallsForSendAndClose() throws IOException {
        ((KafkaProducer)Mockito.doReturn(null).when(this.producerMock)).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        ((ProducerPerformance)Mockito.doReturn(this.producerMock).when((Object)this.producerPerformanceSpy)).createKafkaProducer((Properties)ArgumentMatchers.any(Properties.class));
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        this.producerPerformanceSpy.start(args);
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)5))).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testUnexpectedArg() {
        String[] args = new String[]{"--test", "test", "--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        ArgumentParser parser = ProducerPerformance.argParser();
        ArgumentParserException thrown = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> parser.parseArgs(args));
        Assertions.assertEquals((Object)"unrecognized arguments: '--test'", (Object)thrown.getMessage());
    }

    @Test
    public void testGenerateRandomPayloadByPayloadFile() {
        Integer recordSize = null;
        String inputString = "Hello Kafka";
        byte[] byteArray = inputString.getBytes(StandardCharsets.UTF_8);
        ArrayList<byte[]> payloadByteList = new ArrayList<byte[]>();
        payloadByteList.add(byteArray);
        byte[] payload = null;
        Random random = new Random(0L);
        payload = ProducerPerformance.generateRandomPayload(recordSize, payloadByteList, payload, (Random)random);
        Assertions.assertEquals((Object)inputString, (Object)new String(payload));
    }

    @Test
    public void testGenerateRandomPayloadByRecordSize() {
        Integer recordSize = 100;
        byte[] payload = new byte[recordSize.intValue()];
        ArrayList payloadByteList = new ArrayList();
        Random random = new Random(0L);
        for (byte b : payload = ProducerPerformance.generateRandomPayload((Integer)recordSize, payloadByteList, (byte[])payload, (Random)random)) {
            Assertions.assertNotEquals((int)0, (int)b);
        }
    }

    @Test
    public void testGenerateRandomPayloadException() {
        Integer recordSize = null;
        byte[] payload = null;
        ArrayList payloadByteList = new ArrayList();
        Random random = new Random(0L);
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ProducerPerformance.generateRandomPayload((Integer)recordSize, (List)payloadByteList, (byte[])payload, (Random)random));
        Assertions.assertEquals((Object)"no payload File Path or record Size provided", (Object)thrown.getMessage());
    }
}

