/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.trogdor.workload.ConsumeBenchSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumeBenchSpecTest {
    @Test
    public void testMaterializeTopicsWithNoPartitions() {
        Map materializedTopics = this.consumeBenchSpec(Arrays.asList("topic[1-3]", "secondTopic")).materializeTopics();
        HashMap expected = new HashMap();
        expected.put("topic1", new ArrayList());
        expected.put("topic2", new ArrayList());
        expected.put("topic3", new ArrayList());
        expected.put("secondTopic", new ArrayList());
        Assertions.assertEquals(expected, (Object)materializedTopics);
    }

    @Test
    public void testMaterializeTopicsWithSomePartitions() {
        Map materializedTopics = this.consumeBenchSpec(Arrays.asList("topic[1-3]:[1-5]", "secondTopic", "thirdTopic:1")).materializeTopics();
        HashMap<String, List<Object>> expected = new HashMap<String, List<Object>>();
        expected.put("topic1", IntStream.range(1, 6).asLongStream().mapToObj(i -> new TopicPartition("topic1", (int)i)).collect(Collectors.toList()));
        expected.put("topic2", IntStream.range(1, 6).asLongStream().mapToObj(i -> new TopicPartition("topic2", (int)i)).collect(Collectors.toList()));
        expected.put("topic3", IntStream.range(1, 6).asLongStream().mapToObj(i -> new TopicPartition("topic3", (int)i)).collect(Collectors.toList()));
        expected.put("secondTopic", new ArrayList());
        expected.put("thirdTopic", Collections.singletonList(new TopicPartition("thirdTopic", 1)));
        Assertions.assertEquals(expected, (Object)materializedTopics);
    }

    @Test
    public void testInvalidTopicNameRaisesExceptionInMaterialize() {
        for (String invalidName : Arrays.asList("In:valid", "invalid:", ":invalid", "in:valid:1", "invalid:2:2", "invalid::1", "invalid[1-3]:")) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumeBenchSpec(Collections.singletonList(invalidName)).materializeTopics());
        }
    }

    private ConsumeBenchSpec consumeBenchSpec(List<String> activeTopics) {
        return new ConsumeBenchSpec(0L, 0L, "node", "localhost", 123, 1234L, "cg-1", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Integer.valueOf(1), Optional.empty(), activeTopics);
    }
}

