/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.agent.Agent;
import org.apache.kafka.trogdor.agent.AgentClient;
import org.apache.kafka.trogdor.agent.AgentRestResource;
import org.apache.kafka.trogdor.basic.BasicNode;
import org.apache.kafka.trogdor.basic.BasicPlatform;
import org.apache.kafka.trogdor.basic.BasicTopology;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.coordinator.Coordinator;
import org.apache.kafka.trogdor.coordinator.CoordinatorClient;
import org.apache.kafka.trogdor.coordinator.CoordinatorRestResource;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniTrogdorCluster
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MiniTrogdorCluster.class);
    private final TreeMap<String, Agent> agents;
    private final TreeMap<String, Builder.NodeData> nodesByAgent;
    private final Coordinator coordinator;
    private final Scheduler scheduler;

    private MiniTrogdorCluster(Scheduler scheduler, TreeMap<String, Agent> agents, TreeMap<String, Builder.NodeData> nodesByAgent, Coordinator coordinator) {
        this.scheduler = scheduler;
        this.agents = agents;
        this.nodesByAgent = nodesByAgent;
        this.coordinator = coordinator;
    }

    public TreeMap<String, Agent> agents() {
        return this.agents;
    }

    public Coordinator coordinator() {
        return this.coordinator;
    }

    public CoordinatorClient coordinatorClient() {
        if (this.coordinator == null) {
            throw new RuntimeException("No coordinator configured.");
        }
        return new CoordinatorClient.Builder().maxTries(10).target("localhost", this.coordinator.port()).build();
    }

    public void restartAgent(String nodeName) {
        if (!this.agents.containsKey(nodeName)) {
            throw new RuntimeException("There is no agent on node " + nodeName);
        }
        Builder.NodeData node = this.nodesByAgent.get(nodeName);
        this.agents.put(nodeName, new Agent(node.platform, this.scheduler, node.agentRestServer, node.agentRestResource));
    }

    public AgentClient agentClient(String nodeName) {
        Agent agent = this.agents.get(nodeName);
        if (agent == null) {
            throw new RuntimeException("No agent configured on node " + nodeName);
        }
        return new AgentClient.Builder().maxTries(10).target("localhost", agent.port()).build();
    }

    @Override
    public void close() throws Exception {
        log.info("Closing MiniTrogdorCluster.");
        if (this.coordinator != null) {
            this.coordinator.beginShutdown(false);
        }
        for (Agent agent : this.agents.values()) {
            agent.beginShutdown();
        }
        for (Agent agent : this.agents.values()) {
            agent.waitForShutdown();
        }
        if (this.coordinator != null) {
            this.coordinator.waitForShutdown();
        }
    }

    public static class Builder {
        private final TreeSet<String> agentNames = new TreeSet();
        private String coordinatorName = null;
        private Scheduler scheduler = Scheduler.SYSTEM;
        private BasicPlatform.CommandRunner commandRunner = new BasicPlatform.ShellCommandRunner();

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder commandRunner(BasicPlatform.CommandRunner commandRunner) {
            this.commandRunner = commandRunner;
            return this;
        }

        public Builder addCoordinator(String nodeName) {
            if (this.coordinatorName != null) {
                throw new RuntimeException("At most one coordinator is allowed.");
            }
            this.coordinatorName = nodeName;
            return this;
        }

        public Builder addAgent(String nodeName) {
            if (this.agentNames.contains(nodeName)) {
                throw new RuntimeException("There is already an agent on node " + nodeName);
            }
            this.agentNames.add(nodeName);
            return this;
        }

        private NodeData getOrCreate(String nodeName, TreeMap<String, NodeData> nodes) {
            NodeData data = nodes.get(nodeName);
            if (data != null) {
                return data;
            }
            data = new NodeData();
            data.hostname = "127.0.0.1";
            nodes.put(nodeName, data);
            return data;
        }

        public MiniTrogdorCluster build() throws Exception {
            log.info("Creating MiniTrogdorCluster with agents: {} and coordinator: {}", (Object)Utils.join(this.agentNames, (String)", "), (Object)this.coordinatorName);
            TreeMap<String, NodeData> nodes = new TreeMap<String, NodeData>();
            for (String string : this.agentNames) {
                NodeData nodeData = this.getOrCreate(string, nodes);
                nodeData.agentRestResource = new AgentRestResource();
                nodeData.agentRestServer = new JsonRestServer(0);
                nodeData.agentRestServer.start(new Object[]{nodeData.agentRestResource});
                nodeData.agentPort = nodeData.agentRestServer.port();
            }
            if (this.coordinatorName != null) {
                NodeData node2 = this.getOrCreate(this.coordinatorName, nodes);
                node2.coordinatorRestResource = new CoordinatorRestResource();
                node2.coordinatorRestServer = new JsonRestServer(0);
                node2.coordinatorRestServer.start(new Object[]{node2.coordinatorRestResource});
                node2.coordinatorPort = node2.coordinatorRestServer.port();
            }
            for (Map.Entry entry : nodes.entrySet()) {
                NodeData nodeData = (NodeData)entry.getValue();
                HashMap<String, String> config = new HashMap<String, String>();
                if (nodeData.agentPort != 0) {
                    config.put("trogdor.agent.port", Integer.toString(nodeData.agentPort));
                }
                if (nodeData.coordinatorPort != 0) {
                    config.put("trogdor.coordinator.port", Integer.toString(nodeData.coordinatorPort));
                }
                nodeData.node = new BasicNode((String)entry.getKey(), nodeData.hostname, config, Collections.emptySet());
            }
            TreeMap<String, BasicNode> topologyNodes = new TreeMap<String, BasicNode>();
            for (Map.Entry<String, NodeData> entry : nodes.entrySet()) {
                topologyNodes.put(entry.getKey(), entry.getValue().node);
            }
            BasicTopology basicTopology = new BasicTopology(topologyNodes);
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory((String)"MiniTrogdorClusterStartupThread%d", (boolean)false));
            AtomicReference<Object> failure = new AtomicReference<Object>(null);
            for (Map.Entry<String, NodeData> entry : nodes.entrySet()) {
                scheduledExecutorService.submit(() -> {
                    String nodeName = (String)entry.getKey();
                    try {
                        NodeData node = (NodeData)entry.getValue();
                        node.platform = new BasicPlatform(nodeName, topology, this.scheduler, this.commandRunner);
                        if (node.agentRestResource != null) {
                            node.agent = new Agent(node.platform, this.scheduler, node.agentRestServer, node.agentRestResource);
                        }
                        if (node.coordinatorRestResource != null) {
                            node.coordinator = new Coordinator(node.platform, this.scheduler, node.coordinatorRestServer, node.coordinatorRestResource, 0L);
                        }
                    }
                    catch (Exception e) {
                        log.error("Unable to initialize {}", (Object)nodeName, (Object)e);
                        failure.compareAndSet(null, e);
                    }
                    return null;
                });
            }
            scheduledExecutorService.shutdown();
            scheduledExecutorService.awaitTermination(1L, TimeUnit.DAYS);
            Exception failureException = failure.get();
            if (failureException != null) {
                throw failureException;
            }
            TreeMap<String, Agent> agents = new TreeMap<String, Agent>();
            Coordinator coordinator = null;
            for (Map.Entry<String, NodeData> entry : nodes.entrySet()) {
                NodeData node3 = entry.getValue();
                if (node3.agent != null) {
                    agents.put(entry.getKey(), node3.agent);
                }
                if (node3.coordinator == null) continue;
                coordinator = node3.coordinator;
            }
            return new MiniTrogdorCluster(this.scheduler, agents, nodes, coordinator);
        }

        private static class NodeData {
            String hostname;
            AgentRestResource agentRestResource = null;
            JsonRestServer agentRestServer = null;
            int agentPort = 0;
            JsonRestServer coordinatorRestServer = null;
            int coordinatorPort = 0;
            CoordinatorRestResource coordinatorRestResource = null;
            Platform platform = null;
            Agent agent = null;
            Coordinator coordinator = null;
            BasicNode node = null;

            private NodeData() {
            }
        }
    }
}

