/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.tools.PushHttpMetricsReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class PushHttpMetricsReporterTest {
    private static final URL URL;
    private final Time time = new MockTime();
    private final ScheduledExecutorService executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
    private final HttpURLConnection httpReq = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
    private final OutputStream httpOut = (OutputStream)Mockito.mock(OutputStream.class);
    private final InputStream httpErr = (InputStream)Mockito.mock(InputStream.class);
    private final ArgumentCaptor<Runnable> reportRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
    private final ArgumentCaptor<byte[]> httpPayloadCaptor = ArgumentCaptor.forClass(byte[].class);
    private PushHttpMetricsReporter reporter;
    private MockedStatic<PushHttpMetricsReporter> mockedStaticReporter;

    @BeforeEach
    public void setUp() {
        this.reporter = new PushHttpMetricsReporter(this.time, this.executor);
        this.mockedStaticReporter = Mockito.mockStatic(PushHttpMetricsReporter.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedStaticReporter.close();
    }

    @Test
    public void testConfigureClose() throws Exception {
        this.whenClose();
        this.configure();
        this.reporter.close();
        this.verifyConfigure();
        this.verifyClose();
    }

    @Test
    public void testConfigureBadUrl() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("metrics.url", "malformed;url");
        config.put("metrics.period", "5");
        Assertions.assertThrows(ConfigException.class, () -> this.reporter.configure(config));
    }

    @Test
    public void testConfigureMissingPeriod() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("metrics.url", URL.toString());
        Assertions.assertThrows(ConfigException.class, () -> this.reporter.configure(config));
    }

    @Test
    public void testNoMetrics() throws Exception {
        this.whenRequest(200);
        this.configure();
        this.verifyConfigure();
        ((Runnable)this.reportRunnableCaptor.getValue()).run();
        this.verifyResponse();
        JsonNode payload = new ObjectMapper().readTree((byte[])this.httpPayloadCaptor.getValue());
        Assertions.assertTrue((boolean)payload.isObject());
        this.assertPayloadHasClientInfo(payload);
        JsonNode metrics = payload.get("metrics");
        Assertions.assertTrue((boolean)metrics.isArray());
        Assertions.assertEquals((int)0, (int)metrics.size());
        this.reporter.close();
        this.verifyClose();
    }

    @Test
    public void testClientError() throws Exception {
        this.whenRequest(400, true);
        this.configure();
        this.verifyConfigure();
        ((Runnable)this.reportRunnableCaptor.getValue()).run();
        this.verifyResponse();
        this.reporter.close();
        this.verifyClose();
    }

    @Test
    public void testServerError() throws Exception {
        this.whenRequest(500, true);
        this.configure();
        this.verifyConfigure();
        ((Runnable)this.reportRunnableCaptor.getValue()).run();
        this.verifyResponse();
        this.reporter.close();
        this.verifyClose();
    }

    @Test
    public void testMetricValues() throws Exception {
        this.whenRequest(200);
        this.configure();
        this.verifyConfigure();
        KafkaMetric metric1 = new KafkaMetric(new Object(), new MetricName("name1", "group1", "desc1", Collections.singletonMap("key1", "value1")), new ImmutableValue<Double>(1.0), null, this.time);
        KafkaMetric newMetric1 = new KafkaMetric(new Object(), new MetricName("name1", "group1", "desc1", Collections.singletonMap("key1", "value1")), new ImmutableValue<Double>(-1.0), null, this.time);
        KafkaMetric metric2 = new KafkaMetric(new Object(), new MetricName("name2", "group2", "desc2", Collections.singletonMap("key2", "value2")), new ImmutableValue<Double>(2.0), null, this.time);
        KafkaMetric metric3 = new KafkaMetric(new Object(), new MetricName("name3", "group3", "desc3", Collections.singletonMap("key3", "value3")), new ImmutableValue<Double>(3.0), null, this.time);
        KafkaMetric metric4 = new KafkaMetric(new Object(), new MetricName("name4", "group4", "desc4", Collections.singletonMap("key4", "value4")), new ImmutableValue<String>("value4"), null, this.time);
        this.reporter.init(Arrays.asList(metric1, metric2, metric4));
        this.reporter.metricChange(newMetric1);
        this.reporter.metricChange(metric3);
        this.reporter.metricRemoval(metric2);
        ((Runnable)this.reportRunnableCaptor.getValue()).run();
        this.verifyResponse();
        JsonNode payload = new ObjectMapper().readTree((byte[])this.httpPayloadCaptor.getValue());
        Assertions.assertTrue((boolean)payload.isObject());
        this.assertPayloadHasClientInfo(payload);
        JsonNode metrics = payload.get("metrics");
        Assertions.assertTrue((boolean)metrics.isArray());
        Assertions.assertEquals((int)3, (int)metrics.size());
        List<JsonNode> metricsList = Arrays.asList(metrics.get(0), metrics.get(1), metrics.get(2));
        metricsList.sort((m1, m2) -> m1.get("name").textValue().compareTo(m2.get("name").textValue()));
        JsonNode m12 = metricsList.get(0);
        Assertions.assertEquals((Object)"name1", (Object)m12.get("name").textValue());
        Assertions.assertEquals((Object)"group1", (Object)m12.get("group").textValue());
        JsonNode m1Tags = m12.get("tags");
        Assertions.assertTrue((boolean)m1Tags.isObject());
        Assertions.assertEquals((int)1, (int)m1Tags.size());
        Assertions.assertEquals((Object)"value1", (Object)m1Tags.get("key1").textValue());
        Assertions.assertEquals((double)-1.0, (double)m12.get("value").doubleValue(), (double)0.0);
        JsonNode m3 = metricsList.get(1);
        Assertions.assertEquals((Object)"name3", (Object)m3.get("name").textValue());
        Assertions.assertEquals((Object)"group3", (Object)m3.get("group").textValue());
        JsonNode m3Tags = m3.get("tags");
        Assertions.assertTrue((boolean)m3Tags.isObject());
        Assertions.assertEquals((int)1, (int)m3Tags.size());
        Assertions.assertEquals((Object)"value3", (Object)m3Tags.get("key3").textValue());
        Assertions.assertEquals((double)3.0, (double)m3.get("value").doubleValue(), (double)0.0);
        JsonNode m4 = metricsList.get(2);
        Assertions.assertEquals((Object)"name4", (Object)m4.get("name").textValue());
        Assertions.assertEquals((Object)"group4", (Object)m4.get("group").textValue());
        JsonNode m4Tags = m4.get("tags");
        Assertions.assertTrue((boolean)m4Tags.isObject());
        Assertions.assertEquals((int)1, (int)m4Tags.size());
        Assertions.assertEquals((Object)"value4", (Object)m4Tags.get("key4").textValue());
        Assertions.assertEquals((Object)"value4", (Object)m4.get("value").textValue());
        this.reporter.close();
        this.verifyClose();
    }

    private void configure() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("metrics.url", URL.toString());
        config.put("metrics.period", "5");
        this.reporter.configure(config);
    }

    private void whenRequest(int returnStatus) throws Exception {
        this.whenRequest(returnStatus, false);
    }

    private void whenRequest(int returnStatus, boolean readResponse) throws Exception {
        Mockito.when((Object)PushHttpMetricsReporter.newHttpConnection((URL)URL)).thenReturn((Object)this.httpReq);
        Mockito.when((Object)this.httpReq.getOutputStream()).thenReturn((Object)this.httpOut);
        Mockito.when((Object)this.httpReq.getResponseCode()).thenReturn((Object)returnStatus);
        if (readResponse) {
            this.whenReadResponse();
        }
    }

    private void assertPayloadHasClientInfo(JsonNode payload) throws UnknownHostException {
        JsonNode client = payload.get("client");
        Assertions.assertTrue((boolean)client.isObject());
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)client.get("host").textValue());
        Assertions.assertEquals((Object)"", (Object)client.get("client_id").textValue());
        Assertions.assertEquals((long)this.time.milliseconds(), (long)client.get("time").longValue());
    }

    private void whenReadResponse() {
        Mockito.when((Object)this.httpReq.getErrorStream()).thenReturn((Object)this.httpErr);
        Mockito.when((Object)PushHttpMetricsReporter.readResponse((InputStream)this.httpErr)).thenReturn((Object)"error response message");
    }

    private void whenClose() throws Exception {
        Mockito.when((Object)this.executor.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenReturn((Object)true);
    }

    private void verifyClose() throws InterruptedException {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.executor});
        ((ScheduledExecutorService)inOrder.verify((Object)this.executor)).shutdown();
        ((ScheduledExecutorService)inOrder.verify((Object)this.executor)).awaitTermination(30L, TimeUnit.SECONDS);
    }

    private void verifyConfigure() {
        ((ScheduledExecutorService)Mockito.verify((Object)this.executor)).scheduleAtFixedRate((Runnable)this.reportRunnableCaptor.capture(), ArgumentMatchers.eq((long)5L), ArgumentMatchers.eq((long)5L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
    }

    private void verifyResponse() throws IOException {
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setRequestMethod("POST");
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setDoInput(true);
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setRequestProperty("Content-Type", "application/json");
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setRequestProperty((String)ArgumentMatchers.eq((Object)"Content-Length"), ArgumentMatchers.anyString());
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setRequestProperty("Accept", "*/*");
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setUseCaches(false);
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).setDoOutput(true);
        ((HttpURLConnection)Mockito.verify((Object)this.httpReq)).disconnect();
        ((OutputStream)Mockito.verify((Object)this.httpOut)).write((byte[])this.httpPayloadCaptor.capture());
        ((OutputStream)Mockito.verify((Object)this.httpOut)).flush();
        ((OutputStream)Mockito.verify((Object)this.httpOut)).close();
    }

    static {
        try {
            URL = new URL("http://fake:80");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static class ImmutableValue<T>
    implements Gauge<T> {
        private final T value;

        public ImmutableValue(T value) {
            this.value = value;
        }

        public T value(MetricConfig config, long now) {
            return this.value;
        }
    }
}

