/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.streams;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteStreamsGroupsOptions;
import org.apache.kafka.clients.admin.DeleteStreamsGroupsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeStreamsGroupsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.StreamsGroupDescription;
import org.apache.kafka.clients.admin.StreamsGroupMemberAssignment;
import org.apache.kafka.clients.admin.StreamsGroupMemberDescription;
import org.apache.kafka.clients.admin.StreamsGroupSubtopologyDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.streams.StreamsGroupCommand;
import org.apache.kafka.tools.streams.StreamsGroupCommandOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StreamsGroupCommandTest {
    @Test
    public void testListStreamsGroups() throws Exception {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--list"};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        ListGroupsResult result = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.completedFuture(Arrays.asList(new GroupListing(firstGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE)), new GroupListing(secondGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.EMPTY)))));
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)result);
        StreamsGroupCommand.StreamsGroupService service = this.getStreamsGroupService(cgcArgs, adminClient);
        HashSet<String> expectedGroups = new HashSet<String>(Arrays.asList(firstGroup, secondGroup));
        Set[] foundGroups = new Set[]{Set.of()};
        TestUtils.waitForCondition(() -> {
            foundGroups[0] = new HashSet(service.listStreamsGroups());
            return Objects.equals(expectedGroups, foundGroups[0]);
        }, (String)("Expected --list to show groups " + String.valueOf(expectedGroups) + ", but found " + String.valueOf(foundGroups[0]) + "."));
        service.close();
    }

    @Test
    public void testListWithUnrecognizedOption() {
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--frivolous-nonsense", "--bootstrap-server", bootstrapServer, "--list"};
        Exception exception = (Exception)Assertions.assertThrows(OptionException.class, () -> this.getStreamsGroupService(cgcArgs, (Admin)new MockAdminClient()));
        Assertions.assertEquals((Object)"frivolous-nonsense is not a recognized option", (Object)exception.getMessage());
    }

    @Test
    public void testListStreamsGroupsWithStates() throws Exception {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--list", "--state"};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        ListGroupsResult resultWithAllStates = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)resultWithAllStates.all()).thenReturn((Object)KafkaFuture.completedFuture(Arrays.asList(new GroupListing(firstGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE)), new GroupListing(secondGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.EMPTY)))));
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)resultWithAllStates);
        StreamsGroupCommand.StreamsGroupService service = this.getStreamsGroupService(cgcArgs, adminClient);
        HashSet<GroupListing> expectedListing = new HashSet<GroupListing>(Arrays.asList(new GroupListing(firstGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE)), new GroupListing(secondGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.EMPTY))));
        Set[] foundListing = new Set[]{Set.of()};
        TestUtils.waitForCondition(() -> {
            foundListing[0] = new HashSet(service.listStreamsGroupsInStates(new HashSet<GroupState>(Arrays.asList(GroupState.values()))));
            return Objects.equals(expectedListing, foundListing[0]);
        }, (String)("Expected to show groups " + String.valueOf(expectedListing) + ", but found " + String.valueOf(foundListing[0])));
        ListGroupsResult resultWithStableState = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)resultWithStableState.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of(new GroupListing(firstGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE)))));
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)resultWithStableState);
        Set<GroupListing> expectedListingStable = Set.of(new GroupListing(firstGroup, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE)));
        foundListing[0] = Set.of();
        TestUtils.waitForCondition(() -> {
            foundListing[0] = new HashSet(service.listStreamsGroupsInStates(Set.of(GroupState.STABLE)));
            return Objects.equals(expectedListingStable, foundListing[0]);
        }, (String)("Expected to show groups " + String.valueOf(expectedListingStable) + ", but found " + String.valueOf(foundListing[0])));
        service.close();
    }

    @Test
    public void testDescribeStreamsGroups() throws Exception {
        String firstGroup = "group1";
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DescribeStreamsGroupsResult result = (DescribeStreamsGroupsResult)Mockito.mock(DescribeStreamsGroupsResult.class);
        HashMap<String, StreamsGroupDescription> resultMap = new HashMap<String, StreamsGroupDescription>();
        StreamsGroupDescription exp = new StreamsGroupDescription(firstGroup, 0, 0, 0, List.of(new StreamsGroupSubtopologyDescription("foo", List.of(), List.of(), Map.of(), Map.of())), List.of(), GroupState.STABLE, new Node(0, "bar", 0), null);
        resultMap.put(firstGroup, exp);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.completedFuture(resultMap));
        Mockito.when((Object)adminClient.describeStreamsGroups(ArgumentMatchers.anyCollection())).thenReturn((Object)result);
        StreamsGroupCommand.StreamsGroupService service = new StreamsGroupCommand.StreamsGroupService(null, adminClient);
        Assertions.assertEquals((Object)exp, (Object)service.getDescribeGroup(firstGroup));
        service.close();
    }

    @Test
    public void testDescribeStreamsGroupsGetOffsets() throws Exception {
        String groupId = "group1";
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        ListOffsetsResult startOffset = (ListOffsetsResult)Mockito.mock(ListOffsetsResult.class);
        HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> startOffsetResultMap = new HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>();
        startOffsetResultMap.put(new TopicPartition("topic1", 0), new ListOffsetsResult.ListOffsetsResultInfo(10L, -1L, Optional.empty()));
        ListOffsetsResult endOffset = (ListOffsetsResult)Mockito.mock(ListOffsetsResult.class);
        HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> endOffsetResultMap = new HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>();
        endOffsetResultMap.put(new TopicPartition("topic1", 0), new ListOffsetsResult.ListOffsetsResultInfo(30L, -1L, Optional.empty()));
        Mockito.when((Object)startOffset.all()).thenReturn((Object)KafkaFuture.completedFuture(startOffsetResultMap));
        Mockito.when((Object)endOffset.all()).thenReturn((Object)KafkaFuture.completedFuture(endOffsetResultMap));
        Mockito.when((Object)adminClient.listOffsets(ArgumentMatchers.anyMap())).thenReturn((Object)startOffset, (Object[])new ListOffsetsResult[]{endOffset});
        ListStreamsGroupOffsetsResult result = (ListStreamsGroupOffsetsResult)Mockito.mock(ListStreamsGroupOffsetsResult.class);
        HashMap<TopicPartition, OffsetAndMetadata> committedOffsetsMap = new HashMap<TopicPartition, OffsetAndMetadata>();
        committedOffsetsMap.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(12L, Optional.of(0), ""));
        Mockito.when((Object)adminClient.listStreamsGroupOffsets(ArgumentMatchers.anyMap())).thenReturn((Object)result);
        Mockito.when((Object)result.partitionsToOffsetAndMetadata(ArgumentMatchers.anyString())).thenReturn((Object)KafkaFuture.completedFuture(committedOffsetsMap));
        StreamsGroupMemberDescription description = new StreamsGroupMemberDescription("foo", 0, Optional.empty(), Optional.empty(), "bar", "baz", 0, "qux", Optional.empty(), Map.of(), List.of(), List.of(), new StreamsGroupMemberAssignment(List.of(), List.of(), List.of()), new StreamsGroupMemberAssignment(List.of(), List.of(), List.of()), false);
        StreamsGroupDescription x = new StreamsGroupDescription("group1", 0, 0, 0, List.of(new StreamsGroupSubtopologyDescription("id", List.of("topic1"), List.of(), Map.of(), Map.of())), List.of(description), GroupState.STABLE, new Node(0, "host", 0), null);
        DescribeStreamsGroupsResult describeStreamsGroupsResult = (DescribeStreamsGroupsResult)Mockito.mock(DescribeStreamsGroupsResult.class);
        Mockito.when((Object)describeStreamsGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(Map.of(groupId, x)));
        Mockito.when((Object)adminClient.describeStreamsGroups(List.of(groupId))).thenReturn((Object)describeStreamsGroupsResult);
        StreamsGroupCommand.StreamsGroupService service = new StreamsGroupCommand.StreamsGroupService(null, adminClient);
        Map lags = service.getOffsets(x);
        Assertions.assertEquals((int)1, (int)lags.size());
        Assertions.assertEquals((Object)new StreamsGroupCommand.OffsetsInfo(Optional.of(12L), Optional.of(0), Long.valueOf(30L), Long.valueOf(18L)), lags.get(new TopicPartition("topic1", 0)));
        service.close();
    }

    @Test
    public void testPrintEmptyGroupState() {
        Assertions.assertFalse((boolean)StreamsGroupCommand.StreamsGroupService.isGroupStateValid((GroupState)GroupState.EMPTY, (int)0));
        Assertions.assertFalse((boolean)StreamsGroupCommand.StreamsGroupService.isGroupStateValid((GroupState)GroupState.DEAD, (int)0));
        Assertions.assertFalse((boolean)StreamsGroupCommand.StreamsGroupService.isGroupStateValid((GroupState)GroupState.STABLE, (int)0));
        Assertions.assertTrue((boolean)StreamsGroupCommand.StreamsGroupService.isGroupStateValid((GroupState)GroupState.STABLE, (int)1));
        Assertions.assertTrue((boolean)StreamsGroupCommand.StreamsGroupService.isGroupStateValid((GroupState)GroupState.UNKNOWN, (int)1));
    }

    @Test
    public void testRetrieveInternalTopics() {
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        String groupId = "foo-group";
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--bootstrap-server", "localhost:9092", "--group", groupId, "--delete"));
        List<String> sourceTopics = List.of("source-topic1", "source-topic2");
        List<String> repartitionSinkTopics = List.of("rep-sink-topic1", "rep-sink-topic2");
        Map<CallSite, StreamsGroupSubtopologyDescription.TopicInfo> stateChangelogTopics = Map.of(groupId + "-1-changelog", (StreamsGroupSubtopologyDescription.TopicInfo)Mockito.mock(StreamsGroupSubtopologyDescription.TopicInfo.class), "some-pre-fix-changelog", (StreamsGroupSubtopologyDescription.TopicInfo)Mockito.mock(StreamsGroupSubtopologyDescription.TopicInfo.class), groupId + "-2-changelog", (StreamsGroupSubtopologyDescription.TopicInfo)Mockito.mock(StreamsGroupSubtopologyDescription.TopicInfo.class));
        Map<CallSite, StreamsGroupSubtopologyDescription.TopicInfo> repartitionSourceTopics = Map.of(groupId + "-1-repartition", (StreamsGroupSubtopologyDescription.TopicInfo)Mockito.mock(StreamsGroupSubtopologyDescription.TopicInfo.class), groupId + "-some-thing", (StreamsGroupSubtopologyDescription.TopicInfo)Mockito.mock(StreamsGroupSubtopologyDescription.TopicInfo.class), groupId + "-2-repartition", (StreamsGroupSubtopologyDescription.TopicInfo)Mockito.mock(StreamsGroupSubtopologyDescription.TopicInfo.class));
        HashMap<String, StreamsGroupDescription> resultMap = new HashMap<String, StreamsGroupDescription>();
        resultMap.put(groupId, new StreamsGroupDescription(groupId, 0, 0, 0, List.of(new StreamsGroupSubtopologyDescription("subtopology1", sourceTopics, repartitionSinkTopics, stateChangelogTopics, repartitionSourceTopics)), List.of(), GroupState.DEAD, new Node(0, "localhost", 9092), null));
        DescribeStreamsGroupsResult result = (DescribeStreamsGroupsResult)Mockito.mock(DescribeStreamsGroupsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.completedFuture(resultMap));
        Mockito.when((Object)adminClient.describeStreamsGroups(ArgumentMatchers.anyCollection())).thenReturn((Object)result);
        StreamsGroupCommand.StreamsGroupService service = this.getStreamsGroupService(args.toArray(new String[0]), adminClient);
        Map internalTopics = service.retrieveInternalTopics(List.of(groupId));
        Assertions.assertNotNull(internalTopics.get(groupId));
        Assertions.assertEquals((int)4, (int)((List)internalTopics.get(groupId)).size());
        Assertions.assertEquals(new HashSet<CallSite>(List.of(groupId + "-1-changelog", groupId + "-2-changelog", groupId + "-1-repartition", groupId + "-2-repartition")), new HashSet((Collection)internalTopics.get(groupId)));
        Assertions.assertFalse((boolean)((List)internalTopics.get(groupId)).stream().anyMatch(List.of("some-pre-fix-changelog", groupId + "-some-thing")::contains));
        Assertions.assertFalse((boolean)((List)internalTopics.get(groupId)).stream().anyMatch(sourceTopics::contains));
        Assertions.assertFalse((boolean)((List)internalTopics.get(groupId)).stream().anyMatch(repartitionSinkTopics::contains));
        service.close();
    }

    @Test
    public void testDeleteStreamsGroup() {
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        String groupId = "foo-group";
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--bootstrap-server", "localhost:9092", "--group", groupId, "--delete"));
        DeleteStreamsGroupsResult deleteStreamsGroupsResult = (DeleteStreamsGroupsResult)Mockito.mock(DeleteStreamsGroupsResult.class);
        Mockito.when((Object)adminClient.deleteStreamsGroups((Collection)ArgumentMatchers.eq(List.of(groupId)), (DeleteStreamsGroupsOptions)ArgumentMatchers.any(DeleteStreamsGroupsOptions.class))).thenReturn((Object)deleteStreamsGroupsResult);
        Mockito.when((Object)deleteStreamsGroupsResult.deletedGroups()).thenReturn(Map.of(groupId, KafkaFuture.completedFuture(null)));
        DeleteTopicsResult deleteTopicsResult = (DeleteTopicsResult)Mockito.mock(DeleteTopicsResult.class);
        Mockito.when((Object)deleteTopicsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(null));
        Mockito.when((Object)adminClient.deleteTopics(ArgumentMatchers.anyCollection())).thenReturn((Object)deleteTopicsResult);
        DescribeStreamsGroupsResult describeStreamsGroupsResult = (DescribeStreamsGroupsResult)Mockito.mock(DescribeStreamsGroupsResult.class);
        Mockito.when((Object)describeStreamsGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(Map.of(groupId, (StreamsGroupDescription)Mockito.mock(StreamsGroupDescription.class))));
        Mockito.when((Object)adminClient.describeStreamsGroups((Collection)ArgumentMatchers.any())).thenReturn((Object)describeStreamsGroupsResult);
        ListGroupsResult listGroupsResult = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)listGroupsResult);
        Mockito.when((Object)listGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of(new GroupListing(groupId, Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.EMPTY)))));
        StreamsGroupCommand.StreamsGroupService service = this.getStreamsGroupService(args.toArray(new String[0]), adminClient);
        service.deleteGroups();
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).deleteStreamsGroups((Collection)ArgumentMatchers.eq(List.of(groupId)), (DeleteStreamsGroupsOptions)ArgumentMatchers.any(DeleteStreamsGroupsOptions.class));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).describeStreamsGroups((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)0))).deleteTopics(ArgumentMatchers.anyCollection());
        service.close();
    }

    @Test
    public void testDeleteNonStreamsGroup() {
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        String groupId = "foo-group";
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--bootstrap-server", "localhost:9092", "--group", groupId, "--delete"));
        ListGroupsResult listGroupsResult = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)listGroupsResult);
        Mockito.when((Object)listGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of()));
        StreamsGroupCommand.StreamsGroupService service = this.getStreamsGroupService(args.toArray(new String[0]), adminClient);
        Map result = service.deleteGroups();
        Assertions.assertNotNull(result.get(groupId));
        Assertions.assertEquals((Object)((Throwable)result.get(groupId)).getMessage(), (Object)("Group '" + groupId + "' does not exist or is not a streams group."));
        Assertions.assertInstanceOf(IllegalArgumentException.class, result.get(groupId));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)0))).deleteStreamsGroups((Collection)ArgumentMatchers.eq(List.of(groupId)), (DeleteStreamsGroupsOptions)ArgumentMatchers.any(DeleteStreamsGroupsOptions.class));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)0))).describeStreamsGroups((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)0))).deleteTopics(ArgumentMatchers.anyCollection());
        service.close();
    }

    @Test
    public void testGroupStatesFromString() {
        Set result = StreamsGroupCommand.groupStatesFromString((String)"empty");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.EMPTY)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"EMPTY");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.EMPTY)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"notready");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.NOT_READY)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"notReady");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.NOT_READY)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"assigning");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.ASSIGNING)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"ASSIGNING");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.ASSIGNING)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"RECONCILING");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.RECONCILING)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"reconCILING");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.RECONCILING)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"STABLE");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.STABLE)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"stable");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.STABLE)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"DEAD");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.DEAD)), (Object)result);
        result = StreamsGroupCommand.groupStatesFromString((String)"dead");
        Assertions.assertEquals(new HashSet<GroupState>(List.of(GroupState.DEAD)), (Object)result);
        StreamsGroupCommandTest.assertThrow("preparingRebalance");
        StreamsGroupCommandTest.assertThrow("completingRebalance");
        StreamsGroupCommandTest.assertThrow("bad, wrong");
        StreamsGroupCommandTest.assertThrow("  bad, Stable");
        StreamsGroupCommandTest.assertThrow("   ,   ,");
    }

    StreamsGroupCommand.StreamsGroupService getStreamsGroupService(String[] args, Admin adminClient) {
        StreamsGroupCommandOptions opts = new StreamsGroupCommandOptions(args);
        return new StreamsGroupCommand.StreamsGroupService(opts, adminClient);
    }

    private static void assertThrow(String wrongState) {
        HashSet<String> validStates = new HashSet<String>(Arrays.asList("Assigning", "Dead", "Empty", "Reconciling", "Stable", "NotReady"));
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> StreamsGroupCommand.groupStatesFromString((String)wrongState));
        Assertions.assertTrue((boolean)exception.getMessage().contains(" Valid states are: "));
        String[] exceptionMessage = exception.getMessage().split(" Valid states are: ");
        Assertions.assertEquals((Object)("Invalid state list '" + wrongState + "'."), (Object)exceptionMessage[0]);
        Assertions.assertEquals(Arrays.stream(exceptionMessage[1].split(",")).map(String::trim).collect(Collectors.toSet()), validStates);
    }
}

