/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.reassign;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.tools.AdminCommandFailedException;
import org.apache.kafka.tools.AdminOperationException;
import org.apache.kafka.tools.reassign.ActiveMoveState;
import org.apache.kafka.tools.reassign.CancelledMoveState;
import org.apache.kafka.tools.reassign.CompletedMoveState;
import org.apache.kafka.tools.reassign.MissingLogDirMoveState;
import org.apache.kafka.tools.reassign.MissingReplicaMoveState;
import org.apache.kafka.tools.reassign.PartitionMove;
import org.apache.kafka.tools.reassign.PartitionReassignmentState;
import org.apache.kafka.tools.reassign.ReassignPartitionsCommand;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class ReassignPartitionsUnitTest {
    @BeforeAll
    public static void setUp() {
        Exit.setExitProcedure((statusCode, message) -> {
            throw new IllegalArgumentException(message);
        });
    }

    @AfterAll
    public static void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testCompareTopicPartitions() {
        Assertions.assertTrue((ReassignPartitionsCommand.compareTopicPartitions((TopicPartition)new TopicPartition("abc", 0), (TopicPartition)new TopicPartition("abc", 1)) < 0 ? 1 : 0) != 0);
        Assertions.assertFalse((ReassignPartitionsCommand.compareTopicPartitions((TopicPartition)new TopicPartition("def", 0), (TopicPartition)new TopicPartition("abc", 1)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTopicPartitionReplicas() {
        Assertions.assertTrue((ReassignPartitionsCommand.compareTopicPartitionReplicas((TopicPartitionReplica)new TopicPartitionReplica("def", 0, 0), (TopicPartitionReplica)new TopicPartitionReplica("abc", 0, 1)) < 0 ? 1 : 0) != 0);
        Assertions.assertFalse((ReassignPartitionsCommand.compareTopicPartitionReplicas((TopicPartitionReplica)new TopicPartitionReplica("def", 0, 0), (TopicPartitionReplica)new TopicPartitionReplica("cde", 0, 0)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignStatesToString() {
        HashMap<TopicPartition, PartitionReassignmentState> states = new HashMap<TopicPartition, PartitionReassignmentState>();
        states.put(new TopicPartition("foo", 0), new PartitionReassignmentState(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3), true));
        states.put(new TopicPartition("foo", 1), new PartitionReassignmentState(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 4), false));
        states.put(new TopicPartition("bar", 0), new PartitionReassignmentState(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 4), false));
        Assertions.assertEquals((Object)String.join((CharSequence)System.lineSeparator(), "Status of partition reassignment:", "Reassignment of partition bar-0 is still in progress.", "Reassignment of partition foo-0 is completed.", "Reassignment of partition foo-1 is still in progress."), (Object)ReassignPartitionsCommand.partitionReassignmentStatesToString(states));
    }

    private void addTopics(MockAdminClient adminClient) {
        List b = adminClient.brokers();
        adminClient.addTopic(false, "foo", Arrays.asList(new TopicPartitionInfo(0, (Node)b.get(0), Arrays.asList((Node)b.get(0), (Node)b.get(1), (Node)b.get(2)), Arrays.asList((Node)b.get(0), (Node)b.get(1))), new TopicPartitionInfo(1, (Node)b.get(1), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)))), Collections.emptyMap());
        adminClient.addTopic(false, "bar", Arrays.asList(new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Node)b.get(2), (Node)b.get(3), (Node)b.get(0)), Arrays.asList((Node)b.get(2), (Node)b.get(3), (Node)b.get(0)))), Collections.emptyMap());
    }

    @Test
    public void testFindPartitionReassignmentStates() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            HashMap<TopicPartition, List<Integer>> reassignments = new HashMap<TopicPartition, List<Integer>>();
            reassignments.put(new TopicPartition("foo", 0), Arrays.asList(0, 1, 3));
            reassignments.put(new TopicPartition("quux", 0), Arrays.asList(1, 2, 3));
            Map reassignmentResult = ReassignPartitionsCommand.alterPartitionReassignments((Admin)adminClient, reassignments, (boolean)false);
            Assertions.assertEquals((int)1, (int)reassignmentResult.size());
            Assertions.assertEquals(UnknownTopicOrPartitionException.class, ((Throwable)reassignmentResult.get(new TopicPartition("quux", 0))).getClass());
            HashMap<TopicPartition, PartitionReassignmentState> expStates = new HashMap<TopicPartition, PartitionReassignmentState>();
            expStates.put(new TopicPartition("foo", 0), new PartitionReassignmentState(Arrays.asList(0, 1, 2), Arrays.asList(0, 1, 3), false));
            expStates.put(new TopicPartition("foo", 1), new PartitionReassignmentState(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3), true));
            Map.Entry actual = ReassignPartitionsCommand.findPartitionReassignmentStates((Admin)adminClient, Arrays.asList(new AbstractMap.SimpleImmutableEntry<TopicPartition, List<Integer>>(new TopicPartition("foo", 0), Arrays.asList(0, 1, 3)), new AbstractMap.SimpleImmutableEntry<TopicPartition, List<Integer>>(new TopicPartition("foo", 1), Arrays.asList(1, 2, 3))));
            Assertions.assertEquals(expStates, actual.getKey());
            Assertions.assertTrue((boolean)((Boolean)actual.getValue()));
            Map cancelResult = ReassignPartitionsCommand.cancelPartitionReassignments((Admin)adminClient, new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("quux", 2))));
            Assertions.assertEquals((int)1, (int)cancelResult.size());
            Assertions.assertEquals(UnknownTopicOrPartitionException.class, ((Throwable)cancelResult.get(new TopicPartition("quux", 2))).getClass());
            expStates.clear();
            expStates.put(new TopicPartition("foo", 0), new PartitionReassignmentState(Arrays.asList(0, 1, 2), Arrays.asList(0, 1, 3), true));
            expStates.put(new TopicPartition("foo", 1), new PartitionReassignmentState(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3), true));
            actual = ReassignPartitionsCommand.findPartitionReassignmentStates((Admin)adminClient, Arrays.asList(new AbstractMap.SimpleImmutableEntry<TopicPartition, List<Integer>>(new TopicPartition("foo", 0), Arrays.asList(0, 1, 3)), new AbstractMap.SimpleImmutableEntry<TopicPartition, List<Integer>>(new TopicPartition("foo", 1), Arrays.asList(1, 2, 3))));
            Assertions.assertEquals(expStates, actual.getKey());
            Assertions.assertFalse((boolean)((Boolean)actual.getValue()));
        }
    }

    @Test
    public void testFindLogDirMoveStates() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Arrays.asList(Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"), Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"), Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"), Arrays.asList("/tmp/kafka-logs0", null))).build();){
            this.addTopics(adminClient);
            List b = adminClient.brokers();
            adminClient.addTopic(false, "quux", Arrays.asList(new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)))), Collections.emptyMap());
            HashMap<TopicPartitionReplica, String> replicaAssignment = new HashMap<TopicPartitionReplica, String>();
            replicaAssignment.put(new TopicPartitionReplica("foo", 0, 0), "/tmp/kafka-logs1");
            replicaAssignment.put(new TopicPartitionReplica("quux", 0, 0), "/tmp/kafka-logs1");
            adminClient.alterReplicaLogDirs(replicaAssignment).all().get();
            HashMap<TopicPartitionReplica, Object> states = new HashMap<TopicPartitionReplica, Object>();
            states.put(new TopicPartitionReplica("bar", 0, 0), new CompletedMoveState("/tmp/kafka-logs0"));
            states.put(new TopicPartitionReplica("foo", 0, 0), new ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1"));
            states.put(new TopicPartitionReplica("foo", 1, 0), new CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1"));
            states.put(new TopicPartitionReplica("quux", 1, 0), new MissingLogDirMoveState("/tmp/kafka-logs1"));
            states.put(new TopicPartitionReplica("quuz", 0, 0), new MissingReplicaMoveState("/tmp/kafka-logs0"));
            HashMap<TopicPartitionReplica, String> targetMoves = new HashMap<TopicPartitionReplica, String>();
            targetMoves.put(new TopicPartitionReplica("bar", 0, 0), "/tmp/kafka-logs0");
            targetMoves.put(new TopicPartitionReplica("foo", 0, 0), "/tmp/kafka-logs1");
            targetMoves.put(new TopicPartitionReplica("foo", 1, 0), "/tmp/kafka-logs1");
            targetMoves.put(new TopicPartitionReplica("quux", 1, 0), "/tmp/kafka-logs1");
            targetMoves.put(new TopicPartitionReplica("quuz", 0, 0), "/tmp/kafka-logs0");
            Assertions.assertEquals(states, (Object)ReassignPartitionsCommand.findLogDirMoveStates((Admin)adminClient, targetMoves));
        }
    }

    @Test
    public void testReplicaMoveStatesToString() {
        HashMap<TopicPartitionReplica, Object> states = new HashMap<TopicPartitionReplica, Object>();
        states.put(new TopicPartitionReplica("bar", 0, 0), new CompletedMoveState("/tmp/kafka-logs0"));
        states.put(new TopicPartitionReplica("foo", 0, 0), new ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1"));
        states.put(new TopicPartitionReplica("foo", 1, 0), new CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1"));
        states.put(new TopicPartitionReplica("quux", 0, 0), new MissingReplicaMoveState("/tmp/kafka-logs1"));
        states.put(new TopicPartitionReplica("quux", 1, 1), new ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs2"));
        states.put(new TopicPartitionReplica("quux", 2, 1), new MissingLogDirMoveState("/tmp/kafka-logs1"));
        Assertions.assertEquals((Object)String.join((CharSequence)System.lineSeparator(), "Reassignment of replica bar-0-0 completed successfully.", "Reassignment of replica foo-0-0 is still in progress.", "Partition foo-1 on broker 0 is not being moved from log dir /tmp/kafka-logs0 to /tmp/kafka-logs1.", "Partition quux-0 cannot be found in any live log directory on broker 0.", "Partition quux-1 on broker 1 is being moved to log dir /tmp/kafka-logs2 instead of /tmp/kafka-logs1.", "Partition quux-2 is not found in any live log dir on broker 1. There is likely an offline log directory on the broker."), (Object)ReassignPartitionsCommand.replicaMoveStatesToString(states));
    }

    @Test
    public void testGetReplicaAssignments() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            HashMap<TopicPartition, List<Integer>> assignments = new HashMap<TopicPartition, List<Integer>>();
            assignments.put(new TopicPartition("foo", 0), Arrays.asList(0, 1, 2));
            assignments.put(new TopicPartition("foo", 1), Arrays.asList(1, 2, 3));
            Assertions.assertEquals(assignments, (Object)ReassignPartitionsCommand.getReplicaAssignmentForTopics((Admin)adminClient, Arrays.asList("foo")));
            assignments.clear();
            assignments.put(new TopicPartition("foo", 0), Arrays.asList(0, 1, 2));
            assignments.put(new TopicPartition("bar", 0), Arrays.asList(2, 3, 0));
            Assertions.assertEquals(assignments, (Object)ReassignPartitionsCommand.getReplicaAssignmentForPartitions((Admin)adminClient, new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0)))));
            UnknownTopicOrPartitionException exception = (UnknownTopicOrPartitionException)Assertions.assertInstanceOf(UnknownTopicOrPartitionException.class, (Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand.getReplicaAssignmentForPartitions((Admin)adminClient, new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("foo", 10)))))).getCause());
            Assertions.assertEquals((Object)"Unable to find partition: foo-10", (Object)exception.getMessage());
        }
    }

    @Test
    public void testGetBrokerRackInformation() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList(new Node(0, "localhost", 9092, "rack0"), new Node(1, "localhost", 9093, "rack1"), new Node(2, "localhost", 9094, null))).build();){
            Assertions.assertEquals(Arrays.asList(new UsableBroker(0, Optional.of("rack0"), false), new UsableBroker(1, Optional.of("rack1"), false)), (Object)ReassignPartitionsCommand.getBrokerMetadata((Admin)adminClient, Arrays.asList(0, 1), (boolean)true));
            Assertions.assertEquals(Arrays.asList(new UsableBroker(0, Optional.empty(), false), new UsableBroker(1, Optional.empty(), false)), (Object)ReassignPartitionsCommand.getBrokerMetadata((Admin)adminClient, Arrays.asList(0, 1), (boolean)false));
            this.assertStartsWith("Not all brokers have rack information", ((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand.getBrokerMetadata((Admin)adminClient, Arrays.asList(1, 2), (boolean)true))).getMessage());
            Assertions.assertEquals(Arrays.asList(new UsableBroker(1, Optional.empty(), false), new UsableBroker(2, Optional.empty(), false)), (Object)ReassignPartitionsCommand.getBrokerMetadata((Admin)adminClient, Arrays.asList(1, 2), (boolean)false));
        }
    }

    @Test
    public void testParseGenerateAssignmentArgs() throws Exception {
        this.assertStartsWith("Broker list contains duplicate entries", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseGenerateAssignmentArgs((String)"{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", (String)"1,1,2"), (String)"Expected to detect duplicate broker list entries")).getMessage());
        this.assertStartsWith("Broker list contains duplicate entries", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseGenerateAssignmentArgs((String)"{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", (String)"5,2,3,4,5"), (String)"Expected to detect duplicate broker list entries")).getMessage());
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<List<Integer>, List<String>>(Arrays.asList(5, 2, 3, 4), Arrays.asList("foo")), (Object)ReassignPartitionsCommand.parseGenerateAssignmentArgs((String)"{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", (String)"5,2,3,4"));
        this.assertStartsWith("List of topics to reassign contains duplicate entries", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseGenerateAssignmentArgs((String)"{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"foo\"}], \"version\":1}", (String)"5,2,3,4"), (String)"Expected to detect duplicate topic entries")).getMessage());
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<List<Integer>, List<String>>(Arrays.asList(5, 3, 4), Arrays.asList("foo", "bar")), (Object)ReassignPartitionsCommand.parseGenerateAssignmentArgs((String)"{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"bar\"}], \"version\":1}", (String)"5,3,4"));
    }

    @Test
    public void testGenerateAssignmentFailsWithoutEnoughReplicas() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("The target replication factor of 3 cannot be reached because only 2 broker(s) are registered", ((InvalidReplicationFactorException)Assertions.assertThrows(InvalidReplicationFactorException.class, () -> ReassignPartitionsCommand.generateAssignment((Admin)adminClient, (String)"{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", (String)"0,1", (Boolean)false), (String)"Expected generateAssignment to fail")).getMessage());
        }
    }

    @Test
    public void testGenerateAssignmentWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand.generateAssignment((Admin)adminClient, (String)"{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"quux\"}]}", (String)"0,1", (Boolean)false), (String)"Expected generateAssignment to fail")).getCause().getMessage());
        }
    }

    @Test
    public void testGenerateAssignmentWithInconsistentRacks() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList(new Node(0, "localhost", 9092, "rack0"), new Node(1, "localhost", 9093, "rack0"), new Node(2, "localhost", 9094, null), new Node(3, "localhost", 9095, "rack1"), new Node(4, "localhost", 9096, "rack1"), new Node(5, "localhost", 9097, "rack2"))).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Not all brokers have rack information.", ((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand.generateAssignment((Admin)adminClient, (String)"{\"topics\":[{\"topic\":\"foo\"}]}", (String)"0,1,2,3", (Boolean)true), (String)"Expected generateAssignment to fail")).getMessage());
            Map.Entry proposedCurrent = ReassignPartitionsCommand.generateAssignment((Admin)adminClient, (String)"{\"topics\":[{\"topic\":\"foo\"}]}", (String)"0,1,2,3", (Boolean)false);
            HashMap<TopicPartition, List<Integer>> expCurrent = new HashMap<TopicPartition, List<Integer>>();
            expCurrent.put(new TopicPartition("foo", 0), Arrays.asList(0, 1, 2));
            expCurrent.put(new TopicPartition("foo", 1), Arrays.asList(1, 2, 3));
            Assertions.assertEquals(expCurrent, proposedCurrent.getValue());
        }
    }

    @Test
    public void testGenerateAssignmentWithFewerBrokers() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            List<Integer> goalBrokers = Arrays.asList(0, 1, 3);
            Map.Entry proposedCurrent = ReassignPartitionsCommand.generateAssignment((Admin)adminClient, (String)"{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", (String)goalBrokers.stream().map(Object::toString).collect(Collectors.joining(",")), (Boolean)false);
            HashMap<TopicPartition, List<Integer>> expCurrent = new HashMap<TopicPartition, List<Integer>>();
            expCurrent.put(new TopicPartition("foo", 0), Arrays.asList(0, 1, 2));
            expCurrent.put(new TopicPartition("foo", 1), Arrays.asList(1, 2, 3));
            expCurrent.put(new TopicPartition("bar", 0), Arrays.asList(2, 3, 0));
            Assertions.assertEquals(expCurrent, proposedCurrent.getValue());
            ((Map)proposedCurrent.getKey()).values().forEach(replicas -> Assertions.assertTrue((boolean)goalBrokers.containsAll((Collection<?>)replicas), (String)("Proposed assignment " + String.valueOf(proposedCurrent.getKey()) + " puts replicas on brokers other than " + String.valueOf(goalBrokers))));
        }
    }

    @Test
    public void testCurrentPartitionReplicaAssignmentToString() throws Exception {
        HashMap<TopicPartition, List<Integer>> proposedParts = new HashMap<TopicPartition, List<Integer>>();
        proposedParts.put(new TopicPartition("foo", 1), Arrays.asList(1, 2, 3));
        proposedParts.put(new TopicPartition("bar", 0), Arrays.asList(7, 8, 9));
        HashMap<TopicPartition, List<Integer>> currentParts = new HashMap<TopicPartition, List<Integer>>();
        currentParts.put(new TopicPartition("foo", 0), Arrays.asList(1, 2, 3));
        currentParts.put(new TopicPartition("foo", 1), Arrays.asList(4, 5, 6));
        currentParts.put(new TopicPartition("bar", 0), Arrays.asList(7, 8));
        currentParts.put(new TopicPartition("baz", 0), Arrays.asList(10, 11, 12));
        Assertions.assertEquals((Object)String.join((CharSequence)System.lineSeparator(), "Current partition replica assignment", "", "{\"version\":1,\"partitions\":[{\"topic\":\"bar\",\"partition\":0,\"replicas\":[7,8],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[4,5,6],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", "", "Save this to use as the --reassignment-json-file option during rollback"), (Object)ReassignPartitionsCommand.currentPartitionReplicaAssignmentToString(proposedParts, currentParts));
    }

    @Test
    public void testMoveMap() {
        HashMap<TopicPartition, PartitionReassignment> currentReassignments = new HashMap<TopicPartition, PartitionReassignment>();
        currentReassignments.put(new TopicPartition("foo", 0), new PartitionReassignment(Arrays.asList(1, 2, 3, 4), Arrays.asList(4), Arrays.asList(3)));
        currentReassignments.put(new TopicPartition("foo", 1), new PartitionReassignment(Arrays.asList(4, 5, 6, 7, 8), Arrays.asList(7, 8), Arrays.asList(4, 5)));
        currentReassignments.put(new TopicPartition("foo", 2), new PartitionReassignment(Arrays.asList(1, 2, 3, 4), Arrays.asList(3, 4), Arrays.asList(1, 2)));
        currentReassignments.put(new TopicPartition("foo", 3), new PartitionReassignment(Arrays.asList(1, 2, 3, 4), Arrays.asList(3, 4), Arrays.asList(1, 2)));
        currentReassignments.put(new TopicPartition("foo", 4), new PartitionReassignment(Arrays.asList(1, 2, 3, 4), Arrays.asList(3, 4), Arrays.asList(1, 2)));
        currentReassignments.put(new TopicPartition("foo", 5), new PartitionReassignment(Arrays.asList(1, 2, 3, 4), Arrays.asList(3, 4), Arrays.asList(1, 2)));
        HashMap<TopicPartition, List<Integer>> proposedParts = new HashMap<TopicPartition, List<Integer>>();
        proposedParts.put(new TopicPartition("foo", 0), Arrays.asList(1, 2, 5));
        proposedParts.put(new TopicPartition("foo", 2), Arrays.asList(3, 4));
        proposedParts.put(new TopicPartition("foo", 3), Arrays.asList(5, 6));
        proposedParts.put(new TopicPartition("foo", 4), Arrays.asList(3));
        proposedParts.put(new TopicPartition("foo", 5), Arrays.asList(3, 4, 5, 6));
        proposedParts.put(new TopicPartition("bar", 0), Arrays.asList(1, 2, 3));
        HashMap<TopicPartition, List<Integer>> currentParts = new HashMap<TopicPartition, List<Integer>>();
        currentParts.put(new TopicPartition("foo", 0), Arrays.asList(1, 2, 3, 4));
        currentParts.put(new TopicPartition("foo", 1), Arrays.asList(4, 5, 6, 7, 8));
        currentParts.put(new TopicPartition("foo", 2), Arrays.asList(1, 2, 3, 4));
        currentParts.put(new TopicPartition("foo", 3), Arrays.asList(1, 2, 3, 4));
        currentParts.put(new TopicPartition("foo", 4), Arrays.asList(1, 2, 3, 4));
        currentParts.put(new TopicPartition("foo", 5), Arrays.asList(1, 2, 3, 4));
        currentParts.put(new TopicPartition("bar", 0), Arrays.asList(2, 3, 4));
        currentParts.put(new TopicPartition("baz", 0), Arrays.asList(1, 2, 3));
        Map moveMap = ReassignPartitionsCommand.calculateProposedMoveMap(currentReassignments, proposedParts, currentParts);
        HashMap<Integer, PartitionMove> fooMoves = new HashMap<Integer, PartitionMove>();
        fooMoves.put(0, new PartitionMove(new HashSet<Integer>(Arrays.asList(1, 2, 3)), new HashSet<Integer>(Arrays.asList(5))));
        fooMoves.put(1, new PartitionMove(new HashSet<Integer>(Arrays.asList(4, 5, 6)), new HashSet<Integer>(Arrays.asList(7, 8))));
        fooMoves.put(2, new PartitionMove(new HashSet<Integer>(Arrays.asList(1, 2)), new HashSet<Integer>(Arrays.asList(3, 4))));
        fooMoves.put(3, new PartitionMove(new HashSet<Integer>(Arrays.asList(1, 2)), new HashSet<Integer>(Arrays.asList(5, 6))));
        fooMoves.put(4, new PartitionMove(new HashSet<Integer>(Arrays.asList(1, 2)), new HashSet<Integer>(Arrays.asList(3))));
        fooMoves.put(5, new PartitionMove(new HashSet<Integer>(Arrays.asList(1, 2)), new HashSet<Integer>(Arrays.asList(3, 4, 5, 6))));
        HashMap<Integer, PartitionMove> barMoves = new HashMap<Integer, PartitionMove>();
        barMoves.put(0, new PartitionMove(new HashSet<Integer>(Arrays.asList(2, 3, 4)), new HashSet<Integer>(Arrays.asList(1))));
        Assertions.assertEquals(fooMoves, moveMap.get("foo"));
        Assertions.assertEquals(barMoves, moveMap.get("bar"));
        HashMap<String, String> expLeaderThrottle = new HashMap<String, String>();
        expLeaderThrottle.put("foo", "0:1,0:2,0:3,1:4,1:5,1:6,2:1,2:2,3:1,3:2,4:1,4:2,5:1,5:2");
        expLeaderThrottle.put("bar", "0:2,0:3,0:4");
        Assertions.assertEquals(expLeaderThrottle, (Object)ReassignPartitionsCommand.calculateLeaderThrottles((Map)moveMap));
        HashMap<String, String> expFollowerThrottle = new HashMap<String, String>();
        expFollowerThrottle.put("foo", "0:5,1:7,1:8,2:3,2:4,3:5,3:6,4:3,5:3,5:4,5:5,5:6");
        expFollowerThrottle.put("bar", "0:1");
        Assertions.assertEquals(expFollowerThrottle, (Object)ReassignPartitionsCommand.calculateFollowerThrottles((Map)moveMap));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8)), (Object)ReassignPartitionsCommand.calculateReassigningBrokers((Map)moveMap));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 2)), (Object)ReassignPartitionsCommand.calculateMovingBrokers(new HashSet<TopicPartitionReplica>(Arrays.asList(new TopicPartitionReplica("quux", 0, 0), new TopicPartitionReplica("quux", 1, 2)))));
    }

    @Test
    public void testParseExecuteAssignmentArgs() throws Exception {
        this.assertStartsWith("Partition reassignment list cannot be empty", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseExecuteAssignmentArgs((String)"{\"version\":1,\"partitions\":[]}"), (String)"Expected to detect empty partition reassignment list")).getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseExecuteAssignmentArgs((String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"), (String)"Expected to detect a partition list with duplicate entries")).getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseExecuteAssignmentArgs((String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), (String)"Expected to detect a partition replica list with duplicate entries")).getMessage());
        this.assertStartsWith("Partition replica lists may not contain duplicate entries", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.parseExecuteAssignmentArgs((String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,0],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), (String)"Expected to detect a partition replica list with duplicate entries")).getMessage());
        HashMap<TopicPartition, List<Integer>> partitionsToBeReassigned = new HashMap<TopicPartition, List<Integer>>();
        partitionsToBeReassigned.put(new TopicPartition("foo", 0), Arrays.asList(1, 2, 3));
        partitionsToBeReassigned.put(new TopicPartition("foo", 1), Arrays.asList(3, 4, 5));
        Map.Entry actual = ReassignPartitionsCommand.parseExecuteAssignmentArgs((String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[3,4,5],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}");
        Assertions.assertEquals(partitionsToBeReassigned, actual.getKey());
        Assertions.assertTrue((boolean)((Map)actual.getValue()).isEmpty());
        HashMap<TopicPartitionReplica, String> replicaAssignment = new HashMap<TopicPartitionReplica, String>();
        replicaAssignment.put(new TopicPartitionReplica("foo", 0, 1), "/tmp/a");
        replicaAssignment.put(new TopicPartitionReplica("foo", 0, 2), "/tmp/b");
        replicaAssignment.put(new TopicPartitionReplica("foo", 0, 3), "/tmp/c");
        actual = ReassignPartitionsCommand.parseExecuteAssignmentArgs((String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"/tmp/a\",\"/tmp/b\",\"/tmp/c\"]}]}");
        Assertions.assertEquals(Collections.singletonMap(new TopicPartition("foo", 0), Arrays.asList(1, 2, 3)), actual.getKey());
        Assertions.assertEquals(replicaAssignment, actual.getValue());
    }

    @Test
    public void testExecuteWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand.executeAssignment((Admin)adminClient, (Boolean)false, (String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"quux\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", (Long)-1L, (Long)-1L, (Long)10000L, (Time)Time.SYSTEM, (boolean)false), (String)"Expected reassignment with non-existent topic to fail")).getCause().getMessage());
        }
    }

    @Test
    public void testExecuteWithInvalidBrokerIdFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unknown broker id 4", ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand.executeAssignment((Admin)adminClient, (Boolean)false, (String)"{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", (Long)-1L, (Long)-1L, (Long)10000L, (Time)Time.SYSTEM, (boolean)false), (String)"Expected reassignment with non-existent broker id to fail")).getMessage());
        }
    }

    @Test
    public void testModifyBrokerInterBrokerThrottle() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand.modifyInterBrokerThrottle((Admin)adminClient, new HashSet<Integer>(Arrays.asList(0, 1, 2)), (long)1000L);
            ReassignPartitionsCommand.modifyInterBrokerThrottle((Admin)adminClient, new HashSet<Integer>(Arrays.asList(0, 3)), (long)100L);
            ArrayList<ConfigResource> brokers = new ArrayList<ConfigResource>();
            for (int i = 0; i < 4; ++i) {
                brokers.add(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(i)));
            }
            Map results = (Map)adminClient.describeConfigs(brokers).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(0)), 100L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(1)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(2)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(3)), 100L, -1L);
        }
    }

    @Test
    public void testModifyLogDirThrottle() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand.modifyLogDirThrottle((Admin)adminClient, new HashSet<Integer>(Arrays.asList(0, 1, 2)), (long)2000L);
            ReassignPartitionsCommand.modifyLogDirThrottle((Admin)adminClient, new HashSet<Integer>(Arrays.asList(0, 3)), (long)-1L);
            ArrayList<ConfigResource> brokers = new ArrayList<ConfigResource>();
            for (int i = 0; i < 4; ++i) {
                brokers.add(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(i)));
            }
            Map results = (Map)adminClient.describeConfigs(brokers).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(0)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(1)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(2)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.get(3)), -1L, -1L);
        }
    }

    @Test
    public void testCurReassignmentsToString() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)"No partition reassignments found.", (Object)ReassignPartitionsCommand.curReassignmentsToString((Admin)adminClient));
            HashMap<TopicPartition, List<Integer>> reassignments = new HashMap<TopicPartition, List<Integer>>();
            reassignments.put(new TopicPartition("foo", 1), Arrays.asList(4, 5, 3));
            reassignments.put(new TopicPartition("foo", 0), Arrays.asList(0, 1, 4, 2));
            reassignments.put(new TopicPartition("bar", 0), Arrays.asList(2, 3));
            Map reassignmentResult = ReassignPartitionsCommand.alterPartitionReassignments((Admin)adminClient, reassignments, (boolean)false);
            Assertions.assertTrue((boolean)reassignmentResult.isEmpty());
            Assertions.assertEquals((Object)String.join((CharSequence)System.lineSeparator(), "Current partition reassignments:", "bar-0: replicas: 2,3,0. removing: 0.", "foo-0: replicas: 0,1,2. adding: 4.", "foo-1: replicas: 1,2,3. adding: 4,5. removing: 1,2."), (Object)ReassignPartitionsCommand.curReassignmentsToString((Admin)adminClient));
        }
    }

    private void verifyBrokerThrottleResults(Config config, long expectedInterBrokerThrottle, long expectedReplicaAlterLogDirsThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put(entry.name(), entry.value()));
        if (expectedInterBrokerThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrDefault("leader.replication.throttled.rate", ""));
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrDefault("follower.replication.throttled.rate", ""));
        }
        if (expectedReplicaAlterLogDirsThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedReplicaAlterLogDirsThrottle), (Object)configs.getOrDefault("replica.alter.log.dirs.io.max.bytes.per.second", ""));
        }
    }

    @Test
    public void testModifyTopicThrottles() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            HashMap<String, String> leaderThrottles = new HashMap<String, String>();
            leaderThrottles.put("foo", "leaderFoo");
            leaderThrottles.put("bar", "leaderBar");
            ReassignPartitionsCommand.modifyTopicThrottles((Admin)adminClient, leaderThrottles, Collections.singletonMap("bar", "followerBar"));
            List topics = Stream.of("bar", "foo").map(id -> new ConfigResource(ConfigResource.Type.TOPIC, id)).collect(Collectors.toList());
            Map results = (Map)adminClient.describeConfigs(topics).all().get();
            this.verifyTopicThrottleResults((Config)results.get(topics.get(0)), "leaderBar", "followerBar");
            this.verifyTopicThrottleResults((Config)results.get(topics.get(1)), "leaderFoo", "");
        }
    }

    private void verifyTopicThrottleResults(Config config, String expectedLeaderThrottle, String expectedFollowerThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put(entry.name(), entry.value()));
        Assertions.assertEquals((Object)expectedLeaderThrottle, (Object)configs.getOrDefault("leader.replication.throttled.replicas", ""));
        Assertions.assertEquals((Object)expectedFollowerThrottle, (Object)configs.getOrDefault("follower.replication.throttled.replicas", ""));
    }

    @Test
    public void testAlterReplicaLogDirs() throws Exception {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Collections.nCopies(4, Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"))).build();){
            this.addTopics(adminClient);
            HashMap<TopicPartitionReplica, String> assignment = new HashMap<TopicPartitionReplica, String>();
            assignment.put(new TopicPartitionReplica("foo", 0, 0), "/tmp/kafka-logs1");
            assignment.put(new TopicPartitionReplica("quux", 1, 0), "/tmp/kafka-logs1");
            Assertions.assertEquals(new HashSet<TopicPartitionReplica>(Arrays.asList(new TopicPartitionReplica("foo", 0, 0))), (Object)ReassignPartitionsCommand.alterReplicaLogDirs((Admin)adminClient, assignment));
        }
    }

    public void assertStartsWith(String prefix, String str) {
        Assertions.assertTrue((boolean)str.startsWith(prefix), (String)String.format("Expected the string to start with %s, but it was %s", prefix, str));
    }

    @Test
    public void testPropagateInvalidJsonError() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unexpected character", ((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand.executeAssignment((Admin)adminClient, (Boolean)false, (String)"{invalid_json", (Long)-1L, (Long)-1L, (Long)10000L, (Time)Time.SYSTEM, (boolean)false))).getMessage());
        }
    }
}

