/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.reassign;

import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.reassign.ReassignPartitionsCommand;
import org.apache.kafka.tools.reassign.ReassignPartitionsCommandOptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class ReassignPartitionsCommandArgsTest {
    public static final String MISSING_BOOTSTRAP_SERVER_MSG = "Please specify either --bootstrap-server or --bootstrap-controller";

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((statusCode, message) -> {
            throw new IllegalArgumentException(message);
        });
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void shouldUseDefaultsIfEnabled() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommandOptions opts = ReassignPartitionsCommand.validateAndParseArgs((String[])args);
        Assertions.assertEquals((long)10000L, (Long)((Long)opts.options.valueOf(opts.timeoutOpt)));
        Assertions.assertEquals((long)-1L, (Long)((Long)opts.options.valueOf(opts.interBrokerThrottleOpt)));
    }

    @Test
    public void testList() {
        String[] args = new String[]{"--list", "--bootstrap-server", "localhost:1234"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void testCancelWithPreserveThrottlesOption() {
        String[] args = new String[]{"--cancel", "--bootstrap-server", "localhost:1234", "--reassignment-json-file", "myfile.json", "--preserve-throttles"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = new String[]{};
        this.shouldFailWith("This tool helps to move topic partitions between replicas.", args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = new String[]{" "};
        this.shouldFailWith("Command must include exactly one action", args);
    }

    @Test
    public void shouldFailIfMultipleActions() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--verify", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Command must include exactly one action", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[topics-to-move-json-file]\" can't be used with action \"[execute]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokerList() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"};
        this.shouldFailWith("Option \"[broker-list]\" can't be used with action \"[execute]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--execute"};
        this.shouldFailWith("Missing required argument \"[reassignment-json-file]\"", args);
    }

    @Test
    public void testMissingBootstrapServerArgumentForExecute() {
        String[] args = new String[]{"--execute"};
        this.shouldFailWith(MISSING_BOOTSTRAP_SERVER_MSG, args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--generate"};
        this.shouldFailWith("Missing required argument \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"};
        this.shouldFailWith("Missing required argument \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--broker-list", "101,102", "--generate"};
        this.shouldFailWith("Missing required argument \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[throttle]\" can't be used with action \"[generate]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[reassignment-json-file]\" can't be used with action \"[generate]\"", args);
    }

    @Test
    public void shouldPrintHelpTextIfHelpArg() {
        String[] args = new String[]{"--help"};
        this.shouldFailWith("This tool helps to move topic partitions between replicas.", args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--verify"};
        this.shouldFailWith("Missing required argument \"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[broker-list]\" can't be used with action \"[verify]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[throttle]\" can't be used with action \"[verify]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[topics-to-move-json-file]\" can't be used with action \"[verify]\"", args);
    }

    private void shouldFailWith(String msg, String[] args) {
        Throwable e = Assertions.assertThrows(Exception.class, () -> ReassignPartitionsCommand.validateAndParseArgs((String[])args), () -> "Should have failed with [" + msg + "] but no failure occurred.");
        Assertions.assertTrue((boolean)e.getMessage().startsWith(msg), (String)("Expected exception with message:\n[" + msg + "]\nbut was\n[" + e.getMessage() + "]"));
    }

    @Test
    public void shouldNotAllowCancelWithoutBootstrapServerOption() {
        String[] args = new String[]{"--cancel"};
        this.shouldFailWith(MISSING_BOOTSTRAP_SERVER_MSG, args);
    }

    @Test
    public void shouldNotAllowCancelWithoutReassignmentJsonFile() {
        String[] args = new String[]{"--cancel", "--bootstrap-server", "localhost:1234", "--preserve-throttles"};
        this.shouldFailWith("Missing required argument \"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldAllowBootstrapControllerArg() {
        String[] args = new String[]{"--bootstrap-controller", "localhost:1234", "--cancel", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand.validateAndParseArgs((String[])args);
    }

    @Test
    public void shouldNotAllowBootstrapControllerArgWithUnsupportedAction() {
        String[] args = new String[]{"--bootstrap-controller", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[bootstrap-controller]\" can't be used with action \"[generate]", args);
    }

    @Test
    public void shouldNotAllowBootstrapControllerAndBootstrapServerArg() {
        String[] args = new String[]{"--bootstrap-server", "localhost:1234", "--bootstrap-controller", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Please don't specify both --bootstrap-server and --bootstrap-controller", args);
    }
}

