/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.filter;

import org.apache.kafka.tools.filter.TopicFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicFilterTest {
    @Test
    public void testIncludeLists() {
        TopicFilter.IncludeList topicFilter1 = new TopicFilter.IncludeList("yes1,yes2");
        Assertions.assertTrue((boolean)topicFilter1.isTopicAllowed("yes2", true));
        Assertions.assertTrue((boolean)topicFilter1.isTopicAllowed("yes2", false));
        Assertions.assertFalse((boolean)topicFilter1.isTopicAllowed("no1", true));
        Assertions.assertFalse((boolean)topicFilter1.isTopicAllowed("no1", false));
        TopicFilter.IncludeList topicFilter2 = new TopicFilter.IncludeList(".+");
        Assertions.assertTrue((boolean)topicFilter2.isTopicAllowed("alltopics", true));
        Assertions.assertFalse((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", true));
        Assertions.assertTrue((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", false));
        Assertions.assertFalse((boolean)topicFilter2.isTopicAllowed("__transaction_state", true));
        Assertions.assertTrue((boolean)topicFilter2.isTopicAllowed("__transaction_state", false));
        TopicFilter.IncludeList topicFilter3 = new TopicFilter.IncludeList("included-topic.+");
        Assertions.assertTrue((boolean)topicFilter3.isTopicAllowed("included-topic1", true));
        Assertions.assertFalse((boolean)topicFilter3.isTopicAllowed("no1", true));
        TopicFilter.IncludeList topicFilter4 = new TopicFilter.IncludeList("test-(?!bad\\b)[\\w]+");
        Assertions.assertTrue((boolean)topicFilter4.isTopicAllowed("test-good", true));
        Assertions.assertFalse((boolean)topicFilter4.isTopicAllowed("test-bad", true));
    }
}

