/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group.share;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.coordinator.share.ShareGroupOffset;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatterTest;
import org.apache.kafka.tools.consumer.group.share.ShareGroupStateMessageFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ShareGroupStateMessageFormatterTest
extends CoordinatorRecordMessageFormatterTest {
    private static final SharePartitionKey KEY_1 = SharePartitionKey.getInstance((String)"gs1", (Uuid)Uuid.fromString((String)"gtb2stGYRk-vWZ2zAozmoA"), (int)0);
    private static final ShareGroupOffset SHARE_GROUP_OFFSET_1 = new ShareGroupOffset.Builder().setSnapshotEpoch(0).setStateEpoch(1).setLeaderEpoch(20).setStartOffset(50L).setStateBatches(Arrays.asList(new PersisterStateBatch(100L, 200L, 1, 10), new PersisterStateBatch(201L, 210L, 2, 10))).build();
    private static final SharePartitionKey KEY_2 = SharePartitionKey.getInstance((String)"gs2", (Uuid)Uuid.fromString((String)"r9Nq4xGAQf28jvu36t7gQQ"), (int)0);
    private static final ShareGroupOffset SHARE_GROUP_OFFSET_2 = new ShareGroupOffset.Builder().setSnapshotEpoch(1).setStateEpoch(3).setLeaderEpoch(25).setStartOffset(55L).setStateBatches(Arrays.asList(new PersisterStateBatch(100L, 150L, 1, 12), new PersisterStateBatch(151L, 200L, 2, 15))).build();
    private static final ShareSnapshotKey SHARE_SNAPSHOT_KEY = new ShareSnapshotKey().setGroupId(KEY_1.groupId()).setTopicId(KEY_1.topicId()).setPartition(KEY_1.partition());
    private static final ShareSnapshotValue SHARE_SNAPSHOT_VALUE = new ShareSnapshotValue().setSnapshotEpoch(SHARE_GROUP_OFFSET_1.snapshotEpoch()).setStateEpoch(SHARE_GROUP_OFFSET_1.stateEpoch()).setLeaderEpoch(SHARE_GROUP_OFFSET_1.leaderEpoch()).setStartOffset(SHARE_GROUP_OFFSET_1.startOffset()).setCreateTimestamp(1744279603L).setWriteTimestamp(1744279603L).setStateBatches(SHARE_GROUP_OFFSET_1.stateBatches().stream().map(batch -> new ShareSnapshotValue.StateBatch().setFirstOffset(batch.firstOffset()).setLastOffset(batch.lastOffset()).setDeliveryState(batch.deliveryState()).setDeliveryCount(batch.deliveryCount())).toList());
    private static final ShareUpdateKey SHARE_UPDATE_KEY = new ShareUpdateKey().setGroupId(KEY_2.groupId()).setTopicId(KEY_2.topicId()).setPartition(KEY_2.partition());
    private static final ShareUpdateValue SHARE_UPDATE_VALUE = new ShareUpdateValue().setSnapshotEpoch(SHARE_GROUP_OFFSET_2.snapshotEpoch()).setLeaderEpoch(SHARE_GROUP_OFFSET_2.leaderEpoch()).setStartOffset(SHARE_GROUP_OFFSET_2.startOffset()).setStateBatches(SHARE_GROUP_OFFSET_2.stateBatches().stream().map(batch -> new ShareUpdateValue.StateBatch().setFirstOffset(batch.firstOffset()).setLastOffset(batch.lastOffset()).setDeliveryState(batch.deliveryState()).setDeliveryCount(batch.deliveryCount())).toList());

    @Override
    protected CoordinatorRecordMessageFormatter formatter() {
        return new ShareGroupStateMessageFormatter();
    }

    @Override
    protected Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_SNAPSHOT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_SNAPSHOT_VALUE).array(), "    {\"key\":{\"type\":0,\"data\":{\"groupId\":\"gs1\",\"topicId\":\"gtb2stGYRk-vWZ2zAozmoA\",\"partition\":0}},\n     \"value\":{\"version\":0,\n              \"data\":{\"snapshotEpoch\":0,\n                      \"stateEpoch\":1,\n                      \"leaderEpoch\":20,\n                      \"startOffset\":50,\n                      \"createTimestamp\": 1744279603,\n                      \"writeTimestamp\": 1744279603,\n                      \"stateBatches\":[{\"firstOffset\":100,\"lastOffset\":200,\"deliveryState\":1,\"deliveryCount\":10},\n                                      {\"firstOffset\":201,\"lastOffset\":210,\"deliveryState\":2,\"deliveryCount\":10}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_SNAPSHOT_KEY).array(), null, "    {\"key\":{\"type\":0,\"data\":{\"groupId\":\"gs1\",\"topicId\":\"gtb2stGYRk-vWZ2zAozmoA\",\"partition\":0}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)SHARE_UPDATE_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_UPDATE_VALUE).array(), "    {\"key\":{\"type\":1,\"data\":{\"groupId\":\"gs2\",\"topicId\":\"r9Nq4xGAQf28jvu36t7gQQ\",\"partition\":0}},\n     \"value\":{\"version\":0,\n              \"data\":{\"snapshotEpoch\":1,\n                      \"leaderEpoch\":25,\n                      \"startOffset\":55,\n                      \"stateBatches\":[{\"firstOffset\":100,\"lastOffset\":150,\"deliveryState\":1,\"deliveryCount\":12},\n                                      {\"firstOffset\":151,\"lastOffset\":200,\"deliveryState\":2,\"deliveryCount\":15}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)10, (Message)SHARE_SNAPSHOT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_SNAPSHOT_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)15, (Message)SHARE_UPDATE_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_UPDATE_VALUE).array(), ""}));
    }

    private static Stream<Arguments> exceptions() {
        return Stream.of(Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_SNAPSHOT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_UPDATE_VALUE).array(), new RuntimeException("Could not read record at offset 0 due to: Could not read record with version 0 from value's buffer due to: non-nullable field stateBatches was serialized as null.")}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)SHARE_UPDATE_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_SNAPSHOT_VALUE).array(), new RuntimeException("Could not read record at offset 0 due to: Could not read record with version 0 from value's buffer due to: non-nullable field stateBatches was serialized as null.")}));
    }

    @ParameterizedTest
    @MethodSource(value={"exceptions"})
    public void testShareGroupStateMessageFormatterException(byte[] keyBuffer, byte[] valueBuffer, RuntimeException expectedOutput) {
        ConsumerRecord record = new ConsumerRecord("__share_group_state", 0, 0L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)keyBuffer, (Object)valueBuffer, (Headers)new RecordHeaders(), Optional.empty());
        try (ShareGroupStateMessageFormatter formatter = new ShareGroupStateMessageFormatter();){
            formatter.configure(Collections.emptyMap());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            RuntimeException re = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ShareGroupStateMessageFormatterTest.lambda$testShareGroupStateMessageFormatterException$2((MessageFormatter)formatter, record, out));
            Assertions.assertEquals((Object)expectedOutput.getMessage(), (Object)re.getMessage());
        }
    }

    private static /* synthetic */ void lambda$testShareGroupStateMessageFormatterException$2(MessageFormatter formatter, ConsumerRecord record, ByteArrayOutputStream out) throws Throwable {
        formatter.writeTo(record, new PrintStream(out));
    }
}

