/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import joptsimple.OptionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteShareGroupsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupsResult;
import org.apache.kafka.clients.admin.DescribeShareGroupsOptions;
import org.apache.kafka.clients.admin.DescribeShareGroupsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.clients.admin.ShareMemberAssignment;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.ToolsTestUtils;
import org.apache.kafka.tools.consumer.group.ShareGroupCommand;
import org.apache.kafka.tools.consumer.group.ShareGroupCommandOptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShareGroupCommandTest {
    private static final List<List<String>> DESCRIBE_TYPE_OFFSETS = List.of(List.of(""), List.of("--offsets"), List.of("--verbose"), List.of("--offsets", "--verbose"));
    private static final List<List<String>> DESCRIBE_TYPE_MEMBERS = List.of(List.of("--members"), List.of("--members", "--verbose"));
    private static final List<List<String>> DESCRIBE_TYPE_STATE = List.of(List.of("--state"), List.of("--state", "--verbose"));
    private static final List<List<String>> DESCRIBE_TYPES = Stream.of(DESCRIBE_TYPE_OFFSETS, DESCRIBE_TYPE_MEMBERS, DESCRIBE_TYPE_STATE).flatMap(Collection::stream).toList();

    @BeforeEach
    public void setup() {
        Exit.setExitProcedure((statusCode, message) -> {});
    }

    @AfterEach
    public void teardown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testListShareGroups() throws Exception {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--list"};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        ListGroupsResult result = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.completedFuture(Arrays.asList(new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing(secondGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.EMPTY)))));
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            HashSet<String> expectedGroups = new HashSet<String>(Arrays.asList(firstGroup, secondGroup));
            Set[] foundGroups = new Set[]{Set.of()};
            TestUtils.waitForCondition(() -> {
                foundGroups[0] = new HashSet(service.listShareGroups());
                return Objects.equals(expectedGroups, foundGroups[0]);
            }, (String)("Expected --list to show groups " + String.valueOf(expectedGroups) + ", but found " + String.valueOf(foundGroups[0]) + "."));
        }
    }

    @Test
    public void testListShareGroupsWithStates() throws Exception {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--list", "--state"};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        ListGroupsResult resultWithAllStates = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        Mockito.when((Object)resultWithAllStates.all()).thenReturn((Object)KafkaFuture.completedFuture(Arrays.asList(new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing(secondGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.EMPTY)))));
        Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)resultWithAllStates);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            HashSet<GroupListing> expectedListing = new HashSet<GroupListing>(Arrays.asList(new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing(secondGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.EMPTY))));
            Set[] foundListing = new Set[]{Set.of()};
            TestUtils.waitForCondition(() -> {
                foundListing[0] = new HashSet(service.listShareGroupsInStates(new HashSet<GroupState>(Arrays.asList(GroupState.values()))));
                return Objects.equals(expectedListing, foundListing[0]);
            }, (String)("Expected to show groups " + String.valueOf(expectedListing) + ", but found " + String.valueOf(foundListing[0])));
            ListGroupsResult resultWithStableState = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
            Mockito.when((Object)resultWithStableState.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of(new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)))));
            Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)resultWithStableState);
            Set<GroupListing> expectedListingStable = Set.of(new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)));
            foundListing[0] = Set.of();
            TestUtils.waitForCondition(() -> {
                foundListing[0] = new HashSet(service.listShareGroupsInStates(Set.of(GroupState.STABLE)));
                return Objects.equals(expectedListingStable, foundListing[0]);
            }, (String)("Expected to show groups " + String.valueOf(expectedListingStable) + ", but found " + String.valueOf(foundListing[0])));
        }
    }

    @Test
    public void testDescribeOffsetsOfExistingGroup() throws Exception {
        String firstGroup = "group1";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_OFFSETS) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--group", firstGroup));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            ListShareGroupOffsetsResult listShareGroupOffsetsResult = AdminClientTestUtils.createListShareGroupOffsetsResult(Map.of(firstGroup, KafkaFuture.completedFuture(Map.of(new TopicPartition("topic1", 0), new OffsetAndMetadata(0L, Optional.of(1), "")))));
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            Mockito.when((Object)adminClient.listShareGroupOffsets(ArgumentMatchers.anyMap())).thenReturn((Object)listShareGroupOffsetsResult);
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    List<String> expectedValues = describeType.contains("--verbose") ? List.of(firstGroup, "topic1", "0", "1", "0") : List.of(firstGroup, "topic1", "0", "0");
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues);
                }, (String)("Expected a data row and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeOffsetsOfExistingGroupWithNulls() throws Exception {
        String firstGroup = "group1";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_OFFSETS) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--group", firstGroup));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            ListShareGroupOffsetsResult listShareGroupOffsetsResult = AdminClientTestUtils.createListShareGroupOffsetsResult(Map.of(firstGroup, KafkaFuture.completedFuture(Collections.singletonMap(new TopicPartition("topic1", 0), null))));
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            Mockito.when((Object)adminClient.listShareGroupOffsets(ArgumentMatchers.anyMap())).thenReturn((Object)listShareGroupOffsetsResult);
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    List<String> expectedValues = describeType.contains("--verbose") ? List.of(firstGroup, "topic1", "0", "-", "-") : List.of(firstGroup, "topic1", "0", "-");
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues);
                }, (String)("Expected a data row and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeOffsetsOfAllExistingGroups() throws Exception {
        String firstGroup = "group1";
        String secondGroup = "group2";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_OFFSETS) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--all-groups"));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            ListGroupsResult listGroupsResult = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
            GroupListing firstGroupListing = new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE));
            GroupListing secondGroupListing = new GroupListing(secondGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE));
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp1 = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            ShareGroupDescription exp2 = new ShareGroupDescription(secondGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            ListShareGroupOffsetsResult listShareGroupOffsetsResult1 = AdminClientTestUtils.createListShareGroupOffsetsResult(Map.of(firstGroup, KafkaFuture.completedFuture(Map.of(new TopicPartition("topic1", 0), new OffsetAndMetadata(0L, Optional.of(1), "")))));
            ListShareGroupOffsetsResult listShareGroupOffsetsResult2 = AdminClientTestUtils.createListShareGroupOffsetsResult(Map.of(secondGroup, KafkaFuture.completedFuture(Map.of(new TopicPartition("topic1", 0), new OffsetAndMetadata(0L, Optional.of(1), "")))));
            Mockito.when((Object)listGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of(firstGroupListing, secondGroupListing)));
            Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)listGroupsResult);
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp1), secondGroup, KafkaFuture.completedFuture((Object)exp2)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            Mockito.when((Object)adminClient.listShareGroupOffsets(ArgumentMatchers.anyMap())).thenAnswer(invocation -> {
                Map argument = (Map)invocation.getArgument(0);
                if (argument.containsKey(firstGroup)) {
                    return listShareGroupOffsetsResult1;
                }
                if (argument.containsKey(secondGroup)) {
                    return listShareGroupOffsetsResult2;
                }
                return null;
            });
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    List<String> expectedValues2;
                    List<String> expectedValues1;
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    if (describeType.contains("--verbose")) {
                        expectedValues1 = List.of(firstGroup, "topic1", "0", "1", "0");
                        expectedValues2 = List.of(secondGroup, "topic1", "0", "1", "0");
                    } else {
                        expectedValues1 = List.of(firstGroup, "topic1", "0", "0");
                        expectedValues2 = List.of(secondGroup, "topic1", "0", "0");
                    }
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && this.checkArgsHeaderOutput(cgcArgs, lines[3]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues1) && Arrays.stream(lines[4].trim().split("\\s+")).toList().equals(expectedValues2);
                }, (String)("Expected 2 data rows and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeStateOfExistingGroup() throws Exception {
        String firstGroup = "group1";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_STATE) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--group", firstGroup));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp1 = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp1)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    List<String> expectedValues1 = describeType.contains("--verbose") ? List.of(firstGroup, "host1:9090", "(0)", "Stable", "0", "0", "1") : List.of(firstGroup, "host1:9090", "(0)", "Stable", "1");
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues1);
                }, (String)("Expected a data row and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeStatesOfAllExistingGroups() throws Exception {
        String firstGroup = "group1";
        String secondGroup = "group2";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_STATE) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--all-groups"));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            ListGroupsResult listGroupsResult = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
            GroupListing firstGroupListing = new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE));
            GroupListing secondGroupListing = new GroupListing(secondGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE));
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp1 = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            ShareGroupDescription exp2 = new ShareGroupDescription(secondGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            Mockito.when((Object)listGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of(firstGroupListing, secondGroupListing)));
            Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)listGroupsResult);
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp1), secondGroup, KafkaFuture.completedFuture((Object)exp2)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    List<String> expectedValues2;
                    List<String> expectedValues1;
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    if (describeType.contains("--verbose")) {
                        expectedValues1 = List.of(firstGroup, "host1:9090", "(0)", "Stable", "0", "0", "1");
                        expectedValues2 = List.of(secondGroup, "host1:9090", "(0)", "Stable", "0", "0", "1");
                    } else {
                        expectedValues1 = List.of(firstGroup, "host1:9090", "(0)", "Stable", "1");
                        expectedValues2 = List.of(secondGroup, "host1:9090", "(0)", "Stable", "1");
                    }
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && this.checkArgsHeaderOutput(cgcArgs, lines[3]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues1) && Arrays.stream(lines[4].trim().split("\\s+")).toList().equals(expectedValues2);
                }, (String)("Expected 2 data rows and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeMembersOfExistingGroup() throws Exception {
        String firstGroup = "group1";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_MEMBERS) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--group", firstGroup));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp1 = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp1)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    List<String> expectedValues1 = describeType.contains("--verbose") ? List.of(firstGroup, "memid1", "host1", "clId1", "3", "0", "topic1:0,1;topic2:0") : List.of(firstGroup, "memid1", "host1", "clId1", "3", "topic1:0,1;topic2:0");
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues1);
                }, (String)("Expected a data row and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeMembersOfAllExistingGroups() throws Exception {
        String firstGroup = "group1";
        String secondGroup = "group2";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPE_MEMBERS) {
            ArrayList<String> cgcArgs = new ArrayList<String>(List.of("--bootstrap-server", bootstrapServer, "--describe", "--all-groups"));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            ListGroupsResult listGroupsResult = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
            GroupListing firstGroupListing = new GroupListing(firstGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE));
            GroupListing secondGroupListing = new GroupListing(secondGroup, Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE));
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            ShareGroupDescription exp1 = new ShareGroupDescription(firstGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            ShareGroupDescription exp2 = new ShareGroupDescription(secondGroup, List.of(new ShareMemberDescription("memid1", "clId1", "host1", new ShareMemberAssignment(Set.of(new TopicPartition("topic1", 0))), 0)), GroupState.STABLE, new Node(0, "host1", 9090), 0, 0);
            Mockito.when((Object)listGroupsResult.all()).thenReturn((Object)KafkaFuture.completedFuture(List.of(firstGroupListing, secondGroupListing)));
            Mockito.when((Object)adminClient.listGroups((ListGroupsOptions)ArgumentMatchers.any(ListGroupsOptions.class))).thenReturn((Object)listGroupsResult);
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(firstGroup, KafkaFuture.completedFuture((Object)exp1), secondGroup, KafkaFuture.completedFuture((Object)exp2)));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
            try {
                TestUtils.waitForCondition(() -> {
                    List<String> expectedValues2;
                    List<String> expectedValues1;
                    Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.describeGroups(service));
                    String[] lines = res.getKey().trim().split("\n");
                    if (lines.length != 2 && !res.getValue().isEmpty()) {
                        return false;
                    }
                    if (describeType.contains("--verbose")) {
                        expectedValues1 = List.of(firstGroup, "memid1", "host1", "clId1", "3", "0", "topic1:0,1;topic2:0");
                        expectedValues2 = List.of(secondGroup, "memid1", "host1", "clId1", "1", "0", "topic1:0");
                    } else {
                        expectedValues1 = List.of(firstGroup, "memid1", "host1", "clId1", "3", "topic1:0,1;topic2:0");
                        expectedValues2 = List.of(secondGroup, "memid1", "host1", "clId1", "1", "topic1:0");
                    }
                    return this.checkArgsHeaderOutput(cgcArgs, lines[0]) && this.checkArgsHeaderOutput(cgcArgs, lines[3]) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedValues1) && Arrays.stream(lines[4].trim().split("\\s+")).toList().equals(expectedValues2);
                }, (String)("Expected 2 data rows and no error in describe results with describe type " + String.join((CharSequence)" ", describeType) + "."));
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @Test
    public void testDescribeNonexistentGroup() {
        String missingGroup = "missing.group";
        String bootstrapServer = "localhost:9092";
        for (List<String> describeType : DESCRIBE_TYPES) {
            ArrayList<String> cgcArgs = new ArrayList<String>(Arrays.asList("--bootstrap-server", bootstrapServer, "--describe", "--group", missingGroup));
            cgcArgs.addAll(describeType);
            Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
            DescribeShareGroupsResult describeShareGroupsResult = (DescribeShareGroupsResult)Mockito.mock(DescribeShareGroupsResult.class);
            KafkaFutureImpl missingGroupFuture = new KafkaFutureImpl();
            missingGroupFuture.completeExceptionally((Throwable)new GroupIdNotFoundException("Group " + missingGroup + " not found."));
            Mockito.when((Object)describeShareGroupsResult.describedGroups()).thenReturn(Map.of(missingGroup, missingGroupFuture));
            Mockito.when((Object)adminClient.describeShareGroups(ArgumentMatchers.anyCollection(), (DescribeShareGroupsOptions)ArgumentMatchers.any(DescribeShareGroupsOptions.class))).thenReturn((Object)describeShareGroupsResult);
            try {
                ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);
                try {
                    service.describeGroups();
                    Assertions.fail((String)("Expected error was not detected for describe option '" + String.join((CharSequence)" ", describeType) + "'"));
                }
                finally {
                    if (service == null) continue;
                    service.close();
                }
            }
            catch (ExecutionException ee) {
                Assertions.assertInstanceOf(GroupIdNotFoundException.class, (Object)ee.getCause());
                Assertions.assertEquals((Object)("Group " + missingGroup + " not found."), (Object)ee.getCause().getMessage());
            }
            catch (Exception e) {
                Assertions.fail((String)("Expected error was not detected for describe option '" + String.join((CharSequence)" ", describeType) + "'"));
            }
        }
    }

    @Test
    public void testPrintEmptyGroupState() {
        Assertions.assertFalse((boolean)ShareGroupCommand.ShareGroupService.maybePrintEmptyGroupState((String)"group", (GroupState)GroupState.EMPTY, (int)0));
        Assertions.assertFalse((boolean)ShareGroupCommand.ShareGroupService.maybePrintEmptyGroupState((String)"group", (GroupState)GroupState.DEAD, (int)0));
        Assertions.assertFalse((boolean)ShareGroupCommand.ShareGroupService.maybePrintEmptyGroupState((String)"group", (GroupState)GroupState.STABLE, (int)0));
        Assertions.assertTrue((boolean)ShareGroupCommand.ShareGroupService.maybePrintEmptyGroupState((String)"group", (GroupState)GroupState.STABLE, (int)1));
        Assertions.assertTrue((boolean)ShareGroupCommand.ShareGroupService.maybePrintEmptyGroupState((String)"group", (GroupState)GroupState.UNKNOWN, (int)1));
    }

    @Test
    public void testListWithUnrecognizedOption() {
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--list", "--verbose"};
        Assertions.assertThrows(OptionException.class, () -> this.getShareGroupService(cgcArgs, (Admin)new MockAdminClient()));
    }

    @Test
    public void testGroupStatesFromString() {
        Set result = ShareGroupCommand.groupStatesFromString((String)"Stable");
        Assertions.assertEquals(Set.of(GroupState.STABLE), (Object)result);
        result = ShareGroupCommand.groupStatesFromString((String)"stable");
        Assertions.assertEquals(Set.of(GroupState.STABLE), (Object)result);
        result = ShareGroupCommand.groupStatesFromString((String)"dead");
        Assertions.assertEquals(Set.of(GroupState.DEAD), (Object)result);
        result = ShareGroupCommand.groupStatesFromString((String)"empty");
        Assertions.assertEquals(Set.of(GroupState.EMPTY), (Object)result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupCommand.groupStatesFromString((String)"assigning"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupCommand.groupStatesFromString((String)"bad, wrong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupCommand.groupStatesFromString((String)"  bad, Stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupCommand.groupStatesFromString((String)"   ,   ,"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteShareGroupOffsetsArgsWithoutTopic() {
        String bootstrapServer = "localhost:9092";
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete-offsets", "--group", "groupId"};
        AtomicBoolean exited = new AtomicBoolean(false);
        Exit.setExitProcedure((statusCode, message) -> {
            Assertions.assertNotEquals((int)0, (int)statusCode);
            Assertions.assertTrue((boolean)message.contains("Option [delete-offsets] takes the following options: [topic], [group]"));
            exited.set(true);
        });
        try {
            this.getShareGroupService(cgcArgs, adminClient);
        }
        finally {
            Assertions.assertTrue((boolean)exited.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteShareGroupOffsetsArgsWithoutGroup() {
        String bootstrapServer = "localhost:9092";
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete-offsets", "--topic", "t1"};
        AtomicBoolean exited = new AtomicBoolean(false);
        Exit.setExitProcedure((statusCode, message) -> {
            Assertions.assertNotEquals((int)0, (int)statusCode);
            Assertions.assertTrue((boolean)message.contains("Option [delete-offsets] takes the following options: [topic], [group]"));
            exited.set(true);
        });
        try {
            this.getShareGroupService(cgcArgs, adminClient);
        }
        finally {
            Assertions.assertTrue((boolean)exited.get());
        }
    }

    @Test
    public void testDeleteShareGroupOffsets() throws Exception {
        String firstGroup = "first-group";
        String firstTopic = "t1";
        String secondTopic = "t2";
        String bootstrapServer = "localhost:9092";
        ArrayList<String> cgcArgs = new ArrayList<String>(Arrays.asList("--bootstrap-server", bootstrapServer, "--delete-offsets", "--group", firstGroup, "--topic", firstTopic, "--topic", secondTopic));
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupOffsetsResult result = (DeleteShareGroupOffsetsResult)Mockito.mock(DeleteShareGroupOffsetsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.completedFuture(null));
        Mockito.when((Object)result.topicResult((String)ArgumentMatchers.eq((Object)firstTopic))).thenReturn((Object)KafkaFuture.completedFuture(null));
        Mockito.when((Object)result.topicResult((String)ArgumentMatchers.eq((Object)secondTopic))).thenReturn((Object)KafkaFuture.completedFuture(null));
        Mockito.when((Object)adminClient.deleteShareGroupOffsets((String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (DeleteShareGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);){
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.deleteOffsets(service));
                String[] lines = res.getKey().trim().split("\n");
                if (lines.length != 3 && !res.getValue().isEmpty()) {
                    return false;
                }
                List<String> expectedResultHeader = List.of("TOPIC", "STATUS");
                List<String> expectedResultValues1 = List.of(firstTopic, "Successful");
                List<String> expectedResultValues2 = List.of(secondTopic, "Successful");
                return Arrays.stream(lines[0].trim().split("\\s+")).toList().equals(expectedResultHeader) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedResultValues1) && Arrays.stream(lines[2].trim().split("\\s+")).toList().equals(expectedResultValues2);
            }, (String)("Expected a data row and no error in delete offsets result with group: " + firstGroup + " and topic: " + firstTopic));
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsMultipleGroups() {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String firstTopic = "t1";
        String secondTopic = "t2";
        String bootstrapServer = "localhost:9092";
        ArrayList<String> cgcArgs = new ArrayList<String>(Arrays.asList("--bootstrap-server", bootstrapServer, "--delete-offsets", "--group", firstGroup, "--group", secondGroup, "--topic", firstTopic, "--topic", secondTopic));
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);){
            service.deleteOffsets();
            Assertions.fail((String)"Expected error was not detected while trying delete offsets multiple groups");
        }
        catch (Exception e) {
            String expectedErrorMessage = "Found multiple arguments for option group, but you asked for only one";
            Assertions.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsTopLevelError() throws Exception {
        String firstGroup = "first-group";
        String firstTopic = "t1";
        String secondTopic = "t2";
        String bootstrapServer = "localhost:9092";
        ArrayList<String> cgcArgs = new ArrayList<String>(Arrays.asList("--bootstrap-server", bootstrapServer, "--delete-offsets", "--group", firstGroup, "--topic", firstTopic, "--topic", secondTopic));
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupOffsetsResult result = (DeleteShareGroupOffsetsResult)Mockito.mock(DeleteShareGroupOffsetsResult.class);
        KafkaFutureImpl resultFuture = new KafkaFutureImpl();
        String errorMessage = "Group g3 not found.";
        GroupIdNotFoundException exception = new GroupIdNotFoundException(errorMessage);
        resultFuture.completeExceptionally((Throwable)exception);
        Mockito.when((Object)result.all()).thenReturn((Object)resultFuture);
        Mockito.when((Object)result.topicResult((String)ArgumentMatchers.eq((Object)firstTopic))).thenReturn((Object)resultFuture);
        Mockito.when((Object)result.topicResult((String)ArgumentMatchers.eq((Object)secondTopic))).thenReturn((Object)resultFuture);
        Mockito.when((Object)adminClient.deleteShareGroupOffsets((String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (DeleteShareGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);){
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.deleteOffsets(service));
                String[] lines = res.getKey().trim().split("\n");
                if (lines.length != 5 && !res.getValue().isEmpty()) {
                    return false;
                }
                List<String> error = Stream.concat(Stream.of("Error:"), Arrays.stream(errorMessage.trim().split("\\s+"))).toList();
                ArrayList<String> errorLine = new ArrayList<String>(error);
                List<String> expectedResultHeader = List.of("TOPIC", "STATUS");
                ArrayList<String> expectedResultValue1 = new ArrayList<String>();
                expectedResultValue1.add(firstTopic);
                expectedResultValue1.addAll(error);
                ArrayList<String> expectedResultValue2 = new ArrayList<String>();
                expectedResultValue2.add(secondTopic);
                expectedResultValue2.addAll(error);
                return Arrays.stream(lines[0].trim().split("\\s+")).toList().equals(errorLine) && Arrays.stream(lines[2].trim().split("\\s+")).toList().equals(expectedResultHeader) && Arrays.stream(lines[3].trim().split("\\s+")).toList().equals(expectedResultValue1) && Arrays.stream(lines[4].trim().split("\\s+")).toList().equals(expectedResultValue2);
            }, (String)("Expected a data row and no error in delete offsets result with group: " + firstGroup + " and topic: " + firstTopic));
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsTopicLevelError() throws Exception {
        String firstGroup = "first-group";
        String firstTopic = "t1";
        String secondTopic = "t2";
        String bootstrapServer = "localhost:9092";
        ArrayList<String> cgcArgs = new ArrayList<String>(Arrays.asList("--bootstrap-server", bootstrapServer, "--delete-offsets", "--group", firstGroup, "--topic", firstTopic, "--topic", secondTopic));
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupOffsetsResult result = (DeleteShareGroupOffsetsResult)Mockito.mock(DeleteShareGroupOffsetsResult.class);
        KafkaFutureImpl resultFuture = new KafkaFutureImpl();
        String errorMessage = Errors.UNKNOWN_TOPIC_OR_PARTITION.message();
        resultFuture.completeExceptionally((Throwable)Errors.UNKNOWN_TOPIC_OR_PARTITION.exception());
        Mockito.when((Object)result.all()).thenReturn((Object)resultFuture);
        Mockito.when((Object)result.topicResult((String)ArgumentMatchers.eq((Object)firstTopic))).thenReturn((Object)KafkaFuture.completedFuture(null));
        Mockito.when((Object)result.topicResult((String)ArgumentMatchers.eq((Object)secondTopic))).thenReturn((Object)resultFuture);
        Mockito.when((Object)adminClient.deleteShareGroupOffsets((String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (DeleteShareGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs.toArray(new String[0]), adminClient);){
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(this.deleteOffsets(service));
                String[] lines = res.getKey().trim().split("\n");
                if (lines.length != 5 && !res.getValue().isEmpty()) {
                    return false;
                }
                List<String> error = Stream.concat(Stream.of("Error:"), Arrays.stream(errorMessage.trim().split("\\s+"))).toList();
                List<String> expectedResultHeader = List.of("TOPIC", "STATUS");
                List<String> expectedResultValue1 = List.of(firstTopic, "Successful");
                ArrayList<String> expectedResultValue2 = new ArrayList<String>();
                expectedResultValue2.add(secondTopic);
                expectedResultValue2.addAll(error);
                return Arrays.stream(lines[0].trim().split("\\s+")).toList().equals(expectedResultHeader) && Arrays.stream(lines[1].trim().split("\\s+")).toList().equals(expectedResultValue1) && Arrays.stream(lines[2].trim().split("\\s+")).toList().equals(expectedResultValue2);
            }, (String)("Expected a data row and no error in delete offsets result with group: " + firstGroup + " and topic: " + firstTopic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteShareGroupsArgs() {
        String bootstrapServer = "localhost:9092";
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        this.mockListShareGroups(adminClient, new LinkedHashMap<String, GroupState>());
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete"};
        AtomicBoolean exited = new AtomicBoolean(false);
        Exit.setExitProcedure((statusCode, message) -> {
            Assertions.assertNotEquals((int)0, (int)statusCode);
            Assertions.assertTrue((boolean)message.contains("Option [delete] takes the options [group] or [all-groups]"));
            exited.set(true);
        });
        try {
            this.getShareGroupService(cgcArgs, adminClient);
        }
        finally {
            Assertions.assertTrue((boolean)exited.get());
        }
    }

    @Test
    public void testDeleteShareGroupsSuccess() {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--group", firstGroup, "--group", secondGroup};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        Map<String, KafkaFuture> deletedGroups = Map.of(firstGroup, KafkaFuture.completedFuture(null), secondGroup, KafkaFuture.completedFuture(null));
        LinkedHashMap<String, GroupState> shareGroupMap = new LinkedHashMap<String, GroupState>();
        shareGroupMap.put(firstGroup, GroupState.EMPTY);
        shareGroupMap.put(secondGroup, GroupState.EMPTY);
        this.mockListShareGroups(adminClient, shareGroupMap);
        Mockito.when((Object)result.deletedGroups()).thenReturn(deletedGroups);
        HashMap<String, Object> expectedResults = new HashMap<String, Object>();
        expectedResults.put(firstGroup, null);
        expectedResults.put(secondGroup, null);
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            Assertions.assertEquals(expectedResults, (Object)service.deleteShareGroups());
        }
    }

    @Test
    public void testDeleteShareGroupsAllGroupsSuccess() {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--all-groups"};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        Map<String, KafkaFuture> deletedGroups = Map.of(firstGroup, KafkaFuture.completedFuture(null), secondGroup, KafkaFuture.completedFuture(null));
        LinkedHashMap<String, GroupState> shareGroupMap = new LinkedHashMap<String, GroupState>();
        shareGroupMap.put(firstGroup, GroupState.EMPTY);
        shareGroupMap.put(secondGroup, GroupState.EMPTY);
        this.mockListShareGroups(adminClient, shareGroupMap);
        Mockito.when((Object)result.deletedGroups()).thenReturn(deletedGroups);
        HashMap<String, Object> expectedResults = new HashMap<String, Object>();
        expectedResults.put(firstGroup, null);
        expectedResults.put(secondGroup, null);
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            Assertions.assertEquals(expectedResults, (Object)service.deleteShareGroups());
        }
    }

    @Test
    public void testDeleteShareGroupsAllGroupsPartialFail() {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--all-groups"};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        KafkaFutureImpl future2 = new KafkaFutureImpl();
        future1.complete(null);
        Exception exp = new Exception("bad");
        future2.completeExceptionally((Throwable)exp);
        Map<String, KafkaFutureImpl> deletedGroups = Map.of(firstGroup, future1, secondGroup, future2);
        LinkedHashMap<String, GroupState> shareGroupMap = new LinkedHashMap<String, GroupState>();
        shareGroupMap.put(firstGroup, GroupState.EMPTY);
        shareGroupMap.put(secondGroup, GroupState.EMPTY);
        this.mockListShareGroups(adminClient, shareGroupMap);
        Mockito.when((Object)result.deletedGroups()).thenReturn(deletedGroups);
        HashMap<String, Exception> expectedResults = new HashMap<String, Exception>();
        expectedResults.put(firstGroup, null);
        expectedResults.put(secondGroup, exp);
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            Assertions.assertEquals(expectedResults, (Object)service.deleteShareGroups());
        }
    }

    @Test
    public void testDeleteShareGroupsDeleteFailure() {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--group", firstGroup, "--group", secondGroup};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        LinkedHashMap<String, GroupState> shareGroupMap = new LinkedHashMap<String, GroupState>();
        shareGroupMap.put(firstGroup, GroupState.EMPTY);
        shareGroupMap.put(secondGroup, GroupState.EMPTY);
        this.mockListShareGroups(adminClient, shareGroupMap);
        KafkaFutureImpl future = new KafkaFutureImpl();
        Exception exp = new Exception("bad");
        future.completeExceptionally((Throwable)exp);
        Map<String, KafkaFutureImpl> deletedGroups = Map.of(firstGroup, future, secondGroup, future);
        Mockito.when((Object)result.deletedGroups()).thenReturn(deletedGroups);
        HashMap<String, Exception> expectedResults = new HashMap<String, Exception>();
        expectedResults.put(firstGroup, exp);
        expectedResults.put(secondGroup, exp);
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            Assertions.assertEquals(expectedResults, (Object)service.deleteShareGroups());
        }
    }

    @Test
    public void testDeleteShareGroupsFailureNonShareGroup() {
        String firstGroup = "first-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--group", firstGroup};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        this.mockListShareGroups(adminClient, new LinkedHashMap<String, GroupState>());
        Mockito.when((Object)result.deletedGroups()).thenReturn(Map.of());
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            service.deleteShareGroups();
            ((DeleteShareGroupsResult)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).deletedGroups();
            ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)0))).deleteShareGroups((Collection)ArgumentMatchers.anyList());
        }
    }

    @Test
    public void testDeleteShareGroupsFailureNonEmptyGroup() {
        String firstGroup = "first-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--group", firstGroup};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        LinkedHashMap<String, GroupState> shareGroupMap = new LinkedHashMap<String, GroupState>();
        shareGroupMap.put(firstGroup, GroupState.STABLE);
        this.mockListShareGroups(adminClient, shareGroupMap);
        Mockito.when((Object)result.deletedGroups()).thenReturn(Map.of());
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            service.deleteShareGroups();
            ((DeleteShareGroupsResult)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).deletedGroups();
            ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)0))).deleteShareGroups((Collection)ArgumentMatchers.anyList());
        }
    }

    @Test
    public void testDeleteShareGroupsPartialFailure() {
        String firstGroup = "first-group";
        String secondGroup = "second-group";
        String bootstrapServer = "localhost:9092";
        String[] cgcArgs = new String[]{"--bootstrap-server", bootstrapServer, "--delete", "--group", firstGroup, "--group", secondGroup};
        Admin adminClient = (Admin)Mockito.mock(KafkaAdminClient.class);
        DeleteShareGroupsResult result = (DeleteShareGroupsResult)Mockito.mock(DeleteShareGroupsResult.class);
        LinkedHashMap<String, GroupState> shareGroupMap = new LinkedHashMap<String, GroupState>();
        shareGroupMap.put(firstGroup, GroupState.EMPTY);
        shareGroupMap.put(secondGroup, GroupState.EMPTY);
        this.mockListShareGroups(adminClient, shareGroupMap);
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        KafkaFutureImpl future2 = new KafkaFutureImpl();
        future1.complete(null);
        Exception exp = new Exception("bad");
        future2.completeExceptionally((Throwable)exp);
        Map<String, KafkaFutureImpl> deletedGroups = Map.of(firstGroup, future1, secondGroup, future2);
        Mockito.when((Object)result.deletedGroups()).thenReturn(deletedGroups);
        Mockito.when((Object)adminClient.deleteShareGroups((Collection)ArgumentMatchers.anyList(), (DeleteShareGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        HashMap<String, Exception> expectedResults = new HashMap<String, Exception>();
        expectedResults.put(firstGroup, null);
        expectedResults.put(secondGroup, exp);
        try (ShareGroupCommand.ShareGroupService service = this.getShareGroupService(cgcArgs, adminClient);){
            Assertions.assertEquals(expectedResults, (Object)service.deleteShareGroups());
        }
    }

    private void mockListShareGroups(Admin client, LinkedHashMap<String, GroupState> groupIds) {
        ListGroupsResult listResult = (ListGroupsResult)Mockito.mock(ListGroupsResult.class);
        KafkaFutureImpl listFuture = new KafkaFutureImpl();
        ArrayList groupListings = new ArrayList();
        groupIds.forEach((groupId, state) -> groupListings.add(new GroupListing(groupId, Optional.of(GroupType.SHARE), "share", Optional.of(state))));
        listFuture.complete(groupListings);
        Mockito.when((Object)listResult.all()).thenReturn((Object)listFuture);
        Mockito.when((Object)client.listGroups((ListGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
    }

    ShareGroupCommand.ShareGroupService getShareGroupService(String[] args, Admin adminClient) {
        ShareGroupCommandOptions opts = new ShareGroupCommandOptions(args);
        opts.checkArgs();
        return new ShareGroupCommand.ShareGroupService(opts, adminClient);
    }

    private Runnable describeGroups(ShareGroupCommand.ShareGroupService service) {
        return () -> Assertions.assertDoesNotThrow(() -> ((ShareGroupCommand.ShareGroupService)service).describeGroups());
    }

    private Runnable deleteOffsets(ShareGroupCommand.ShareGroupService service) {
        return () -> Assertions.assertDoesNotThrow(() -> ((ShareGroupCommand.ShareGroupService)service).deleteOffsets());
    }

    private boolean checkArgsHeaderOutput(List<String> args, String output) {
        if (!output.contains("GROUP")) {
            return false;
        }
        if (args.contains("--members")) {
            return this.checkMembersArgsHeaderOutput(output, args.contains("--verbose"));
        }
        if (args.contains("--state")) {
            return this.checkStateArgsHeaderOutput(output, args.contains("--verbose"));
        }
        return this.checkOffsetsArgsHeaderOutput(output, args.contains("--verbose"));
    }

    private boolean checkOffsetsArgsHeaderOutput(String output, boolean verbose) {
        List<String> expectedKeys = verbose ? List.of("GROUP", "TOPIC", "PARTITION", "LEADER-EPOCH", "START-OFFSET") : List.of("GROUP", "TOPIC", "PARTITION", "START-OFFSET");
        return Arrays.stream(output.trim().split("\\s+")).toList().equals(expectedKeys);
    }

    private boolean checkMembersArgsHeaderOutput(String output, boolean verbose) {
        List<String> expectedKeys = verbose ? List.of("GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "#PARTITIONS", "MEMBER-EPOCH", "ASSIGNMENT") : List.of("GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "#PARTITIONS", "ASSIGNMENT");
        return Arrays.stream(output.trim().split("\\s+")).toList().equals(expectedKeys);
    }

    private boolean checkStateArgsHeaderOutput(String output, boolean verbose) {
        List<String> expectedKeys = verbose ? List.of("GROUP", "COORDINATOR", "(ID)", "STATE", "GROUP-EPOCH", "ASSIGNMENT-EPOCH", "#MEMBERS") : List.of("GROUP", "COORDINATOR", "(ID)", "STATE", "#MEMBERS");
        return Arrays.stream(output.trim().split("\\s+")).toList().equals(expectedKeys);
    }
}

