/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.api.AbstractSaslTest;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommand;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandOptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Option;
import scala.Some$;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

public class SaslClientsWithInvalidCredentialsTest
extends AbstractSaslTest {
    private static final String TOPIC = "topic";
    public static final int NUM_PARTITIONS = 1;
    public static final int BROKER_COUNT = 1;
    public static final String KAFKA_CLIENT_SASL_MECHANISM = "SCRAM-SHA-256";
    private static final Seq<String> KAFKA_SERVER_SASL_MECHANISMS = CollectionConverters.asScala(Collections.singletonList("SCRAM-SHA-256")).toSeq();

    private Consumer<byte[], byte[]> createConsumer() {
        return this.createConsumer((Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), new Properties(), CollectionConverters.asScala(Collections.emptySet()).toList());
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Option<Properties> serverSaslProperties() {
        return Some$.MODULE$.apply((Object)this.kafkaServerSaslProperties(KAFKA_SERVER_SASL_MECHANISMS, KAFKA_CLIENT_SASL_MECHANISM));
    }

    public Option<Properties> clientSaslProperties() {
        return Some$.MODULE$.apply((Object)this.kafkaClientSaslProperties(KAFKA_CLIENT_SASL_MECHANISM, false));
    }

    public int brokerCount() {
        return 1;
    }

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
    }

    public void addFormatterSettings(Formatter formatter) {
        formatter.setClusterId("XcZZOzUqS4yHOjhMQB6JLQ");
        formatter.setScramArguments(Arrays.asList("SCRAM-SHA-256=[name=scram-admin,password=scram-admin-secret]"));
    }

    public Admin createPrivilegedAdminClient() {
        return this.createAdminClient(this.bootstrapServers(this.listenerName()), this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties(), KAFKA_CLIENT_SASL_MECHANISM, "scram-admin", "scram-admin-secret");
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections(KAFKA_SERVER_SASL_MECHANISMS, (Option)Some$.MODULE$.apply((Object)KAFKA_CLIENT_SASL_MECHANISM), "KafkaServer"));
        String superuserLoginContext = this.jaasAdminLoginModule(KAFKA_CLIENT_SASL_MECHANISM, Option.empty());
        this.superuserClientConfig().put("sasl.jaas.config", superuserLoginContext);
        super.setUp(testInfo);
        try (Admin admin = this.createPrivilegedAdminClient();){
            admin.createTopics(Collections.singletonList(new NewTopic(TOPIC, 1, 1))).all().get(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testConsumerGroupServiceWithAuthenticationFailure(String groupProtocol) throws Exception {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();
             Consumer<byte[], byte[]> consumer = this.createConsumer();){
            consumer.subscribe(Collections.singletonList(TOPIC));
            this.verifyAuthenticationException(() -> ((ConsumerGroupCommand.ConsumerGroupService)consumerGroupService).listGroups());
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testConsumerGroupServiceWithAuthenticationSuccess(String groupProtocol) throws Exception {
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();
             Consumer<byte[], byte[]> consumer = this.createConsumer();){
            consumer.subscribe(Collections.singletonList(TOPIC));
            TestUtils.waitForCondition(() -> {
                try {
                    consumer.poll(Duration.ofMillis(1000L));
                    return true;
                }
                catch (SaslAuthenticationException ignored) {
                    return false;
                }
            }, (String)"failed to poll data with authentication");
            Assertions.assertEquals((int)1, (int)consumerGroupService.listConsumerGroups().size());
        }
    }

    private ConsumerGroupCommand.ConsumerGroupService prepareConsumerGroupService() throws IOException {
        File propsFile = TestUtils.tempFile((String)"security.protocol=SASL_PLAINTEXT\nsasl.mechanism=SCRAM-SHA-256");
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.listenerName()), "--describe", "--group", "test.group", "--command-config", propsFile.getAbsolutePath()};
        ConsumerGroupCommandOptions opts = ConsumerGroupCommandOptions.fromArgs((String[])cgcArgs);
        return new ConsumerGroupCommand.ConsumerGroupService(opts, Collections.emptyMap());
    }

    private void verifyAuthenticationException(Executable action) {
        long startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, (Executable)action);
        long elapsedMs = System.currentTimeMillis() - startMs;
        Assertions.assertTrue((elapsedMs <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + elapsedMs));
    }
}

