/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommand;
import org.apache.kafka.tools.consumer.group.ListConsumerGroupTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ListConsumerGroupUnitTest {
    ListConsumerGroupUnitTest() {
    }

    @Test
    public void testConsumerGroupStatesFromString() {
        Set result = ConsumerGroupCommand.groupStatesFromString((String)"Stable");
        Assertions.assertEquals(ListConsumerGroupTest.set(Collections.singleton(GroupState.STABLE)), (Object)result);
        result = ConsumerGroupCommand.groupStatesFromString((String)"Stable, PreparingRebalance");
        Assertions.assertEquals(ListConsumerGroupTest.set(Arrays.asList(GroupState.STABLE, GroupState.PREPARING_REBALANCE)), (Object)result);
        result = ConsumerGroupCommand.groupStatesFromString((String)"Dead,CompletingRebalance,");
        Assertions.assertEquals(ListConsumerGroupTest.set(Arrays.asList(GroupState.DEAD, GroupState.COMPLETING_REBALANCE)), (Object)result);
        result = ConsumerGroupCommand.groupStatesFromString((String)"stable");
        Assertions.assertEquals(ListConsumerGroupTest.set(Collections.singletonList(GroupState.STABLE)), (Object)result);
        result = ConsumerGroupCommand.groupStatesFromString((String)"stable, assigning");
        Assertions.assertEquals(ListConsumerGroupTest.set(Arrays.asList(GroupState.STABLE, GroupState.ASSIGNING)), (Object)result);
        result = ConsumerGroupCommand.groupStatesFromString((String)"dead,reconciling,");
        Assertions.assertEquals(ListConsumerGroupTest.set(Arrays.asList(GroupState.DEAD, GroupState.RECONCILING)), (Object)result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.groupStatesFromString((String)"bad, wrong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.groupStatesFromString((String)"  bad, Stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.groupStatesFromString((String)"   ,   ,"));
    }

    @Test
    public void testConsumerGroupTypesFromString() {
        Set result = ConsumerGroupCommand.consumerGroupTypesFromString((String)"consumer");
        Assertions.assertEquals(ListConsumerGroupTest.set(Collections.singleton(GroupType.CONSUMER)), (Object)result);
        result = ConsumerGroupCommand.consumerGroupTypesFromString((String)"consumer, classic");
        Assertions.assertEquals(ListConsumerGroupTest.set(Arrays.asList(GroupType.CONSUMER, GroupType.CLASSIC)), (Object)result);
        result = ConsumerGroupCommand.consumerGroupTypesFromString((String)"Consumer, Classic");
        Assertions.assertEquals(ListConsumerGroupTest.set(Arrays.asList(GroupType.CONSUMER, GroupType.CLASSIC)), (Object)result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.consumerGroupTypesFromString((String)"Share"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.consumerGroupTypesFromString((String)"streams"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.consumerGroupTypesFromString((String)"bad, wrong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.consumerGroupTypesFromString((String)"  bad, generic"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand.consumerGroupTypesFromString((String)"   ,   ,"));
    }
}

