/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import joptsimple.OptionException;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.ToolsTestUtils;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommand;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandOptions;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@ClusterTestDefaults(types={Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.consumer.heartbeat.interval.ms", value="500"), @ClusterConfigProperty(key="group.consumer.min.heartbeat.interval.ms", value="500")})
public class DeleteConsumerGroupsTest {
    @Test
    public void testDeleteWithTopicOption() {
        String[] cgcArgs = new String[]{"--bootstrap-server", "localhost:62241", "--delete", "--group", this.getDummyGroupId(), "--topic"};
        Assertions.assertThrows(OptionException.class, () -> ConsumerGroupCommandOptions.fromArgs((String[])cgcArgs));
    }

    @ClusterTest
    public void testDeleteCmdNonExistingGroup(ClusterInstance cluster) {
        String missingGroupId = this.getDummyGroupId();
        String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", missingGroupId};
        try (ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);){
            String output = ToolsTestUtils.grabConsoleOutput(() -> ((ConsumerGroupCommand.ConsumerGroupService)service).deleteGroups());
            Assertions.assertTrue((output.contains("Group '" + missingGroupId + "' could not be deleted due to:") && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0, (String)("The expected error (" + String.valueOf(Errors.GROUP_ID_NOT_FOUND) + ") was not detected while deleting consumer group"));
        }
    }

    @ClusterTest
    public void testDeleteNonExistingGroup(ClusterInstance cluster) {
        String missingGroupId = this.getDummyGroupId();
        String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", missingGroupId};
        try (ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);){
            Map result = service.deleteGroups();
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertNotNull(result.get(missingGroupId));
            Assertions.assertInstanceOf(GroupIdNotFoundException.class, result.get(missingGroupId), (String)("The expected error (" + String.valueOf(Errors.GROUP_ID_NOT_FOUND) + ") was not detected while deleting consumer group"));
        }
    }

    @ClusterTest
    public void testDeleteNonEmptyGroup(ClusterInstance cluster) throws Exception {
        for (GroupProtocol groupProtocol : cluster.supportedGroupProtocols()) {
            String groupId = this.composeGroupId(groupProtocol);
            String topicName = this.composeTopicName(groupProtocol);
            String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", groupId};
            AutoCloseable consumerGroupCloseable = this.consumerGroupClosable(cluster, groupProtocol, groupId, topicName);
            try {
                ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
                try {
                    TestUtils.waitForCondition(() -> ((Collection)((Optional)service.collectGroupMembers(groupId).getValue()).get()).size() == 1, (String)"The group did not initialize as expected.");
                    String output = ToolsTestUtils.grabConsoleOutput(() -> ((ConsumerGroupCommand.ConsumerGroupService)service).deleteGroups());
                    Map result = service.deleteGroups();
                    Assertions.assertTrue((output.contains("Group '" + groupId + "' could not be deleted due to:") && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0, (String)("The expected error (" + String.valueOf(Errors.NON_EMPTY_GROUP) + ") was not detected while deleting consumer group. Output was: (" + output + ")"));
                    Assertions.assertNotNull(result.get(groupId), (String)("Group was deleted successfully, but it shouldn't have been. Result was:(" + String.valueOf(result) + ")"));
                    Assertions.assertEquals((int)1, (int)result.size());
                    Assertions.assertNotNull(result.get(groupId));
                    Assertions.assertInstanceOf(GroupNotEmptyException.class, result.get(groupId), (String)("The expected error (" + String.valueOf(Errors.NON_EMPTY_GROUP) + ") was not detected while deleting consumer group. Result was:(" + String.valueOf(result) + ")"));
                }
                finally {
                    if (service == null) continue;
                    service.close();
                }
            }
            finally {
                if (consumerGroupCloseable == null) continue;
                consumerGroupCloseable.close();
            }
        }
    }

    @ClusterTest
    void testDeleteEmptyGroup(ClusterInstance cluster) throws Exception {
        for (GroupProtocol groupProtocol : cluster.supportedGroupProtocols()) {
            String groupId = this.composeGroupId(groupProtocol);
            String topicName = this.composeTopicName(groupProtocol);
            String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", groupId};
            AutoCloseable consumerGroupCloseable = this.consumerGroupClosable(cluster, groupProtocol, groupId, topicName);
            try {
                ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
                try {
                    TestUtils.waitForCondition(() -> service.listConsumerGroups().contains(groupId) && this.checkGroupState(service, groupId, GroupState.STABLE), (String)"The group did not initialize as expected.");
                    consumerGroupCloseable.close();
                    TestUtils.waitForCondition(() -> this.checkGroupState(service, groupId, GroupState.EMPTY), (String)"The group did not become empty as expected.");
                    HashMap result = new HashMap();
                    String output = ToolsTestUtils.grabConsoleOutput(() -> result.putAll(service.deleteGroups()));
                    Assertions.assertTrue((boolean)output.contains("Deletion of requested consumer groups ('" + groupId + "') was successful."), (String)"The consumer group could not be deleted as expected");
                    Assertions.assertEquals((int)1, (int)result.size());
                    Assertions.assertTrue((boolean)result.containsKey(groupId));
                    Assertions.assertNull(result.get(groupId), (String)"The consumer group could not be deleted as expected");
                }
                finally {
                    if (service == null) continue;
                    service.close();
                }
            }
            finally {
                if (consumerGroupCloseable == null) continue;
                consumerGroupCloseable.close();
            }
        }
    }

    @ClusterTest
    public void testDeleteCmdAllGroups(ClusterInstance cluster) throws Exception {
        for (GroupProtocol groupProtocol : cluster.supportedGroupProtocols()) {
            String topicName = this.composeTopicName(groupProtocol);
            Map groupIdToExecutor = IntStream.rangeClosed(1, 3).mapToObj(i -> this.composeGroupId(groupProtocol) + i).collect(Collectors.toMap(Function.identity(), group -> this.consumerGroupClosable(cluster, groupProtocol, (String)group, topicName)));
            String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--all-groups"};
            ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
            try {
                TestUtils.waitForCondition(() -> new HashSet(service.listConsumerGroups()).equals(groupIdToExecutor.keySet()) && groupIdToExecutor.keySet().stream().allMatch(groupId -> (Boolean)Assertions.assertDoesNotThrow(() -> this.checkGroupState(service, (String)groupId, GroupState.STABLE))), (String)"The group did not initialize as expected.");
                for (AutoCloseable consumerGroupExecutor : groupIdToExecutor.values()) {
                    consumerGroupExecutor.close();
                }
                TestUtils.waitForCondition(() -> groupIdToExecutor.keySet().stream().allMatch(groupId -> (Boolean)Assertions.assertDoesNotThrow(() -> this.checkGroupState(service, (String)groupId, GroupState.EMPTY))), (String)"The group did not become empty as expected.");
                String output = ToolsTestUtils.grabConsoleOutput(() -> ((ConsumerGroupCommand.ConsumerGroupService)service).deleteGroups()).trim();
                Set expectedGroupsForDeletion = groupIdToExecutor.keySet();
                Set deletedGroupsGrepped = Arrays.stream(output.substring(output.indexOf(40) + 1, output.indexOf(41)).split(",")).map(str -> str.replaceAll("'", "").trim()).collect(Collectors.toSet());
                Assertions.assertTrue((output.matches("Deletion of requested consumer groups (.*) was successful.") && Objects.equals(deletedGroupsGrepped, expectedGroupsForDeletion) ? 1 : 0) != 0, (String)"The consumer group(s) could not be deleted as expected");
            }
            finally {
                if (service == null) continue;
                service.close();
            }
        }
    }

    @ClusterTest
    public void testDeleteCmdWithMixOfSuccessAndError(ClusterInstance cluster) throws Exception {
        for (GroupProtocol groupProtocol : cluster.supportedGroupProtocols()) {
            String groupId = this.composeGroupId(groupProtocol);
            String topicName = this.composeTopicName(groupProtocol);
            String missingGroupId = this.composeMissingGroupId(groupProtocol);
            String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", groupId};
            AutoCloseable consumerGroupClosable = this.consumerGroupClosable(cluster, groupProtocol, groupId, topicName);
            try {
                ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
                try {
                    TestUtils.waitForCondition(() -> service.listConsumerGroups().contains(groupId) && this.checkGroupState(service, groupId, GroupState.STABLE), (String)"The group did not initialize as expected.");
                    consumerGroupClosable.close();
                    TestUtils.waitForCondition(() -> this.checkGroupState(service, groupId, GroupState.EMPTY), (String)"The group did not become empty as expected.");
                    cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", groupId, "--group", missingGroupId};
                    ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService(cgcArgs);
                    try {
                        String output = ToolsTestUtils.grabConsoleOutput(() -> ((ConsumerGroupCommand.ConsumerGroupService)service2).deleteGroups());
                        Assertions.assertTrue((output.contains("Group '" + missingGroupId + "' could not be deleted due to:") && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains("These consumer groups were deleted successfully: '" + groupId + "'") ? 1 : 0) != 0, (String)"The consumer group deletion did not work as expected");
                    }
                    finally {
                        if (service2 == null) continue;
                        service2.close();
                    }
                }
                finally {
                    if (service == null) continue;
                    service.close();
                }
            }
            finally {
                if (consumerGroupClosable == null) continue;
                consumerGroupClosable.close();
            }
        }
    }

    @ClusterTest
    public void testDeleteWithMixOfSuccessAndError(ClusterInstance cluster) throws Exception {
        for (GroupProtocol groupProtocol : cluster.supportedGroupProtocols()) {
            String groupId = this.composeGroupId(groupProtocol);
            String topicName = this.composeTopicName(groupProtocol);
            String missingGroupId = this.composeMissingGroupId(groupProtocol);
            String[] cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", groupId};
            AutoCloseable executor = this.consumerGroupClosable(cluster, groupProtocol, groupId, topicName);
            try {
                ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
                try {
                    TestUtils.waitForCondition(() -> service.listConsumerGroups().contains(groupId) && this.checkGroupState(service, groupId, GroupState.STABLE), (String)"The group did not initialize as expected.");
                    executor.close();
                    TestUtils.waitForCondition(() -> this.checkGroupState(service, groupId, GroupState.EMPTY), (String)"The group did not become empty as expected.");
                    cgcArgs = new String[]{"--bootstrap-server", cluster.bootstrapServers(), "--delete", "--group", groupId, "--group", missingGroupId};
                    ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService(cgcArgs);
                    try {
                        Map result = service2.deleteGroups();
                        Assertions.assertTrue((result.size() == 2 && result.containsKey(groupId) && result.get(groupId) == null && result.containsKey(missingGroupId) && ((Throwable)result.get(missingGroupId)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0, (String)"The consumer group deletion did not work as expected");
                    }
                    finally {
                        if (service2 == null) continue;
                        service2.close();
                    }
                }
                finally {
                    if (service == null) continue;
                    service.close();
                }
            }
            finally {
                if (executor == null) continue;
                executor.close();
            }
        }
    }

    @Test
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", "localhost:62241", "--delete", "--group", this.getDummyGroupId()};
        Assertions.assertThrows(OptionException.class, () -> ConsumerGroupCommandOptions.fromArgs((String[])cgcArgs));
    }

    private String getDummyGroupId() {
        return this.composeGroupId(null);
    }

    private String composeGroupId(GroupProtocol protocol) {
        String groupPrefix = "test.";
        return protocol != null ? groupPrefix + protocol.name : groupPrefix + "dummy";
    }

    private String composeTopicName(GroupProtocol protocol) {
        String topicPrefix = "foo.";
        return protocol != null ? topicPrefix + protocol.name : topicPrefix + "dummy";
    }

    private String composeMissingGroupId(GroupProtocol protocol) {
        String missingGroupPrefix = "missing.";
        return protocol != null ? missingGroupPrefix + protocol.name : missingGroupPrefix + "dummy";
    }

    private AutoCloseable consumerGroupClosable(ClusterInstance cluster, GroupProtocol protocol, String groupId, String topicName) {
        Map<String, Object> configs = this.composeConfigs(cluster, groupId, protocol.name, Collections.emptyMap());
        return ConsumerGroupCommandTestUtils.buildConsumers(1, false, topicName, () -> new KafkaConsumer(configs));
    }

    private boolean checkGroupState(ConsumerGroupCommand.ConsumerGroupService service, String groupId, GroupState state) throws Exception {
        return Objects.equals(service.collectGroupState((String)groupId).groupState, state);
    }

    private ConsumerGroupCommand.ConsumerGroupService getConsumerGroupService(String[] args) {
        ConsumerGroupCommandOptions opts = ConsumerGroupCommandOptions.fromArgs((String[])args);
        return new ConsumerGroupCommand.ConsumerGroupService(opts, Collections.singletonMap("retries", Integer.toString(Integer.MAX_VALUE)));
    }

    private Map<String, Object> composeConfigs(ClusterInstance cluster, String groupId, String groupProtocol, Map<String, Object> customConfigs) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", cluster.bootstrapServers());
        configs.put("group.id", groupId);
        configs.put("key.deserializer", StringDeserializer.class.getName());
        configs.put("value.deserializer", StringDeserializer.class.getName());
        configs.put("group.protocol", groupProtocol);
        if (GroupProtocol.CLASSIC.name.equalsIgnoreCase(groupProtocol)) {
            configs.put("partition.assignment.strategy", RangeAssignor.class.getName());
        }
        configs.putAll(customConfigs);
        return configs;
    }
}

