/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommand;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerGroupServiceTest {
    public static final String GROUP = "testGroup";
    public static final int NUM_PARTITIONS = 10;
    private static final List<String> TOPICS = IntStream.range(0, 5).mapToObj(i -> "testTopic" + i).collect(Collectors.toList());
    private static final List<TopicPartition> TOPIC_PARTITIONS = TOPICS.stream().flatMap(topic -> IntStream.range(0, 10).mapToObj(i -> new TopicPartition(topic, i))).collect(Collectors.toList());
    private final Admin admin = (Admin)Mockito.mock(Admin.class);

    @Test
    public void testAdminRequestsForDescribeOffsets() throws Exception {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--group", GROUP, "--describe", "--offsets"};
        ConsumerGroupCommand.ConsumerGroupService groupService = this.consumerGroupService(args);
        Mockito.when((Object)this.admin.describeConsumerGroups((Collection)ArgumentMatchers.eq(Collections.singletonList(GROUP)), (DescribeConsumerGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)this.describeGroupsResult(GroupState.STABLE));
        Mockito.when((Object)this.admin.listConsumerGroupOffsets((Map)ArgumentMatchers.eq(this.listConsumerGroupOffsetsSpec()), (ListConsumerGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)this.listGroupOffsetsResult(GROUP));
        Mockito.when((Object)this.admin.listOffsets(this.offsetsArgMatcher(), (ListOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)this.listOffsetsResult());
        Map.Entry statesAndAssignments = groupService.collectGroupOffsets(GROUP);
        Assertions.assertEquals(Optional.of(GroupState.STABLE), statesAndAssignments.getKey());
        Assertions.assertTrue((boolean)((Optional)statesAndAssignments.getValue()).isPresent());
        Assertions.assertEquals((int)TOPIC_PARTITIONS.size(), (int)((Collection)((Optional)statesAndAssignments.getValue()).get()).size());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).describeConsumerGroups((Collection)ArgumentMatchers.eq(Collections.singletonList(GROUP)), (DescribeConsumerGroupsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).listConsumerGroupOffsets((Map)ArgumentMatchers.eq(this.listConsumerGroupOffsetsSpec()), (ListConsumerGroupOffsetsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).listOffsets(this.offsetsArgMatcher(), (ListOffsetsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminRequestsForDescribeNegativeOffsets() throws Exception {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--group", GROUP, "--describe", "--offsets"};
        ConsumerGroupCommand.ConsumerGroupService groupService = this.consumerGroupService(args);
        TopicPartition testTopicPartition0 = new TopicPartition("testTopic1", 0);
        TopicPartition testTopicPartition1 = new TopicPartition("testTopic1", 1);
        TopicPartition testTopicPartition2 = new TopicPartition("testTopic1", 2);
        TopicPartition testTopicPartition3 = new TopicPartition("testTopic2", 0);
        TopicPartition testTopicPartition4 = new TopicPartition("testTopic2", 1);
        TopicPartition testTopicPartition5 = new TopicPartition("testTopic2", 2);
        HashMap<TopicPartition, OffsetAndMetadata> committedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        committedOffsets.put(testTopicPartition1, new OffsetAndMetadata(100L, Optional.of(1), ""));
        committedOffsets.put(testTopicPartition2, null);
        committedOffsets.put(testTopicPartition3, new OffsetAndMetadata(100L, Optional.of(1), ""));
        committedOffsets.put(testTopicPartition4, new OffsetAndMetadata(100L, Optional.of(1), ""));
        committedOffsets.put(testTopicPartition5, null);
        ListOffsetsResult.ListOffsetsResultInfo resultInfo = new ListOffsetsResult.ListOffsetsResultInfo(100L, System.currentTimeMillis(), Optional.of(1));
        HashMap<TopicPartition, KafkaFuture> endOffsets = new HashMap<TopicPartition, KafkaFuture>();
        endOffsets.put(testTopicPartition0, KafkaFuture.completedFuture((Object)resultInfo));
        endOffsets.put(testTopicPartition1, KafkaFuture.completedFuture((Object)resultInfo));
        endOffsets.put(testTopicPartition2, KafkaFuture.completedFuture((Object)resultInfo));
        endOffsets.put(testTopicPartition3, KafkaFuture.completedFuture((Object)resultInfo));
        endOffsets.put(testTopicPartition4, KafkaFuture.completedFuture((Object)resultInfo));
        endOffsets.put(testTopicPartition5, KafkaFuture.completedFuture((Object)resultInfo));
        HashSet<TopicPartition> assignedTopicPartitions = new HashSet<TopicPartition>(Arrays.asList(testTopicPartition0, testTopicPartition1, testTopicPartition2));
        HashSet<TopicPartition> unassignedTopicPartitions = new HashSet<TopicPartition>(Arrays.asList(testTopicPartition3, testTopicPartition4, testTopicPartition5));
        ConsumerGroupDescription consumerGroupDescription = new ConsumerGroupDescription(GROUP, true, Collections.singleton(new MemberDescription("member1", Optional.of("instance1"), "client1", "host1", new MemberAssignment(assignedTopicPartitions), Optional.empty(), Optional.empty(), Optional.empty())), RangeAssignor.class.getName(), GroupType.CLASSIC, GroupState.STABLE, new Node(1, "localhost", 9092), Set.of(), Optional.empty(), Optional.empty());
        Function<Collection, ArgumentMatcher> offsetsArgMatcher = expectedPartitions -> topicPartitionOffsets -> topicPartitionOffsets != null && topicPartitionOffsets.keySet().equals(expectedPartitions);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)consumerGroupDescription);
        Mockito.when((Object)this.admin.describeConsumerGroups((Collection)ArgumentMatchers.eq(Collections.singletonList(GROUP)), (DescribeConsumerGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)new DescribeConsumerGroupsResult(Collections.singletonMap(GROUP, future)));
        Mockito.when((Object)this.admin.listConsumerGroupOffsets((Map)ArgumentMatchers.eq(this.listConsumerGroupOffsetsSpec()), (ListConsumerGroupOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)AdminClientTestUtils.listConsumerGroupOffsetsResult(Collections.singletonMap(GROUP, committedOffsets)));
        Mockito.when((Object)this.admin.listOffsets((Map)ArgumentMatchers.argThat((ArgumentMatcher)offsetsArgMatcher.apply(assignedTopicPartitions)), (ListOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)new ListOffsetsResult(endOffsets.entrySet().stream().filter(e -> assignedTopicPartitions.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        Mockito.when((Object)this.admin.listOffsets((Map)ArgumentMatchers.argThat((ArgumentMatcher)offsetsArgMatcher.apply(unassignedTopicPartitions)), (ListOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)new ListOffsetsResult(endOffsets.entrySet().stream().filter(e -> unassignedTopicPartitions.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        Map.Entry statesAndAssignments = groupService.collectGroupOffsets(GROUP);
        Optional state = (Optional)statesAndAssignments.getKey();
        Optional assignments = (Optional)statesAndAssignments.getValue();
        Map returnedOffsets = assignments.map(results -> results.stream().collect(Collectors.toMap(assignment -> new TopicPartition((String)assignment.topic.get(), ((Integer)assignment.partition.get()).intValue()), assignment -> assignment.offset))).orElse(Collections.emptyMap());
        Map returnedLeaderEpoch = assignments.map(results -> results.stream().collect(Collectors.toMap(assignment -> new TopicPartition((String)assignment.topic.get(), ((Integer)assignment.partition.get()).intValue()), assignment -> assignment.leaderEpoch))).orElse(Collections.emptyMap());
        Map expectedOffsets = Map.of(testTopicPartition0, Optional.empty(), testTopicPartition1, Optional.of(100L), testTopicPartition2, Optional.empty(), testTopicPartition3, Optional.of(100L), testTopicPartition4, Optional.of(100L), testTopicPartition5, Optional.empty());
        Map expectedLeaderEpoch = Map.of(testTopicPartition0, Optional.empty(), testTopicPartition1, Optional.of(1), testTopicPartition2, Optional.empty(), testTopicPartition3, Optional.of(1), testTopicPartition4, Optional.of(1), testTopicPartition5, Optional.empty());
        Assertions.assertEquals(Optional.of(GroupState.STABLE), (Object)state);
        Assertions.assertEquals(expectedOffsets, returnedOffsets);
        Assertions.assertEquals(expectedLeaderEpoch, returnedLeaderEpoch);
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).describeConsumerGroups((Collection)ArgumentMatchers.eq(Collections.singletonList(GROUP)), (DescribeConsumerGroupsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).listConsumerGroupOffsets((Map)ArgumentMatchers.eq(this.listConsumerGroupOffsetsSpec()), (ListConsumerGroupOffsetsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).listOffsets((Map)ArgumentMatchers.argThat((ArgumentMatcher)offsetsArgMatcher.apply(assignedTopicPartitions)), (ListOffsetsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).listOffsets((Map)ArgumentMatchers.argThat((ArgumentMatcher)offsetsArgMatcher.apply(unassignedTopicPartitions)), (ListOffsetsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminRequestsForResetOffsets() {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--bootstrap-server", "localhost:9092", "--group", GROUP, "--reset-offsets", "--to-latest"));
        List<String> topicsWithoutPartitionsSpecified = TOPICS.subList(1, TOPICS.size());
        ArrayList<String> topicArgs = new ArrayList<String>(Arrays.asList("--topic", TOPICS.get(0) + ":" + IntStream.range(0, 10).mapToObj(Integer::toString).collect(Collectors.joining(","))));
        topicsWithoutPartitionsSpecified.forEach(topic -> topicArgs.addAll(Arrays.asList("--topic", topic)));
        args.addAll(topicArgs);
        ConsumerGroupCommand.ConsumerGroupService groupService = this.consumerGroupService(args.toArray(new String[0]));
        Mockito.when((Object)this.admin.describeConsumerGroups((Collection)ArgumentMatchers.eq(Collections.singletonList(GROUP)), (DescribeConsumerGroupsOptions)ArgumentMatchers.any())).thenReturn((Object)this.describeGroupsResult(GroupState.DEAD));
        Mockito.when((Object)this.admin.describeTopics((Collection)ArgumentMatchers.eq(topicsWithoutPartitionsSpecified), (DescribeTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.describeTopicsResult(topicsWithoutPartitionsSpecified));
        Mockito.when((Object)this.admin.listOffsets(this.offsetsArgMatcher(), (ListOffsetsOptions)ArgumentMatchers.any())).thenReturn((Object)this.listOffsetsResult());
        Map resetResult = groupService.resetOffsets();
        Assertions.assertEquals(Collections.singleton(GROUP), resetResult.keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(TOPIC_PARTITIONS), ((Map)resetResult.get(GROUP)).keySet());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).describeConsumerGroups((Collection)ArgumentMatchers.eq(Collections.singletonList(GROUP)), (DescribeConsumerGroupsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).describeTopics((Collection)ArgumentMatchers.eq(topicsWithoutPartitionsSpecified), (DescribeTopicsOptions)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).listOffsets(this.offsetsArgMatcher(), (ListOffsetsOptions)ArgumentMatchers.any());
    }

    private ConsumerGroupCommand.ConsumerGroupService consumerGroupService(String[] args) {
        return new ConsumerGroupCommand.ConsumerGroupService(ConsumerGroupCommandOptions.fromArgs((String[])args), Collections.emptyMap()){

            protected Admin createAdminClient(Map<String, String> configOverrides) {
                return ConsumerGroupServiceTest.this.admin;
            }
        };
    }

    private DescribeConsumerGroupsResult describeGroupsResult(GroupState groupState) {
        MemberDescription member1 = new MemberDescription("member1", Optional.of("instance1"), "client1", "host1", null, Optional.empty(), Optional.empty(), Optional.empty());
        ConsumerGroupDescription description = new ConsumerGroupDescription(GROUP, true, Collections.singleton(member1), RangeAssignor.class.getName(), GroupType.CLASSIC, groupState, new Node(1, "localhost", 9092), Set.of(), Optional.empty(), Optional.empty());
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)description);
        return new DescribeConsumerGroupsResult(Collections.singletonMap(GROUP, future));
    }

    private ListConsumerGroupOffsetsResult listGroupOffsetsResult(String groupId) {
        Map offsets = TOPIC_PARTITIONS.stream().collect(Collectors.toMap(Function.identity(), __ -> new OffsetAndMetadata(100L)));
        return AdminClientTestUtils.listConsumerGroupOffsetsResult(Collections.singletonMap(groupId, offsets));
    }

    private Map<TopicPartition, OffsetSpec> offsetsArgMatcher() {
        Map expectedOffsets = TOPIC_PARTITIONS.stream().collect(Collectors.toMap(Function.identity(), __ -> OffsetSpec.latest()));
        return (Map)ArgumentMatchers.argThat(map -> Objects.equals(map.keySet(), expectedOffsets.keySet()) && map.values().stream().allMatch(v -> v instanceof OffsetSpec.LatestSpec));
    }

    private ListOffsetsResult listOffsetsResult() {
        ListOffsetsResult.ListOffsetsResultInfo resultInfo = new ListOffsetsResult.ListOffsetsResultInfo(100L, System.currentTimeMillis(), Optional.of(1));
        Map futures = TOPIC_PARTITIONS.stream().collect(Collectors.toMap(Function.identity(), __ -> KafkaFuture.completedFuture((Object)resultInfo)));
        return new ListOffsetsResult(futures);
    }

    private DescribeTopicsResult describeTopicsResult(Collection<String> topics) {
        HashMap topicDescriptions = new HashMap();
        topics.forEach(topic -> {
            List partitions = IntStream.range(0, 10).mapToObj(i -> new TopicPartitionInfo(i, null, Collections.emptyList(), Collections.emptyList())).collect(Collectors.toList());
            topicDescriptions.put(topic, new TopicDescription(topic, false, partitions));
        });
        return AdminClientTestUtils.describeTopicsResult(topicDescriptions);
    }

    private Map<String, ListConsumerGroupOffsetsSpec> listConsumerGroupOffsetsSpec() {
        return Collections.singletonMap(GROUP, new ListConsumerGroupOffsetsSpec());
    }
}

