/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.api.AbstractAuthorizerIntegrationTest;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommand;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.jdk.javaapi.CollectionConverters;

public class AuthorizerIntegrationTest
extends AbstractAuthorizerIntegrationTest {
    @Test
    public void testDescribeGroupCliWithGroupDescribe() throws Exception {
        this.addAndVerifyAcls(CollectionConverters.asScala(Collections.singleton(new AccessControlEntry(AuthorizerIntegrationTest.ClientPrincipal().toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW))).toSet(), this.groupResource());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.listenerName()), "--describe", "--group", this.group()};
        ConsumerGroupCommandOptions opts = ConsumerGroupCommandOptions.fromArgs((String[])cgcArgs);
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts, Collections.emptyMap());){
            consumerGroupService.describeGroups();
            Assertions.fail((String)"Non-existent group should throw an exception");
        }
        catch (ExecutionException e) {
            Assertions.assertInstanceOf(GroupIdNotFoundException.class, (Object)e.getCause(), (String)"Non-existent group should throw GroupIdNotFoundException");
        }
    }
}

