/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.util.Collections;
import java.util.stream.Stream;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatterTest;
import org.apache.kafka.tools.consumer.TransactionLogMessageFormatter;
import org.junit.jupiter.params.provider.Arguments;

public class TransactionLogMessageFormatterTest
extends CoordinatorRecordMessageFormatterTest {
    private static final TransactionLogKey TXN_LOG_KEY = new TransactionLogKey().setTransactionalId("TXNID");
    private static final TransactionLogValue TXN_LOG_VALUE = new TransactionLogValue().setProducerId(100L).setProducerEpoch((short)50).setTransactionStatus((byte)4).setTransactionStartTimestampMs(750L).setTransactionLastUpdateTimestampMs(1000L).setTransactionTimeoutMs(500).setTransactionPartitions(Collections.emptyList());

    @Override
    protected CoordinatorRecordMessageFormatter formatter() {
        return new TransactionLogMessageFormatter();
    }

    @Override
    protected Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)10, (Message)TXN_LOG_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)10, (Message)TXN_LOG_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)TXN_LOG_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)TXN_LOG_VALUE).array(), "    {\"key\":{\"type\":0,\"data\":{\"transactionalId\":\"TXNID\"}},\n     \"value\":{\"version\":1,\n              \"data\":{\"producerId\":100,\n                      \"producerEpoch\":50,\n                      \"transactionTimeoutMs\":500,\n                      \"transactionStatus\":4,\n                      \"transactionPartitions\":[],\n                      \"transactionLastUpdateTimestampMs\":1000,\n                      \"transactionStartTimestampMs\":750}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)TXN_LOG_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)TXN_LOG_VALUE).array(), "    {\"key\":{\"type\":0,\"data\":{\"transactionalId\":\"TXNID\"}},\n     \"value\":{\"version\":1,\n              \"data\":{\"producerId\":100,\n                      \"producerEpoch\":50,\n                      \"transactionTimeoutMs\":500,\n                      \"transactionStatus\":4,\n                      \"transactionPartitions\":[],\n                      \"transactionLastUpdateTimestampMs\":1000,\n                      \"transactionStartTimestampMs\":750}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)TXN_LOG_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)TXN_LOG_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)TXN_LOG_KEY).array(), null, "    {\"key\":{\"type\":0,\"data\":{\"transactionalId\":\"TXNID\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{null, MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)TXN_LOG_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{null, null, ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)Short.MAX_VALUE, (Message)TXN_LOG_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)TXN_LOG_VALUE).array(), ""}));
    }
}

