/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.util.List;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataValue;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatterTest;
import org.apache.kafka.tools.consumer.ShareGroupMessageFormatter;
import org.junit.jupiter.params.provider.Arguments;

public class ShareGroupMessageFormatterTest
extends CoordinatorRecordMessageFormatterTest {
    private static final ShareGroupMemberMetadataKey SHARE_GROUP_MEMBER_METADATA_KEY = new ShareGroupMemberMetadataKey().setGroupId("group-id").setMemberId("member-id");
    private static final ShareGroupMemberMetadataValue SHARE_GROUP_MEMBER_METADATA_VALUE = new ShareGroupMemberMetadataValue().setRackId("rack-a").setClientId("client-id").setClientHost("1.2.3.4").setSubscribedTopicNames(List.of("topic"));
    private static final ShareGroupMetadataKey SHARE_GROUP_METADATA_KEY = new ShareGroupMetadataKey().setGroupId("group-id");
    private static final ShareGroupMetadataValue SHARE_GROUP_METADATA_VALUE = new ShareGroupMetadataValue().setEpoch(1).setMetadataHash(1L);
    private static final ShareGroupTargetAssignmentMetadataKey SHARE_GROUP_TARGET_ASSIGNMENT_METADATA_KEY = new ShareGroupTargetAssignmentMetadataKey().setGroupId("group-id");
    private static final ShareGroupTargetAssignmentMetadataValue SHARE_GROUP_TARGET_ASSIGNMENT_METADATA_VALUE = new ShareGroupTargetAssignmentMetadataValue().setAssignmentEpoch(1);
    private static final ShareGroupTargetAssignmentMemberKey SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER_KEY = new ShareGroupTargetAssignmentMemberKey().setGroupId("group-id").setMemberId("member-id");
    private static final ShareGroupTargetAssignmentMemberValue SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER_VALUE = new ShareGroupTargetAssignmentMemberValue().setTopicPartitions(List.of(new ShareGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(Uuid.ONE_UUID).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))));
    private static final ShareGroupCurrentMemberAssignmentKey SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT_KEY = new ShareGroupCurrentMemberAssignmentKey().setGroupId("group-id").setMemberId("member-id");
    private static final ShareGroupCurrentMemberAssignmentValue SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT_VALUE = new ShareGroupCurrentMemberAssignmentValue().setMemberEpoch(1).setPreviousMemberEpoch(0).setState((byte)0).setAssignedPartitions(List.of(new ShareGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(Uuid.ONE_UUID).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))));
    private static final ShareGroupStatePartitionMetadataKey SHARE_GROUP_STATE_PARTITION_METADATA_KEY = new ShareGroupStatePartitionMetadataKey().setGroupId("group-id");
    private static final ShareGroupStatePartitionMetadataValue SHARE_GROUP_STATE_PARTITION_METADATA_VALUE = new ShareGroupStatePartitionMetadataValue().setInitializingTopics(List.of(new ShareGroupStatePartitionMetadataValue.TopicPartitionsInfo().setTopicId(Uuid.ONE_UUID).setTopicName("topic").setPartitions(List.of(Integer.valueOf(1))))).setInitializedTopics(List.of(new ShareGroupStatePartitionMetadataValue.TopicPartitionsInfo().setTopicId(Uuid.ONE_UUID).setTopicName("topic").setPartitions(List.of(Integer.valueOf(0))))).setDeletingTopics(List.of(new ShareGroupStatePartitionMetadataValue.TopicInfo().setTopicId(Uuid.ONE_UUID).setTopicName("topic")));

    @Override
    protected CoordinatorRecordMessageFormatter formatter() {
        return new ShareGroupMessageFormatter();
    }

    @Override
    protected Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)10, (Message)SHARE_GROUP_MEMBER_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_GROUP_MEMBER_METADATA_VALUE).array(), "    {\"key\":{\"type\":10,\"data\":{\"groupId\":\"group-id\",\"memberId\":\"member-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"rackId\":\"rack-a\",\n                      \"clientId\":\"client-id\",\n                      \"clientHost\":\"1.2.3.4\",\n                      \"subscribedTopicNames\":[\"topic\"]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)10, (Message)SHARE_GROUP_MEMBER_METADATA_KEY).array(), null, "    {\"key\":{\"type\":10,\"data\":{\"groupId\":\"group-id\",\"memberId\":\"member-id\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)11, (Message)SHARE_GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_GROUP_METADATA_VALUE).array(), "    {\"key\":{\"type\":11,\"data\":{\"groupId\":\"group-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"epoch\":1,\n                      \"metadataHash\":1}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)11, (Message)SHARE_GROUP_METADATA_KEY).array(), null, "    {\"key\":{\"type\":11,\"data\":{\"groupId\":\"group-id\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)12, (Message)SHARE_GROUP_TARGET_ASSIGNMENT_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_GROUP_TARGET_ASSIGNMENT_METADATA_VALUE).array(), "    {\"key\":{\"type\":12,\"data\":{\"groupId\":\"group-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"assignmentEpoch\":1}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)12, (Message)SHARE_GROUP_TARGET_ASSIGNMENT_METADATA_KEY).array(), null, "    {\"key\":{\"type\":12,\"data\":{\"groupId\":\"group-id\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)13, (Message)SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER_VALUE).array(), "    {\"key\":{\"type\":13,\"data\":{\"groupId\":\"group-id\",\"memberId\":\"member-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"topicPartitions\":[{\"topicId\":\"AAAAAAAAAAAAAAAAAAAAAQ\",\n                                          \"partitions\":[0,1]}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)13, (Message)SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER_KEY).array(), null, "    {\"key\":{\"type\":13,\"data\":{\"groupId\":\"group-id\",\"memberId\":\"member-id\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)14, (Message)SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT_VALUE).array(), "    {\"key\":{\"type\":14,\"data\":{\"groupId\":\"group-id\",\"memberId\":\"member-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"memberEpoch\":1,\n                      \"previousMemberEpoch\":0,\n                      \"state\":0,\n                      \"assignedPartitions\":[{\"topicId\":\"AAAAAAAAAAAAAAAAAAAAAQ\",\n                                             \"partitions\":[0,1]}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)14, (Message)SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT_KEY).array(), null, "    {\"key\":{\"type\":14,\"data\":{\"groupId\":\"group-id\",\"memberId\":\"member-id\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)15, (Message)SHARE_GROUP_STATE_PARTITION_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)SHARE_GROUP_STATE_PARTITION_METADATA_VALUE).array(), "    {\"key\":{\"type\":15,\"data\":{\"groupId\":\"group-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"initializingTopics\":[{\"topicId\":\"AAAAAAAAAAAAAAAAAAAAAQ\",\n                                             \"topicName\":\"topic\",\n                                             \"partitions\":[1]}],\n                      \"initializedTopics\":[{\"topicId\":\"AAAAAAAAAAAAAAAAAAAAAQ\",\n                                            \"topicName\":\"topic\",\n                                            \"partitions\":[0]}],\n                      \"deletingTopics\":[{\"topicId\":\"AAAAAAAAAAAAAAAAAAAAAQ\",\n                                         \"topicName\":\"topic\"}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)15, (Message)SHARE_GROUP_STATE_PARTITION_METADATA_KEY).array(), null, "    {\"key\":{\"type\":15,\"data\":{\"groupId\":\"group-id\"}},\"value\":null}\n"}));
    }
}

