/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.util.Collections;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatterTest;
import org.apache.kafka.tools.consumer.OffsetsMessageFormatter;
import org.junit.jupiter.params.provider.Arguments;

public class OffsetMessageFormatterTest
extends CoordinatorRecordMessageFormatterTest {
    private static final OffsetCommitKey OFFSET_COMMIT_KEY = new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1);
    private static final OffsetCommitValue OFFSET_COMMIT_VALUE = new OffsetCommitValue().setOffset(100L).setLeaderEpoch(10).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(5678L).setTopicId(Uuid.fromString((String)"MKXx1fIkQy2J9jXHhK8m1w"));
    private static final GroupMetadataKey GROUP_METADATA_KEY = new GroupMetadataKey().setGroup("group-id");
    private static final GroupMetadataValue GROUP_METADATA_VALUE = new GroupMetadataValue().setProtocolType("consumer").setGeneration(1).setProtocol("range").setLeader("leader").setMembers(Collections.emptyList());

    @Override
    protected CoordinatorRecordMessageFormatter formatter() {
        return new OffsetsMessageFormatter();
    }

    @Override
    protected Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)OFFSET_COMMIT_VALUE).array(), "    {\"key\":{\"type\":0,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\n     \"value\":{\"version\":0,\n              \"data\":{\"offset\":100,\n                      \"metadata\":\"metadata\",\n                      \"commitTimestamp\":1234}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)OFFSET_COMMIT_VALUE).array(), "    {\"key\":{\"type\":1,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\n     \"value\":{\"version\":0,\n              \"data\":{\"offset\":100,\n                      \"metadata\":\"metadata\",\n                      \"commitTimestamp\":1234}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_VALUE).array(), "    {\"key\":{\"type\":1,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\n     \"value\":{\"version\":1,\n              \"data\":{\"offset\":100,\n                      \"metadata\":\"metadata\",\n                      \"commitTimestamp\":1234,\n                      \"expireTimestamp\":5678}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)OFFSET_COMMIT_VALUE).array(), "    {\"key\":{\"type\":1,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\n     \"value\":{\"version\":2,\n              \"data\":{\"offset\":100,\n                      \"metadata\":\"metadata\",\n                      \"commitTimestamp\":1234}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)3, (Message)OFFSET_COMMIT_VALUE).array(), "    {\"key\":{\"type\":1,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\n     \"value\":{\"version\":3,\n              \"data\":{\"offset\":100,\n                      \"leaderEpoch\":10,\n                      \"metadata\":\"metadata\",\n                      \"commitTimestamp\":1234}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)4, (Message)OFFSET_COMMIT_VALUE).array(), "    {\"key\":{\"type\":1,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\n     \"value\":{\"version\":4,\n              \"data\":{\"offset\":100,\n                      \"leaderEpoch\":10,\n                      \"metadata\":\"metadata\",\n                      \"commitTimestamp\":1234,\n                      \"topicId\":\"MKXx1fIkQy2J9jXHhK8m1w\"}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_KEY).array(), null, "  {\"key\":{\"type\":1,\"data\":{\"group\":\"group-id\",\"topic\":\"foo\",\"partition\":1}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{null, MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)OFFSET_COMMIT_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{null, null, ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)Short.MAX_VALUE, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_VALUE).array(), ""}));
    }
}

