/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.util.Collections;
import java.util.stream.Stream;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatterTest;
import org.apache.kafka.tools.consumer.GroupMetadataMessageFormatter;
import org.junit.jupiter.params.provider.Arguments;

public class GroupMetadataMessageFormatterTest
extends CoordinatorRecordMessageFormatterTest {
    private static final OffsetCommitKey OFFSET_COMMIT_KEY = new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1);
    private static final OffsetCommitValue OFFSET_COMMIT_VALUE = new OffsetCommitValue().setOffset(100L).setLeaderEpoch(10).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(-1L);
    private static final GroupMetadataValue.MemberMetadata MEMBER_METADATA = new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(new byte[]{1, 2});
    private static final GroupMetadataKey GROUP_METADATA_KEY = new GroupMetadataKey().setGroup("group-id");
    private static final GroupMetadataValue GROUP_METADATA_VALUE = new GroupMetadataValue().setProtocolType("consumer").setGeneration(1).setProtocol("range").setLeader("leader").setMembers(Collections.singletonList(MEMBER_METADATA)).setCurrentStateTimestamp(1234L);

    @Override
    protected CoordinatorRecordMessageFormatter formatter() {
        return new GroupMetadataMessageFormatter();
    }

    @Override
    protected Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)GROUP_METADATA_VALUE).array(), "    {\"key\":{\"type\":2,\"data\":{\"group\":\"group-id\"}},\n     \"value\":{\"version\":0,\n              \"data\":{\"protocolType\":\"consumer\",\n                      \"generation\":1,\n                      \"protocol\":\"range\",\n                      \"leader\":\"leader\",\n                      \"members\":[{\"memberId\":\"member-1\",\n                                  \"clientId\":\"client-1\",\n                                  \"clientHost\":\"host-1\",\n                                  \"sessionTimeout\":1500,\n                                  \"subscription\":\"AAE=\",\n                                  \"assignment\":\"AQI=\"}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)GROUP_METADATA_VALUE).array(), "    {\"key\":{\"type\":2,\"data\":{\"group\":\"group-id\"}},\n     \"value\":{\"version\":1,\n              \"data\":{\"protocolType\":\"consumer\",\n                      \"generation\":1,\n                      \"protocol\":\"range\",\n                      \"leader\":\"leader\",\n                      \"members\":[{\"memberId\":\"member-1\",\n                                  \"clientId\":\"client-1\",\n                                  \"clientHost\":\"host-1\",\n                                  \"rebalanceTimeout\":1000,\n                                  \"sessionTimeout\":1500,\n                                  \"subscription\":\"AAE=\",\n                                  \"assignment\":\"AQI=\"}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_VALUE).array(), "    {\"key\":{\"type\":2,\"data\":{\"group\":\"group-id\"}},\n     \"value\":{\"version\":2,\n              \"data\":{\"protocolType\":\"consumer\",\n                      \"generation\":1,\n                      \"protocol\":\"range\",\n                      \"leader\":\"leader\",\n                      \"currentStateTimestamp\":1234,\n                      \"members\":[{\"memberId\":\"member-1\",\n                                  \"clientId\":\"client-1\",\n                                  \"clientHost\":\"host-1\",\n                                  \"rebalanceTimeout\":1000,\n                                  \"sessionTimeout\":1500,\n                                  \"subscription\":\"AAE=\",\n                                  \"assignment\":\"AQI=\"}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)3, (Message)GROUP_METADATA_VALUE).array(), "    {\"key\":{\"type\":2,\"data\":{\"group\":\"group-id\"}},\n     \"value\":{\"version\":3,\n              \"data\":{\"protocolType\":\"consumer\",\n                      \"generation\":1,\n                      \"protocol\":\"range\",\n                      \"leader\":\"leader\",\n                      \"currentStateTimestamp\":1234,\n                      \"members\":[{\"memberId\":\"member-1\",\n                                  \"groupInstanceId\":\"group-instance-1\",\n                                  \"clientId\":\"client-1\",\n                                  \"clientHost\":\"host-1\",\n                                  \"rebalanceTimeout\":1000,\n                                  \"sessionTimeout\":1500,\n                                  \"subscription\":\"AAE=\",\n                                  \"assignment\":\"AQI=\"}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)4, (Message)GROUP_METADATA_VALUE).array(), "    {\"key\":{\"type\":2,\"data\":{\"group\":\"group-id\"}},\n    \"value\":{\"version\":4,\n             \"data\":{\"protocolType\":\"consumer\",\n                     \"generation\":1,\n                     \"protocol\":\"range\",\n                     \"leader\":\"leader\",\n                     \"currentStateTimestamp\":1234,\n                     \"members\":[{\"memberId\":\"member-1\",\n                                 \"groupInstanceId\":\"group-instance-1\",\n                                 \"clientId\":\"client-1\",\n                                 \"clientHost\":\"host-1\",\n                                 \"rebalanceTimeout\":1000,\n                                 \"sessionTimeout\":1500,\n                                 \"subscription\":\"AAE=\",\n                                 \"assignment\":\"AQI=\"}]}}}\n"}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)2, (Message)GROUP_METADATA_KEY).array(), null, "    {\"key\":{\"type\":2,\"data\":{\"group\":\"group-id\"}},\"value\":null}\n"}), Arguments.of((Object[])new Object[]{null, MessageUtil.toVersionPrefixedByteBuffer((short)4, (Message)GROUP_METADATA_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{null, null, ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)OFFSET_COMMIT_VALUE).array(), ""}), Arguments.of((Object[])new Object[]{MessageUtil.toVersionPrefixedByteBuffer((short)Short.MAX_VALUE, (Message)OFFSET_COMMIT_KEY).array(), MessageUtil.toVersionPrefixedByteBuffer((short)0, (Message)OFFSET_COMMIT_VALUE).array(), ""}));
    }
}

