/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.tools.consumer.DefaultMessageFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultMessageFormatterTest {
    @Test
    public void testDefaultMessageFormatter() {
        ConsumerRecord record = new ConsumerRecord("topic", 0, 123L, (Object)"key".getBytes(), (Object)"value".getBytes());
        DefaultMessageFormatter formatter = new DefaultMessageFormatter();
        HashMap<String, String> configs = new HashMap<String, String>();
        formatter.configure(configs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"value\n", (Object)out.toString());
        configs.put("print.key", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"key\tvalue\n", (Object)out.toString());
        configs.put("print.partition", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"Partition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.timestamp", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.offset", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.headers", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tNO_HEADERS\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.delivery", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tDelivery:NOT_PRESENT\tNO_HEADERS\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.epoch", "true");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"NO_TIMESTAMP\tPartition:0\tOffset:123\tDelivery:NOT_PRESENT\tEpoch:NOT_PRESENT\tNO_HEADERS\tkey\tvalue\n", (Object)out.toString());
        RecordHeaders headers = new RecordHeaders();
        headers.add("h1", "v1".getBytes());
        headers.add("h2", "v2".getBytes());
        record = new ConsumerRecord("topic", 0, 123L, 123L, TimestampType.CREATE_TIME, -1, -1, (Object)"key".getBytes(), (Object)"value".getBytes(), (Headers)headers, Optional.of(58), Optional.of((short)1));
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123\tPartition:0\tOffset:123\tDelivery:1\tEpoch:58\th1:v1,h2:v2\tkey\tvalue\n", (Object)out.toString());
        configs.put("print.value", "false");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123\tPartition:0\tOffset:123\tDelivery:1\tEpoch:58\th1:v1,h2:v2\tkey\n", (Object)out.toString());
        configs.put("key.separator", "<sep>");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>Delivery:1<sep>Epoch:58<sep>h1:v1,h2:v2<sep>key\n", (Object)out.toString());
        configs.put("print.delivery", "false");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>Epoch:58<sep>h1:v1,h2:v2<sep>key\n", (Object)out.toString());
        configs.put("print.epoch", "false");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>h1:v1,h2:v2<sep>key\n", (Object)out.toString());
        configs.put("line.separator", "<end>");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>h1:v1,h2:v2<sep>key<end>", (Object)out.toString());
        configs.put("headers.separator", "|");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>h1:v1|h2:v2<sep>key<end>", (Object)out.toString());
        record = new ConsumerRecord("topic", 0, 123L, 123L, TimestampType.CREATE_TIME, -1, -1, (Object)"key".getBytes(), (Object)"value".getBytes(), (Headers)headers, Optional.empty());
        configs.put("key.deserializer", UpperCaseDeserializer.class.getName());
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>h1:v1|h2:v2<sep>KEY<end>", (Object)out.toString());
        configs.put("headers.deserializer", UpperCaseDeserializer.class.getName());
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>h1:V1|h2:V2<sep>KEY<end>", (Object)out.toString());
        record = new ConsumerRecord("topic", 0, 123L, 123L, TimestampType.CREATE_TIME, -1, -1, (Object)"key".getBytes(), null, (Headers)headers, Optional.empty());
        configs.put("print.value", "true");
        configs.put("null.literal", "<null>");
        formatter.configure(configs);
        out = new ByteArrayOutputStream();
        formatter.writeTo(record, new PrintStream(out));
        Assertions.assertEquals((Object)"CreateTime:123<sep>Partition:0<sep>Offset:123<sep>h1:V1|h2:V2<sep>KEY<sep><null><end>", (Object)out.toString());
        formatter.close();
    }

    static class UpperCaseDeserializer
    implements Deserializer<String> {
        UpperCaseDeserializer() {
        }

        public String deserialize(String topic, byte[] data) {
            return new String(data, StandardCharsets.UTF_8).toUpperCase(Locale.ROOT);
        }
    }
}

