/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.tools.consumer.CoordinatorRecordMessageFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class CoordinatorRecordMessageFormatterTest {
    private static final String TOPIC = "TOPIC";

    protected abstract CoordinatorRecordMessageFormatter formatter();

    protected abstract Stream<Arguments> parameters();

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testMessageFormatter(byte[] keyBuffer, byte[] valueBuffer, String expectedOutput) {
        ConsumerRecord record = new ConsumerRecord(TOPIC, 0, 0L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)keyBuffer, (Object)valueBuffer, (Headers)new RecordHeaders(), Optional.empty());
        try (CoordinatorRecordMessageFormatter formatter = this.formatter();){
            formatter.configure(Collections.emptyMap());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            formatter.writeTo(record, new PrintStream(out));
            Assertions.assertEquals((Object)expectedOutput.replaceAll("\\s+", ""), (Object)out.toString());
        }
    }
}

