/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.PrintStream;
import java.time.Duration;
import java.util.Optional;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.tools.consumer.ConsoleShareConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class ConsoleShareConsumerTest {
    @BeforeEach
    public void setup() {
        ConsoleShareConsumer.messageCount = 0;
    }

    @Test
    public void shouldThrowTimeoutExceptionWhenTimeoutIsReached() {
        String topic = "test";
        MockTime time = new MockTime();
        int timeoutMs = 1000;
        ShareConsumer mockConsumer = (ShareConsumer)Mockito.mock(ShareConsumer.class);
        Mockito.when((Object)mockConsumer.poll(Duration.ofMillis(1000L))).thenAnswer(arg_0 -> ConsoleShareConsumerTest.lambda$shouldThrowTimeoutExceptionWhenTimeoutIsReached$0((Time)time, arg_0));
        ConsoleShareConsumer.ConsumerWrapper consumer = new ConsoleShareConsumer.ConsumerWrapper(topic, mockConsumer, 1000L);
        Assertions.assertThrows(TimeoutException.class, () -> ((ConsoleShareConsumer.ConsumerWrapper)consumer).receive());
    }

    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        ConsoleShareConsumer.ConsumerWrapper consumer = (ConsoleShareConsumer.ConsumerWrapper)Mockito.mock(ConsoleShareConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, (Object)new byte[0], (Object)new byte[0]);
        int messageLimit = 10;
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleShareConsumer.process((int)messageLimit, (MessageFormatter)formatter, (ConsoleShareConsumer.ConsumerWrapper)consumer, (PrintStream)System.out, (boolean)true, (AcknowledgeType)AcknowledgeType.ACCEPT);
        ((ConsoleShareConsumer.ConsumerWrapper)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)messageLimit))).receive();
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)messageLimit))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        consumer.cleanup();
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        ConsoleShareConsumer.ConsumerWrapper consumer = (ConsoleShareConsumer.ConsumerWrapper)Mockito.mock(ConsoleShareConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, (Object)new byte[0], (Object)new byte[0]);
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        Mockito.when((Object)printStream.checkError()).thenReturn((Object)true);
        ConsoleShareConsumer.process((int)-1, (MessageFormatter)formatter, (ConsoleShareConsumer.ConsumerWrapper)consumer, (PrintStream)printStream, (boolean)true, (AcknowledgeType)AcknowledgeType.ACCEPT);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleShareConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((PrintStream)Mockito.verify((Object)printStream)).checkError();
        consumer.cleanup();
    }

    @Test
    public void testRejectMessageOnError() {
        ConsoleShareConsumer.ConsumerWrapper consumer = (ConsoleShareConsumer.ConsumerWrapper)Mockito.mock(ConsoleShareConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, (Object)new byte[0], (Object)new byte[0]);
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ((MessageFormatter)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        ConsoleShareConsumer.process((int)1, (MessageFormatter)formatter, (ConsoleShareConsumer.ConsumerWrapper)consumer, (PrintStream)printStream, (boolean)true, (AcknowledgeType)AcknowledgeType.ACCEPT);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleShareConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((ConsoleShareConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).acknowledge(record, AcknowledgeType.REJECT);
        consumer.cleanup();
    }

    @Test
    public void shouldUpgradeDeliveryCount() {
        ConsoleShareConsumer.ConsumerWrapper consumer = (ConsoleShareConsumer.ConsumerWrapper)Mockito.mock(ConsoleShareConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        short deliveryCount = 1;
        ConsumerRecord record = new ConsumerRecord("test-topic", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, 0, 0, (Object)new byte[0], (Object)new byte[0], (Headers)new RecordHeaders(), Optional.empty(), Optional.of(deliveryCount));
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleShareConsumer.process((int)1, (MessageFormatter)formatter, (ConsoleShareConsumer.ConsumerWrapper)consumer, (PrintStream)printStream, (boolean)false, (AcknowledgeType)AcknowledgeType.ACCEPT);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConsumerRecord.class);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)captor.capture(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ConsumerRecord capturedRecord = (ConsumerRecord)captor.getValue();
        Assertions.assertEquals((Object)"test-topic", (Object)capturedRecord.topic());
        Assertions.assertEquals((int)0, (int)capturedRecord.partition());
        Assertions.assertEquals((long)0L, (long)capturedRecord.offset());
        Assertions.assertEquals((short)deliveryCount, (Short)capturedRecord.deliveryCount().orElse((short)0));
        ((ConsoleShareConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).acknowledge(record, AcknowledgeType.ACCEPT);
        consumer.cleanup();
    }

    private static /* synthetic */ Object lambda$shouldThrowTimeoutExceptionWhenTimeoutIsReached$0(Time time, InvocationOnMock invocation) throws Throwable {
        time.sleep(501L);
        return ConsumerRecords.EMPTY;
    }
}

